/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ModelElementSelectionInfo;
import de.interactive_instruments.ShapeChange.ModelElementSelectionParseException;
import de.interactive_instruments.ShapeChange.ShapeChangeParseException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessRuleModelElementSelectionConfigurationEntry {
    private String rule = null;
    private ModelElementSelectionInfo meselection = null;

    public ProcessRuleModelElementSelectionConfigurationEntry(String rule, ModelElementSelectionInfo meselect) {
        this.rule = rule;
        this.meselection = meselect;
    }

    public String getRule() {
        return this.rule;
    }

    public ModelElementSelectionInfo getModelElementSelectionInfo() {
        return this.meselection;
    }

    public static List<ProcessRuleModelElementSelectionConfigurationEntry> parseAndValidateConfigurationEntries(Element advancedProcessConfigurations) throws ShapeChangeParseException {
        ArrayList<ProcessRuleModelElementSelectionConfigurationEntry> prmesEntries = new ArrayList<ProcessRuleModelElementSelectionConfigurationEntry>();
        if (advancedProcessConfigurations == null) {
            return prmesEntries;
        }
        ArrayList<Element> prmesEs = new ArrayList<Element>();
        NodeList prmesNl = advancedProcessConfigurations.getElementsByTagName("ProcessRuleModelElementSelection");
        if (prmesNl != null && prmesNl.getLength() != 0) {
            for (int k = 0; k < prmesNl.getLength(); ++k) {
                Node n = prmesNl.item(k);
                if (n.getNodeType() != 1) continue;
                prmesEs.add((Element)n);
            }
        }
        ArrayList<CallSite> compilationErrors = new ArrayList<CallSite>();
        for (int i = 0; i < prmesEs.size(); ++i) {
            String indexForMsg = "" + (i + 1);
            Element prmesE = (Element)prmesEs.get(i);
            String ruleName = prmesE.getAttribute("rule").trim();
            ModelElementSelectionInfo meselect = ModelElementSelectionInfo.parse(prmesE);
            try {
                meselect.validate();
            }
            catch (ModelElementSelectionParseException e) {
                compilationErrors.add((CallSite)((Object)(indexForMsg + " ProcessRuleModelElementSelection element: " + e.getMessage())));
            }
            prmesEntries.add(new ProcessRuleModelElementSelectionConfigurationEntry(ruleName, meselect));
        }
        if (!compilationErrors.isEmpty()) {
            throw new ShapeChangeParseException(StringUtils.join(compilationErrors, (String)", "));
        }
        return prmesEntries;
    }
}

