/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import com.google.common.base.Splitter;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;

public class ProcessConfiguration {
    private String className;
    private ProcessMode processMode = ProcessMode.enabled;
    private Map<String, String> parameters = null;
    private Map<String, ProcessRuleSet> ruleSets = null;
    private List<ProcessMapEntry> mapEntries;
    private Map<String, ProcessMapEntry> mapEntryByType = new HashMap<String, ProcessMapEntry>();
    private Element advancedProcessConfigurations;
    private String gmlVersion = "3.2";
    private List<TransformerConfiguration> transformers = new ArrayList<TransformerConfiguration>();
    private List<TargetConfiguration> targets = new ArrayList<TargetConfiguration>();

    public ProcessConfiguration(String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, List<ProcessMapEntry> mapEntries, Element advancedProcessConfigurations) {
        this.className = className;
        this.processMode = processMode;
        this.parameters = parameters;
        this.ruleSets = ruleSets;
        this.advancedProcessConfigurations = advancedProcessConfigurations;
        if (mapEntries == null) {
            this.mapEntries = new ArrayList<ProcessMapEntry>();
        } else {
            this.mapEntries = mapEntries;
            for (ProcessMapEntry pme : mapEntries) {
                this.mapEntryByType.put(pme.type, pme);
            }
        }
        if (parameters.containsKey("gmlVersion")) {
            this.gmlVersion = parameters.get("gmlVersion");
        }
    }

    public String getClassName() {
        return this.className;
    }

    public ProcessMode getProcessMode() {
        return this.processMode;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public boolean parameterAsBoolean(String parameterName, boolean defaultValue) {
        String valueByConfig = this.parameters.get(parameterName);
        boolean res = valueByConfig == null ? defaultValue : Boolean.parseBoolean(valueByConfig.trim());
        return res;
    }

    public String parameterAsString(String parameterName, String defaultValue, boolean allowNonEmptyTrimmedStringValue, boolean trimValue) {
        String result;
        String string = result = this.parameters == null ? null : this.parameters.get(parameterName);
        if (result == null || result.trim().isEmpty() && !allowNonEmptyTrimmedStringValue) {
            result = defaultValue;
        } else if (trimValue) {
            result = result.trim();
        }
        return result;
    }

    public Pattern parameterAsRegexPattern(String parameterName, String parameterDefaultValue) throws PatternSyntaxException {
        String regexText;
        String string = regexText = this.parameters == null ? null : this.parameters.get(parameterName);
        if (regexText == null) {
            regexText = parameterDefaultValue;
        }
        if (regexText == null) {
            return null;
        }
        return Pattern.compile(regexText);
    }

    public List<String> parameterAsStringList(String parameterName, String[] defaultValues, boolean omitEmptyStrings, boolean trimResults) {
        return this.parameterAsStringList(parameterName, defaultValues, omitEmptyStrings, trimResults, ",");
    }

    public List<String> parameterAsStringList(String parameterName, String[] defaultValues, boolean omitEmptyStrings, boolean trimResults, String separator) {
        List result;
        ArrayList<String> defaultValuesList = defaultValues == null ? new ArrayList() : Arrays.asList(defaultValues);
        String paramValue = this.parameters.get(parameterName);
        if (paramValue == null) {
            return defaultValuesList;
        }
        Splitter splitter = Splitter.on((String)separator);
        if (omitEmptyStrings) {
            splitter = splitter.omitEmptyStrings();
        }
        if (trimResults) {
            splitter = splitter.trimResults();
        }
        if ((result = splitter.splitToList((CharSequence)paramValue)).isEmpty()) {
            return defaultValuesList;
        }
        return new ArrayList<String>(result);
    }

    public String[] getListParameterValue(String parameterName) {
        String p = this.parameters.get(parameterName);
        if (p == null) {
            return null;
        }
        String[] values = p.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public Map<String, ProcessRuleSet> getRuleSets() {
        return this.ruleSets;
    }

    public Set<String> getAllRules() {
        HashSet<String> rules = new HashSet<String>();
        if (this.ruleSets != null && !this.ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : this.ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        return rules;
    }

    public List<ProcessMapEntry> getMapEntries() {
        return this.mapEntries;
    }

    public boolean hasParameter(String paramName) {
        if (paramName == null || paramName.trim().length() == 0) {
            return false;
        }
        return this.parameters.containsKey(paramName.trim());
    }

    public Element getAdvancedProcessConfigurations() {
        return this.advancedProcessConfigurations;
    }

    public boolean hasAdvancedProcessConfigurations() {
        return this.advancedProcessConfigurations != null;
    }

    public String getGmlVersion() {
        return this.gmlVersion;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ProcessConfiguration:\r\n");
        sb.append("\tclass name: " + this.className + "\r\n");
        sb.append("\tprocess mode " + this.processMode + "\r\n");
        sb.append("\tparameters: ");
        if (this.parameters == null || this.parameters.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.parameters.keySet()) {
                sb.append("\t\t(" + key + " | " + this.parameters.get(key) + ")\r\n");
            }
        }
        sb.append("\trule sets: ");
        if (this.ruleSets == null || this.ruleSets.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.ruleSets.keySet()) {
                String ext = this.ruleSets.get(key).getExtendedRuleSetName();
                if (ext == null) {
                    ext = "<none>";
                }
                sb.append("\t\t(name: " + this.ruleSets.get(key).getName() + " | extends: " + ext + " | rules: ");
                SortedSet<String> rules = this.ruleSets.get(key).getAdditionalRules();
                if (rules == null || rules.isEmpty()) {
                    sb.append("<none>");
                } else {
                    Iterator rulesIterator = rules.iterator();
                    sb.append((String)rulesIterator.next());
                    while (rulesIterator.hasNext()) {
                        sb.append("," + (String)rulesIterator.next());
                    }
                }
                sb.append(")\r\n");
            }
        }
        sb.append("\tmap entries: ");
        if (this.mapEntries.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (ProcessMapEntry mapEntry : this.mapEntries) {
                sb.append("\t\tmap entry:\r\n");
                sb.append("\t\t\ttype: '" + mapEntry.getType() + "'\r\n");
                sb.append("\t\t\trule: '" + mapEntry.getRule() + "'\r\n");
                if (mapEntry.getTargetType() == null) {
                    sb.append("\t\t\ttargetType: <none>\r\n");
                } else {
                    sb.append("\t\t\ttargetType: '" + mapEntry.getTargetType() + "'\r\n");
                }
                if (mapEntry.getParam() == null) {
                    sb.append("\t\t\tparam: <none>\r\n");
                    continue;
                }
                sb.append("\t\t\tparam: '" + mapEntry.getParam() + "'\r\n");
            }
        }
        return sb.toString();
    }

    public List<TransformerConfiguration> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<TransformerConfiguration> transformers) {
        this.transformers = transformers;
    }

    public void addTransformer(TransformerConfiguration transformerConfig) {
        this.transformers.add(transformerConfig);
    }

    public List<TargetConfiguration> getTargets() {
        return this.targets;
    }

    public void setTargets(List<TargetConfiguration> targets) {
        this.targets = targets;
    }

    public void addTarget(TargetConfiguration targetConfig) {
        this.targets.add(targetConfig);
    }

    public ProcessMapEntry getMapEntry(String type) {
        return this.mapEntryByType.get(type);
    }
}

