/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageSelector {
    private Pattern schemaNamePattern;
    private Pattern namePattern;
    private Pattern stereotypePattern;

    public PackageSelector(Pattern schemaNamePattern, Pattern namePatternPattern, Pattern stereotypePattern) {
        this.schemaNamePattern = schemaNamePattern;
        this.namePattern = namePatternPattern;
        this.stereotypePattern = stereotypePattern;
    }

    public PackageSelector() {
    }

    public Set<PackageInfo> selectPackages(Model m) {
        HashSet<PackageInfo> result = new HashSet<PackageInfo>();
        SortedSet<? extends PackageInfo> selectedSchemas = m.selectedSchemas();
        HashSet<PackageInfo> selSchemas = new HashSet<PackageInfo>(selectedSchemas);
        if (selectedSchemas == null || selectedSchemas.isEmpty()) {
            return result;
        }
        Set<PackageInfo> matchingSelectedSchemas = this.filterByName(this.schemaNamePattern, selSchemas);
        result.addAll(matchingSelectedSchemas);
        HashSet<PackageInfo> pisInTnsOfSelSchemas = new HashSet<PackageInfo>();
        for (PackageInfo mss : matchingSelectedSchemas) {
            pisInTnsOfSelSchemas.addAll(this.identifyChildPackagesInSameTargetNamespace(mss));
        }
        Set<PackageInfo> matchingPisInTnsOfSelSchemas = this.filterByName(this.namePattern, pisInTnsOfSelSchemas);
        matchingPisInTnsOfSelSchemas = this.filterByStereotype(this.stereotypePattern, matchingPisInTnsOfSelSchemas);
        result.addAll(matchingPisInTnsOfSelSchemas);
        return result;
    }

    private Set<PackageInfo> identifyChildPackagesInSameTargetNamespace(PackageInfo pi) {
        HashSet<PackageInfo> result = new HashSet<PackageInfo>();
        if (pi != null && pi.containedPackages() != null) {
            for (PackageInfo childPi : pi.containedPackages()) {
                if (!childPi.targetNamespace().equals(pi.targetNamespace())) continue;
                result.add(childPi);
                result.addAll(this.identifyChildPackagesInSameTargetNamespace(childPi));
            }
        }
        return result;
    }

    private Set<PackageInfo> filterByStereotype(Pattern p, Set<PackageInfo> pis) {
        HashSet<PackageInfo> matches = new HashSet<PackageInfo>();
        if (p != null) {
            block0: for (PackageInfo pi : pis) {
                String[] stsArr;
                Stereotypes sts = pi.stereotypes();
                for (String st : stsArr = sts.asArray()) {
                    if (!this.matchesRegex(st, p)) continue;
                    matches.add(pi);
                    continue block0;
                }
            }
        } else {
            matches.addAll(pis);
        }
        return matches;
    }

    private Set<PackageInfo> filterByName(Pattern p, Set<PackageInfo> pis) {
        HashSet<PackageInfo> matches = new HashSet<PackageInfo>();
        if (p != null) {
            for (PackageInfo pi : pis) {
                if (!this.matchesRegex(pi.name(), p)) continue;
                matches.add(pi);
            }
        } else {
            matches.addAll(pis);
        }
        return matches;
    }

    private boolean matchesRegex(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        return matcher.matches();
    }

    public void setSchemaNamePattern(Pattern schemaNamePattern) {
        this.schemaNamePattern = schemaNamePattern;
    }

    public void setNamePattern(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public void setStereotypePattern(Pattern stereotypePattern) {
        this.stereotypePattern = stereotypePattern;
    }
}

