/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import com.google.common.base.Splitter;
import de.interactive_instruments.ShapeChange.AIXMSchemaInfos;
import de.interactive_instruments.ShapeChange.ConstraintMapping;
import de.interactive_instruments.ShapeChange.DescriptorTarget;
import de.interactive_instruments.ShapeChange.InputAndLogParameterRegistry;
import de.interactive_instruments.ShapeChange.InputConfiguration;
import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.StereotypesCacheSet;
import de.interactive_instruments.ShapeChange.Model.TaggedValueNormalizer;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TaggedValuesCacheArray;
import de.interactive_instruments.ShapeChange.Model.TaggedValuesCacheMap;
import de.interactive_instruments.ShapeChange.Model.TaggedValuesImpl;
import de.interactive_instruments.ShapeChange.Namespace;
import de.interactive_instruments.ShapeChange.PackageInfoConfiguration;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.PropertyConversionParameter;
import de.interactive_instruments.ShapeChange.RdfPropertyMapEntry;
import de.interactive_instruments.ShapeChange.RdfTypeMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import de.interactive_instruments.ShapeChange.StereotypeConversionParameter;
import de.interactive_instruments.ShapeChange.TaggedValueConfigurationEntry;
import de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.FeatureCatalogue;
import de.interactive_instruments.ShapeChange.Target.Ontology.GeneralDataProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.GeneralObjectProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfGeneralProperty;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.TargetOwlConfiguration;
import de.interactive_instruments.ShapeChange.TargetRegistry;
import de.interactive_instruments.ShapeChange.TargetXmlSchemaConfiguration;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.TypeConversionParameter;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import de.interactive_instruments.ShapeChange.XmlNamespace;
import de.interactive_instruments.ShapeChange.XsdMapEntry;
import de.interactive_instruments.ShapeChange.XsdPropertyMapEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Options {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String SCAI_NS_PREFIX = "sc";
    public static final String SCAI_NS = "http://www.interactive-instruments.de/ShapeChange/AppInfo";
    public static final String SCHEMATRON_NS = "http://purl.oclc.org/dsdl/schematron";
    public static final String TargetXmlSchemaClass = "de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema";
    public static final String TargetFOL2SchematronClass = "de.interactive_instruments.ShapeChange.Target.FOL2Schematron.FOL2Schematron";
    public static final Set<String> classStereotypes = Stream.of("codelist", "enumeration", "datatype", "featuretype", "type", "basictype", "interface", "union", "abstract", "fachid", "schluesseltabelle", "adeelement", "featureconcept", "attributeconcept", "valueconcept", "roleconcept", "aixmextension", "retired").collect(Collectors.toSet());
    public static final Set<String> assocStereotypes = Stream.of("disjoint", "retired").collect(Collectors.toSet());
    public static final Set<String> propertyStereotypes = Stream.of("voidable", "identifier", "version", "property", "estimated", "enum", "retired", "propertymetadata").collect(Collectors.toSet());
    public static final Set<String> packageStereotypes = Stream.of("application schema", "schema", "bundle", "leaf", "retired").collect(Collectors.toSet());
    public static final Set<String> depStereotypes = Stream.of("import", "include", "retired").collect(Collectors.toSet());
    public static final String CRLF = "\r\n";
    public static final int UNKNOWN = -1;
    public static final int FEATURE = 1;
    public static final int CODELIST = 2;
    public static final int ENUMERATION = 3;
    public static final int MIXIN = 4;
    public static final int DATATYPE = 5;
    public static final int OBJECT = 6;
    public static final int GMLOBJECT = 6;
    public static final int BASICTYPE = 7;
    public static final int UNION = 8;
    public static final int OKSTRAKEY = 11;
    public static final int OKSTRAFID = 12;
    public static final int FEATURECONCEPT = 13;
    public static final int ATTRIBUTECONCEPT = 14;
    public static final int VALUECONCEPT = 15;
    public static final int AIXMEXTENSION = 16;
    public static final int ROLECONCEPT = 17;
    public static final String ELEMENT_NAME_KEY_FOR_DIAGRAM_MATCHING = "NAME";
    public static final String IMAGE_INCLUSION_CLASS_REGEX = "NAME";
    public static final String IMAGE_INCLUSION_PACKAGE_REGEX = "NAME";
    public static final String INPUTELEMENTID = "INPUT";
    public static final String PARAM_INPUT_EXCLUDED_PACKAGES = "excludedPackages";
    public static final String PARAM_CONSTRAINT_EXCEL_FILE = "constraintExcelFile";
    public static final String PARAM_IGNORE_ENCODING_RULE_TVS = "ignoreEncodingRuleTaggedValues";
    public static final String PARAM_ONLY_DEFERRABLE_OUTPUT_WRITE = "onlyDeferrableOutputWrite";
    public static final String PARAM_USE_STRING_INTERNING = "useStringInterning";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_PROHIBIT_LOADING_CLASSES_WITH_STATUS_TV = "prohibitLoadingClassesWithStatusTaggedValue";
    public static final String[] DEFAULT_FOR_PROHIBIT_LOADING_CLASSES_WITH_STATUS_TV = new String[]{"notValid", "retired", "superseded"};
    private boolean prohibitedStatusValuesWhenLoadingClasses_accessed = false;
    protected Set<String> prohibitedStatusValuesWhenLoadingClasses = null;
    public static final String PARAM_SKIP_SEMANTIC_VALIDATION_OF_CONFIG = "skipSemanticValidationOfShapeChangeConfiguration";
    public static final String PARAM_TAGGED_VALUE_IMPL = "taggedValueImplementation";
    public static final String PARAM_DONT_CONSTRUCT_ASSOCIATION_NAMES = "dontConstructAssociationNames";
    public static final String PARAM_LOAD_CONSTRAINT_FOR_SEL_SCHEMAS_ONLY = "loadConstraintsForSelectedSchemasOnly";
    public static final String PARAM_OCLPARSE_NAVIGATE_NON_NAV_ASSOC = "navigatingNonNavigableAssociationsWhenParsingOcl";
    public String xmlNamespaceDefault = "FIXME";
    public String xmlNamespaceAbbreviationDefault = "FIXME";
    public String appSchemaVersion = "unknown";
    public String configFile = null;
    public String GML_NS = "http://www.opengis.net/gml/3.2";
    public static String GMLEXR_NS = "http://www.opengis.net/gml/3.3/exr";
    public String gmlVersion = "3.2";
    public boolean sortedSchemaOutput = false;
    public boolean roseBugFixDuplicateGlobalDataTypes = true;
    public boolean eaBugFixWrongID = true;
    public boolean eaBugFixPublicPackagesAreMarkedAsPrivate = true;
    public boolean eaIncludeExtentsions = true;
    public boolean argoBugFixMissingDOCTYPE = false;
    public static final String DEFAULT_TMP_DIR_PATH = "temp";
    public static final String TMP_DIR_PATH_PARAM = "tmpDirectory";
    protected File tmpDir = null;
    private boolean reportUnrecognizedParametersAsWarnings = false;
    protected HashMap<String, ProcessMode> fTargets = new HashMap();
    protected HashMap<String, String> fParameters = new HashMap();
    protected HashMap<String, String> fReplace = new HashMap();
    protected HashMap<String, MapEntry> fTypeMap = new HashMap();
    protected HashMap<String, MapEntry> fBaseMap = new HashMap();
    protected HashMap<String, MapEntry> fElementMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeGroupMap = new HashMap();
    protected Map<String, Boolean> fXmlReferenceableMap = new HashMap<String, Boolean>();
    protected Map<String, Boolean> fXmlElementHasSimpleContentMap = new HashMap<String, Boolean>();
    protected Map<String, ProcessMapEntry> targetMapEntryByTypeRuleKey = new HashMap<String, ProcessMapEntry>();
    protected HashMap<String, String> fStereotypeAliases = new HashMap();
    protected HashMap<String, String> fTagAliases = new HashMap();
    protected HashMap<String, String> fDescriptorSources = new HashMap();
    public static final String DERIVED_DOCUMENTATION_DEFAULT_TEMPLATE = "[[definition]]";
    public static final String DERIVED_DOCUMENTATION_DEFAULT_NOVALUE = "";
    public static final String LF = System.getProperty("line.separator");
    public static final String DERIVED_DOCUMENTATION_INSPIRE_TEMPLATE = "-- Name --" + LF + "[[alias]]" + LF + LF + "-- Definition --" + LF + "[[definition]]" + LF + LF + "-- Description --" + LF + "[[description]]";
    protected HashMap<String, MapEntry> fNamespaces = new HashMap();
    protected HashMap<String, MapEntry> fPackages = new HashMap();
    protected HashMap<String, String> fSchemaLocations = new HashMap();
    protected TargetRegistry targetRegistry;
    protected RuleRegistry ruleRegistry;
    protected InputAndLogParameterRegistry inputAndLogParameterRegistry;
    protected String extractSeparator = null;
    protected String definitionSeparator = null;
    protected String descriptionSeparator = null;
    protected String nameSeparator = null;
    boolean getDescriptorsFromSupertypesInitialised = false;
    boolean getDescriptorsFromSupertypes = false;
    boolean getDescriptorsFromDependencyInitialised = false;
    boolean getDescriptorsFromDependency = true;
    protected boolean constraintCreationForProperties = true;
    protected boolean ignoreEncodingRuleTaggedValues = false;
    protected boolean useStringInterning = false;
    protected boolean dontConstructAssociationNames = false;
    protected boolean allowAllTags = false;
    protected boolean allowAllStereotypes = false;
    protected Set<String> addedStereotypes = new HashSet<String>();
    protected String language = "en";
    protected HashSet<Integer> classTypesToCreateConstraintsFor = null;
    protected InputConfiguration inputConfig = null;
    protected Map<String, String> dialogParameters = null;
    protected Map<String, String> logParameters = new HashMap<String, String>();
    protected ProcessConfiguration currentProcessConfig = null;
    protected List<TargetConfiguration> inputTargetConfigs = new ArrayList<TargetConfiguration>();
    protected List<TransformerConfiguration> inputTransformerConfigs = new ArrayList<TransformerConfiguration>();
    private String inputId = null;
    private List<TargetConfiguration> targetConfigs = null;
    private Map<String, TransformerConfiguration> transformerConfigs = null;
    protected File imageTmpDir = null;
    protected File linkedDocTmpDir = null;
    protected TaggedValueNormalizer tvNormalizer = null;
    private Map<String, AIXMSchemaInfos.AIXMSchemaInfo> schemaInfos;

    public String extractSeparator() {
        if (this.extractSeparator == null) {
            this.extractSeparator = this.parameter("extractSeparator");
        }
        return this.extractSeparator;
    }

    public String definitionSeparator() {
        if (this.definitionSeparator == null) {
            this.definitionSeparator = this.parameter("definitionSeparator");
        }
        return this.definitionSeparator;
    }

    public String descriptionSeparator() {
        if (this.descriptionSeparator == null) {
            this.descriptionSeparator = this.parameter("descriptionSeparator");
        }
        return this.descriptionSeparator;
    }

    public String nameSeparator() {
        if (this.nameSeparator == null) {
            this.nameSeparator = this.parameter("nameSeparator");
        }
        return this.nameSeparator;
    }

    public boolean getDescriptorsFromSupertypes() {
        if (!this.getDescriptorsFromSupertypesInitialised) {
            this.getDescriptorsFromSupertypesInitialised = true;
            String s = this.parameter("inheritDocumentation");
            if (s == null || !s.equals("true")) {
                s = this.parameter(FeatureCatalogue.class.getName(), "inheritDocumentation");
            }
            if (s != null && s.equals("true")) {
                this.getDescriptorsFromSupertypes = true;
            }
        }
        return this.getDescriptorsFromSupertypes;
    }

    public boolean getDescriptorsFromDepedency() {
        if (!this.getDescriptorsFromDependencyInitialised) {
            this.getDescriptorsFromDependencyInitialised = true;
            String s = this.parameter("documentationFromDependency");
            if (s != null && s.equals("false")) {
                this.getDescriptorsFromDependency = false;
            }
        }
        return this.getDescriptorsFromDependency;
    }

    public boolean reportUnrecognizedParametersAsWarnings() {
        return this.reportUnrecognizedParametersAsWarnings;
    }

    public boolean isConstraintCreationForProperties() {
        return this.constraintCreationForProperties;
    }

    public boolean isAIXM() {
        return this.parameter("isAIXM") != null && this.parameter("isAIXM").equalsIgnoreCase("true");
    }

    public boolean isLoadConstraintsForSelectedSchemasOnly() {
        return this.parameter(PARAM_LOAD_CONSTRAINT_FOR_SEL_SCHEMAS_ONLY) != null && this.parameter(PARAM_LOAD_CONSTRAINT_FOR_SEL_SCHEMAS_ONLY).equalsIgnoreCase("true");
    }

    public boolean isNavigatingNonNavigableAssociationsWhenParsingOcl() {
        if (this.currentProcessConfig != null) {
            return this.currentProcessConfig.parameterAsBoolean(PARAM_OCLPARSE_NAVIGATE_NON_NAV_ASSOC, false);
        }
        return "true".equalsIgnoreCase(this.parameter(PARAM_OCLPARSE_NAVIGATE_NON_NAV_ASSOC));
    }

    public boolean isOnlyDeferrableOutputWrite() {
        return this.parameter(PARAM_ONLY_DEFERRABLE_OUTPUT_WRITE) != null && this.parameter(PARAM_ONLY_DEFERRABLE_OUTPUT_WRITE).equalsIgnoreCase("true");
    }

    public boolean ignoreEncodingRuleTaggedValues() {
        return this.ignoreEncodingRuleTaggedValues;
    }

    public boolean isClassTypeToCreateConstraintsFor(int classCategory) {
        if (this.classTypesToCreateConstraintsFor == null) {
            return true;
        }
        return this.classTypesToCreateConstraintsFor.contains(classCategory);
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3, String s4) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3, s4));
    }

    public MapEntry typeMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fTypeMap.get(k1 + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    public void addTargetTypeMapEntry(ProcessMapEntry pme) {
        this.targetMapEntryByTypeRuleKey.put(pme.getType() + "#" + pme.getRule().toLowerCase(), pme);
    }

    public ProcessMapEntry targetMapEntry(String type, String rule) {
        ProcessMapEntry pme = null;
        while (pme == null && rule != null) {
            pme = this.targetMapEntryByTypeRuleKey.get(type + "#" + rule.toLowerCase());
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return pme;
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fBaseMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry baseMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fBaseMap.get(k1 + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    public MapEntry baseMapEntry(String k1, String k2, String xmlTypeType, String xmlTypeContent) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            MapEntry mex = this.fBaseMap.get(k1 + "#" + rule);
            if (mex != null && mex.p2.equalsIgnoreCase(xmlTypeType + "/" + xmlTypeContent)) {
                me = mex;
            }
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2) {
        this.fElementMap.put(k1 + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fElementMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry elementMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fElementMap.get(k1 + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    protected void addAttributeMapEntry(String k1, String k2, String s1) {
        this.fAttributeMap.put(k1 + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fAttributeMap.get(k1 + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    protected void addAttributeGroupMapEntry(String k1, String k2, String s1) {
        this.fAttributeGroupMap.put(k1 + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeGroupMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fAttributeGroupMap.get(k1 + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return me;
    }

    protected void addTarget(String k1, ProcessMode k2) {
        this.fTargets.put(k1, k2);
    }

    public Vector<String> targets() {
        Vector<String> res = new Vector<String>();
        for (String t : this.fTargets.keySet()) {
            res.add(t);
        }
        return res;
    }

    public ProcessMode targetMode(String targetClassName) {
        ProcessMode processMode = targetClassName == null ? ProcessMode.disabled : (this.fTargets.get(targetClassName) == null ? ProcessMode.disabled : this.fTargets.get(targetClassName));
        return processMode;
    }

    public ProcessMode setTargetMode(String tn, ProcessMode mode) {
        return this.fTargets.put(tn, mode);
    }

    public String parameter(String k1) {
        return this.fParameters.get(k1);
    }

    public String parameter(String t, String k1) {
        if (t == null) {
            return this.fParameters.get(k1);
        }
        return this.fParameters.get(t + "::" + k1);
    }

    public boolean hasParameter(String className, String parameterName) {
        Object key = className == null ? parameterName : className + "::" + parameterName;
        return this.fParameters.containsKey(key);
    }

    public String parameterAsString(String className, String parameterName, String defaultValue, boolean allowNonEmptyTrimmedStringValue, boolean trimValue) {
        String result = this.parameter(className, parameterName);
        if (result == null || result.trim().isEmpty() && !allowNonEmptyTrimmedStringValue) {
            result = defaultValue;
        } else if (trimValue) {
            result = result.trim();
        }
        return result;
    }

    public List<String> parameterAsStringList(String className, String parameterName, String[] defaultValues, boolean omitEmptyStrings, boolean trimResults) {
        List result;
        ArrayList<String> defaultValuesList = defaultValues == null ? new ArrayList() : Arrays.asList(defaultValues);
        String paramValue = this.parameter(className, parameterName);
        if (paramValue == null) {
            return defaultValuesList;
        }
        Splitter splitter = Splitter.on((char)',');
        if (omitEmptyStrings) {
            splitter = splitter.omitEmptyStrings();
        }
        if (trimResults) {
            splitter = splitter.trimResults();
        }
        if ((result = splitter.splitToList((CharSequence)paramValue)).isEmpty()) {
            return defaultValuesList;
        }
        return new ArrayList<String>(result);
    }

    public int parameterAsInteger(String className, String parameterName, int defaultValue) {
        int res;
        String valueByConfig = this.parameter(className, parameterName);
        if (valueByConfig == null) {
            res = defaultValue;
        } else {
            try {
                res = Integer.parseInt(valueByConfig);
            }
            catch (NumberFormatException e) {
                res = defaultValue;
            }
        }
        return res;
    }

    public byte parameterAsByte(String className, String parameterName, byte defaultValue) {
        byte res;
        String valueByConfig = this.parameter(className, parameterName);
        if (valueByConfig == null) {
            res = defaultValue;
        } else {
            try {
                res = Byte.parseByte(valueByConfig);
            }
            catch (NumberFormatException e) {
                res = defaultValue;
            }
        }
        return res;
    }

    public boolean parameterAsBoolean(String className, String parameterName, boolean defaultValue) {
        String valueByConfig = this.parameter(className, parameterName);
        boolean res = valueByConfig == null ? defaultValue : Boolean.parseBoolean(valueByConfig.trim());
        return res;
    }

    public String[] parameterNamesByRegex(String t, String regex) {
        HashSet<String> pnames = new HashSet<String>();
        int lt2 = t.length() + 2;
        for (Map.Entry<String, String> e : this.fParameters.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(t + "::") || !Pattern.matches(regex, key.substring(lt2))) continue;
            pnames.add(key.substring(lt2));
        }
        return pnames.toArray(new String[0]);
    }

    public void setParameter(String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(k1.trim(), s);
        } else {
            this.fParameters.put(k1.trim(), s1);
        }
    }

    public void setParameter(String t, String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(t + "::" + k1.trim(), s);
        } else {
            this.fParameters.put(t + "::" + k1.trim(), s1);
        }
    }

    public String replaceValue(String k1) {
        return this.fReplace.get(k1);
    }

    public void setReplaceValue(String k1, String s1) {
        this.fReplace.put(k1, s1);
    }

    protected void addStereotypeAlias(String alias, String wellknown) {
        this.fStereotypeAliases.put(alias.toLowerCase(), wellknown);
    }

    public String stereotypeAlias(String alias) {
        return this.fStereotypeAliases.get(alias.toLowerCase());
    }

    protected void addTagAlias(String alias, String wellknown) {
        this.fTagAliases.put(alias.toLowerCase(Locale.ENGLISH), wellknown);
    }

    public String tagAlias(String alias) {
        return this.fTagAliases.get(alias.toLowerCase(Locale.ENGLISH));
    }

    protected void addDescriptorSource(String descriptor, String source) {
        this.fDescriptorSources.put(descriptor, source);
    }

    public String descriptorSource(String descriptor) {
        return this.fDescriptorSources.get(descriptor.toLowerCase());
    }

    protected void addNamespace(String k1, String s1, String s2) {
        this.fNamespaces.put(k1, new MapEntry(s1, s2));
    }

    protected void addPackage(String k1, String s1, String s2, String s3, String s4) {
        this.fPackages.put(k1, new MapEntry(s1, s2, s3, s4));
    }

    public void addSchemaLocation(String k1, String s1) {
        this.fSchemaLocations.put(k1, s1);
    }

    protected MapEntry namespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        return me;
    }

    public String nsabrForNamespace(String ns) {
        for (String nsabr : this.fNamespaces.keySet()) {
            MapEntry me = this.fNamespaces.get(nsabr);
            if (!me.rule.equals(ns)) continue;
            return nsabr;
        }
        return null;
    }

    public String fullNamespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsabrOfPackage(String packageName) {
        MapEntry me = this.fPackages.get(packageName);
        if (me != null) {
            return me.p1;
        }
        return null;
    }

    public String xsdOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p2;
        }
        return null;
    }

    public String versionOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p3;
        }
        return null;
    }

    public String schemaLocationOfNamespace(String k1) {
        String loc = this.fSchemaLocations.get(k1);
        return loc;
    }

    public String categoryName(int category) {
        switch (category) {
            case 16: {
                return "aixmextension";
            }
            case -1: {
                return "unknown";
            }
            case 1: {
                return "feature";
            }
            case 2: {
                return "codelist";
            }
            case 3: {
                return "enumeration";
            }
            case 4: {
                return "mixin";
            }
            case 5: {
                return "datatype";
            }
            case 6: {
                return "object";
            }
            case 7: {
                return "basic type";
            }
            case 8: {
                return "union";
            }
            case 11: {
                return "okstra key";
            }
            case 12: {
                return "okstra fid";
            }
            case 13: {
                return "feature concept";
            }
            case 14: {
                return "attribute concept";
            }
            case 15: {
                return "value concept";
            }
            case 17: {
                return "role concept";
            }
        }
        return "unknown category";
    }

    public void loadConfiguration() throws ShapeChangeAbortException {
        String m;
        InputStream configStream = null;
        if (this.configFile == null) {
            Object minConfigFile = "/config/minimal.xml";
            configStream = this.getClass().getResourceAsStream((String)minConfigFile);
            if (configStream == null) {
                File file = new File((String)(minConfigFile = "src/main/resources" + (String)minConfigFile));
                if (file.exists()) {
                    try {
                        configStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e1) {
                        throw new ShapeChangeAbortException("Minimal configuration file not found: " + (String)minConfigFile);
                    }
                } else {
                    String configURL = "http://shapechange.net/resources/config/minimal.xml";
                    try {
                        URL url = new URL(configURL);
                        configStream = url.openStream();
                    }
                    catch (MalformedURLException e) {
                        throw new ShapeChangeAbortException("Minimal configuration file not accessible from: " + configURL + " (malformed URL)");
                    }
                    catch (IOException e) {
                        throw new ShapeChangeAbortException("Minimal configuration file not accessible from: " + configURL + " (IO error)");
                    }
                }
            }
        } else {
            File file = new File(this.configFile);
            if (file == null || !file.exists()) {
                try {
                    configStream = new URL(this.configFile).openStream();
                }
                catch (MalformedURLException e) {
                    throw new ShapeChangeAbortException("No configuration file found at " + this.configFile + " (malformed URL)");
                }
                catch (IOException e) {
                    throw new ShapeChangeAbortException("No configuration file found at " + this.configFile + " (IO exception)");
                }
            }
            try {
                configStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ShapeChangeAbortException("No configuration file found at " + this.configFile);
            }
            if (configStream == null) {
                throw new ShapeChangeAbortException("No configuration file found at " + this.configFile);
            }
        }
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler handler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            builder = factory.newDocumentBuilder();
            handler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(handler);
        }
        catch (FactoryConfigurationError e) {
            throw new ShapeChangeAbortException("Unable to get a document builder factory.");
        }
        catch (ParserConfigurationException e) {
            throw new ShapeChangeAbortException("XML Parser was unable to be configured.");
        }
        try {
            String language_value;
            String addStereotypes_value;
            String string;
            String dontConstructAssociationNames_value;
            String useStringInterning_value;
            String ignoreEncodingRuleTaggedValues;
            String constraintCreationForProperties;
            Node node;
            Document document = builder.parse(configStream);
            if (handler.errorsFound()) {
                throw new ShapeChangeAbortException("Invalid configuration file.");
            }
            NodeList nl = document.getElementsByTagName("input");
            Element inputElement = (Element)nl.item(0);
            if (inputElement.hasAttribute("id")) {
                this.inputId = inputElement.getAttribute("id").trim();
                if (this.inputId.length() == 0) {
                    this.inputId = null;
                }
            } else {
                this.inputId = INPUTELEMENTID;
            }
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            nl = inputElement.getElementsByTagName("parameter");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element e = (Element)nl.item(j);
                String key = e.getAttribute("name");
                String val = e.getAttribute("value");
                inputParameters.put(key, val);
            }
            HashMap<String, String> stereotypeAliases = new HashMap<String, String>();
            nl = inputElement.getElementsByTagName("StereotypeAlias");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element e = (Element)nl.item(j);
                String key = e.getAttribute("alias");
                String val = e.getAttribute("wellknown");
                key = key.toLowerCase();
                val = val.toLowerCase();
                stereotypeAliases.put(key, val);
            }
            HashMap<String, String> tagAliases = new HashMap<String, String>();
            nl = inputElement.getElementsByTagName("TagAlias");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element e = (Element)nl.item(j);
                String key = e.getAttribute("alias");
                String val = e.getAttribute("wellknown");
                tagAliases.put(key, val);
            }
            HashMap<String, String> descriptorSources = new HashMap<String, String>();
            nl = inputElement.getElementsByTagName("DescriptorSource");
            for (int j = 0; j < nl.getLength(); ++j) {
                String s;
                Element e = (Element)nl.item(j);
                String key = e.getAttribute("descriptor");
                Object val = e.getAttribute("source");
                key = key.toLowerCase();
                if (((String)(val = ((String)val).toLowerCase())).equals("sc:extract")) {
                    s = e.getAttribute("token");
                    val = (String)val + "#" + (s == null ? DERIVED_DOCUMENTATION_DEFAULT_NOVALUE : s);
                } else if (((String)val).equals("tag")) {
                    s = e.getAttribute("tag");
                    val = (String)val + "#" + (s == null ? DERIVED_DOCUMENTATION_DEFAULT_NOVALUE : s);
                }
                descriptorSources.put(key, (String)val);
            }
            Map<String, PackageInfoConfiguration> packageInfos = this.parsePackageInfos(inputElement);
            this.inputConfig = new InputConfiguration(this.inputId, inputParameters, stereotypeAliases, tagAliases, descriptorSources, packageInfos);
            nl = document.getElementsByTagName("dialog");
            if (nl != null && nl.getLength() != 0) {
                for (int k = 0; k < nl.getLength(); ++k) {
                    node = nl.item(k);
                    if (node.getNodeType() != 1) continue;
                    Element dialogElement = (Element)node;
                    this.dialogParameters = this.parseParameters(dialogElement, "parameter");
                }
            }
            if ((nl = document.getElementsByTagName("log")) != null && nl.getLength() != 0) {
                for (int k = 0; k < nl.getLength(); ++k) {
                    node = nl.item(k);
                    if (node.getNodeType() != 1) continue;
                    Element logElement = (Element)node;
                    this.logParameters = this.parseParameters(logElement, "parameter");
                    if (!this.logParameters.containsKey("reportUnrecognizedParametersAsWarnings") || !this.logParameters.get("reportUnrecognizedParametersAsWarnings").equalsIgnoreCase("true")) continue;
                    this.reportUnrecognizedParametersAsWarnings = true;
                }
            }
            this.transformerConfigs = this.parseTransformerConfigurations(document);
            this.targetConfigs = this.parseTargetConfigurations(document);
            this.resetFields();
            for (TargetConfiguration tgtConfig : this.targetConfigs) {
                String className = tgtConfig.getClassName();
                ProcessMode mode = tgtConfig.getProcessMode();
                if (!this.fTargets.containsKey(className)) {
                    this.addTarget(className, mode);
                } else if (this.fTargets.get(className).equals((Object)ProcessMode.disabled)) {
                    this.addTarget(className, mode);
                }
                if (!tgtConfig.getProcessMode().equals((Object)ProcessMode.disabled)) {
                    for (ProcessRuleSet processRuleSet : tgtConfig.getRuleSets().values()) {
                        this.ruleRegistry.addRuleSet(processRuleSet);
                    }
                    for (String string2 : tgtConfig.getParameters().keySet()) {
                        this.setParameter(className, string2, tgtConfig.getParameters().get(string2));
                    }
                }
                if (tgtConfig instanceof TargetXmlSchemaConfiguration) {
                    TargetXmlSchemaConfiguration config = (TargetXmlSchemaConfiguration)tgtConfig;
                    for (XmlNamespace xns : config.getXmlNamespaces()) {
                        this.addNamespace(xns.getNsabr(), xns.getNs(), xns.getLocation());
                        this.addSchemaLocation(xns.getNs(), xns.getLocation());
                    }
                    this.addXsdMapEntries(config.getXsdMapEntries());
                    continue;
                }
                for (ProcessMapEntry processMapEntry : tgtConfig.getMapEntries()) {
                    this.addTargetTypeMapEntry(processMapEntry);
                }
            }
            for (TargetConfiguration tgtConfig : this.targetConfigs) {
                for (String inputIdref : tgtConfig.getInputIds()) {
                    if (inputIdref.equals(this.getInputId())) {
                        this.inputTargetConfigs.add(tgtConfig);
                        continue;
                    }
                    this.transformerConfigs.get(inputIdref).addTarget(tgtConfig);
                }
            }
            for (TransformerConfiguration trfConfig : this.transformerConfigs.values()) {
                String[] inputIdref = trfConfig.getInputId();
                if (inputIdref.equals(this.getInputId())) {
                    this.inputTransformerConfigs.add(trfConfig);
                    continue;
                }
                this.transformerConfigs.get(inputIdref).addTransformer(trfConfig);
            }
            String classTypesToCreateConstraintsFor = this.parameter("classTypesToCreateConstraintsFor");
            if (classTypesToCreateConstraintsFor != null && (classTypesToCreateConstraintsFor = classTypesToCreateConstraintsFor.trim()).length() > 0) {
                String[] stereotypes = classTypesToCreateConstraintsFor.split("\\W*,\\W*");
                this.classTypesToCreateConstraintsFor = new HashSet();
                for (String string3 : stereotypes) {
                    String sForCons = string3.toLowerCase();
                    if (sForCons.equals("enumeration")) {
                        this.classTypesToCreateConstraintsFor.add(3);
                        continue;
                    }
                    if (sForCons.equals("codelist")) {
                        this.classTypesToCreateConstraintsFor.add(2);
                        continue;
                    }
                    if (sForCons.equals("schluesseltabelle")) {
                        this.classTypesToCreateConstraintsFor.add(11);
                        continue;
                    }
                    if (sForCons.equals("fachid")) {
                        this.classTypesToCreateConstraintsFor.add(12);
                        continue;
                    }
                    if (sForCons.equals("datatype")) {
                        this.classTypesToCreateConstraintsFor.add(5);
                        continue;
                    }
                    if (sForCons.equals("union")) {
                        this.classTypesToCreateConstraintsFor.add(8);
                        continue;
                    }
                    if (sForCons.equals("featureconcept")) {
                        this.classTypesToCreateConstraintsFor.add(13);
                        continue;
                    }
                    if (sForCons.equals("attributeconcept")) {
                        this.classTypesToCreateConstraintsFor.add(14);
                        continue;
                    }
                    if (sForCons.equals("roleconcept")) {
                        this.classTypesToCreateConstraintsFor.add(17);
                        continue;
                    }
                    if (sForCons.equals("valueconcept")) {
                        this.classTypesToCreateConstraintsFor.add(15);
                        continue;
                    }
                    if (sForCons.equals("interface")) {
                        this.classTypesToCreateConstraintsFor.add(4);
                        continue;
                    }
                    if (sForCons.equals("basictype")) {
                        this.classTypesToCreateConstraintsFor.add(7);
                        continue;
                    }
                    if (sForCons.equals("adeelement")) {
                        this.classTypesToCreateConstraintsFor.add(1);
                        continue;
                    }
                    if (sForCons.equals("featuretype")) {
                        this.classTypesToCreateConstraintsFor.add(1);
                        continue;
                    }
                    if (sForCons.equals("type")) {
                        this.classTypesToCreateConstraintsFor.add(6);
                        continue;
                    }
                    this.classTypesToCreateConstraintsFor.add(-1);
                }
            }
            if ((constraintCreationForProperties = this.parameter("constraintCreationForProperties")) != null && constraintCreationForProperties.trim().equalsIgnoreCase("false")) {
                this.constraintCreationForProperties = false;
            }
            if ((ignoreEncodingRuleTaggedValues = this.parameter(PARAM_IGNORE_ENCODING_RULE_TVS)) != null && ignoreEncodingRuleTaggedValues.trim().equalsIgnoreCase("true")) {
                this.ignoreEncodingRuleTaggedValues = true;
            }
            if ((useStringInterning_value = this.parameter(PARAM_USE_STRING_INTERNING)) != null && useStringInterning_value.trim().equalsIgnoreCase("true")) {
                this.useStringInterning = true;
            }
            if ((dontConstructAssociationNames_value = this.parameter(PARAM_DONT_CONSTRUCT_ASSOCIATION_NAMES)) != null && dontConstructAssociationNames_value.trim().equalsIgnoreCase("true")) {
                this.dontConstructAssociationNames = true;
            }
            if ((string = this.parameter("addTaggedValues")) != null && string.trim().equals("*")) {
                this.allowAllTags = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(addStereotypes_value = this.parameter("addStereotypes")))) {
                if (addStereotypes_value.trim().equals("*")) {
                    this.allowAllStereotypes = true;
                } else {
                    String[] as;
                    for (String s : as = StringUtils.split((String)addStereotypes_value, (String)",")) {
                        if (StringUtils.stripToNull((String)s) == null) continue;
                        this.addedStereotypes.add(s.trim());
                    }
                }
            }
            if ((language_value = this.inputConfig.getParameters().get(PARAM_LANGUAGE)) != null && !language_value.trim().isEmpty()) {
                this.language = language_value.trim().toLowerCase();
            }
        }
        catch (SAXException e) {
            m = e.getMessage();
            if (m != null) {
                throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + System.err);
        }
        catch (IOException e) {
            m = e.getMessage();
            if (m != null) {
                throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + System.err);
        }
        MapEntry nsme = this.namespace("gml");
        if (nsme != null) {
            this.GML_NS = nsme.rule;
        }
    }

    private void addXmlElementHasSimpleContent(String type, String xsdEncodingRule, Boolean xmlElementHasSimpleContent) {
        this.fXmlElementHasSimpleContentMap.put(type + "#" + xsdEncodingRule, xmlElementHasSimpleContent);
    }

    public Boolean xmlElementHasSimpleContent(String type, String xsdEncodingRule) {
        String rule = xsdEncodingRule;
        Boolean val = null;
        while (val == null && rule != null) {
            val = this.fXmlElementHasSimpleContentMap.get(type + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return val;
    }

    private void addXmlReferenceableMapEntry(String type, String xsdEncodingRule, Boolean xmlReferenceable) {
        this.fXmlReferenceableMap.put(type + "#" + xsdEncodingRule, xmlReferenceable);
    }

    public Boolean xmlReferenceable(String type, String xsdEncodingRule) {
        String rule = xsdEncodingRule;
        Boolean val = null;
        while (val == null && rule != null) {
            val = this.fXmlReferenceableMap.get(type + "#" + rule);
            rule = this.ruleRegistry.extendsEncRule(rule);
        }
        return val;
    }

    public void resetFields() {
        MapEntry mapEntry;
        this.fParameters = new HashMap();
        this.fTypeMap = new HashMap();
        this.fBaseMap = new HashMap();
        this.fElementMap = new HashMap();
        this.fAttributeMap = new HashMap();
        this.fAttributeGroupMap = new HashMap();
        this.targetMapEntryByTypeRuleKey = new HashMap<String, ProcessMapEntry>();
        this.fStereotypeAliases = new HashMap();
        this.fTagAliases = new HashMap();
        this.fDescriptorSources = new HashMap();
        this.fNamespaces = new HashMap();
        this.fPackages = new HashMap();
        this.fSchemaLocations = new HashMap();
        this.setStandardParameters();
        this.ruleRegistry.reset();
        for (String string : this.inputConfig.getParameters().keySet()) {
            this.setParameter(string, this.inputConfig.getParameters().get(string));
        }
        for (String string : this.inputConfig.getStereotypeAliases().keySet()) {
            this.addStereotypeAlias(string, this.inputConfig.getStereotypeAliases().get(string));
        }
        for (String string : this.inputConfig.getTagAliases().keySet()) {
            this.addTagAlias(string, this.inputConfig.getTagAliases().get(string));
        }
        for (String string : this.inputConfig.getDescriptorSources().keySet()) {
            this.addDescriptorSource(string, (String)this.inputConfig.getDescriptorSources().get(string));
        }
        for (PackageInfoConfiguration packageInfoConfiguration : this.inputConfig.getPackageInfos().values()) {
            this.addPackage(packageInfoConfiguration.getPackageName(), packageInfoConfiguration.getNs(), packageInfoConfiguration.getNsabr(), packageInfoConfiguration.getXsdDocument(), packageInfoConfiguration.getVersion());
            this.addSchemaLocation(packageInfoConfiguration.getNs(), packageInfoConfiguration.getXsdDocument());
        }
        if (this.dialogParameters != null) {
            for (String string : this.dialogParameters.keySet()) {
                this.setParameter(string, this.dialogParameters.get(string));
            }
        }
        for (String string : this.logParameters.keySet()) {
            this.setParameter(string, this.logParameters.get(string));
        }
        int countXmlSchemaConfigs = 0;
        for (TargetConfiguration targetConfiguration : this.targetConfigs) {
            if (targetConfiguration.getProcessMode().equals((Object)ProcessMode.disabled) || !(targetConfiguration instanceof TargetXmlSchemaConfiguration) || this.currentProcessConfig != null && this.currentProcessConfig instanceof TargetXmlSchemaConfiguration) continue;
            if (++countXmlSchemaConfigs == 2) {
                System.out.println("Warning: Multiple non-disabled XmlSchema targets found in the ShapeChange configuration. If these targets have different encoding rules or different values for the target parameter defaultEncodingRule, that may lead to unexpected results.");
            }
            for (ProcessRuleSet prs : targetConfiguration.getRuleSets().values()) {
                this.ruleRegistry.addRuleSet(prs);
            }
            if (!targetConfiguration.hasParameter("defaultEncodingRule")) continue;
            this.setParameter(targetConfiguration.getClassName(), "defaultEncodingRule", targetConfiguration.getParameters().get("defaultEncodingRule"));
        }
        if (this.currentProcessConfig != null) {
            this.gmlVersion = this.currentProcessConfig.getGmlVersion();
            if (this.currentProcessConfig instanceof TargetConfiguration) {
                for (String string : this.currentProcessConfig.getParameters().keySet()) {
                    this.setParameter(this.currentProcessConfig.getClassName(), string, this.currentProcessConfig.getParameters().get(string));
                }
                for (ProcessRuleSet processRuleSet : this.currentProcessConfig.getRuleSets().values()) {
                    this.ruleRegistry.addRuleSet(processRuleSet);
                }
            }
            if (this.currentProcessConfig.getClassName().equals(TargetFOL2SchematronClass) && this.currentProcessConfig.getParameters().get("defaultEncodingRule") != null) {
                this.setParameter(TargetXmlSchemaClass, "defaultEncodingRule", this.currentProcessConfig.getParameters().get("defaultEncodingRule"));
            }
            if (this.currentProcessConfig instanceof TargetXmlSchemaConfiguration) {
                TargetXmlSchemaConfiguration targetXmlSchemaConfiguration = (TargetXmlSchemaConfiguration)this.currentProcessConfig;
                for (XmlNamespace xns : targetXmlSchemaConfiguration.getXmlNamespaces()) {
                    this.addNamespace(xns.getNsabr(), xns.getNs(), xns.getLocation());
                    this.addSchemaLocation(xns.getNs(), xns.getLocation());
                }
                this.addXsdMapEntries(targetXmlSchemaConfiguration.getXsdMapEntries());
            } else {
                for (ProcessMapEntry processMapEntry : this.currentProcessConfig.getMapEntries()) {
                    this.addTargetTypeMapEntry(processMapEntry);
                }
            }
        }
        if ((mapEntry = this.namespace("gml")) != null) {
            this.GML_NS = mapEntry.rule;
        }
    }

    private void addXsdMapEntries(List<XsdMapEntry> xsdMapEntries) {
        for (XsdMapEntry xsdme : xsdMapEntries) {
            for (String xsdEncodingRule : xsdme.getEncodingRules()) {
                String type = xsdme.getType();
                String xmlPropertyType = xsdme.getXmlPropertyType();
                String xmlElement = xsdme.getXmlElement();
                String xmlTypeContent = xsdme.getXmlTypeContent();
                String xmlTypeNilReason = xsdme.getXmlTypeNilReason();
                String xmlType = xsdme.getXmlType();
                String xmlTypeType = xsdme.getXmlTypeType();
                String xmlAttribute = xsdme.getXmlAttribute();
                String xmlAttributeGroup = xsdme.getXmlAttributeGroup();
                Boolean xmlReferenceable = xsdme.getXmlReferenceable();
                Boolean xmlElementHasSimpleContent = xsdme.getXmlElementHasSimpleContent();
                if (xmlPropertyType != null) {
                    if (xmlPropertyType.equals("_P_") && xmlElement != null) {
                        this.addTypeMapEntry(type, xsdEncodingRule, "propertyType", xmlElement);
                    } else if (xmlPropertyType.equals("_MP_") && xmlElement != null) {
                        this.addTypeMapEntry(type, xsdEncodingRule, "metadataPropertyType", xmlElement);
                    } else {
                        this.addTypeMapEntry(type, xsdEncodingRule, "direct", xmlPropertyType, xmlTypeType + "/" + xmlTypeContent, xmlTypeNilReason);
                    }
                }
                if (xmlElement != null) {
                    this.addElementMapEntry(type, xsdEncodingRule, "direct", xmlElement);
                }
                if (xmlType != null) {
                    this.addBaseMapEntry(type, xsdEncodingRule, "direct", xmlType, xmlTypeType + "/" + xmlTypeContent);
                }
                if (xmlAttribute != null) {
                    this.addAttributeMapEntry(type, xsdEncodingRule, xmlAttribute);
                }
                if (xmlAttributeGroup != null) {
                    this.addAttributeGroupMapEntry(type, xsdEncodingRule, xmlAttributeGroup);
                }
                if (xmlReferenceable != null) {
                    this.addXmlReferenceableMapEntry(type, xsdEncodingRule, xmlReferenceable);
                }
                if (xmlElementHasSimpleContent == null) continue;
                this.addXmlElementHasSimpleContent(type, xsdEncodingRule, xmlElementHasSimpleContent);
            }
        }
    }

    private void setStandardParameters() {
        this.setParameter("reportLevel", "INFO");
        this.setParameter("xsltFile", "src/main/resources/xslt/result.xsl");
        this.setParameter("appSchemaName", DERIVED_DOCUMENTATION_DEFAULT_NOVALUE);
        this.setParameter("appSchemaNameRegex", DERIVED_DOCUMENTATION_DEFAULT_NOVALUE);
        this.setParameter("appSchemaNamespaceRegex", DERIVED_DOCUMENTATION_DEFAULT_NOVALUE);
        this.setParameter("publicOnly", "true");
        this.setParameter("inputFile", "http://shapechange.net/resources/test/test.xmi");
        this.setParameter("inputModelType", "XMI10");
        this.setParameter("logFile", "log.xml");
        this.setParameter("representTaggedValues", DERIVED_DOCUMENTATION_DEFAULT_NOVALUE);
        this.setParameter("addTaggedValues", DERIVED_DOCUMENTATION_DEFAULT_NOVALUE);
        this.setParameter("extractSeparator", "--IMPROBABLE--DUMMY--SEPARATOR--");
        this.setParameter("definitionSeparator", "-- Definition --");
        this.setParameter("descriptionSeparator", "-- Description --");
        this.setParameter("nameSeparator", "-- Name --");
        this.setParameter("outputDirectory", SystemUtils.getUserDir().getPath());
        this.setParameter("sortedSchemaOutput", "true");
        this.setParameter("sortedOutput", "true");
        this.setParameter("oclConstraintTypeRegex", "(OCL|Invariant)");
        this.setParameter("folConstraintTypeRegex", "(SBVR)");
        this.setParameter(TargetXmlSchemaClass, "gmlVersion", "3.2");
    }

    private Map<String, PackageInfoConfiguration> parsePackageInfos(Element inputElement) {
        HashMap<String, PackageInfoConfiguration> result = new HashMap<String, PackageInfoConfiguration>();
        NodeList nl = inputElement.getElementsByTagName("PackageInfo");
        for (int j = 0; j < nl.getLength(); ++j) {
            Element e = (Element)nl.item(j);
            String name = StringUtils.stripToNull((String)e.getAttribute("packageName"));
            String nsabr = StringUtils.stripToNull((String)e.getAttribute("nsabr"));
            String ns = StringUtils.stripToNull((String)e.getAttribute("ns"));
            String xsdDocument = StringUtils.stripToNull((String)e.getAttribute("xsdDocument"));
            String version = StringUtils.stripToNull((String)e.getAttribute("version"));
            PackageInfoConfiguration pic = new PackageInfoConfiguration(name, nsabr, ns, xsdDocument, version);
            result.put(name, pic);
        }
        return result;
    }

    private List<TargetConfiguration> parseTargetConfigurations(Document configurationDocument) throws ShapeChangeAbortException {
        ArrayList<TargetConfiguration> tgtConfigs = new ArrayList<TargetConfiguration>();
        NodeList tgtsNl = configurationDocument.getElementsByTagName("targets");
        for (int i = 0; i < tgtsNl.getLength(); ++i) {
            Node tgtsN = tgtsNl.item(i);
            NodeList tgtNl = tgtsN.getChildNodes();
            for (int j = 0; j < tgtNl.getLength(); ++j) {
                TargetConfiguration tgtConfig;
                TreeSet<String> tgtConfigInputs;
                Node tgtN = tgtNl.item(j);
                if (tgtN.getNodeType() != 1) continue;
                Element tgtE = (Element)tgtN;
                String tgtType = tgtE.getNodeName();
                String tgtConfigName = tgtE.getAttribute("class");
                ProcessMode tgtMode = this.parseMode(tgtE);
                Map<String, String> processParameters = this.parseParameters(tgtE, "targetParameter");
                Map<String, ProcessRuleSet> processRuleSets = this.parseRuleSets(tgtE, "EncodingRule", true);
                if (tgtE.hasAttribute("inputs")) {
                    String[] inputs = tgtE.getAttribute("inputs").split("\\s");
                    tgtConfigInputs = new TreeSet<String>(Arrays.asList(inputs));
                } else {
                    tgtConfigInputs = new TreeSet<String>();
                    tgtConfigInputs.add(this.getInputId());
                }
                Element advancedProcessConfigurations = this.parseAdvancedProcessConfigurations(tgtE);
                if (tgtType.equals("Target")) {
                    List<ProcessMapEntry> processMapEntries = this.parseProcessMapEntries(tgtE, "MapEntry");
                    List<Namespace> namespaces = this.parseNamespaces(tgtE);
                    tgtConfig = new TargetConfiguration(tgtConfigName, tgtMode, processParameters, processRuleSets, processMapEntries, tgtConfigInputs, namespaces, advancedProcessConfigurations);
                } else if (tgtType.equals("TargetOwl")) {
                    Map<String, List<RdfTypeMapEntry>> rdfTypeMapEntries = this.parseRdfTypeMapEntries(tgtE);
                    Map<String, List<RdfPropertyMapEntry>> rdfPropertyMapEntries = this.parseRdfPropertyMapEntries(tgtE);
                    SortedMap<String, List<StereotypeConversionParameter>> stereotypeConversionParameters = this.parseStereotypeConversionParameters(tgtE);
                    Map<String, List<TypeConversionParameter>> typeConversionParameters = this.parseTypeConversionParameters(tgtE);
                    Map<String, List<PropertyConversionParameter>> propertyConversionParameters = this.parsePropertyConversionParameters(tgtE);
                    List<DescriptorTarget> descriptorTargets = this.parseDescriptorTargets(tgtE);
                    SortedMap<ConstraintMapping.ConstraintType, ConstraintMapping> constraintMappings = this.parseConstraintMappings(tgtE);
                    List<RdfGeneralProperty> generalProperties = this.parseGeneralProperties(tgtE);
                    List<Namespace> namespaces = this.parseNamespaces(tgtE);
                    TargetOwlConfiguration owlConfig = new TargetOwlConfiguration(tgtConfigName, tgtMode, processParameters, processRuleSets, tgtConfigInputs, namespaces, advancedProcessConfigurations, rdfTypeMapEntries, rdfPropertyMapEntries, stereotypeConversionParameters, typeConversionParameters, propertyConversionParameters, descriptorTargets, constraintMappings, generalProperties);
                    tgtConfig = owlConfig;
                } else {
                    List<XsdMapEntry> xsdMapEntries = this.parseXsdMapEntries(tgtE);
                    Map<String, List<XsdPropertyMapEntry>> xsdPropertyMapEntries = this.parseXsdPropertyMapEntries(tgtE);
                    List<XmlNamespace> xmlNamespaces = this.parseXmlNamespaces(tgtE);
                    tgtConfig = new TargetXmlSchemaConfiguration(tgtConfigName, tgtMode, processParameters, processRuleSets, null, xsdMapEntries, xsdPropertyMapEntries, xmlNamespaces, tgtConfigInputs, advancedProcessConfigurations);
                }
                tgtConfigs.add(tgtConfig);
            }
        }
        return tgtConfigs;
    }

    private Map<String, List<XsdPropertyMapEntry>> parseXsdPropertyMapEntries(Element targetElement) {
        NodeList xpmeNl = targetElement.getElementsByTagName("XsdPropertyMapEntry");
        TreeMap<String, List<XsdPropertyMapEntry>> result = new TreeMap<String, List<XsdPropertyMapEntry>>();
        if (xpmeNl != null && xpmeNl.getLength() != 0) {
            for (int k = 0; k < xpmeNl.getLength(); ++k) {
                List<XsdPropertyMapEntry> list;
                String target;
                Node xpmeN = xpmeNl.item(k);
                if (xpmeN.getNodeType() != 1) continue;
                Element xpmeE = (Element)xpmeN;
                String property = xpmeE.getAttribute("property").trim();
                String schema = xpmeE.hasAttribute("schema") ? xpmeE.getAttribute("schema").trim() : null;
                String string = target = xpmeE.hasAttribute("targetElement") ? xpmeE.getAttribute("targetElement").trim() : null;
                if (StringUtils.isBlank((CharSequence)target)) {
                    target = null;
                }
                XsdPropertyMapEntry xpme = new XsdPropertyMapEntry(property, schema, target);
                if (result.containsKey(property)) {
                    list = (List)result.get(property);
                } else {
                    list = new ArrayList();
                    result.put(property, list);
                }
                list.add(xpme);
            }
        }
        return result;
    }

    private List<RdfGeneralProperty> parseGeneralProperties(Element targetElement) {
        ArrayList<RdfGeneralProperty> result = new ArrayList<RdfGeneralProperty>();
        List<Element> gopEs = XMLUtil.getChildElements(targetElement, "GeneralObjectProperty");
        for (Element gopE : gopEs) {
            GeneralObjectProperty gop = new GeneralObjectProperty(gopE);
            result.add(gop);
        }
        List<Element> gdpEs = XMLUtil.getChildElements(targetElement, "GeneralDataProperty");
        for (Element gdpE : gdpEs) {
            GeneralDataProperty gdp = new GeneralDataProperty(gdpE);
            result.add(gdp);
        }
        return result;
    }

    private Element parseAdvancedProcessConfigurations(Element processElement) {
        NodeList apcNl = processElement.getElementsByTagName("advancedProcessConfigurations");
        if (apcNl != null && apcNl.getLength() != 0) {
            for (int k = 0; k < apcNl.getLength(); ++k) {
                Node apcN = apcNl.item(k);
                if (apcN.getNodeType() != 1) continue;
                Element apcE = (Element)apcN;
                return apcE;
            }
        }
        return null;
    }

    private SortedMap<String, List<StereotypeConversionParameter>> parseStereotypeConversionParameters(Element targetElement) {
        NodeList scpNl = targetElement.getElementsByTagName("StereotypeConversionParameter");
        TreeMap<String, List<StereotypeConversionParameter>> result = new TreeMap<String, List<StereotypeConversionParameter>>();
        if (scpNl != null && scpNl.getLength() != 0) {
            for (int k = 0; k < scpNl.getLength(); ++k) {
                List<StereotypeConversionParameter> list;
                Node scpN = scpNl.item(k);
                if (scpN.getNodeType() != 1) continue;
                Element scpE = (Element)scpN;
                String wellknown = scpE.getAttribute("wellknown").toLowerCase();
                String subClassOf_tmp = scpE.getAttribute("subClassOf").trim();
                TreeSet<String> subClassOf = new TreeSet<String>(Arrays.asList(StringUtils.split((String)subClassOf_tmp)));
                String rule = scpE.hasAttribute("rule") ? scpE.getAttribute("rule").trim() : "*";
                StereotypeConversionParameter scp = new StereotypeConversionParameter(wellknown, subClassOf, rule);
                if (result.containsKey(wellknown)) {
                    list = (List)result.get(wellknown);
                } else {
                    list = new ArrayList();
                    result.put(wellknown, list);
                }
                list.add(scp);
            }
        }
        return result;
    }

    private Map<String, List<TypeConversionParameter>> parseTypeConversionParameters(Element targetElement) {
        NodeList tcpNl = targetElement.getElementsByTagName("TypeConversionParameter");
        TreeMap<String, List<TypeConversionParameter>> result = new TreeMap<String, List<TypeConversionParameter>>();
        if (tcpNl != null && tcpNl.getLength() != 0) {
            for (int k = 0; k < tcpNl.getLength(); ++k) {
                List<TypeConversionParameter> list;
                Node tcpN = tcpNl.item(k);
                if (tcpN.getNodeType() != 1) continue;
                Element tcpE = (Element)tcpN;
                String type = tcpE.getAttribute("type");
                String schema = tcpE.hasAttribute("schema") ? tcpE.getAttribute("schema") : null;
                TreeSet<String> subClassOf = new TreeSet<String>(Arrays.asList(StringUtils.split((String)tcpE.getAttribute("subClassOf"))));
                String rule = tcpE.hasAttribute("rule") ? tcpE.getAttribute("rule") : "*";
                TypeConversionParameter tcp = new TypeConversionParameter(type, schema, subClassOf, rule);
                if (result.containsKey(type)) {
                    list = (List)result.get(type);
                } else {
                    list = new ArrayList();
                    result.put(type, list);
                }
                list.add(tcp);
            }
        }
        return result;
    }

    private Map<String, List<PropertyConversionParameter>> parsePropertyConversionParameters(Element targetElement) {
        NodeList pcpNl = targetElement.getElementsByTagName("PropertyConversionParameter");
        TreeMap<String, List<PropertyConversionParameter>> result = new TreeMap<String, List<PropertyConversionParameter>>();
        if (pcpNl != null && pcpNl.getLength() != 0) {
            for (int k = 0; k < pcpNl.getLength(); ++k) {
                List<PropertyConversionParameter> list;
                Node pcpN = pcpNl.item(k);
                if (pcpN.getNodeType() != 1) continue;
                Element pcpE = (Element)pcpN;
                String property = pcpE.getAttribute("property").trim();
                String schema = pcpE.hasAttribute("schema") ? pcpE.getAttribute("schema").trim() : null;
                boolean global = pcpE.hasAttribute("global") ? DatatypeConverter.parseBoolean((String)pcpE.getAttribute("global")) : false;
                String subPropertyOf_tmp = pcpE.hasAttribute("subPropertyOf") ? pcpE.getAttribute("subPropertyOf").trim() : null;
                TreeSet<String> subPropertyOf = null;
                if (subPropertyOf_tmp != null) {
                    subPropertyOf = new TreeSet<String>(Arrays.asList(StringUtils.split((String)subPropertyOf_tmp)));
                }
                String target = pcpE.hasAttribute("target") ? pcpE.getAttribute("target").trim() : null;
                String targetSchema = pcpE.hasAttribute("targetSchema") ? pcpE.getAttribute("targetSchema").trim() : null;
                String rule = pcpE.hasAttribute("rule") ? pcpE.getAttribute("rule").trim() : "*";
                PropertyConversionParameter pcp = new PropertyConversionParameter(property, schema, global, subPropertyOf, target, targetSchema, rule);
                if (result.containsKey(property)) {
                    list = (List)result.get(property);
                } else {
                    list = new ArrayList();
                    result.put(property, list);
                }
                list.add(pcp);
            }
        }
        return result;
    }

    private Map<String, List<RdfTypeMapEntry>> parseRdfTypeMapEntries(Element targetElement) {
        NodeList rtmeNl = targetElement.getElementsByTagName("RdfTypeMapEntry");
        TreeMap<String, List<RdfTypeMapEntry>> result = new TreeMap<String, List<RdfTypeMapEntry>>();
        if (rtmeNl != null && rtmeNl.getLength() != 0) {
            for (int k = 0; k < rtmeNl.getLength(); ++k) {
                List<RdfTypeMapEntry> list;
                Node rtmeN = rtmeNl.item(k);
                if (rtmeN.getNodeType() != 1) continue;
                Element rtmeE = (Element)rtmeN;
                String type = rtmeE.getAttribute("type").trim();
                String schema = rtmeE.hasAttribute("schema") ? rtmeE.getAttribute("schema").trim() : null;
                String target = rtmeE.getAttribute("target").trim();
                RdfTypeMapEntry.TargetType targetType = RdfTypeMapEntry.TargetType.CLASS;
                if (rtmeE.hasAttribute("targetType")) {
                    String tmp = rtmeE.getAttribute("targetType");
                    targetType = tmp.trim().equalsIgnoreCase("class") ? RdfTypeMapEntry.TargetType.CLASS : RdfTypeMapEntry.TargetType.DATATYPE;
                }
                String rule = rtmeE.hasAttribute("rule") ? rtmeE.getAttribute("rule").trim() : "*";
                RdfTypeMapEntry rtme = new RdfTypeMapEntry(type, schema, target, targetType, rule);
                if (result.containsKey(type)) {
                    list = (List)result.get(type);
                } else {
                    list = new ArrayList();
                    result.put(type, list);
                }
                list.add(rtme);
            }
        }
        return result;
    }

    private Map<String, List<RdfPropertyMapEntry>> parseRdfPropertyMapEntries(Element targetElement) {
        NodeList rpmeNl = targetElement.getElementsByTagName("RdfPropertyMapEntry");
        TreeMap<String, List<RdfPropertyMapEntry>> result = new TreeMap<String, List<RdfPropertyMapEntry>>();
        if (rpmeNl != null && rpmeNl.getLength() != 0) {
            for (int k = 0; k < rpmeNl.getLength(); ++k) {
                List<RdfPropertyMapEntry> list;
                String target;
                Node rpmeN = rpmeNl.item(k);
                if (rpmeN.getNodeType() != 1) continue;
                Element rpmeE = (Element)rpmeN;
                String property = rpmeE.getAttribute("property").trim();
                String schema = rpmeE.hasAttribute("schema") ? rpmeE.getAttribute("schema").trim() : null;
                String string = target = rpmeE.hasAttribute("target") ? rpmeE.getAttribute("target").trim() : null;
                if (target != null && target.isEmpty()) {
                    target = null;
                }
                String range = rpmeE.hasAttribute("range") ? rpmeE.getAttribute("range").trim() : null;
                String rule = rpmeE.hasAttribute("rule") ? rpmeE.getAttribute("rule").trim() : "*";
                RdfPropertyMapEntry rpme = new RdfPropertyMapEntry(property, schema, target, range, rule);
                if (result.containsKey(property)) {
                    list = (List)result.get(property);
                } else {
                    list = new ArrayList();
                    result.put(property, list);
                }
                list.add(rpme);
            }
        }
        return result;
    }

    private SortedMap<ConstraintMapping.ConstraintType, ConstraintMapping> parseConstraintMappings(Element targetElement) {
        NodeList cmNl = targetElement.getElementsByTagName("ConstraintMapping");
        TreeMap<ConstraintMapping.ConstraintType, ConstraintMapping> result = new TreeMap<ConstraintMapping.ConstraintType, ConstraintMapping>();
        if (cmNl != null && cmNl.getLength() != 0) {
            for (int k = 0; k < cmNl.getLength(); ++k) {
                Node cmN = cmNl.item(k);
                if (cmN.getNodeType() != 1) continue;
                Element cmE = (Element)cmN;
                String tmp = cmE.getAttribute("constraintType");
                ConstraintMapping.ConstraintType constraintType = tmp.trim().equalsIgnoreCase("Text") ? ConstraintMapping.ConstraintType.TEXT : (tmp.trim().equalsIgnoreCase("FOL") ? ConstraintMapping.ConstraintType.FOL : ConstraintMapping.ConstraintType.OCL);
                String target = cmE.hasAttribute("target") ? cmE.getAttribute("target").trim() : "iso19150-2:constraint";
                String template = cmE.getAttribute("template");
                String noValue = cmE.hasAttribute("noValue") ? cmE.getAttribute("noValue") : " ";
                String mvct = cmE.hasAttribute("multiValueConnectorToken") ? cmE.getAttribute("multiValueConnectorToken") : " ";
                ConstraintMapping.Format format = ConstraintMapping.Format.STRING;
                if (cmE.hasAttribute("format")) {
                    String tmp2 = cmE.getAttribute("format");
                    format = tmp2.trim().equalsIgnoreCase("string") ? ConstraintMapping.Format.STRING : ConstraintMapping.Format.LANG_STRING;
                }
                ConstraintMapping cm = new ConstraintMapping(constraintType, target, template, noValue, mvct, format);
                result.put(constraintType, cm);
            }
        }
        return result;
    }

    private List<DescriptorTarget> parseDescriptorTargets(Element targetElement) {
        NodeList dtNl = targetElement.getElementsByTagName("DescriptorTarget");
        ArrayList<DescriptorTarget> result = new ArrayList<DescriptorTarget>();
        if (dtNl != null && dtNl.getLength() != 0) {
            for (int k = 0; k < dtNl.getLength(); ++k) {
                Node dtN = dtNl.item(k);
                if (dtN.getNodeType() != 1) continue;
                Element dtE = (Element)dtN;
                String target = dtE.getAttribute("target").trim();
                String template = dtE.getAttribute("template");
                DescriptorTarget.Format format = DescriptorTarget.Format.LANG_STRING;
                if (dtE.hasAttribute("format")) {
                    String tmp = dtE.getAttribute("format");
                    format = tmp.trim().equalsIgnoreCase("string") ? DescriptorTarget.Format.STRING : (tmp.trim().equalsIgnoreCase("IRI") ? DescriptorTarget.Format.IRI : DescriptorTarget.Format.LANG_STRING);
                }
                DescriptorTarget.NoValueBehavior noValueBehavior = DescriptorTarget.NoValueBehavior.INGORE;
                if (dtE.hasAttribute("noValueBehavior")) {
                    String tmp = dtE.getAttribute("noValueBehavior");
                    noValueBehavior = tmp.trim().equalsIgnoreCase("populateOnce") ? DescriptorTarget.NoValueBehavior.POPULATE_ONCE : DescriptorTarget.NoValueBehavior.INGORE;
                }
                String noValueText = dtE.hasAttribute("noValueText") ? dtE.getAttribute("noValueText") : DERIVED_DOCUMENTATION_DEFAULT_NOVALUE;
                DescriptorTarget.MultiValueBehavior multiValueBehavior = DescriptorTarget.MultiValueBehavior.CONNECT_IN_SINGLE_TARGET;
                if (dtE.hasAttribute("multiValueBehavior")) {
                    String tmp = dtE.getAttribute("multiValueBehavior");
                    multiValueBehavior = tmp.trim().equalsIgnoreCase("splitToMultipleTargets") ? DescriptorTarget.MultiValueBehavior.SPLIT_TO_MULTIPLE_TARGETS : DescriptorTarget.MultiValueBehavior.CONNECT_IN_SINGLE_TARGET;
                }
                DescriptorTarget.AppliesTo appliesTo = DescriptorTarget.AppliesTo.ALL;
                if (dtE.hasAttribute("appliesTo")) {
                    String tmp = dtE.getAttribute("appliesTo");
                    appliesTo = tmp.trim().equalsIgnoreCase("ontology") ? DescriptorTarget.AppliesTo.ONTOLOGY : (tmp.trim().equalsIgnoreCase("class") ? DescriptorTarget.AppliesTo.CLASS : (tmp.trim().equalsIgnoreCase("conceptscheme") ? DescriptorTarget.AppliesTo.CONCEPT_SCHEME : (tmp.trim().equalsIgnoreCase("property") ? DescriptorTarget.AppliesTo.PROPERTY : DescriptorTarget.AppliesTo.ALL)));
                }
                String mvct = dtE.hasAttribute("multiValueConnectorToken") ? dtE.getAttribute("multiValueConnectorToken") : " ";
                DescriptorTarget dt = new DescriptorTarget(appliesTo, target, template, format, noValueBehavior, noValueText, multiValueBehavior, mvct);
                result.add(dt);
            }
        }
        return result;
    }

    private List<Namespace> parseNamespaces(Element targetElement) {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        NodeList namespacesNl = targetElement.getElementsByTagName("Namespace");
        if (namespacesNl != null && namespacesNl.getLength() != 0) {
            for (int k = 0; k < namespacesNl.getLength(); ++k) {
                String location;
                Node namespaceN = namespacesNl.item(k);
                if (namespaceN.getNodeType() != 1) continue;
                Element namespaceE = (Element)namespaceN;
                String nsabr = namespaceE.getAttribute("nsabr");
                String ns = namespaceE.getAttribute("ns");
                location = namespaceE.hasAttribute("location") ? (location = namespaceE.getAttribute("location")) : null;
                result.add(new Namespace(nsabr, ns, location));
            }
        }
        return result;
    }

    private Map<String, String> parseParameters(Element processElement, String parameterElementTagName) throws ShapeChangeAbortException {
        String s;
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList parametersNl = processElement.getElementsByTagName(parameterElementTagName);
        if (parametersNl != null && parametersNl.getLength() != 0) {
            for (int k = 0; k < parametersNl.getLength(); ++k) {
                Node parameterN = parametersNl.item(k);
                if (parameterN.getNodeType() != 1) continue;
                Element parameterE = (Element)parameterN;
                result.put(parameterE.getAttribute("name"), parameterE.getAttribute("value"));
            }
        }
        if ((s = (String)result.get("gmlVersion")) != null) {
            if (s.equals("3.3") || s.equals("3.2") || s.equals("3.1") || s.equals("2.1")) {
                this.gmlVersion = s;
            } else {
                throw new ShapeChangeAbortException("Unknown value for gmlVersion: " + s);
            }
        }
        return result;
    }

    private List<XmlNamespace> parseXmlNamespaces(Element targetXmlSchemaElement) {
        ArrayList<XmlNamespace> result = new ArrayList<XmlNamespace>();
        NodeList xmlNamespacesNl = targetXmlSchemaElement.getElementsByTagName("XmlNamespace");
        if (xmlNamespacesNl != null && xmlNamespacesNl.getLength() != 0) {
            for (int k = 0; k < xmlNamespacesNl.getLength(); ++k) {
                String location;
                Node xmlNamespaceN = xmlNamespacesNl.item(k);
                if (xmlNamespaceN.getNodeType() != 1) continue;
                Element xmlNamespaceE = (Element)xmlNamespaceN;
                String nsabr = xmlNamespaceE.getAttribute("nsabr");
                String ns = xmlNamespaceE.getAttribute("ns");
                location = xmlNamespaceE.hasAttribute("location") ? (location = xmlNamespaceE.getAttribute("location")) : null;
                String packageName = xmlNamespaceE.hasAttribute("packageName") ? xmlNamespaceE.getAttribute("packageName") : null;
                result.add(new XmlNamespace(nsabr, ns, location, packageName));
            }
        }
        return result;
    }

    private List<XsdMapEntry> parseXsdMapEntries(Element targetXmlSchemaElement) {
        ArrayList<XsdMapEntry> result = new ArrayList<XsdMapEntry>();
        NodeList xsdMapEntriesNl = targetXmlSchemaElement.getElementsByTagName("XsdMapEntry");
        if (xsdMapEntriesNl != null && xsdMapEntriesNl.getLength() != 0) {
            for (int k = 0; k < xsdMapEntriesNl.getLength(); ++k) {
                Node xsdMapEntryN = xsdMapEntriesNl.item(k);
                if (xsdMapEntryN.getNodeType() != 1) continue;
                Element xsdMapEntryE = (Element)xsdMapEntryN;
                String type = xsdMapEntryE.getAttribute("type");
                ArrayList<String> encodingRules = new ArrayList();
                String encodingRulesValue = xsdMapEntryE.getAttribute("xsdEncodingRules");
                if (encodingRulesValue != null && encodingRulesValue.trim().length() > 0) {
                    encodingRulesValue = encodingRulesValue.toLowerCase();
                    encodingRules = new ArrayList<String>(Arrays.asList(encodingRulesValue.split("\\s")));
                }
                String xmlType = xsdMapEntryE.hasAttribute("xmlType") ? xsdMapEntryE.getAttribute("xmlType") : null;
                String xmlTypeContent = DERIVED_DOCUMENTATION_DEFAULT_NOVALUE;
                if (xsdMapEntryE.hasAttribute("xmlTypeContent")) {
                    xmlTypeContent = xsdMapEntryE.getAttribute("xmlTypeContent").trim();
                }
                if (xmlTypeContent.length() == 0) {
                    xmlTypeContent = "complex";
                }
                String xmlTypeType = DERIVED_DOCUMENTATION_DEFAULT_NOVALUE;
                if (xsdMapEntryE.hasAttribute("xmlTypeType")) {
                    xmlTypeType = xsdMapEntryE.getAttribute("xmlTypeType").trim();
                }
                if (xmlTypeType.length() == 0) {
                    xmlTypeType = "complex";
                }
                String xmlTypeNilReason = DERIVED_DOCUMENTATION_DEFAULT_NOVALUE;
                if (xsdMapEntryE.hasAttribute("xmlTypeNilReason")) {
                    xmlTypeNilReason = xsdMapEntryE.getAttribute("xmlTypeNilReason").trim();
                }
                if (xmlTypeNilReason.length() == 0) {
                    xmlTypeNilReason = xmlTypeType.equals("simple") ? "false" : "true";
                }
                String xmlElement = xsdMapEntryE.hasAttribute("xmlElement") ? xsdMapEntryE.getAttribute("xmlElement") : null;
                String xmlPropertyType = xsdMapEntryE.hasAttribute("xmlPropertyType") ? xsdMapEntryE.getAttribute("xmlPropertyType") : null;
                String xmlAttribute = xsdMapEntryE.hasAttribute("xmlAttribute") ? xsdMapEntryE.getAttribute("xmlAttribute") : null;
                String xmlAttributeGroup = xsdMapEntryE.hasAttribute("xmlAttributeGroup") ? xsdMapEntryE.getAttribute("xmlAttributeGroup") : null;
                String xmlReferenceable = xsdMapEntryE.hasAttribute("xmlReferenceable") ? xsdMapEntryE.getAttribute("xmlReferenceable") : null;
                String xmlElementHasSimpleContent = xsdMapEntryE.hasAttribute("xmlElementHasSimpleContent") ? xsdMapEntryE.getAttribute("xmlElementHasSimpleContent") : null;
                String nsabr = xsdMapEntryE.hasAttribute("nsabr") ? xsdMapEntryE.getAttribute("nsabr") : null;
                result.add(new XsdMapEntry(type, encodingRules, xmlType, xmlTypeContent, xmlTypeType, xmlTypeNilReason, xmlElement, xmlPropertyType, xmlAttribute, xmlAttributeGroup, xmlReferenceable, xmlElementHasSimpleContent, nsabr));
            }
        }
        return result;
    }

    private List<ProcessMapEntry> parseProcessMapEntries(Element processElement, String mapEntryElementTagName) {
        ArrayList<ProcessMapEntry> result = new ArrayList<ProcessMapEntry>();
        NodeList processMapEntriesNl = processElement.getElementsByTagName(mapEntryElementTagName);
        if (processMapEntriesNl != null && processMapEntriesNl.getLength() != 0) {
            for (int k = 0; k < processMapEntriesNl.getLength(); ++k) {
                Node processMapEntryN = processMapEntriesNl.item(k);
                if (processMapEntryN.getNodeType() != 1) continue;
                Element processMapEntryE = (Element)processMapEntryN;
                String type = processMapEntryE.getAttribute("type");
                String rule = processMapEntryE.getAttribute("rule");
                String targetType = processMapEntryE.hasAttribute("targetType") ? processMapEntryE.getAttribute("targetType") : null;
                String param = processMapEntryE.hasAttribute("param") ? processMapEntryE.getAttribute("param") : null;
                result.add(new ProcessMapEntry(type, rule, targetType, param));
            }
        }
        return result;
    }

    private Map<String, TransformerConfiguration> parseTransformerConfigurations(Document configurationDocument) throws ShapeChangeAbortException {
        HashMap<String, TransformerConfiguration> trfConfigs = new HashMap<String, TransformerConfiguration>();
        NodeList trfsNl = configurationDocument.getElementsByTagName("transformers");
        for (int i = 0; i < trfsNl.getLength(); ++i) {
            Node trfsN = trfsNl.item(i);
            NodeList trfNl = trfsN.getChildNodes();
            for (int j = 0; j < trfNl.getLength(); ++j) {
                Node trfN = trfNl.item(j);
                if (trfN.getNodeType() != 1) continue;
                Element trfE = (Element)trfN;
                String trfConfigId = trfE.getAttribute("id");
                String trfConfigName = trfE.getAttribute("class");
                ProcessMode trfMode = this.parseMode(trfE);
                Map<String, String> processParameters = this.parseParameters(trfE, "ProcessParameter");
                Map<String, ProcessRuleSet> processRuleSets = this.parseRuleSets(trfE, "ProcessRuleSet", false);
                List<ProcessMapEntry> processMapEntries = this.parseProcessMapEntries(trfE, "ProcessMapEntry");
                List<TaggedValueConfigurationEntry> taggedValues = this.parseTaggedValues(trfE);
                String trfConfigInput = trfE.hasAttribute("input") ? trfE.getAttribute("input") : this.getInputId();
                if (trfConfigInput.equals(trfConfigId)) {
                    throw new ShapeChangeAbortException("Attributes input and id are equal in a transformer configuration element (class: " + trfConfigName + ") which is not allowed.");
                }
                Element advancedProcessConfigurations = this.parseAdvancedProcessConfigurations(trfE);
                TransformerConfiguration trfConfig = new TransformerConfiguration(trfConfigId, trfConfigName, trfMode, processParameters, processRuleSets, processMapEntries, taggedValues, trfConfigInput, advancedProcessConfigurations);
                trfConfigs.put(trfConfig.getId(), trfConfig);
            }
        }
        return trfConfigs;
    }

    private List<TaggedValueConfigurationEntry> parseTaggedValues(Element trfE) {
        NodeList taggedValuesNl;
        ArrayList<TaggedValueConfigurationEntry> result = new ArrayList<TaggedValueConfigurationEntry>();
        Element directTaggedValuesInTrf = null;
        NodeList children = trfE.getChildNodes();
        if (children != null && children.getLength() != 0) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node n = children.item(k);
                if (n.getNodeType() != 1 || !n.getNodeName().equals("taggedValues")) continue;
                directTaggedValuesInTrf = (Element)n;
                break;
            }
        }
        if (directTaggedValuesInTrf != null && (taggedValuesNl = directTaggedValuesInTrf.getElementsByTagName("TaggedValue")) != null && taggedValuesNl.getLength() > 0) {
            for (int k = 0; k < taggedValuesNl.getLength(); ++k) {
                Node taggedValueN = taggedValuesNl.item(k);
                if (taggedValueN.getNodeType() != 1) continue;
                Element taggedValueE = (Element)taggedValueN;
                TaggedValueConfigurationEntry tvce = TaggedValueConfigurationEntry.parse(taggedValueE);
                result.add(tvce);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private ProcessMode parseMode(Element processElement) {
        ProcessMode result = ProcessMode.enabled;
        if (processElement.hasAttribute("mode")) {
            String mode = processElement.getAttribute("mode");
            if (mode.equalsIgnoreCase("diagnostics-only")) {
                mode = "diagnosticsonly";
            }
            result = ProcessMode.fromString(mode);
        }
        return result;
    }

    private Map<String, ProcessRuleSet> parseRuleSets(Element processElement, String ruleSetElementTagName, boolean checkRuleExistence) throws ShapeChangeAbortException {
        HashMap<String, ProcessRuleSet> result = new HashMap<String, ProcessRuleSet>();
        NodeList processRuleSetsNl = processElement.getElementsByTagName(ruleSetElementTagName);
        if (processRuleSetsNl != null && processRuleSetsNl.getLength() != 0) {
            for (int k = 0; k < processRuleSetsNl.getLength(); ++k) {
                Node processRuleSetN = processRuleSetsNl.item(k);
                if (processRuleSetN.getNodeType() != 1) continue;
                Element processRuleSetE = (Element)processRuleSetN;
                String processRuleSetName = processRuleSetE.getAttribute("name");
                String extendedRuleName = processRuleSetE.getAttribute("extends");
                if (extendedRuleName != null && extendedRuleName.trim().length() == 0) {
                    extendedRuleName = "*";
                }
                TreeSet<String> ruleSetRules = null;
                NodeList processRuleSetRulesNl = processRuleSetE.getElementsByTagName("rule");
                if (processRuleSetRulesNl != null && processRuleSetRulesNl.getLength() != 0) {
                    for (int l = 0; l < processRuleSetRulesNl.getLength(); ++l) {
                        Node processRuleSetRuleN = processRuleSetRulesNl.item(l);
                        if (processRuleSetRuleN.getNodeType() != 1) continue;
                        Element processRuleSetRuleE = (Element)processRuleSetRuleN;
                        if (ruleSetRules == null) {
                            ruleSetRules = new TreeSet<String>();
                        }
                        String ruleName = processRuleSetRuleE.getAttribute("name");
                        if (checkRuleExistence) {
                            if (this.ruleRegistry.hasRule(ruleName)) {
                                ruleSetRules.add(ruleName);
                                continue;
                            }
                            System.err.println("Warning while loading configuration file: Rule '" + ruleName + "' is unknown, but referenced from the configuration. This is only a problem, if you know that the conversion rule is used in an encoding rule of your configuration.");
                            continue;
                        }
                        ruleSetRules.add(ruleName);
                    }
                }
                result.put(processRuleSetName, new ProcessRuleSet(processRuleSetName, extendedRuleName, ruleSetRules));
            }
        }
        return result;
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public String normalizeStereotype(String stereotype) {
        String s = this.stereotypeAlias(stereotype.trim());
        if (s != null) {
            return s;
        }
        return stereotype;
    }

    public String normalizeTag(String tag) {
        String s = this.tagAlias(tag.trim());
        if (s != null) {
            return s;
        }
        return tag;
    }

    public boolean skipSchema(PackageInfo pi) {
        String name = pi.name();
        String ns = pi.targetNamespace();
        String appSchemaName = null;
        String appSchemaNameRegex = null;
        String appSchemaNamespaceRegex = null;
        if (this.currentProcessConfig != null && (this.currentProcessConfig.hasParameter("appSchemaName") || this.currentProcessConfig.hasParameter("appSchemaNameRegex") || this.currentProcessConfig.hasParameter("appSchemaNamespaceRegex"))) {
            appSchemaName = this.currentProcessConfig.getParameterValue("appSchemaName");
            appSchemaNameRegex = this.currentProcessConfig.getParameterValue("appSchemaNameRegex");
            appSchemaNamespaceRegex = this.currentProcessConfig.getParameterValue("appSchemaNamespaceRegex");
        } else {
            appSchemaName = this.parameter("appSchemaName");
            appSchemaNameRegex = this.parameter("appSchemaNameRegex");
            appSchemaNamespaceRegex = this.parameter("appSchemaNamespaceRegex");
        }
        if (StringUtils.isNotBlank((CharSequence)appSchemaName) && !appSchemaName.equals(name)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)appSchemaNameRegex) && !name.matches(appSchemaNameRegex)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)appSchemaNamespaceRegex) && !ns.matches(appSchemaNamespaceRegex);
    }

    public String targetClassName(String rule) {
        String[] ra = rule.toLowerCase().split("-", 4);
        if (ra.length != 4) {
            return null;
        }
        return this.targetRegistry.targetClassName(ra[1]);
    }

    public TargetRegistry getTargetRegistry() {
        return this.targetRegistry;
    }

    public InputAndLogParameterRegistry getInputAndLogParameterRegistry() {
        return this.inputAndLogParameterRegistry;
    }

    public Options() throws ShapeChangeAbortException {
        this.targetRegistry = new TargetRegistry();
        this.ruleRegistry = new RuleRegistry(this.targetRegistry);
        this.setStandardParameters();
        this.inputAndLogParameterRegistry = new InputAndLogParameterRegistry();
    }

    public List<TargetConfiguration> getInputTargetConfigs() {
        return this.inputTargetConfigs;
    }

    public List<TransformerConfiguration> getInputTransformerConfigs() {
        return this.inputTransformerConfigs;
    }

    public void setCurrentProcessConfig(ProcessConfiguration currentProcessConfig) {
        this.currentProcessConfig = currentProcessConfig;
    }

    public ProcessConfiguration getCurrentProcessConfig() {
        return this.currentProcessConfig;
    }

    public List<TargetConfiguration> getTargetConfigurations() {
        return this.targetConfigs;
    }

    public Map<String, TransformerConfiguration> getTransformerConfigs() {
        return this.transformerConfigs;
    }

    public String getInputId() {
        return this.inputId;
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            String tmpDirPath = this.parameter(TMP_DIR_PATH_PARAM);
            if (tmpDirPath == null) {
                tmpDirPath = DEFAULT_TMP_DIR_PATH;
            }
            this.tmpDir = new File(tmpDirPath);
        }
        if (!this.tmpDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.tmpDir);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return this.tmpDir;
    }

    public File imageTmpDir() {
        if (this.imageTmpDir == null) {
            this.imageTmpDir = new File(this.getTmpDir(), "images");
        }
        if (!this.imageTmpDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.imageTmpDir);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return this.imageTmpDir;
    }

    public File linkedDocumentsTmpDir() {
        if (this.linkedDocTmpDir == null) {
            this.linkedDocTmpDir = new File(this.getTmpDir(), "linkedDocuments");
        }
        if (!this.linkedDocTmpDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.linkedDocTmpDir);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return this.linkedDocTmpDir;
    }

    public Set<String> getExcludedPackages() {
        HashSet<String> excludedPackages = new HashSet<String>();
        String value = this.parameter(PARAM_INPUT_EXCLUDED_PACKAGES);
        if (value != null && (value = value.trim()).length() > 0) {
            String[] values;
            for (String v : values = value.split(",")) {
                excludedPackages.add(v.trim());
            }
        }
        return excludedPackages;
    }

    public void setAIXMSchemaInfos(Map<String, AIXMSchemaInfos.AIXMSchemaInfo> schemaInfos) {
        this.schemaInfos = schemaInfos;
    }

    public Map<String, AIXMSchemaInfos.AIXMSchemaInfo> getAIXMSchemaInfos() {
        return this.schemaInfos;
    }

    public String language() {
        return this.language;
    }

    public boolean useStringInterning() {
        return this.useStringInterning;
    }

    public boolean dontConstructAssociationNames() {
        return this.dontConstructAssociationNames;
    }

    public boolean allowAllTags() {
        return this.allowAllTags;
    }

    public boolean allowAllStereotypes() {
        return this.allowAllStereotypes;
    }

    public Set<String> addedStereotypes() {
        return this.addedStereotypes;
    }

    public String internalize(String string) {
        if (string == null) {
            return null;
        }
        if (this.useStringInterning) {
            return string.intern();
        }
        return string;
    }

    public String[] internalize(String[] array) {
        if (this.useStringInterning) {
            String[] result = new String[array.length];
            int i = 0;
            for (String s : array) {
                result[i++] = s.intern();
            }
            return result;
        }
        return array;
    }

    private boolean useTaggedValuesArray() {
        String tvImpl = this.parameter(PARAM_TAGGED_VALUE_IMPL);
        return tvImpl != null && tvImpl.equalsIgnoreCase("array");
    }

    public TaggedValues taggedValueFactory() {
        TaggedValuesImpl result = this.useTaggedValuesArray() ? new TaggedValuesCacheArray(this) : new TaggedValuesCacheMap(this);
        return result;
    }

    public TaggedValues taggedValueFactory(int size) {
        TaggedValuesImpl result = this.useTaggedValuesArray() ? (size < 0 ? new TaggedValuesCacheArray(this) : new TaggedValuesCacheArray(size, this)) : (size < 0 ? new TaggedValuesCacheMap(this) : new TaggedValuesCacheMap(size, this));
        return result;
    }

    public TaggedValues taggedValueFactory(TaggedValues original, String tagList) {
        TaggedValuesImpl result = this.useTaggedValuesArray() ? new TaggedValuesCacheArray(original, tagList, this) : new TaggedValuesCacheMap(original, tagList, this);
        return result;
    }

    public TaggedValueNormalizer taggedValueNormalizer() {
        if (this.tvNormalizer == null) {
            this.tvNormalizer = new TaggedValueNormalizer(this);
        }
        return this.tvNormalizer;
    }

    public TaggedValues taggedValueFactory(TaggedValues original) {
        TaggedValuesImpl result = this.useTaggedValuesArray() ? new TaggedValuesCacheArray(original, this) : new TaggedValuesCacheMap(original, this);
        return result;
    }

    public Stereotypes stereotypesFactory() {
        return new StereotypesCacheSet(this);
    }

    public Stereotypes stereotypesFactory(Stereotypes stereotypes) {
        return new StereotypesCacheSet(stereotypes, this);
    }

    public Set<String> prohibitedStatusValuesWhenLoadingClasses() {
        if (!this.prohibitedStatusValuesWhenLoadingClasses_accessed) {
            this.prohibitedStatusValuesWhenLoadingClasses_accessed = true;
            this.prohibitedStatusValuesWhenLoadingClasses = this.hasParameter(null, PARAM_PROHIBIT_LOADING_CLASSES_WITH_STATUS_TV) ? new HashSet<String>(this.parameterAsStringList(null, PARAM_PROHIBIT_LOADING_CLASSES_WITH_STATUS_TV, DEFAULT_FOR_PROHIBIT_LOADING_CLASSES_WITH_STATUS_TV, true, true)) : new HashSet<String>();
        }
        return this.prohibitedStatusValuesWhenLoadingClasses;
    }

    public InputConfiguration getInputConfig() {
        return this.inputConfig;
    }

    public boolean constraintLoadingEnabled() {
        String value = this.parameter("checkingConstraints");
        if (StringUtils.isBlank((CharSequence)value)) {
            value = this.parameter("constraintLoading");
        }
        return value == null || !value.equalsIgnoreCase("disabled");
    }
}

