/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Ocl.SourceReference;
import java.util.HashMap;

abstract class Token {
    private static HashMap<String, Type> fixedTokens = new HashMap();
    private static HashMap<Type, String> fixedStrings = new HashMap();
    protected Type type;
    protected short serialNumber;
    private SourceReference sourceReference;

    Token() {
    }

    static Type getTypeFromLexicalString(String lexstr) {
        return fixedTokens.get(lexstr);
    }

    static String getLexicalStringFromType(Type type) {
        return fixedStrings.get((Object)type);
    }

    private static void feedMaps(String lexstr, Type type) {
        fixedTokens.put(lexstr, type);
        fixedStrings.put(type, lexstr);
    }

    Type getType() {
        return this.type;
    }

    int getSerialNumber() {
        return this.serialNumber;
    }

    abstract String getDenotation();

    void setSourceReference(short lineno, short colFrom, short colTo) {
        this.sourceReference = new SourceReference(lineno, colFrom, colTo, this.serialNumber, this.serialNumber);
    }

    SourceReference getSourceReference() {
        return this.sourceReference;
    }

    static {
        Token.feedMaps("(", Type.O_BRACKET);
        Token.feedMaps(")", Type.C_BRACKET);
        Token.feedMaps("[", Type.O_SQ_BRACKET);
        Token.feedMaps("]", Type.C_SQ_BRACKET);
        Token.feedMaps("{", Type.O_CU_BRACKET);
        Token.feedMaps("}", Type.C_CU_BRACKET);
        Token.feedMaps("|", Type.BAR);
        Token.feedMaps(",", Type.COMMA);
        Token.feedMaps(";", Type.SEMICOLON);
        Token.feedMaps(":", Type.COLON);
        Token.feedMaps("::", Type.DOUBLE_COLON);
        Token.feedMaps("=", Type.EQUAL);
        Token.feedMaps("<>", Type.NOT_EQUAL);
        Token.feedMaps("<", Type.LESS);
        Token.feedMaps(">", Type.GREATER);
        Token.feedMaps("<=", Type.LESS_EQUAL);
        Token.feedMaps(">=", Type.GREATER_EQUAL);
        Token.feedMaps("+", Type.PLUS);
        Token.feedMaps("-", Type.MINUS);
        Token.feedMaps("*", Type.ASTERISK);
        Token.feedMaps("/", Type.SLASH);
        Token.feedMaps(".", Type.DOT);
        Token.feedMaps("->", Type.ARROW);
        Token.feedMaps("and", Type.AND);
        Token.feedMaps("or", Type.OR);
        Token.feedMaps("xor", Type.XOR);
        Token.feedMaps("not", Type.NOT);
        Token.feedMaps("implies", Type.IMPLIES);
        Token.feedMaps("if", Type.IF);
        Token.feedMaps("then", Type.THEN);
        Token.feedMaps("else", Type.ELSE);
        Token.feedMaps("endif", Type.ENDIF);
        Token.feedMaps("let", Type.LET);
        Token.feedMaps("in", Type.IN);
        Token.feedMaps("context", Type.CONTEXT);
        Token.feedMaps("inv", Type.INV);
        Token.feedMaps("attr", Type.ATTR);
        Token.feedMaps("def", Type.DEF);
        Token.feedMaps("endpackage", Type.ENDPACKAGE);
        Token.feedMaps("oper", Type.OPER);
        Token.feedMaps("package", Type.PACKAGE);
        Token.feedMaps("post", Type.POST);
        Token.feedMaps("pre", Type.PRE);
        Token.feedMaps("init", Type.INIT);
        Token.feedMaps("derive", Type.DERIVE);
        Token.feedMaps("body", Type.BODY);
    }

    static class Illegal
    extends Token {
        private String item;

        @Override
        String getDenotation() {
            return "illegal characters";
        }

        String getItem() {
            return this.item;
        }

        Illegal(short serial, String item) {
            this.item = item;
            this.type = Type.ILLEGAL;
            this.serialNumber = serial;
        }
    }

    static class Comment
    extends Token {
        private String value;

        @Override
        String getDenotation() {
            int lv = this.value.length();
            return "comment \"" + this.value.substring(0, lv > 15 ? 15 : lv) + (lv > 15 ? "..." : "") + "\"";
        }

        String getValue() {
            return this.value;
        }

        Comment(short serial, String value) {
            if (value.startsWith("--")) {
                value = value.substring(2);
            }
            this.value = value.trim();
            this.type = Type.COMMENT;
            this.serialNumber = serial;
        }
    }

    static class Operator
    extends Token {
        @Override
        String getDenotation() {
            if (this.type == Type.END_OF_TEXT) {
                return "end of text";
            }
            return "operator \"" + Operator.getLexicalStringFromType(this.type) + "\"";
        }

        Operator(short serial, Type type) {
            this.type = type;
            this.serialNumber = serial;
        }
    }

    static class Number
    extends Token {
        private double value;
        private String stringValue;
        private boolean isInteger;

        @Override
        String getDenotation() {
            Double val = this.value;
            if (this.isInteger) {
                return "integer number '" + Long.toString(val.longValue()) + "'";
            }
            return "floating point number '" + val.toString() + "'";
        }

        double getValue() {
            return this.value;
        }

        String getStringValue() {
            return this.stringValue;
        }

        boolean isInteger() {
            return this.isInteger;
        }

        Number(short serial, String value, boolean isInteger) {
            this.stringValue = value;
            this.value = Double.parseDouble(value);
            this.isInteger = isInteger;
            this.type = Type.NUMBER;
            this.serialNumber = serial;
        }
    }

    static class Text
    extends Token {
        private String value;

        @Override
        String getDenotation() {
            int lv = this.value.length();
            return "string literal \"" + this.value.substring(0, lv > 15 ? 15 : lv) + (lv > 15 ? "..." : "") + "\"";
        }

        String getValue() {
            return this.value;
        }

        Text(short serial, String value) {
            this.value = value;
            this.type = Type.TEXT;
            this.serialNumber = serial;
        }
    }

    static class Identifier
    extends Token {
        private String name;

        @Override
        String getDenotation() {
            return "identifier \"" + this.name + "\"";
        }

        String getName() {
            return this.name;
        }

        Identifier(short serial, String name) {
            this.name = name;
            this.type = Type.IDENTIFIER;
            this.serialNumber = serial;
        }
    }

    static enum Type {
        IDENTIFIER,
        TEXT,
        NUMBER,
        COMMENT,
        O_BRACKET,
        C_BRACKET,
        O_SQ_BRACKET,
        C_SQ_BRACKET,
        O_CU_BRACKET,
        C_CU_BRACKET,
        BAR,
        COMMA,
        SEMICOLON,
        COLON,
        DOUBLE_COLON,
        EQUAL,
        NOT_EQUAL,
        LESS,
        GREATER,
        LESS_EQUAL,
        GREATER_EQUAL,
        PLUS,
        MINUS,
        ASTERISK,
        SLASH,
        DOT,
        ARROW,
        AND,
        OR,
        XOR,
        NOT,
        IMPLIES,
        IF,
        THEN,
        ELSE,
        ENDIF,
        LET,
        IN,
        CONTEXT,
        INV,
        ATTR,
        DEF,
        ENDPACKAGE,
        OPER,
        PACKAGE,
        POST,
        PRE,
        INIT,
        DERIVE,
        BODY,
        END_OF_TEXT,
        ILLEGAL;

    }
}

