/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Ocl.OclParser;
import de.interactive_instruments.ShapeChange.Ocl.SourceReference;
import de.interactive_instruments.ShapeChange.Ocl.Token;
import de.interactive_instruments.ShapeChange.Type;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Objects;
import java.util.SortedSet;

abstract class TempNode {
    protected SourceReference[] sourceReferences = null;

    TempNode() {
    }

    SourceReference[] getSourceReferences() {
        return this.sourceReferences;
    }

    void addSourceReference(SourceReference sourceRef) {
        if (this.sourceReferences == null) {
            this.sourceReferences = new SourceReference[1];
            this.sourceReferences[0] = sourceRef;
        } else {
            this.sourceReferences = sourceRef.merge(this.sourceReferences, true);
        }
    }

    void addSourceReference(Token token) {
        SourceReference sr = token.getSourceReference();
        if (sr != null) {
            this.addSourceReference(sr);
        }
    }

    void addSourceReference(TempNode tn) {
        if (tn.sourceReferences == null) {
            return;
        }
        if (this.sourceReferences == null) {
            this.sourceReferences = new SourceReference[0];
        }
        this.sourceReferences = SourceReference.merge(this.sourceReferences, tn.sourceReferences, true);
    }

    abstract void debugPrint(PrintWriter var1);

    abstract OclNode connectToModel(OclParser var1, Model var2, OclNode.Declaration var3);

    static class Arguments
    extends TempNode {
        TempNode[] declarations;
        TempNode[] expressions;

        Arguments(TempNode[] declarations, TempNode[] expressions) {
            int i;
            this.declarations = declarations;
            this.expressions = expressions;
            if (declarations != null) {
                for (i = 0; i < declarations.length; ++i) {
                    this.addSourceReference(declarations[i]);
                }
            }
            if (expressions != null) {
                for (i = 0; i < expressions.length; ++i) {
                    this.addSourceReference(expressions[i]);
                }
            }
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            MessageCollection messageCollection = p.getMessageCollection();
            Objects.requireNonNull(messageCollection);
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Attempt to connect TempNode.Arguments to the model.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            int i;
            stream.print("(");
            if (this.declarations != null && this.declarations.length > 0) {
                for (i = 0; i < this.declarations.length; ++i) {
                    if (i > 0) {
                        stream.print(",");
                    }
                    this.declarations[i].debugPrint(stream);
                }
                stream.print("|");
            }
            for (i = 0; i < this.expressions.length; ++i) {
                if (i > 0) {
                    stream.print(",");
                }
                this.expressions[i].debugPrint(stream);
            }
            stream.print(")");
        }
    }

    static class LetClause
    extends TempNode {
        TempNode[] declarations;
        TempNode expression;

        LetClause(TempNode[] declarations, TempNode expression) {
            this.declarations = declarations;
            this.expression = expression;
            for (int i = 0; i < declarations.length; ++i) {
                this.addSourceReference(declarations[i]);
            }
            this.addSourceReference(expression);
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            OclNode body;
            ArrayList<OclNode.Declaration> dcls = new ArrayList<OclNode.Declaration>();
            if (this.declarations != null) {
                for (TempNode declaration : this.declarations) {
                    if (declaration == null || !(declaration instanceof Declaration)) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                        mess.substitute(1, "Illegal Declaration in 'let' construct.");
                        if (declaration == null) {
                            mess.addSourceReferences(this.sourceReferences);
                        } else {
                            mess.addSourceReferences(declaration.sourceReferences);
                        }
                        return null;
                    }
                    OclNode ocldecl = declaration.connectToModel(p, model, varctx);
                    if (ocldecl == null) {
                        return null;
                    }
                    OclNode.Declaration dcl = (OclNode.Declaration)ocldecl;
                    if (dcl.getDataType().builtInType == OclNode.BuiltInType.VOID) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(37);
                        mess.substitute(1, dcl.name);
                        mess.addSourceReferences(declaration.sourceReferences);
                        return null;
                    }
                    if (dcl.initialValue == null) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(38);
                        mess.substitute(1, dcl.name);
                        mess.substitute(2, dcl.getDataType().name);
                        mess.addSourceReferences(declaration.sourceReferences);
                        return null;
                    }
                    dcls.add(dcl);
                    varctx = dcl;
                }
            }
            if ((body = this.expression.connectToModel(p, model, varctx)) == null) {
                return null;
            }
            OclNode.Declaration[] dclarray = new OclNode.Declaration[dcls.size()];
            dclarray = dcls.toArray(dclarray);
            OclNode.LetExp let = new OclNode.LetExp(dclarray, body);
            for (OclNode.Declaration d : dcls) {
                d.ownerNode = let;
            }
            return let;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("let[");
            for (int i = 0; i < this.declarations.length; ++i) {
                if (i > 0) {
                    stream.print(",");
                }
                this.declarations[i].debugPrint(stream);
            }
            stream.print(";");
            this.expression.debugPrint(stream);
            stream.print("]");
        }
    }

    static class IfClause
    extends TempNode {
        TempNode condition;
        TempNode ifPart;
        TempNode elsePart;

        IfClause(TempNode condition, TempNode ifPart, TempNode elsepart) {
            this.condition = condition;
            this.ifPart = ifPart;
            this.elsePart = elsepart;
            this.addSourceReference(condition);
            this.addSourceReference(ifPart);
            this.addSourceReference(this.elsePart);
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            OclNode cond_p = this.condition.connectToModel(p, model, varctx);
            OclNode if_p = this.ifPart.connectToModel(p, model, varctx);
            OclNode else_p = this.elsePart.connectToModel(p, model, varctx);
            if (cond_p == null) {
                return null;
            }
            if (if_p == null) {
                return null;
            }
            if (else_p == null) {
                return null;
            }
            if (cond_p.getDataType().builtInType != OclNode.BuiltInType.BOOLEAN) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(35);
                mess.addSourceReferences(this.condition.sourceReferences);
                return null;
            }
            OclNode.DataType common = if_p.getDataType().commonSuperType(else_p.getDataType());
            if (common == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(36);
                mess.substitute(1, if_p.getDataType().name);
                mess.substitute(2, else_p.getDataType().name);
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            return new OclNode.IfExp(common, cond_p, if_p, else_p);
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("if-then-else[");
            this.condition.debugPrint(stream);
            stream.print(",");
            this.ifPart.debugPrint(stream);
            stream.print(",");
            this.elsePart.debugPrint(stream);
            stream.print("]");
        }
    }

    static class Literal<T>
    extends TempNode {
        T value;

        Literal(T value) {
            this.value = value;
        }

        T getValue() {
            return this.value;
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            if (this.value.getClass() == Double.class) {
                return new OclNode.RealLiteralExp((Double)this.value);
            }
            if (this.value.getClass() == Integer.class || this.value.getClass() == Long.class) {
                return new OclNode.IntegerLiteralExp((Long)this.value);
            }
            if (this.value.getClass() == String.class) {
                return new OclNode.StringLiteralExp((String)this.value);
            }
            if (this.value.getClass() == Boolean.class) {
                return new OclNode.BooleanLiteralExp((Boolean)this.value);
            }
            if (this.value.getClass() == DateTime.class) {
                return new OclNode.DateTimeLiteralExp((GregorianCalendar)this.value);
            }
            if (this.value.getClass() == CurrentDateTime.class) {
                return new OclNode.DateTimeLiteralExp();
            }
            if (this.value.getClass() == Nothing.class) {
                return new OclNode.OclVoidLiteralExp();
            }
            MessageCollection messageCollection = p.getMessageCollection();
            Objects.requireNonNull(messageCollection);
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            String name = this.value.getClass().getName();
            mess.substitute(1, "Attempt to create a literal of type '" + name + "'.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("L[");
            stream.print(this.value);
            stream.print("]");
        }
    }

    static class Nothing {
        Nothing() {
        }

        public String toString() {
            return "null";
        }
    }

    static class DateTime
    extends GregorianCalendar {
        DateTime() {
        }

        @Override
        public String toString() {
            return this.getTime().toString();
        }
    }

    static class CurrentDateTime {
        CurrentDateTime() {
        }

        public String toString() {
            return "CurrentDateTime";
        }
    }

    static class Declaration
    extends TempNode {
        String name;
        TempNode typename;
        TempNode initializer;

        Declaration(String name, TempNode typename, TempNode initializer) {
            this.name = name;
            this.typename = typename;
            this.initializer = initializer;
            if (typename != null) {
                this.addSourceReference(typename);
            }
            if (initializer != null) {
                this.addSourceReference(initializer);
            }
        }

        OclNode connectToModelWithType(OclParser p, Model model, OclNode.Declaration varctx, OclNode.DataType type) {
            OclNode decl = this.connectToModel(p, model, varctx);
            if (decl == null) {
                return null;
            }
            OclNode.Declaration dcl = (OclNode.Declaration)decl;
            if (dcl.getDataType().builtInType == OclNode.BuiltInType.VOID) {
                dcl.dataType = type;
            } else {
                boolean ok;
                boolean bl = ok = dcl.getDataType().isSubTypeOf(type) && type.isSubTypeOf(dcl.getDataType());
                if (!ok) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(39);
                    mess.substitute(1, type.name);
                    mess.substitute(2, dcl.getDataType().name);
                    mess.substitute(3, dcl.name);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            }
            return dcl;
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            MessageCollection.Message mess;
            OclNode.DataType type = null;
            if (this.typename != null) {
                if (!(this.typename instanceof Identifier)) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess2 = messageCollection.new MessageCollection.Message(0);
                    mess2.substitute(1, "Declaration type name is not an Identifer.");
                    mess2.addSourceReferences(this.typename.sourceReferences);
                    return null;
                }
                Identifier typeid = (Identifier)this.typename;
                OclNode cls = typeid.connectAsClassOrPackage(p, model, 1, true);
                if (cls != null) {
                    OclNode.ClassLiteralExp cl = (OclNode.ClassLiteralExp)cls;
                    ClassInfo ci = cl.umlClass;
                    type = new OclNode.DataType(ci, null);
                } else {
                    type = new OclNode.DataType(typeid.name(), null);
                    if (type.builtInType == OclNode.BuiltInType.VOID) {
                        type = null;
                    }
                }
                if (type == null) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    mess = messageCollection.new MessageCollection.Message(38);
                    mess.substitute(1, typeid.name());
                    mess.substitute(2, this.name);
                    mess.addSourceReferences(this.typename.sourceReferences);
                    return null;
                }
            }
            OclNode init = null;
            if (this.initializer != null) {
                init = this.initializer.connectToModel(p, model, varctx);
                if (init == null) {
                    return null;
                }
                OclNode.DataType inittype = init.getDataType();
                if (type == null) {
                    type = inittype;
                } else if (!inittype.isSubTypeOf(type)) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    mess = messageCollection.new MessageCollection.Message(39);
                    mess.substitute(1, type.name);
                    mess.substitute(2, inittype.name);
                    mess.substitute(3, this.name);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            }
            if (type == null) {
                type = new OclNode.DataType(OclNode.BuiltInType.VOID, null);
            }
            return new OclNode.Declaration(this.name, type, init, varctx, null, false);
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("Declare[");
            stream.print(this.name);
            if (this.typename != null) {
                stream.print(":");
                this.typename.debugPrint(stream);
            }
            if (this.initializer != null) {
                stream.print("=");
                this.initializer.debugPrint(stream);
            }
            stream.print("]");
        }
    }

    static class Identifier
    extends TempNode {
        String name;
        TempNode qualification;

        Identifier(TempNode qualification, String name) {
            this.name = name;
            this.qualification = qualification;
            if (qualification != null) {
                this.addSourceReference(qualification);
            }
        }

        String name() {
            Object scope = "";
            if (this.qualification != null && this.qualification instanceof Identifier) {
                scope = ((Identifier)this.qualification).name() + "::";
            }
            return (String)scope + this.name;
        }

        boolean isSimpleName() {
            return this.qualification == null;
        }

        ClassInfo classFromQualification(OclParser p, Model model, boolean quiet) {
            if (this.qualification == null) {
                return null;
            }
            if (this.qualification instanceof Identifier) {
                Identifier qualid = (Identifier)this.qualification;
                OclNode cls = qualid.connectAsClassOrPackage(p, model, 1, quiet);
                if (cls == null || !(cls instanceof OclNode.ClassLiteralExp)) {
                    return null;
                }
                return ((OclNode.ClassLiteralExp)cls).umlClass;
            }
            MessageCollection messageCollection = p.getMessageCollection();
            Objects.requireNonNull(messageCollection);
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Qualifier is non-Identifier token.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            int cat;
            ClassInfo ci;
            if (this.qualification != null && this.qualification instanceof Identifier && (ci = this.classFromQualification(p, model, true)) != null && ((cat = ci.category()) == 3 || cat == 2)) {
                PropertyInfo pi = ci.property(this.name);
                if (pi != null) {
                    return new OclNode.EnumerationLiteralExp(pi);
                }
                if (ci.matches("rule-xsd-cls-codelist-constraints-codeAbsenceInModelAllowed") || !ci.model().isInSelectedSchemas(ci) || ci.options().parameterAsBoolean(null, "codeAbsenceInModelAllowed", false)) {
                    return new OclNode.EnumerationLiteralExp(this.name, ci);
                }
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(33);
                mess.substitute(1, this.name);
                mess.substitute(2, ci.name());
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            OclNode ret = this.connectAsClassOrPackage(p, model, 1, true);
            return ret;
        }

        OclNode connectAsClassOrPackage(OclParser p, Model model, int level, boolean quiet) {
            Identifier qual = null;
            OclNode qctx = null;
            if (this.qualification != null) {
                if (this.qualification instanceof Identifier) {
                    qual = (Identifier)this.qualification;
                    qctx = qual.connectAsClassOrPackage(p, model, level + 1, quiet);
                    if (qctx == null) {
                        return null;
                    }
                } else {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                    mess.substitute(1, "Qualifier is non-Identifier token.");
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            }
            if (level == 1) {
                ClassInfo ci = null;
                if (qctx == null) {
                    ci = model.classByName(this.name);
                    if (ci == null && !quiet) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(21);
                        mess.substitute(1, this.name);
                        mess.addSourceReferences(this.sourceReferences);
                    }
                } else {
                    OclNode.PackageLiteralExp plit = (OclNode.PackageLiteralExp)qctx;
                    PackageInfo pi = plit.getPackage();
                    SortedSet<ClassInfo> cls = model.classes(pi);
                    for (ClassInfo c : cls) {
                        if (!c.name().equals(this.name)) continue;
                        ci = c;
                        break;
                    }
                    if (ci == null || ci.pkg() != pi) {
                        if (!quiet) {
                            MessageCollection messageCollection = p.getMessageCollection();
                            Objects.requireNonNull(messageCollection);
                            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(22);
                            mess.substitute(1, this.name);
                            mess.substitute(2, pi.name());
                            mess.addSourceReferences(this.sourceReferences);
                        }
                        ci = null;
                    }
                }
                if (ci != null) {
                    return new OclNode.ClassLiteralExp(ci);
                }
                return null;
            }
            PackageInfo pi = null;
            if (qctx == null) {
                SortedSet<PackageInfo> pckseed = model.packages();
                LinkedList<PackageInfo> eval = new LinkedList<PackageInfo>();
                for (PackageInfo pck : pckseed) {
                    eval.add(pck);
                }
                pi = this.getPackageToName(eval);
                if (pi == null && !quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(23);
                    mess.substitute(1, this.name);
                    mess.addSourceReferences(this.sourceReferences);
                }
            } else {
                OclNode.PackageLiteralExp plit = (OclNode.PackageLiteralExp)qctx;
                PackageInfo pi2 = plit.getPackage();
                try {
                    SortedSet<PackageInfo> pks = pi2.containedPackages();
                    for (PackageInfo pk : pks) {
                        if (!pk.name().equals(this.name)) continue;
                        pi = pk;
                        break;
                    }
                }
                catch (Exception pks) {
                    // empty catch block
                }
                if (pi == null && !quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(24);
                    mess.substitute(1, this.name);
                    mess.substitute(2, pi2.name());
                    mess.addSourceReferences(this.sourceReferences);
                }
            }
            if (pi != null) {
                return new OclNode.PackageLiteralExp(pi);
            }
            return null;
        }

        PackageInfo getPackageToName(LinkedList<PackageInfo> eval) {
            LinkedList<PackageInfo> evalSub = null;
            for (PackageInfo cpi : eval) {
                if (cpi.name().equals(this.name)) {
                    return cpi;
                }
                try {
                    SortedSet<PackageInfo> npis = cpi.containedPackages();
                    if (evalSub == null && npis.size() > 0) {
                        evalSub = new LinkedList<PackageInfo>();
                    }
                    for (PackageInfo npi : npis) {
                        evalSub.add(npi);
                    }
                }
                catch (Exception exception) {
                }
            }
            if (evalSub != null) {
                return this.getPackageToName(evalSub);
            }
            return null;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            if (this.qualification != null) {
                this.qualification.debugPrint(stream);
                stream.print("::");
            }
            stream.print(this.name);
        }
    }

    static class Property
    extends TempNode {
        TempNode name;
        TempNode arguments;

        Property(TempNode name, TempNode arguments) {
            this.name = name;
            this.arguments = arguments;
            this.addSourceReference(name);
            if (arguments != null) {
                this.addSourceReference(arguments);
            }
        }

        boolean hasSimpleName() {
            if (this.name == null) {
                return false;
            }
            if (!(this.name instanceof Identifier)) {
                return false;
            }
            Identifier id = (Identifier)this.name;
            return id.name == null;
        }

        String name() {
            if (this.name == null) {
                return "(null)";
            }
            if (!(this.name instanceof Identifier)) {
                return "(invalid)";
            }
            Identifier id = (Identifier)this.name;
            return id.name();
        }

        int numberOfArguments() {
            if (this.arguments == null || !(this.arguments instanceof Arguments)) {
                return -1;
            }
            return ((Arguments)this.arguments).expressions.length;
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            if (this.name == null || !(this.name instanceof Identifier)) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "Property is named by non-Identifier token.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            Identifier id = (Identifier)this.name;
            OclNode.Declaration dcl = null;
            if (id.isSimpleName() && this.arguments == null) {
                String name = id.name();
                dcl = varctx;
                while (dcl != null && !name.equals(dcl.name)) {
                    dcl = dcl.nextOuter;
                }
                if (dcl != null) {
                    OclNode.VariableExp var = new OclNode.VariableExp(dcl);
                    return var;
                }
            }
            dcl = varctx;
            while (dcl != null) {
                if (dcl.isImplicit) {
                    OclNode.VariableExp var = new OclNode.VariableExp(dcl);
                    OclNode.DataType type = dcl.getDataType();
                    ClassInfo ci = type.umlClass;
                    OclNode result = null;
                    result = ci != null ? this.connectAsUmlProperty(p, model, varctx, var, true) : this.connectAsBuiltInProperty(p, model, varctx, var, false, true);
                    if (result != null) {
                        if (result instanceof OclNode.PropertyCallExp) {
                            ((OclNode.PropertyCallExp)result).isImplicit = true;
                        }
                        return result;
                    }
                }
                dcl = dcl.nextOuter;
            }
            if (this.arguments != null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(32);
                mess.substitute(1, this.name());
                mess.substitute(2, String.valueOf(this.numberOfArguments()));
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            OclNode result = id.connectToModel(p, model, varctx);
            if (result == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(34);
                mess.substitute(1, this.name());
                mess.addSourceReferences(this.sourceReferences);
            }
            return result;
        }

        OclNode connectAsUmlProperty(OclParser p, Model model, OclNode.Declaration varctx, OclNode object, boolean quiet) {
            ClassInfo ci = object.getDataType().umlClass;
            if (ci == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "connectAsUmlProperty failed due to null object.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            Identifier id = (Identifier)this.name;
            if (!id.isSimpleName()) {
                ClassInfo c;
                ClassInfo qci = id.classFromQualification(p, model, quiet);
                if (qci == null) {
                    return null;
                }
                for (c = ci; c != null && c != qci; c = c.baseClass()) {
                }
                if (c == null) {
                    if (!quiet) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(30);
                        mess.substitute(1, this.name());
                        mess.substitute(2, ci.name());
                        mess.addSourceReferences(this.sourceReferences);
                    }
                    return null;
                }
                ci = qci;
            }
            if (this.arguments == null) {
                PropertyInfo pi = ci.property(this.name());
                if (pi == null && ci.options().isNavigatingNonNavigableAssociationsWhenParsingOcl()) {
                    SortedSet<ClassInfo> ciAndAllSupertypes = ci.supertypesInCompleteHierarchy();
                    ciAndAllSupertypes.add(ci);
                    pi = ci.model().lookupNonNavigableAssociationRole(ciAndAllSupertypes, this.name());
                }
                if (pi != null) {
                    return new OclNode.AttributeCallExp(object, pi, false);
                }
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(26);
                    mess.substitute(1, this.name());
                    mess.substitute(2, ci.name());
                    mess.addSourceReferences(id.sourceReferences);
                }
            } else {
                OclNode res;
                Arguments args = (Arguments)this.arguments;
                if (args.declarations == null) {
                    TempNode[] parms = args.expressions;
                    OclNode[] oclparms = new OclNode[parms.length];
                    String[] types = new String[parms.length + 1];
                    for (int i = 0; i < parms.length; ++i) {
                        oclparms[i] = parms[i].connectToModel(p, model, varctx);
                        if (oclparms[i] == null) {
                            return null;
                        }
                        types[i] = oclparms[i].getDataType().name;
                    }
                    types[parms.length] = "*";
                    OperationInfo oi = ci.operation(this.name(), types);
                    if (oi != null) {
                        return new OclNode.OperationCallExp(object, oi, oclparms, false);
                    }
                }
                if ((res = this.connectAsBuiltInProperty(p, model, varctx, object, false, quiet)) != null) {
                    return res;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        OclNode connectAsBuiltInProperty(OclParser p, Model model, OclNode.Declaration varctx, OclNode object, boolean arrow, boolean quiet) {
            MessageCollection.Message mess;
            OclNode.DataType type = object.getDataType();
            OclNode.BuiltInType bit = type.builtInType;
            String typename = type.name;
            Identifier id = (Identifier)this.name;
            String name = id.name();
            if (this.arguments == null) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess2 = messageCollection.new MessageCollection.Message(26);
                    mess2.substitute(1, name);
                    mess2.substitute(2, typename);
                    mess2.addSourceReferences(id.sourceReferences);
                }
                return null;
            }
            Arguments args = (Arguments)this.arguments;
            int nargs = args.expressions.length;
            ArrayList<OclNode.BuiltInDescr> bids = new ArrayList<OclNode.BuiltInDescr>(1);
            int itersFound = 0;
            for (OclNode.BuiltInDescr builtInDescr : OclNode.builtInDescriptors) {
                OclNode.BuiltInType bidtype;
                if (!name.equals(builtInDescr.name) || (bidtype = builtInDescr.applType) != OclNode.BuiltInType.ANY && bidtype != bit) continue;
                int bidnargs = 0;
                if (builtInDescr.arguTypes != null) {
                    bidnargs = builtInDescr.arguTypes.length;
                }
                if (nargs != bidnargs || arrow != builtInDescr.arrow) continue;
                bids.add(builtInDescr);
                if (builtInDescr.noOfDecls <= 0) continue;
                ++itersFound;
            }
            boolean isAddedOper = false;
            OclNode.DataType addedResultType = null;
            if (bids.size() == 0) {
                ArrayList<OclParser.AddedOperationSignature> aolist = p.additionalOperations;
                for (OclParser.AddedOperationSignature ao : aolist) {
                    if (!name.equals(ao.name) || ao.objType != null && !type.isSubTypeOf(ao.objType) || ao.noOfArgs >= 0 && ao.noOfArgs != nargs) continue;
                    addedResultType = ao.retType;
                    isAddedOper = true;
                    break;
                }
            }
            if (!isAddedOper && bids.size() == 0) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess3 = messageCollection.new MessageCollection.Message(27);
                    mess3.substitute(1, name);
                    mess3.substitute(2, typename);
                    mess3.substitute(3, String.valueOf(nargs));
                    mess3.addSourceReferences(this.sourceReferences);
                }
                return null;
            }
            if (itersFound > 0 && bids.size() != itersFound) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess4 = messageCollection.new MessageCollection.Message(0);
                mess4.substitute(1, "");
                mess4.addSourceReferences(id.sourceReferences);
                return null;
            }
            ArrayList<OclNode.Declaration> ocldecls = null;
            if (itersFound > 0) {
                ocldecls = new ArrayList<OclNode.Declaration>(1);
                if (args.declarations != null) {
                    for (TempNode tempNode : args.declarations) {
                        OclNode.Declaration newVarctx;
                        Declaration decl = (Declaration)tempNode;
                        OclNode ocldecl = decl.connectToModelWithType(p, model, varctx, type);
                        if (ocldecl == null) {
                            return null;
                        }
                        varctx = newVarctx = (OclNode.Declaration)ocldecl;
                        ocldecls.add(newVarctx);
                    }
                } else {
                    OclNode.Declaration declaration;
                    varctx = declaration = new OclNode.Declaration(null, type, null, varctx, null, true);
                    ocldecls.add(declaration);
                }
            }
            OclNode[] oclNodeArray = new OclNode[nargs];
            for (int i = 0; i < nargs; ++i) {
                OclNode arg = args.expressions[i].connectToModel(p, model, varctx);
                if (arg == null) {
                    return null;
                }
                oclNodeArray[i] = arg;
            }
            OclNode.BuiltInDescr selectedbid = null;
            for (OclNode.BuiltInDescr builtInDescr : bids) {
                OclNode.BuiltInType[] bidtypes = builtInDescr.arguTypes;
                boolean matched = true;
                if (bidtypes != null) {
                    for (int i = 0; i < bidtypes.length && !matched; ++i) {
                        if (!oclNodeArray[i].isMultiple() && (bidtypes[i] == OclNode.BuiltInType.ANY || bidtypes[i] == oclNodeArray[i].getDataType().builtInType)) continue;
                        matched = false;
                    }
                }
                if (!matched) continue;
                selectedbid = builtInDescr;
                break;
            }
            if (!isAddedOper && selectedbid == null) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    mess = messageCollection.new MessageCollection.Message(27);
                    mess.substitute(1, name);
                    mess.substitute(2, typename);
                    mess.substitute(3, String.valueOf(nargs));
                    mess.addSourceReferences(this.sourceReferences);
                }
                return null;
            }
            if (itersFound > 0 && ocldecls.size() > selectedbid.noOfDecls) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    mess = messageCollection.new MessageCollection.Message(31);
                    mess.substitute(1, name);
                    mess.addSourceReferences(this.sourceReferences);
                }
                return null;
            }
            ClassInfo metadataType = null;
            Object var22_44 = null;
            if (object instanceof OclNode.AttributeCallExp) {
                OclNode.AttributeCallExp att = (OclNode.AttributeCallExp)object;
                PropertyInfo propi = (PropertyInfo)att.selector.modelProperty;
                String string = propi.name();
                metadataType = propi.propertyMetadataType();
            } else if (object instanceof OclNode.VariableExp) {
                OclNode.VariableExp var = (OclNode.VariableExp)object;
                String string = var.declaration.name;
                metadataType = var.dataType.metadataType;
            }
            OclNode.OperationCallExp callexp = null;
            OclNode.DataType dataType = type = isAddedOper ? addedResultType : new OclNode.DataType(selectedbid.resType, metadataType);
            if (!isAddedOper) {
                block0 : switch (selectedbid.specialTreatment) {
                    case 1: {
                        if (bit != OclNode.BuiltInType.CLASS) break;
                        type = new OclNode.DataType(((OclNode.ClassLiteralExp)object).umlClass, null);
                        break;
                    }
                    case 2: {
                        type = object.getDataType();
                        break;
                    }
                    case 3: {
                        if (oclNodeArray.length <= 0 || oclNodeArray[0].dataType.builtInType != OclNode.BuiltInType.CLASS) break;
                        type = new OclNode.DataType(((OclNode.ClassLiteralExp)oclNodeArray[0]).umlClass, null);
                        break;
                    }
                    case 4: {
                        for (String cn : OclNode.iso19103Map.keySet()) {
                            ClassInfo mci;
                            OclNode.BuiltInType bityp = OclNode.iso19103Map.get(cn);
                            if (bityp == null || bityp != type.builtInType || (mci = model.classByName(cn)) == null) continue;
                            type.umlClass = mci;
                            break block0;
                        }
                        break;
                    }
                    case 5: {
                        if (metadataType == null) {
                            void var22_47;
                            if (quiet) break;
                            MessageCollection messageCollection = p.getMessageCollection();
                            Objects.requireNonNull(messageCollection);
                            MessageCollection.Message mess5 = messageCollection.new MessageCollection.Message(47);
                            mess5.substitute(1, (String)var22_47);
                            mess5.addSourceReferences(this.sourceReferences);
                            break;
                        }
                        type = new OclNode.DataType(metadataType, null);
                    }
                }
            }
            if (itersFound > 0) {
                OclNode.Declaration[] ocldclarray = new OclNode.Declaration[ocldecls.size()];
                ocldclarray = ocldecls.toArray(ocldclarray);
                callexp = new OclNode.IterationCallExp(object, name, ocldclarray, oclNodeArray, type, selectedbid.multMap);
                for (OclNode.Declaration dcl : ocldecls) {
                    dcl.ownerNode = callexp;
                }
            } else {
                OclNode.MultiplicityMapping mm = isAddedOper ? OclNode.MultiplicityMapping.ONE2ONE : selectedbid.multMap;
                callexp = new OclNode.OperationCallExp(object, arrow, name, oclNodeArray, type, mm, false);
            }
            return callexp;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("P[");
            this.name.debugPrint(stream);
            if (this.arguments != null) {
                this.arguments.debugPrint(stream);
            }
            stream.print("]");
        }
    }

    static class Prefix
    extends TempNode {
        Token.Type type;
        TempNode operand;

        Prefix(Token.Type type, TempNode op) {
            this.type = type;
            this.operand = op;
            this.addSourceReference(op);
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            OclNode object = this.operand.connectToModel(p, model, varctx);
            if (object == null) {
                return null;
            }
            OclNode.DataType objDataType = object.getDataType();
            OclNode.BuiltInType bit = objDataType.builtInType;
            OclNode.OperationCallExp result = null;
            String name = Token.getLexicalStringFromType(this.type);
            for (OclNode.BuiltInDescr bid : OclNode.operSymbDescriptors) {
                OclNode.BuiltInType bidtype;
                if (!name.equals(bid.name) || (bidtype = bid.applType) != OclNode.BuiltInType.ANY && bidtype != bit) continue;
                int bidnargs = 0;
                if (bid.arguTypes != null) {
                    bidnargs = bid.arguTypes.length;
                }
                if (bidnargs != 0) continue;
                result = new OclNode.OperationCallExp(object, false, name, new OclNode[0], new OclNode.DataType(bid.resType, null), OclNode.MultiplicityMapping.ONE2ONE, false);
                break;
            }
            if (result == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(44);
                mess.substitute(1, name);
                mess.substitute(2, objDataType.name);
                mess.addSourceReferences(this.operand.sourceReferences);
            }
            return result;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.type);
            stream.print(opsym);
            stream.print("(");
            this.operand.debugPrint(stream);
            stream.print(")");
        }
    }

    static class Infix
    extends TempNode {
        Token.Type type;
        TempNode operand1;
        TempNode operand2;

        Infix(Token.Type type, TempNode op1, TempNode op2) {
            this.type = type;
            this.operand1 = op1;
            this.operand2 = op2;
            this.addSourceReference(op1);
            this.addSourceReference(op2);
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            OclNode object = this.operand1.connectToModel(p, model, varctx);
            if (object == null) {
                return null;
            }
            OclNode.DataType objDataType = object.getDataType();
            OclNode result = null;
            switch (this.type) {
                case ARROW: 
                case DOT: {
                    if (!(this.operand2 instanceof Property)) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        Objects.requireNonNull(messageCollection);
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(25);
                        mess.substitute(1, Token.getLexicalStringFromType(this.type));
                        mess.addSourceReferences(this.operand2.sourceReferences);
                        return null;
                    }
                    Property property = (Property)this.operand2;
                    ClassInfo ci = objDataType.umlClass;
                    if (ci != null && this.type != Token.Type.ARROW) {
                        result = property.connectAsUmlProperty(p, model, varctx, object, false);
                        break;
                    }
                    result = property.connectAsBuiltInProperty(p, model, varctx, object, this.type == Token.Type.ARROW, false);
                    break;
                }
                default: {
                    OclNode op1 = object;
                    OclNode op2 = this.operand2.connectToModel(p, model, varctx);
                    if (op1 == null || op2 == null) {
                        return null;
                    }
                    OclNode.DataType dt1 = objDataType;
                    OclNode.DataType dt2 = op2.getDataType();
                    OclNode.BuiltInType bit1 = dt1.builtInType;
                    OclNode.BuiltInType bit2 = dt2.builtInType;
                    String name = Token.getLexicalStringFromType(this.type);
                    for (OclNode.BuiltInDescr bid : OclNode.operSymbDescriptors) {
                        OclNode.BuiltInType bidtype;
                        if (!name.equals(bid.name) || (bidtype = bid.applType) != OclNode.BuiltInType.ANY && bidtype != bit1) continue;
                        int bidnargs = 0;
                        if (bid.arguTypes != null) {
                            bidnargs = bid.arguTypes.length;
                        }
                        if (bidnargs != 1 || bid.arguTypes[0] != OclNode.BuiltInType.ANY && bid.arguTypes[0] != bit2) continue;
                        result = new OclNode.OperationCallExp(op1, false, name, new OclNode[]{op2}, new OclNode.DataType(bid.resType, null), OclNode.MultiplicityMapping.ONE2ONE, false);
                        break;
                    }
                    if (result != null) break;
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(43);
                    mess.substitute(1, name);
                    mess.substitute(2, dt1.name);
                    mess.substitute(3, dt2.name);
                    mess.addSourceReferences(this.operand2.sourceReferences);
                }
            }
            return result;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.type);
            stream.print(opsym);
            stream.print("(");
            this.operand1.debugPrint(stream);
            stream.print(",");
            this.operand2.debugPrint(stream);
            stream.print(")");
        }
    }

    static class Invalid
    extends TempNode {
        Invalid() {
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            MessageCollection messageCollection = p.getMessageCollection();
            Objects.requireNonNull(messageCollection);
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Attempt to connect INVALID TempNode to the model.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("INVALID");
        }
    }

    static class Expression
    extends TempNode {
        ClassInfo classContext = null;
        Info generalContext = null;
        Token.Type expressionType;
        String expressionName;
        TempNode expression;

        Expression(Token.Type type, String name, TempNode expr) {
            this.expressionType = type;
            this.expressionName = name;
            this.expression = expr;
        }

        OclNode.Expression connectToModelWithContext(OclParser p, Info ctx) {
            if (ctx == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "Cannot connect Expression without class context.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            this.classContext = null;
            if (ctx instanceof ClassInfo) {
                this.classContext = (ClassInfo)ctx;
            } else if (ctx instanceof PropertyInfo) {
                this.classContext = ((PropertyInfo)ctx).inClass();
            } else if (ctx instanceof OperationInfo) {
                this.classContext = null;
            }
            Model model = this.classContext.model();
            this.generalContext = ctx;
            OclNode res = this.connectToModel(p, model, null);
            if (res != null) {
                return (OclNode.Expression)res;
            }
            return null;
        }

        @Override
        OclNode connectToModel(OclParser p, Model model, OclNode.Declaration varctx) {
            OclConstraint.ConditionType et = null;
            if (this.expressionType == Token.Type.INV) {
                et = OclConstraint.ConditionType.INVARIANT;
            } else if (this.expressionType == Token.Type.INIT) {
                et = OclConstraint.ConditionType.INITIAL;
            } else if (this.expressionType == Token.Type.DERIVE) {
                et = OclConstraint.ConditionType.DERIVE;
            } else {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "Unsupported OCL expression type '" + this.expressionType.name() + "'.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            if ((et == OclConstraint.ConditionType.DERIVE || et == OclConstraint.ConditionType.INITIAL) && this.generalContext == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                Objects.requireNonNull(messageCollection);
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "Cannot connect init/derive expression without Property context.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            OclNode.Declaration last = null;
            for (OclNode.Declaration decl : p.environmentDeclarations) {
                decl.nextOuter = last;
                last = decl;
            }
            OclNode.DataType type = new OclNode.DataType(this.classContext, null);
            OclNode.Declaration dcl = new OclNode.Declaration("self", type, null, last, null, true);
            OclNode exp = this.expression.connectToModel(p, model, dcl);
            if (exp == null) {
                return null;
            }
            this.sourceReferences = this.expression.sourceReferences;
            OclNode.Expression ex = new OclNode.Expression(this.expressionName, et, exp, dcl, p.environmentDeclarations);
            dcl.ownerNode = ex;
            for (OclNode.Declaration decl : p.environmentDeclarations) {
                decl.ownerNode = ex;
            }
            OclNode.DataType extype = ex.getDataType();
            boolean isMult = ex.isMultiple();
            if (et == OclConstraint.ConditionType.INVARIANT) {
                if (extype.builtInType != OclNode.BuiltInType.BOOLEAN) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(41);
                    mess.substitute(1, extype.name);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
                if (isMult) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(45);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            } else {
                PropertyInfo pi = (PropertyInfo)this.generalContext;
                boolean pIsMult = pi.cardinality().maxOccurs > 1;
                Type ptype = pi.typeInfo();
                ClassInfo ci = model.classByIdOrName(ptype);
                ClassInfo metadataType = pi.propertyMetadataType();
                OclNode.DataType ttype = null;
                ttype = ci != null ? new OclNode.DataType(ci, metadataType) : new OclNode.DataType(ptype.name, metadataType);
                if (!extype.isSubTypeOf(ttype)) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(42);
                    mess.substitute(1, ttype.name);
                    mess.substitute(2, extype.name);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
                if (isMult && !pIsMult) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    Objects.requireNonNull(messageCollection);
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(46);
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            }
            return ex;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.expressionType);
            stream.print(opsym);
            stream.print(": ");
            if (this.expressionName != null) {
                stream.print(this.expressionName);
                stream.print(" ");
            }
            this.expression.debugPrint(stream);
        }
    }
}

