/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import java.io.Serializable;

public class Multiplicity {
    public int minOccurs = 1;
    public int maxOccurs = 1;

    public Multiplicity() {
    }

    public Multiplicity(int minOccurs, int maxOccurs) {
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public Multiplicity(String multiplicityRanges) {
        String[] ranges = multiplicityRanges.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < ranges.length; ++i) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Multiplicity.boundFromString(minmax[0], 0);
                upper = Multiplicity.boundFromString(minmax[1], Integer.MAX_VALUE);
            } else if (ranges[i].length() == 0 || ranges[i].equals("*") || ranges[i].equals("n")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                upper = lower = Integer.parseInt(ranges[i]);
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper <= maxv) continue;
            maxv = upper;
        }
        this.minOccurs = minv;
        this.maxOccurs = maxv;
    }

    public String toString() {
        return this.minOccurs + (String)(this.maxOccurs == this.minOccurs ? "" : ".." + (Serializable)(this.maxOccurs == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.maxOccurs)));
    }

    public static int boundFromString(String bound, int def) throws NumberFormatException {
        int res = bound.length() == 0 ? def : (bound.equals("*") || bound.equals("n") ? Integer.MAX_VALUE : Integer.parseInt(bound));
        return res;
    }
}

