/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.ModelElementSelectionParseException;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class ModelElementSelectionInfo
implements MessageSource {
    private boolean validated = false;
    private ModelElementType modelElementType = null;
    private String modelElementStereotype = null;
    private Pattern modelElementStereotypePattern = null;
    private String modelElementName = null;
    private Pattern modelElementNamePattern = null;
    private String modelElementOwnerName = null;
    private Pattern modelElementOwnerNamePattern = null;
    private String modelElementOwnerStereotype = null;
    private Pattern modelElementOwnerStereotypePattern = null;
    private String propertyValueTypeStereotype = null;
    private Pattern propertyValueTypeStereotypePattern = null;
    private String applicationSchemaName = null;
    private Pattern applicationSchemaNamePattern = null;

    public ModelElementSelectionInfo() {
    }

    public ModelElementSelectionInfo(ModelElementType modelElementType, String modelElementStereotype, String modelElementName, String modelElementOwnerName, String modelElementOwnerStereotype, String propertyValueTypeStereotype, String applicationSchemaName) {
        this.modelElementType = modelElementType;
        this.modelElementStereotype = modelElementStereotype;
        this.modelElementName = modelElementName;
        this.modelElementOwnerName = modelElementOwnerName;
        this.modelElementOwnerStereotype = modelElementOwnerStereotype;
        this.propertyValueTypeStereotype = propertyValueTypeStereotype;
        this.applicationSchemaName = applicationSchemaName;
    }

    public void validate() throws ModelElementSelectionParseException {
        this.validated = true;
        ArrayList<CallSite> compileErrors = new ArrayList<CallSite>();
        if (this.modelElementName != null) {
            try {
                this.modelElementNamePattern = Pattern.compile(this.modelElementName);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@modelElementName - invalid value (" + this.modelElementName + "): " + e.getMessage())));
            }
        }
        if (this.modelElementOwnerName != null) {
            try {
                this.modelElementOwnerNamePattern = Pattern.compile(this.modelElementOwnerName);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@modelElementOwnerName - invalid value (" + this.modelElementOwnerName + "): " + e.getMessage())));
            }
        }
        if (this.modelElementOwnerStereotype != null) {
            try {
                this.modelElementOwnerStereotypePattern = Pattern.compile(this.modelElementOwnerStereotype);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@modelElementOwnerStereotype - invalid value (" + this.modelElementOwnerStereotype + "): " + e.getMessage())));
            }
        }
        if (this.modelElementStereotype != null) {
            try {
                this.modelElementStereotypePattern = Pattern.compile(this.modelElementStereotype);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@modelElementStereotype - invalid value (" + this.modelElementStereotype + "): " + e.getMessage())));
            }
        }
        if (this.propertyValueTypeStereotype != null) {
            try {
                this.propertyValueTypeStereotypePattern = Pattern.compile(this.propertyValueTypeStereotype);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@propertyValueTypeStereotype - invalid value (" + this.propertyValueTypeStereotype + "): " + e.getMessage())));
            }
        }
        if (this.applicationSchemaName != null) {
            try {
                this.applicationSchemaNamePattern = Pattern.compile(this.applicationSchemaName);
            }
            catch (PatternSyntaxException e) {
                compileErrors.add((CallSite)((Object)("@applicationSchemaName - invalid value (" + this.applicationSchemaName + "): " + e.getMessage())));
            }
        }
        if (!compileErrors.isEmpty()) {
            throw new ModelElementSelectionParseException("Compiling regular expression(s) of model element selection attribute(s) did not succeed. Issues: " + StringUtils.join(compileErrors, (String)", "));
        }
    }

    public Pattern getModelElementOwnerStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementOwnerStereotypePattern;
    }

    public Pattern getModelElementStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementStereotypePattern;
    }

    private void raiseNotValidatedIllegalStateException() {
        throw new IllegalStateException("ModelElementSelectionInfo.validate() has not been called. This is an implementation error.");
    }

    public Pattern getPropertyValueTypeStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.propertyValueTypeStereotypePattern;
    }

    public Pattern getModelElementNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementNamePattern;
    }

    public Pattern getModelElementOwnerNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementOwnerNamePattern;
    }

    public ModelElementType getModelElementType() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementType;
    }

    public Pattern getApplicationSchemaNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.applicationSchemaNamePattern;
    }

    public boolean hasModelElementNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementNamePattern != null;
    }

    public boolean hasModelElementOwnerNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementOwnerNamePattern != null;
    }

    public boolean hasModelElementStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementStereotypePattern != null;
    }

    public boolean hasModelElementOwnerStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementOwnerStereotypePattern != null;
    }

    public boolean hasPropertyValueTypeStereotypePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.propertyValueTypeStereotypePattern != null;
    }

    public boolean hasApplicationSchemaNamePattern() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.applicationSchemaNamePattern != null;
    }

    public boolean hasModelElementType() {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        return this.modelElementType != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(Info infoType) {
        if (!this.validated) {
            this.raiseNotValidatedIllegalStateException();
        }
        Options options = infoType.options();
        ShapeChangeResult result = infoType.result();
        boolean modelElementStereotypeMatch = true;
        boolean propertyValueTypeStereotypeMatch = true;
        boolean modelElementNameMatch = true;
        boolean modelElementOwnerNameMatch = true;
        boolean modelElementOwnerStereotypeMatch = true;
        boolean applicationSchemaNameMatch = true;
        boolean modelElementTypeMatch = true;
        if (this.hasModelElementType()) {
            modelElementTypeMatch = false;
            if (infoType instanceof AssociationInfo && this.modelElementType.equals((Object)ModelElementType.ASSOCIATION) || infoType instanceof ClassInfo && this.modelElementType.equals((Object)ModelElementType.CLASS) || infoType instanceof PackageInfo && this.modelElementType.equals((Object)ModelElementType.PACKAGE) || infoType instanceof PropertyInfo && this.modelElementType.equals((Object)ModelElementType.PROPERTY) || infoType instanceof PropertyInfo && this.modelElementType.equals((Object)ModelElementType.ATTRIBUTE) && ((PropertyInfo)infoType).isAttribute() || infoType instanceof PropertyInfo && this.modelElementType.equals((Object)ModelElementType.ASSOCIATIONROLE) && !((PropertyInfo)infoType).isAttribute()) {
                modelElementTypeMatch = true;
            }
        }
        if (this.hasModelElementStereotypePattern()) {
            modelElementStereotypeMatch = false;
            Stereotypes stereotypes = infoType.stereotypes();
            if (stereotypes.isEmpty()) {
                void var12_16;
                Object var12_12 = null;
                if (infoType instanceof PropertyInfo) {
                    String string = "";
                } else if (infoType instanceof ClassInfo) {
                    String string = "";
                } else if (infoType instanceof PackageInfo) {
                    String string = "";
                }
                stereotypes = options.stereotypesFactory();
                stereotypes.add((String)var12_16);
            }
            for (String stereotype : stereotypes.asArray()) {
                Matcher matcher = this.modelElementStereotypePattern.matcher(stereotype);
                if (matcher.matches()) {
                    modelElementStereotypeMatch = true;
                    result.addDebug(this, 100, stereotype, this.modelElementStereotypePattern.pattern());
                    break;
                }
                result.addDebug(this, 101, stereotype, this.modelElementStereotypePattern.pattern());
            }
        }
        if (this.hasModelElementOwnerStereotypePattern()) {
            PackageInfo packageInfo;
            modelElementOwnerStereotypeMatch = false;
            Info owner = null;
            if (infoType instanceof PropertyInfo) {
                owner = ((PropertyInfo)infoType).inClass();
            } else if (infoType instanceof ClassInfo) {
                owner = ((ClassInfo)infoType).pkg();
            } else if (infoType instanceof PackageInfo && (packageInfo = (PackageInfo)infoType).owner() != null) {
                owner = packageInfo.owner();
            }
            if (owner != null) {
                void var12_22;
                Stereotypes stereotypes = owner.stereotypes();
                if (stereotypes.isEmpty()) {
                    String stereotype = null;
                    if (infoType instanceof PropertyInfo) {
                        stereotype = "";
                    } else if (infoType instanceof ClassInfo) {
                        stereotype = "";
                    } else if (infoType instanceof PackageInfo) {
                        stereotype = "";
                    }
                    Stereotypes stereotypes2 = options.stereotypesFactory();
                    stereotypes2.add(stereotype);
                }
                for (String stereotype : var12_22.asArray()) {
                    Matcher matcher = this.modelElementOwnerStereotypePattern.matcher(stereotype);
                    if (matcher.matches()) {
                        modelElementOwnerStereotypeMatch = true;
                        result.addDebug(this, 100, stereotype, this.modelElementOwnerStereotypePattern.pattern());
                        break;
                    }
                    result.addDebug(this, 101, stereotype, this.modelElementOwnerStereotypePattern.pattern());
                }
            } else {
                modelElementOwnerStereotypeMatch = true;
            }
        }
        if (this.hasPropertyValueTypeStereotypePattern() && infoType instanceof PropertyInfo) {
            PropertyInfo pi = (PropertyInfo)infoType;
            Model model = pi.model();
            ClassInfo valueType = null;
            if (pi.typeInfo().id != null) {
                valueType = model.classById(pi.typeInfo().id);
            }
            if (valueType == null && pi.typeInfo().name != null) {
                valueType = model.classByName(pi.typeInfo().name);
            }
            if (valueType != null) {
                propertyValueTypeStereotypeMatch = false;
                Stereotypes stereotypes = valueType.stereotypes();
                if (stereotypes.isEmpty()) {
                    stereotypes = options.stereotypesFactory();
                    stereotypes.add("");
                }
                for (String stereotype : stereotypes.asArray()) {
                    Matcher matcher = this.propertyValueTypeStereotypePattern.matcher(stereotype);
                    if (matcher.matches()) {
                        propertyValueTypeStereotypeMatch = true;
                        result.addDebug(this, 100, stereotype, this.propertyValueTypeStereotypePattern.pattern());
                        break;
                    }
                    result.addDebug(this, 101, stereotype, this.propertyValueTypeStereotypePattern.pattern());
                }
            }
        }
        if (this.hasModelElementNamePattern()) {
            modelElementNameMatch = false;
            Matcher matcher = this.modelElementNamePattern.matcher(infoType.name());
            if (matcher.matches()) {
                modelElementNameMatch = true;
                result.addDebug(this, 100, infoType.name(), this.modelElementNamePattern.pattern());
            } else {
                result.addDebug(this, 101, infoType.name(), this.modelElementNamePattern.pattern());
            }
        }
        if (this.hasModelElementOwnerNamePattern()) {
            PackageInfo packageInfo;
            modelElementOwnerNameMatch = false;
            String ownerName = null;
            if (infoType instanceof PropertyInfo) {
                ownerName = ((PropertyInfo)infoType).inClass().name();
            } else if (infoType instanceof ClassInfo) {
                ownerName = ((ClassInfo)infoType).pkg().name();
            } else if (infoType instanceof PackageInfo && (packageInfo = (PackageInfo)infoType).owner() != null) {
                ownerName = packageInfo.owner().name();
            }
            if (ownerName != null) {
                Matcher matcher = this.modelElementOwnerNamePattern.matcher(ownerName);
                if (matcher.matches()) {
                    modelElementOwnerNameMatch = true;
                    result.addDebug(this, 100, ownerName, this.modelElementOwnerNamePattern.pattern());
                } else {
                    result.addDebug(this, 101, ownerName, this.modelElementOwnerNamePattern.pattern());
                }
            } else {
                modelElementOwnerNameMatch = true;
            }
        }
        if (this.hasApplicationSchemaNamePattern()) {
            applicationSchemaNameMatch = false;
            SortedSet<String> applicationSchemaNames = this.determineApplicationSchemaName(infoType);
            for (String applicationSchemaName : applicationSchemaNames) {
                Matcher matcher = this.applicationSchemaNamePattern.matcher(applicationSchemaName);
                if (matcher.matches()) {
                    applicationSchemaNameMatch = true;
                    result.addDebug(this, 100, applicationSchemaName, this.applicationSchemaNamePattern.pattern());
                    continue;
                }
                result.addDebug(this, 101, applicationSchemaName, this.applicationSchemaNamePattern.pattern());
            }
        }
        return modelElementStereotypeMatch && modelElementNameMatch && modelElementOwnerNameMatch && modelElementOwnerStereotypeMatch && propertyValueTypeStereotypeMatch && modelElementTypeMatch && applicationSchemaNameMatch;
    }

    public static ModelElementSelectionInfo parse(Element element) {
        String modelElementName = null;
        if (element.hasAttribute("modelElementName")) {
            modelElementName = element.getAttribute("modelElementName");
        }
        String modelElementOwnerName = null;
        if (element.hasAttribute("modelElementOwnerName")) {
            modelElementOwnerName = element.getAttribute("modelElementOwnerName");
        }
        String modelElementOwnerStereotype = null;
        if (element.hasAttribute("modelElementOwnerStereotype")) {
            modelElementOwnerStereotype = element.getAttribute("modelElementOwnerStereotype");
        }
        String modelElementStereotype = null;
        if (element.hasAttribute("modelElementStereotype")) {
            modelElementStereotype = element.getAttribute("modelElementStereotype");
        }
        String propertyValueTypeStereotype = null;
        if (element.hasAttribute("propertyValueTypeStereotype")) {
            propertyValueTypeStereotype = element.getAttribute("propertyValueTypeStereotype");
        }
        String applicationSchemaName = null;
        if (element.hasAttribute("applicationSchemaName")) {
            applicationSchemaName = element.getAttribute("applicationSchemaName");
        }
        ModelElementType modelElementType = null;
        if (element.hasAttribute("modelElementType")) {
            String mdeValue = element.getAttribute("modelElementType");
            if (mdeValue.equalsIgnoreCase("Association")) {
                modelElementType = ModelElementType.ASSOCIATION;
            } else if (mdeValue.equalsIgnoreCase("Class")) {
                modelElementType = ModelElementType.CLASS;
            } else if (mdeValue.equalsIgnoreCase("Package")) {
                modelElementType = ModelElementType.PACKAGE;
            } else if (mdeValue.equalsIgnoreCase("PROPERTY")) {
                modelElementType = ModelElementType.PROPERTY;
            } else if (mdeValue.equalsIgnoreCase("Attribute")) {
                modelElementType = ModelElementType.ATTRIBUTE;
            } else if (mdeValue.equalsIgnoreCase("AssociationRole")) {
                modelElementType = ModelElementType.ASSOCIATIONROLE;
            }
        }
        return new ModelElementSelectionInfo(modelElementType, modelElementStereotype, modelElementName, modelElementOwnerName, modelElementOwnerStereotype, propertyValueTypeStereotype, applicationSchemaName);
    }

    private SortedSet<String> determineApplicationSchemaName(Info infoType) {
        ShapeChangeResult result = infoType.result();
        TreeSet<PackageInfo> pis = new TreeSet<PackageInfo>();
        if (infoType instanceof PackageInfo) {
            pis.add((PackageInfo)infoType);
        } else if (infoType instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)infoType;
            pis.add(ci.pkg());
        } else if (infoType instanceof PropertyInfo) {
            PropertyInfo propI = (PropertyInfo)infoType;
            pis.add(propI.inClass().pkg());
        } else if (infoType instanceof AssociationInfo) {
            AssociationInfo ai = (AssociationInfo)infoType;
            if (ai.assocClass() != null) {
                pis.add(ai.assocClass().pkg());
            }
            pis.add(ai.end1().inClass().pkg());
            pis.add(ai.end2().inClass().pkg());
        } else {
            result.addWarning(this, 103, infoType.name());
        }
        TreeSet<String> asNames = new TreeSet<String>();
        for (PackageInfo pi : pis) {
            PackageInfo piAS = this.identifyApplicationSchema(pi);
            if (piAS == null) continue;
            asNames.add(piAS.name());
        }
        if (asNames.isEmpty()) {
            result.addWarning(this, 102, infoType.name());
        }
        return asNames;
    }

    private PackageInfo identifyApplicationSchema(PackageInfo pi) {
        if (pi.isAppSchema()) {
            return pi;
        }
        if (pi.owner() != null) {
            return this.identifyApplicationSchema(pi.owner());
        }
        return null;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "??'$1$' matches regex '$2$'";
            }
            case 101: {
                return "??'$1$' does not match regex '$2$'";
            }
            case 102: {
                return "Could not find application schema for Info type '$1$'";
            }
            case 103: {
                return "Class type of Info object '$1$' not recognized by logic to determine the name of its application schema";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }

    public static enum ModelElementType {
        ASSOCIATION,
        CLASS,
        PACKAGE,
        PROPERTY,
        ATTRIBUTE,
        ASSOCIATIONROLE;

    }
}

