/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.ModelDiff;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import name.fraser.neil.plaintext.diff_match_patch;

public class Differ {
    private boolean aaaModel = false;
    private String[] maArrRef = new String[0];
    private diff_match_patch strDiffer = new diff_match_patch();
    private Set<ClassInfo> processed = new HashSet<ClassInfo>();
    private Map<ClassInfo, Collection<PropertyInfo>> hiddenPropertiesCurr = new HashMap<ClassInfo, Collection<PropertyInfo>>();
    private Map<ClassInfo, Collection<PropertyInfo>> hiddenPropertiesRef = new HashMap<ClassInfo, Collection<PropertyInfo>>();

    public Differ() {
    }

    public Differ(boolean aaa, String[] maArr) {
        this.aaaModel = true;
        this.maArrRef = maArr;
    }

    public Differ(boolean aaa, String[] maArr, Model curr, Model ref) {
        this.aaaModel = true;
        this.maArrRef = maArr;
        if (this.aaaModel) {
            Collection<PropertyInfo> coll;
            ClassInfo ci;
            PropertyInfo rpi;
            for (PropertyInfo pi : curr.properties()) {
                rpi = pi.reverseProperty();
                if (rpi == null || rpi.isNavigable() || rpi.name() == null || rpi.name().startsWith("role_")) continue;
                ci = rpi.inClass();
                if (!this.hiddenPropertiesCurr.containsKey(ci)) {
                    this.hiddenPropertiesCurr.put(ci, new HashSet());
                }
                coll = this.hiddenPropertiesCurr.get(ci);
                coll.add(rpi);
            }
            for (PropertyInfo pi : ref.properties()) {
                rpi = pi.reverseProperty();
                if (rpi == null || rpi.isNavigable() || rpi.name() == null || rpi.name().startsWith("role_")) continue;
                ci = rpi.inClass();
                if (!this.hiddenPropertiesRef.containsKey(ci)) {
                    this.hiddenPropertiesRef.put(ci, new HashSet());
                }
                coll = this.hiddenPropertiesRef.get(ci);
                coll.add(rpi);
            }
        }
    }

    private boolean MatchingMA(Info i) {
        if (!this.aaaModel) {
            return true;
        }
        String malist = i.taggedValue("AAA:Modellart");
        if (malist == null) {
            return true;
        }
        if ((malist = malist.trim()).length() == 0) {
            return true;
        }
        if (this.maArrRef.length == 0) {
            return true;
        }
        for (String ma : malist.split(",")) {
            ma = ma.trim();
            for (String max : this.maArrRef) {
                if (!ma.equals(max.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public void merge(SortedMap<Info, SortedSet<DiffElement>> diffs, SortedMap<Info, SortedSet<DiffElement>> diffs2) {
        for (Map.Entry<Info, SortedSet<DiffElement>> me : diffs2.entrySet()) {
            if (diffs.containsKey(me.getKey())) {
                ((SortedSet)diffs.get(me.getKey())).addAll((Collection)me.getValue());
                continue;
            }
            diffs.put(me.getKey(), me.getValue());
        }
    }

    public SortedMap<Info, SortedSet<DiffElement>> diff(PackageInfo curr, PackageInfo ref) {
        SortedMap<Info, SortedSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        SortedSet<PackageInfo> sub = curr.containedPackages();
        Info[] infoArr = new Info[sub.size()];
        sub.toArray(infoArr);
        SortedSet<Object> subRef = ref == null ? new TreeSet() : ref.containedPackages();
        Info[] infoArrRef = new Info[subRef.size()];
        subRef.toArray(infoArrRef);
        SortedMap<Info, SortedSet<DiffElement>> diffs2 = this.infoDiffs(curr, DiffElement.ElementType.SUBPACKAGE, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        SortedSet<ClassInfo> temp = curr.model().classes(curr);
        TreeSet<ClassInfo> cls = new TreeSet<ClassInfo>();
        for (ClassInfo ci : temp) {
            if (ci.pkg() != curr || !this.MatchingMA(ci)) continue;
            cls.add(ci);
        }
        infoArr = new Info[cls.size()];
        cls.toArray(infoArr);
        temp = ref == null ? new TreeSet() : ref.model().classes(ref);
        HashSet<ClassInfo> clsRef = new HashSet<ClassInfo>();
        for (ClassInfo ci : temp) {
            if (ci.pkg() != ref || !this.MatchingMA(ci)) continue;
            clsRef.add(ci);
        }
        infoArrRef = new Info[clsRef.size()];
        clsRef.toArray(infoArrRef);
        diffs2 = this.infoDiffs(curr, DiffElement.ElementType.CLASS, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        return diffs;
    }

    public SortedMap<Info, SortedSet<DiffElement>> diff(ClassInfo curr, ClassInfo ref) {
        Collection<PropertyInfo> propadd;
        Collection<PropertyInfo> propadd2;
        if (this.processed.contains(curr)) {
            return new TreeMap<Info, SortedSet<DiffElement>>();
        }
        SortedMap<Info, SortedSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        HashSet<PropertyInfo> prop = new HashSet<PropertyInfo>();
        prop.addAll(curr.properties().values());
        if (this.aaaModel && (propadd2 = this.hiddenPropertiesCurr.get(curr)) != null && !propadd2.isEmpty()) {
            prop.addAll(propadd2);
        }
        Info[] infoArr = new Info[prop.size()];
        prop.toArray(infoArr);
        HashSet<PropertyInfo> propRef = new HashSet<PropertyInfo>();
        propRef.addAll(ref.properties().values());
        if (this.aaaModel && (propadd = this.hiddenPropertiesRef.get(ref)) != null && !propadd.isEmpty()) {
            propRef.addAll(propadd);
        }
        Info[] infoArrRef = new Info[propRef.size()];
        propRef.toArray(infoArrRef);
        SortedMap<Info, SortedSet<DiffElement>> diffs2 = curr.category() == 3 || curr.category() == 2 ? this.infoDiffs(curr, DiffElement.ElementType.ENUM, infoArr, infoArrRef) : this.infoDiffs(curr, DiffElement.ElementType.PROPERTY, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        SortedSet<String> cls = curr.supertypes();
        infoArr = new Info[cls.size()];
        int i = 0;
        for (String id : cls) {
            infoArr[i++] = curr.model().classById(id);
        }
        SortedSet<String> clsRef = ref.supertypes();
        infoArrRef = new Info[clsRef.size()];
        i = 0;
        for (String id : clsRef) {
            infoArrRef[i++] = ref.model().classById(id);
        }
        diffs2 = this.infoDiffs(curr, DiffElement.ElementType.SUPERTYPE, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        this.processed.add(curr);
        return diffs;
    }

    public SortedMap<Info, SortedSet<DiffElement>> diff(PropertyInfo curr, PropertyInfo ref) {
        SortedMap<Info, SortedSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        DiffElement diff = this.stringDiff(DiffElement.ElementType.MULTIPLICITY, ref.cardinality().toString(), curr.cardinality().toString());
        if (diff != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.VALUETYPE, ref.typeInfo().name, curr.typeInfo().name)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        return diffs;
    }

    public SortedMap<Info, SortedSet<DiffElement>> diffEnum(PropertyInfo curr, PropertyInfo ref) {
        SortedMap<Info, SortedSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        return diffs;
    }

    protected LinkedList<diff_match_patch.Diff> aaaDocumentation(String ref, String curr) {
        boolean found;
        String[] sa = curr.split("-==-");
        String[] saRef = ref.split("-==-");
        LinkedList strdiffs = this.strDiffer.diff_main(saRef[0], sa[0]);
        boolean heading = false;
        boolean first = true;
        String sRef = null;
        String head = null;
        for (String s1 : sa) {
            if (heading) {
                head = s1;
                found = false;
                for (String s2 : saRef) {
                    if (found) {
                        sRef = s2;
                        break;
                    }
                    if (!s1.equals(s2)) continue;
                    found = true;
                }
            } else if (sRef != null) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.addAll(this.strDiffer.diff_main(sRef, s1));
                sRef = null;
            } else if (!first && !s1.isEmpty()) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.INSERT, s1));
            }
            heading = !heading;
            first = false;
        }
        heading = false;
        first = true;
        sRef = null;
        head = null;
        for (String s2 : saRef) {
            if (heading) {
                head = s2;
                found = false;
                sRef = null;
                for (String s1 : sa) {
                    if (found) {
                        sRef = s2;
                        break;
                    }
                    if (!s1.equals(s2)) continue;
                    found = true;
                }
            } else if (!first && sRef == null && !s2.isEmpty()) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.DELETE, s2));
            }
            heading = !heading;
            first = false;
        }
        return strdiffs;
    }

    protected DiffElement stringDiff(DiffElement.ElementType type, String ref, String curr) {
        LinkedList<diff_match_patch.Diff> strdiffs = this.aaaModel && type == DiffElement.ElementType.DOCUMENTATION ? this.aaaDocumentation(ref, curr) : this.strDiffer.diff_main(ref, curr);
        this.strDiffer.diff_cleanupEfficiency(strdiffs);
        if (this.strDiffer.diff_levenshtein(strdiffs) == 0) {
            return null;
        }
        DiffElement diff = new DiffElement();
        diff.change = DiffElement.Operation.CHANGE;
        diff.subElementType = type;
        diff.diff = strdiffs;
        return diff;
    }

    protected SortedMap<Info, SortedSet<DiffElement>> infoDiffs(Info base, DiffElement.ElementType type, Info[] currs, Info[] refs) {
        DiffElement diff;
        String s2;
        String s1;
        boolean eq;
        boolean found;
        TreeMap<Info, SortedSet<DiffElement>> diffs = new TreeMap<Info, SortedSet<DiffElement>>();
        for (Info i : currs) {
            if (type != DiffElement.ElementType.SUBPACKAGE && !this.MatchingMA(i)) continue;
            found = false;
            for (Info iRef : refs) {
                if (type != DiffElement.ElementType.SUBPACKAGE && !this.MatchingMA(iRef)) continue;
                eq = i.name().equalsIgnoreCase(iRef.name());
                if (type == DiffElement.ElementType.ENUM) {
                    s1 = ((PropertyInfo)i).initialValue();
                    s2 = ((PropertyInfo)iRef).initialValue();
                    if (s1 != null && s2 != null) {
                        eq = s1.equalsIgnoreCase(s2);
                    }
                }
                if (!eq) continue;
                switch (type) {
                    case SUBPACKAGE: {
                        SortedMap<Info, SortedSet<DiffElement>> diffs2 = this.diff((PackageInfo)i, (PackageInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case CLASS: {
                        SortedMap<Info, SortedSet<DiffElement>> diffs2 = this.diff((ClassInfo)i, (ClassInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case PROPERTY: {
                        SortedMap<Info, SortedSet<DiffElement>> diffs2 = this.diff((PropertyInfo)i, (PropertyInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case ENUM: {
                        SortedMap<Info, SortedSet<DiffElement>> diffs2 = this.diffEnum((PropertyInfo)i, (PropertyInfo)iRef);
                        this.merge(diffs, diffs2);
                    }
                }
                found = true;
                break;
            }
            if (found) continue;
            diff = new DiffElement();
            diff.change = DiffElement.Operation.INSERT;
            diff.subElementType = type;
            diff.subElement = i;
            if (!diffs.containsKey(base)) {
                diffs.put(base, new TreeSet());
            }
            ((SortedSet)diffs.get(base)).add(diff);
        }
        for (Info iRef : refs) {
            if (!this.MatchingMA(iRef)) continue;
            found = false;
            for (Info i : currs) {
                if (!this.MatchingMA(i)) continue;
                eq = i.name().equalsIgnoreCase(iRef.name());
                if (type == DiffElement.ElementType.ENUM) {
                    s1 = ((PropertyInfo)i).initialValue();
                    s2 = ((PropertyInfo)iRef).initialValue();
                    if (s1 != null && s2 != null) {
                        eq = s1.equalsIgnoreCase(s2);
                    }
                }
                if (!eq) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff = new DiffElement();
            diff.change = DiffElement.Operation.DELETE;
            diff.subElementType = type;
            diff.subElement = iRef;
            if (!diffs.containsKey(base)) {
                diffs.put(base, new TreeSet());
            }
            ((SortedSet)diffs.get(base)).add(diff);
        }
        return diffs;
    }

    private String addConstraints(ClassInfo ci, String doc) {
        for (Constraint ocl : ci.directConstraints()) {
            String[] sa;
            doc = (String)doc + "\n\n-==- Konsistenzbedingung ";
            if (!ocl.name().equalsIgnoreCase("alle")) {
                doc = (String)doc + ocl.name() + " ";
            }
            doc = (String)doc + "-==-\n";
            String txt = ocl.text();
            for (String sc : sa = Objects.nonNull(txt) ? txt.split("/\\*") : new String[]{}) {
                if ((sc = sc.trim()).isEmpty()) continue;
                if (sc.contains("*/")) {
                    sc = sc.replaceAll("\\*/.*", "");
                    sc = sc.trim();
                }
                doc = (String)doc + "\n" + sc;
            }
        }
        return doc;
    }

    public SortedMap<Info, SortedSet<DiffElement>> baseDiff(Info curr, Info ref) {
        boolean found;
        String key;
        String s2;
        String s1;
        String refs;
        DiffElement diff;
        TreeMap<Info, SortedSet<DiffElement>> diffs = new TreeMap<Info, SortedSet<DiffElement>>();
        if (this.aaaModel && curr instanceof ClassInfo) {
            String currdoc = this.addConstraints((ClassInfo)curr, curr.documentation());
            String refdoc = ref == null ? "" : this.addConstraints((ClassInfo)ref, ref.documentation());
            diff = this.stringDiff(DiffElement.ElementType.DOCUMENTATION, refdoc, currdoc);
        } else {
            refs = ref == null ? "" : ref.documentation();
            diff = this.stringDiff(DiffElement.ElementType.DOCUMENTATION, refs, curr.documentation());
        }
        if (diff != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.NAME, refs = ref == null ? "" : ref.name(), curr.name())) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string = s1 = ref == null ? "" : ref.aliasName();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.aliasName()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.ALIAS, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string2 = s1 = ref == null ? "" : ref.definition();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.definition()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.DEFINITION, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string3 = s1 = ref == null ? "" : ref.description();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.description()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.DESCRIPTION, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string4 = s1 = ref == null ? "" : ref.legalBasis();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.legalBasis()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.LEGALBASIS, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string5 = s1 = ref == null ? "" : ref.primaryCode();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.primaryCode()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.PRIMARYCODE, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        String string6 = s1 = ref == null ? "" : ref.globalIdentifier();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = curr.globalIdentifier()) == null) {
            s2 = "";
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.GLOBALIDENTIFIER, s1, s2)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.STEREOTYPE, refs = ref == null ? "" : ref.stereotypes().toString().replace("[", "").replace("]", ""), curr.stereotypes().toString().replace("[", "").replace("]", ""))) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        if (this.aaaModel) {
            boolean retired = curr.stereotypes().contains("retired");
            boolean retiredRef = ref.stereotypes().contains("retired");
            diff = null;
            if (!retiredRef && retired) {
                diff = new DiffElement();
                diff.change = DiffElement.Operation.INSERT;
            } else if (retiredRef && !retired) {
                diff = new DiffElement();
                diff.change = DiffElement.Operation.DELETE;
            }
            if (diff != null) {
                diff.subElementType = DiffElement.ElementType.AAARETIRED;
                if (!diffs.containsKey(curr)) {
                    diffs.put(curr, new TreeSet());
                }
                ((SortedSet)diffs.get(curr)).add(diff);
            }
        }
        String taglist = curr.options().parameter("representTaggedValues");
        Map<String, String> taggedValues = curr.taggedValues(taglist);
        Map<String, String> taggedValuesRef = ref == null ? null : ref.taggedValues(taglist);
        for (Map.Entry<String, String> entry : taggedValues.entrySet()) {
            String valref;
            key = entry.getKey();
            String val = entry.getValue();
            if (this.aaaModel && (key.equalsIgnoreCase("AAA:Modellart") || key.equalsIgnoreCase("AAA:Grunddatenbestand"))) {
                valref = null;
                if (taggedValuesRef != null && taggedValuesRef.containsKey(key)) {
                    valref = taggedValuesRef.get(key);
                }
                if (key.equalsIgnoreCase("AAA:Modellart")) {
                    if (val == null || val.isEmpty()) {
                        val = "Alle";
                    }
                    if (valref == null || valref.isEmpty()) {
                        valref = "Alle";
                    }
                } else {
                    if (val == null) {
                        val = "";
                    }
                    if (valref == null) {
                        valref = "";
                    }
                }
                for (String ma : val.split(",")) {
                    ma = ma.trim();
                    for (String max : this.maArrRef) {
                        if (!ma.equals(max.trim())) continue;
                        found = false;
                        for (String ma2 : valref.split(",")) {
                            if (!(ma2 = ma2.trim()).equals(ma)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        diff = new DiffElement();
                        diff.change = DiffElement.Operation.INSERT;
                        diff.subElementType = key.equalsIgnoreCase("AAA:Modellart") ? DiffElement.ElementType.AAAMODELLART : DiffElement.ElementType.AAAGRUNDDATENBESTAND;
                        diff.tag = ma;
                        if (!diffs.containsKey(curr)) {
                            diffs.put(curr, new TreeSet());
                        }
                        ((SortedSet)diffs.get(curr)).add(diff);
                    }
                }
                continue;
            }
            if (this.aaaModel && key.equalsIgnoreCase("AAA:Landnutzung")) {
                valref = null;
                if (taggedValuesRef != null && taggedValuesRef.containsKey(key)) {
                    valref = taggedValuesRef.get(key);
                }
                if (val != null && !val.equalsIgnoreCase("true")) {
                    val = null;
                }
                if (valref != null && !valref.equalsIgnoreCase("true")) {
                    valref = null;
                }
                diff = null;
                if (valref == null && val != null) {
                    diff = new DiffElement();
                    diff.change = DiffElement.Operation.INSERT;
                    diff.tag = val;
                } else if (val == null && valref != null) {
                    diff = new DiffElement();
                    diff.change = DiffElement.Operation.DELETE;
                    diff.tag = valref;
                }
                if (diff == null) continue;
                diff.subElementType = DiffElement.ElementType.AAALANDNUTZUNG;
                if (!diffs.containsKey(curr)) {
                    diffs.put(curr, new TreeSet());
                }
                ((SortedSet)diffs.get(curr)).add(diff);
                continue;
            }
            if (taggedValuesRef != null && taggedValuesRef.containsKey(key)) {
                valref = taggedValuesRef.get(key);
                diff = this.stringDiff(DiffElement.ElementType.TAG, valref, val);
            } else {
                diff = this.stringDiff(DiffElement.ElementType.TAG, "", val);
            }
            if (diff == null) continue;
            if (this.aaaModel && key.equalsIgnoreCase("AAA:GueltigBis")) {
                diff.subElementType = DiffElement.ElementType.AAAGUELTIGBIS;
            } else {
                diff.tag = key;
            }
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new TreeSet());
            }
            ((SortedSet)diffs.get(curr)).add(diff);
        }
        if (taggedValuesRef != null) {
            for (Map.Entry<String, String> entry : taggedValuesRef.entrySet()) {
                String val;
                String valref;
                key = entry.getKey();
                if (this.aaaModel && (key.equalsIgnoreCase("AAA:Modellart") || key.equalsIgnoreCase("AAA:Grunddatenbestand"))) {
                    valref = taggedValuesRef.get(key);
                    val = null;
                    if (taggedValues.containsKey(key)) {
                        val = taggedValues.get(key);
                    }
                    if (key.equalsIgnoreCase("AAA:Modellart")) {
                        if (val == null || val.isEmpty()) {
                            val = "Alle";
                        }
                        if (valref == null || valref.isEmpty()) {
                            val = "Alle";
                        }
                    } else {
                        if (val == null) {
                            val = "";
                        }
                        if (valref == null) {
                            val = "";
                        }
                    }
                    for (String ma : valref.split(",")) {
                        ma = ma.trim();
                        for (String max : this.maArrRef) {
                            if (!ma.equals(max.trim())) continue;
                            found = false;
                            for (String ma2 : val.split(",")) {
                                if (!(ma2 = ma2.trim()).equals(ma)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            diff = new DiffElement();
                            diff.change = DiffElement.Operation.DELETE;
                            diff.subElementType = key.equalsIgnoreCase("AAA:Modellart") ? DiffElement.ElementType.AAAMODELLART : DiffElement.ElementType.AAAGRUNDDATENBESTAND;
                            diff.tag = ma;
                            if (!diffs.containsKey(curr)) {
                                diffs.put(curr, new TreeSet());
                            }
                            ((SortedSet)diffs.get(curr)).add(diff);
                        }
                    }
                    continue;
                }
                if (this.aaaModel && key.equalsIgnoreCase("AAA:Landnutzung")) {
                    valref = taggedValuesRef.get(key);
                    val = null;
                    if (taggedValues.containsKey(key)) {
                        val = taggedValues.get(key);
                    }
                    if (val != null && !val.equalsIgnoreCase("true")) {
                        val = null;
                    }
                    if (valref != null && !valref.equalsIgnoreCase("true")) {
                        valref = null;
                    }
                    diff = null;
                    if (valref == null && val != null) {
                        diff = new DiffElement();
                        diff.change = DiffElement.Operation.INSERT;
                        diff.tag = val;
                    } else if (val == null && valref != null) {
                        diff = new DiffElement();
                        diff.change = DiffElement.Operation.DELETE;
                        diff.tag = valref;
                    }
                    if (diff == null) continue;
                    diff.subElementType = DiffElement.ElementType.AAALANDNUTZUNG;
                    if (!diffs.containsKey(curr)) {
                        diffs.put(curr, new TreeSet());
                    }
                    ((SortedSet)diffs.get(curr)).add(diff);
                    continue;
                }
                if (taggedValues.containsKey(key) || (diff = this.stringDiff(DiffElement.ElementType.TAG, entry.getValue(), "")) == null) continue;
                if (this.aaaModel && key.equalsIgnoreCase("AAA:GueltigBis")) {
                    diff.subElementType = DiffElement.ElementType.AAAGUELTIGBIS;
                } else {
                    diff.tag = key;
                }
                if (!diffs.containsKey(curr)) {
                    diffs.put(curr, new TreeSet());
                }
                ((SortedSet)diffs.get(curr)).add(diff);
            }
        }
        return diffs;
    }

    public String diff_toString(LinkedList<diff_match_patch.Diff> diffs) {
        StringBuilder res = new StringBuilder();
        for (diff_match_patch.Diff aDiff : diffs) {
            String text = aDiff.text;
            switch (aDiff.operation) {
                case INSERT: {
                    res.append("[[ins]]").append(text).append("[[/ins]]");
                    break;
                }
                case DELETE: {
                    res.append("[[del]]").append(text).append("[[/del]]");
                    break;
                }
                case EQUAL: {
                    res.append(text);
                }
            }
        }
        return res.toString();
    }
}

