/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.ModelDiff;

import de.interactive_instruments.ShapeChange.Model.Info;
import java.util.LinkedList;
import name.fraser.neil.plaintext.diff_match_patch;

public class DiffElement
implements Comparable<DiffElement> {
    public Operation change;
    public ElementType subElementType;
    public LinkedList<diff_match_patch.Diff> diff = null;
    public Info subElement = null;
    public String tag = null;

    @Override
    public int compareTo(DiffElement o) {
        if (this.change != o.change) {
            return this.change.toString().compareTo(o.change.toString());
        }
        if (this.subElementType != o.subElementType) {
            return this.subElementType.toString().compareTo(o.subElementType.toString());
        }
        if (this.subElement != null && o.subElement != null) {
            return this.subElement.compareTo(o.subElement);
        }
        if (this.tag != null && o.tag != null) {
            return this.tag.compareTo(o.tag);
        }
        if (this.subElement != null) {
            return -1;
        }
        return 1;
    }

    public String diff_toString() {
        StringBuilder result = new StringBuilder();
        if (this.diff != null) {
            for (diff_match_patch.Diff aDiff : this.diff) {
                switch (aDiff.operation) {
                    case INSERT: {
                        result.append(aDiff.toString());
                        break;
                    }
                    case DELETE: {
                        result.append(aDiff.toString());
                        break;
                    }
                    case EQUAL: {
                        result.append(aDiff.text);
                    }
                }
            }
        }
        return result.toString();
    }

    public String diff_from_to() {
        StringBuilder result = new StringBuilder();
        if (this.diff != null) {
            StringBuilder from = new StringBuilder();
            StringBuilder to = new StringBuilder();
            for (diff_match_patch.Diff aDiff : this.diff) {
                switch (aDiff.operation) {
                    case INSERT: {
                        to.append(aDiff.text);
                        break;
                    }
                    case DELETE: {
                        from.append(aDiff.text);
                        break;
                    }
                    case EQUAL: {
                        from.append(aDiff.text);
                        to.append(aDiff.text);
                    }
                }
            }
            result.append("FROM: ");
            result.append((CharSequence)from);
            result.append(" TO: ");
            result.append((CharSequence)to);
        }
        return result.toString();
    }

    public static enum ElementType {
        NAME,
        DOCUMENTATION,
        MULTIPLICITY,
        VALUETYPE,
        CLASS,
        SUPERTYPE,
        SUBPACKAGE,
        PROPERTY,
        ENUM,
        STEREOTYPE,
        TAG,
        ALIAS,
        DEFINITION,
        DESCRIPTION,
        PRIMARYCODE,
        GLOBALIDENTIFIER,
        LEGALBASIS,
        AAAMODELLART,
        AAAGRUNDDATENBESTAND,
        AAALANDNUTZUNG,
        AAAGUELTIGBIS,
        AAARETIRED;


        public String toString() {
            switch (this) {
                case NAME: {
                    return "NAME";
                }
                case DOCUMENTATION: {
                    return "DOCUMENTATION";
                }
                case MULTIPLICITY: {
                    return "MULTIPLICITY";
                }
                case VALUETYPE: {
                    return "VALUETYPE";
                }
                case CLASS: {
                    return "CLASS";
                }
                case SUPERTYPE: {
                    return "SUPERTYPE";
                }
                case SUBPACKAGE: {
                    return "SUBPACKAGE";
                }
                case PROPERTY: {
                    return "PROPERTY";
                }
                case ENUM: {
                    return "ENUM";
                }
                case STEREOTYPE: {
                    return "STEREOTYPE";
                }
                case TAG: {
                    return "TAG";
                }
                case ALIAS: {
                    return "ALIAS";
                }
                case DEFINITION: {
                    return "DEFINITION";
                }
                case DESCRIPTION: {
                    return "DESCRIPTION";
                }
                case LEGALBASIS: {
                    return "LEGALBASIS";
                }
                case PRIMARYCODE: {
                    return "PRIMARYCODE";
                }
                case GLOBALIDENTIFIER: {
                    return "GLOBALIDENTIFIER";
                }
                case AAAMODELLART: {
                    return "AAAMODELLART";
                }
                case AAAGRUNDDATENBESTAND: {
                    return "AAAGRUNDDATENBESTAND";
                }
                case AAALANDNUTZUNG: {
                    return "AAALANDNUTZUNG";
                }
                case AAAGUELTIGBIS: {
                    return "AAAGUELTIGBIS";
                }
                case AAARETIRED: {
                    return "AAARETIRED";
                }
            }
            return "(unknown)";
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        CHANGE;


        public String toString() {
            switch (this) {
                case DELETE: {
                    return "DELETE";
                }
                case INSERT: {
                    return "INSERT";
                }
                case CHANGE: {
                    return "CHANGE";
                }
            }
            return "(unknown)";
        }
    }
}

