/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.Xmi10.AssociationInfoXmi10;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.List;
import java.util.Vector;
import org.junit.platform.commons.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyInfoXmi10
extends PropertyInfoImpl
implements PropertyInfo,
MessageSource {
    protected Element prp = null;
    protected Xmi10Document doc = null;
    protected String id = null;
    protected boolean attribute = true;
    protected AssociationInfoXmi10 associationInfo = null;
    protected ClassInfo classInfo = null;
    protected StructuredNumber sequenceNumber = null;
    protected boolean aliasAccessed = false;

    @Override
    public Model model() {
        return this.doc;
    }

    @Override
    public Options options() {
        return this.doc.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.doc.result;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        if (s != null) {
            if ((s = s.trim()).startsWith("/")) {
                s = s.substring(1);
            }
            if (this.attribute && s.indexOf("[") > 0 && s.endsWith("]")) {
                String[] parts = s.split("\\[");
                s = parts[0].trim();
            }
        } else if (this.classInfo == null || this.classInfo.category() != 2 && this.classInfo.category() != 3) {
            if (this.isNavigable()) {
                this.doc.result.addWarning(null, 100, "property", this.id);
            }
            s = this.id;
        } else {
            this.doc.result.addWarning(null, 136, this.id, this.classInfo.name());
        }
        return s;
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.doc.taggedValues(this.id());
        }
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory(0);
        }
    }

    @Override
    public boolean isDerived() {
        String s = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        return s != null && (s = s.trim()).startsWith("/");
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public Type typeInfo() {
        String[] parts;
        Type ti = new Type();
        ti.id = this.attribute ? this.doc.idOfProperty(this.prp, "Foundation.Core.StructuralFeature.type").trim() : this.doc.idOfProperty(this.prp, "Foundation.Core.AssociationEnd.type").trim();
        Element e = this.doc.getElementById(ti.id);
        if (e != null) {
            ti.name = this.doc.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (ti.name == null) {
                return ti;
            }
            ti.name = ti.name.trim();
        }
        if (ti.id == null) {
            this.doc.result.addError(this, 137, this.id(), this.name());
            return ti;
        }
        if (ti.name == null) {
            this.doc.result.addError(this, 138, this.id(), this.name());
            return ti;
        }
        if (this.attribute && ti.name.indexOf("[") > 0 && (ti.name.endsWith("]") || ti.name.endsWith("}"))) {
            parts = ti.name.split("\\[");
            ti.name = parts[0].trim();
        }
        if (this.attribute && ti.name.indexOf("{") > 0 && ti.name.endsWith("}")) {
            parts = ti.name.split("\\{");
            ti.name = parts[0].trim();
        }
        return ti;
    }

    @Override
    public Multiplicity cardinality() {
        Multiplicity mx;
        Element e2;
        Multiplicity m = new Multiplicity();
        Element e1 = this.doc.elementOfProperty(this.prp, "Foundation.Core.StructuralFeature.multiplicity");
        if (e1 == null) {
            e1 = this.doc.elementOfProperty(this.prp, "Foundation.Core.AssociationEnd.multiplicity");
        }
        if (e1 != null && (e2 = this.doc.elementOfProperty(e1, "Foundation.Data_Types.Multiplicity.range")) != null) {
            Integer lower = Integer.valueOf(this.doc.textOfProperty(e2, "Foundation.Data_Types.MultiplicityRange.lower"));
            m.minOccurs = lower;
            String upperval = this.doc.textOfProperty(e2, "Foundation.Data_Types.MultiplicityRange.upper");
            if (upperval.equals("*")) {
                m.maxOccurs = Integer.MAX_VALUE;
            } else {
                Integer upper = Integer.valueOf(upperval);
                m.maxOccurs = upper;
                if (m.maxOccurs == -1) {
                    m.maxOccurs = Integer.MAX_VALUE;
                }
            }
        }
        String name = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        if (this.attribute && name.indexOf("[") > 0 && name.endsWith("]")) {
            String[] parts = name.split("\\[");
            String multiplicityRanges = parts[1].substring(0, parts[1].length() - 1);
            String[] ranges = multiplicityRanges.split(",");
            int minv = Integer.MAX_VALUE;
            int maxv = Integer.MIN_VALUE;
            for (int i = 0; i < ranges.length; ++i) {
                int upper;
                int lower;
                if (ranges[i].indexOf("..") > 0) {
                    String[] minmax = ranges[i].split("\\.\\.", 2);
                    lower = Integer.parseInt(minmax[0]);
                    if (minmax[1].equals("*") || minmax[1].equals("n") || minmax[1].length() == 0) {
                        upper = Integer.MAX_VALUE;
                    } else {
                        try {
                            upper = Integer.parseInt(minmax[1]);
                        }
                        catch (NumberFormatException e) {
                            this.doc.result.addWarning(null, 1003, minmax[1]);
                            upper = Integer.MAX_VALUE;
                        }
                    }
                } else if (ranges[i].length() == 0 || ranges[i].equals("*") || ranges[i].equals("n")) {
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = lower = Integer.parseInt(ranges[i]);
                    }
                    catch (NumberFormatException e) {
                        this.doc.result.addWarning(null, 1003, ranges[i]);
                        lower = 0;
                        upper = Integer.MAX_VALUE;
                    }
                }
                if (lower < minv && lower >= 0) {
                    minv = lower;
                }
                if (upper < 0) {
                    maxv = Integer.MAX_VALUE;
                }
                if (upper <= maxv) continue;
                maxv = upper;
            }
            m.minOccurs = minv;
            m.maxOccurs = maxv;
        }
        if (this.attribute && (mx = (Multiplicity)this.doc.fClassesRoseHiddenCardinality.get(this.typeInfo().id)) != null) {
            m = mx;
        }
        return m;
    }

    @Override
    public boolean isNavigable() {
        if (this.attribute) {
            return true;
        }
        return this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.isNavigable", "xmi.value").equals("true");
    }

    @Override
    public boolean isOrdered() {
        if (this.attribute) {
            return false;
        }
        return this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.ordering", "xmi.value").equals("ordered");
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean isComposition() {
        return this.attribute;
    }

    @Override
    public boolean isAggregation() {
        return this.attribute;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.doc.taggedValue(this.id, "inlineOrByReference");
        if (s == null) {
            s = "";
        }
        if (s.length() == 0) {
            s = super.inlineOrByReferenceFromEncodingRule();
        }
        return s.toLowerCase();
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = (Stereotypes)this.doc.fStereotypes.get(this.id);
        }
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String initialValue() {
        Element e;
        NodeList nl;
        String initialValue = null;
        if (this.attribute && (nl = this.prp.getElementsByTagName("Foundation.Core.Attribute.initialValue")).getLength() == 1 && (nl = (e = (Element)nl.item(0)).getElementsByTagName("Foundation.Data_Types.Expression")).getLength() == 1 && (initialValue = this.doc.textOfProperty(e = (Element)nl.item(0), "Foundation.Data_Types.Expression.body")) != null) {
            if ((initialValue = initialValue.trim()).toLowerCase().equals("true")) {
                initialValue = "true";
            } else if (initialValue.toLowerCase().equals("false")) {
                initialValue = "false";
            }
        }
        return initialValue;
    }

    public PropertyInfoXmi10(Xmi10Document d, Element e, AssociationInfoXmi10 ai) throws ShapeChangeAbortException {
        this.doc = d;
        this.prp = e;
        this.attribute = ai == null;
        this.associationInfo = ai;
        this.id = this.prp.getAttribute("xmi.id");
        String s = this.doc.taggedValue(this.id, "sequenceNumber");
        this.sequenceNumber = StringUtils.isNotBlank((String)s) ? new StructuredNumber(s) : (this.attribute ? new StructuredNumber(this.getNextNumberForAttributeWithoutExplicitSequenceNumber()) : new StructuredNumber(this.getNextNumberForAssociationRoleWithoutExplicitSequenceNumber()));
        this.doc.result.addDebug(null, 10013, "property", this.id, this.name());
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = ci;
    }

    public Vector<Constraint> constraints() {
        return new Vector<Constraint>();
    }

    @Override
    public AssociationInfo association() {
        return this.associationInfo;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty() && !this.aliasAccessed && descriptor == Descriptor.ALIAS) {
            String a;
            this.aliasAccessed = true;
            if (this.isAttribute() && (a = this.taggedValue("style")) != null && !a.isEmpty()) {
                ls.add(new LangString(this.options().internalize(a)));
                this.descriptors().put(descriptor, ls);
            }
        }
        return ls;
    }

    @Override
    public boolean isOwned() {
        return false;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 137: {
                return "Property with id '$1' and name '$2' has no type.";
            }
            case 138: {
                return "Property with id '$1' and name '$2' has a type with no name.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

