/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XsdDocument;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageInfoXmi10
extends PackageInfoImpl
implements PackageInfo,
MessageSource {
    protected Element pkg;
    protected Xmi10Document doc;
    protected String id;
    protected XsdDocument gmlASD = null;
    protected boolean processedIncludes = false;
    protected UUID uuid = null;
    protected Document defDocument = null;
    protected Document smDocument = null;

    @Override
    public Model model() {
        return this.doc;
    }

    @Override
    public Options options() {
        return this.doc.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.doc.result;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.pkg, "Foundation.Core.ModelElement.name");
        if (s == null) {
            s = this.id();
            this.doc.result.addWarning(null, 100, "package", s);
        } else {
            s = s.trim();
        }
        return s;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = (Stereotypes)this.doc.fStereotypes.get(this.id);
        }
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.doc.taggedValues(this.id());
        }
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory(0);
        }
    }

    @Override
    public PackageInfo owner() {
        String s = this.doc.idOfProperty(this.pkg, "Foundation.Core.ModelElement.namespace");
        if (s.length() == 0) {
            s = this.doc.getOwnerIdAsString(this.pkg);
        }
        return (PackageInfo)this.doc.fPackages.get(s);
    }

    @Override
    public SortedSet<String> supplierIds() {
        TreeSet<String> suppliers = new TreeSet<String>();
        Vector<String> depids = this.doc.idsOfProperty(this.pkg, "Foundation.Core.ModelElement.clientDependency");
        Iterator<String> i = depids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (e == null || !this.doc.visible(e) && !this.doc.options.eaBugFixPublicPackagesAreMarkedAsPrivate) continue;
            Vector<String> pkgids = this.doc.idsOfProperty(e, "Foundation.Core.Dependency.supplier");
            for (String sid : pkgids) {
                suppliers.add(sid);
            }
        }
        return suppliers;
    }

    public XsdDocument gmlApplicationSchemaDocument() {
        return this.gmlASD;
    }

    public PackageInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException {
        this.doc = d;
        this.pkg = e;
        this.id = this.pkg.getAttribute("xmi.id");
        this.uuid = UUID.randomUUID();
        this.doc.fUUIDs.put(this.id, this.uuid);
        this.doc.result.addDebug(this, 10001, this.id, this.name(), this.targetNamespace());
    }

    @Override
    public SortedSet<PackageInfo> containedPackages() {
        TreeSet<PackageInfo> res = new TreeSet<PackageInfo>();
        NodeList nl = this.pkg.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node n = nl.item(j);
            if (!n.getLocalName().equals("Foundation.Core.Namespace.ownedElement")) continue;
            NodeList nl2 = n.getChildNodes();
            for (int k = 0; k < nl2.getLength(); ++k) {
                Node n2 = nl2.item(k);
                if (!n2.getLocalName().equals("Model_Management.Package")) continue;
                Element e = (Element)n2;
                String xid = e.getAttribute("xmi.id");
                res.add((PackageInfo)this.doc.fPackages.get(xid));
            }
            break;
        }
        return res;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 10001: {
                return "The package with ID '$1$' and name '$2$' was created. Namespace: '$3$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

