/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.OperationInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.junit.platform.commons.util.StringUtils;
import org.w3c.dom.Element;

public class OperationInfoXmi10
extends OperationInfoImpl
implements OperationInfo,
MessageSource {
    protected Element op = null;
    protected Xmi10Document doc = null;
    protected String id = null;
    protected boolean documentationAccessed = false;

    @Override
    public Model model() {
        return this.doc;
    }

    @Override
    public Options options() {
        return this.doc.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.doc.result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = (Stereotypes)this.doc.fStereotypes.get(this.id);
        }
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.doc.taggedValues(this.id());
        }
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory(0);
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.op, "Foundation.Core.ModelElement.name");
        if (s != null) {
            s = s.trim();
        } else {
            this.doc.result.addWarning(null, 100, "operation", this.id);
            s = this.id;
        }
        return s;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty() && !this.documentationAccessed && descriptor == Descriptor.DOCUMENTATION) {
            this.documentationAccessed = true;
            String s = this.doc.taggedValue(this.id, "documentation");
            if (s == null) {
                s = this.doc.taggedValue(this.id, "description");
            }
            if (StringUtils.isNotBlank((String)s)) {
                ls.add(new LangString(this.options().internalize(s)));
                this.descriptors().put(descriptor, ls);
            }
        }
        return ls;
    }

    @Override
    public int parameterCount() {
        Vector<String> pids = this.doc.idsOfProperty(this.op, "Foundation.Core.BehavioralFeature.parameter");
        int parameterCount = 0;
        Iterator<String> i = pids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (!e.getNodeName().equals("Foundation.Core.Parameter") || !this.doc.visible(e) || !this.doc.notAReference(e)) continue;
            ++parameterCount;
        }
        return parameterCount;
    }

    private boolean returnParameter(Element e) {
        if (e == null) {
            return false;
        }
        return "return".equals(this.doc.attributeOfProperty(e, "Foundation.Core.Parameter.kind", "xmi.value"));
    }

    public TreeMap<Integer, String> parameterNames() {
        Vector<String> pids = this.doc.idsOfProperty(this.op, "Foundation.Core.BehavioralFeature.parameter");
        TreeMap<Integer, String> parameterNames = new TreeMap<Integer, String>();
        int parameterCount = 0;
        Iterator<String> i = pids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (!e.getNodeName().equals("Foundation.Core.Parameter") || !this.doc.visible(e) || !this.doc.notAReference(e)) continue;
            String s = this.doc.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (this.returnParameter(e)) {
                s = "__RETURN__";
            }
            parameterNames.put(++parameterCount, s.trim());
            this.doc.result.addDebug(this, 10011, this.id, this.name(), s);
        }
        return parameterNames;
    }

    public TreeMap<Integer, String> parameterTypes() {
        Vector<String> pids = this.doc.idsOfProperty(this.op, "Foundation.Core.BehavioralFeature.parameter");
        TreeMap<Integer, String> parameterTypes = new TreeMap<Integer, String>();
        int parameterCount = 0;
        Iterator<String> i = pids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (!e.getNodeName().equals("Foundation.Core.Parameter") || !this.doc.visible(e) || !this.doc.notAReference(e)) continue;
            String s = this.doc.idOfProperty(e, "Foundation.Core.Parameter.type");
            parameterTypes.put(++parameterCount, s.trim());
        }
        return parameterTypes;
    }

    public OperationInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException {
        this.doc = d;
        this.op = e;
        this.id = this.op.getAttribute("xmi.id");
        this.doc.result.addDebug(null, 10013, "operation", this.id, this.name());
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 10011: {
                return "The operation with ID '$1$' and name '$2$' has the following parameter: '$3$'";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

