/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TaggedValuesImpl;
import de.interactive_instruments.ShapeChange.Options;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TaggedValuesCacheMap
extends TaggedValuesImpl {
    private SortedMap<String, List<String>> tagMap = null;

    public TaggedValuesCacheMap(Options options) {
        this.tagMap = new TreeMap<String, List<String>>();
        this.options = options;
    }

    public TaggedValuesCacheMap(int size, Options options) {
        this.tagMap = new TreeMap<String, List<String>>();
        this.options = options;
    }

    public TaggedValuesCacheMap(TaggedValues original, Options options) {
        this.options = options;
        this.tagMap = original != null ? original.asMap() : new TreeMap<String, List<String>>();
    }

    public TaggedValuesCacheMap(TaggedValues original, String tagList, Options options) {
        this.options = options;
        String[] tags = tagList.split(",");
        TreeSet<String> tagsAsSet = new TreeSet<String>();
        for (String tag : tags) {
            if (tag.trim().length() == 0) continue;
            tagsAsSet.add(tag.trim());
        }
        if (original != null) {
            this.tagMap = original.asMap();
            TreeSet<String> tvsToRemove = new TreeSet<String>();
            for (String tvn : this.tagMap.keySet()) {
                if (tagsAsSet.contains(tvn)) continue;
                tvsToRemove.add(tvn);
            }
            for (String tvToRemove : tvsToRemove) {
                this.tagMap.remove(tvToRemove);
            }
        } else {
            this.tagMap = new TreeMap<String, List<String>>();
        }
    }

    @Override
    public boolean containsKey(String tag) {
        return this.tagMap.containsKey(tag);
    }

    @Override
    public String[] get(String tag) {
        List list = (List)this.tagMap.get(tag);
        return list != null ? list.toArray(new String[list.size()]) : new String[]{};
    }

    @Override
    public SortedSet<String> keySet() {
        if (this.isEmpty()) {
            return new TreeSet<String>();
        }
        return new TreeSet<String>(this.tagMap.keySet());
    }

    @Override
    public void put(String tag, String valueIn) {
        String value = valueIn == null ? "" : valueIn;
        ArrayList<String> tmp = new ArrayList<String>(1);
        tmp.add(this.options.internalize(value));
        this.put(this.options.internalize(tag), tmp);
    }

    @Override
    public void put(String tag, String[] values) {
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(values));
        this.put(tag, tmp);
    }

    @Override
    public void put(String tag, List<String> values) {
        ArrayList<String> tmp = new ArrayList<String>(values.size());
        for (String v : values) {
            String value = v == null ? "" : v;
            tmp.add(this.options.internalize(value));
        }
        this.tagMap.put(this.options.internalize(tag), tmp);
    }

    @Override
    public void add(String tag, String valueIn) {
        String value;
        String string = value = valueIn == null ? "" : valueIn;
        if (this.containsKey(tag)) {
            ((List)this.tagMap.get(tag)).add(this.options.internalize(value));
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.options.internalize(value));
            this.tagMap.put(this.options.internalize(tag), values);
        }
    }

    @Override
    public SortedMap<String, String> getFirstValues() {
        TreeMap<String, String> res = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> e : this.tagMap.entrySet()) {
            res.put(e.getKey(), e.getValue().get(0));
        }
        return res;
    }

    @Override
    public SortedMap<String, String> getFirstValues(String tagList) {
        TreeMap<String, String> res = new TreeMap<String, String>();
        if (tagList != null && !tagList.trim().isEmpty()) {
            String[] tags = tagList.split(",");
            TreeSet<String> tagsAsSet = new TreeSet<String>();
            for (String tag : tags) {
                if (tag.trim().length() == 0) continue;
                tagsAsSet.add(tag.trim());
            }
            for (Map.Entry entry : this.tagMap.entrySet()) {
                if (!tagsAsSet.contains(entry.getKey())) continue;
                res.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
        }
        return res;
    }

    @Override
    public String getFirstValue(String tag) {
        List l = (List)this.tagMap.get(tag);
        return l != null && l.size() > 0 ? (String)l.get(0) : null;
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public SortedMap<String, List<String>> asMap() {
        if (this.isEmpty()) {
            return new TreeMap<String, List<String>>();
        }
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : this.tagMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>(e.getValue().size());
            for (String v : e.getValue()) {
                values.add(this.options.internalize(v));
            }
            result.put(this.options.internalize(e.getKey()), values);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.tagMap.isEmpty();
    }

    @Override
    public void remove(String tvName) {
        if (tvName != null) {
            this.tagMap.remove(tvName);
        }
    }

    @Override
    public void remove(Set<String> tvNames) {
        if (tvNames != null) {
            for (String tvName : tvNames) {
                this.tagMap.remove(tvName);
            }
        }
    }
}

