/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TaggedValuesImpl;
import de.interactive_instruments.ShapeChange.Options;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TaggedValuesCacheArray
extends TaggedValuesImpl {
    private String[][] simpleTags = null;
    private SortedMap<String, List<String>> complexTags = null;

    public TaggedValuesCacheArray(Options options) {
        this.options = options;
    }

    public TaggedValuesCacheArray(int size, Options options) {
        this.options = options;
    }

    public TaggedValuesCacheArray(TaggedValues original, Options options) {
        this.options = options;
        if (original != null && !original.isEmpty()) {
            SortedMap<String, List<String>> tvsDeepCopy = original.asMap();
            this.initializeFields(tvsDeepCopy);
        }
    }

    public TaggedValuesCacheArray(TaggedValues original, String tagList, Options options) {
        this.options = options;
        if (original != null && !original.isEmpty()) {
            String[] tags = tagList.split(",");
            TreeSet<String> tagsAsSet = new TreeSet<String>();
            for (String tag : tags) {
                if (tag.trim().length() == 0) continue;
                tagsAsSet.add(tag.trim());
            }
            SortedMap<String, List<String>> tvsDeepCopy = original.asMap();
            TreeSet<String> tvsNotInTagList = new TreeSet<String>();
            for (String tvName : tvsDeepCopy.keySet()) {
                if (tagsAsSet.contains(tvName)) continue;
                tvsNotInTagList.add(tvName);
            }
            for (String tvToRemove : tvsNotInTagList) {
                tvsDeepCopy.remove(tvToRemove);
            }
            this.initializeFields(tvsDeepCopy);
        }
    }

    private void initializeFields(SortedMap<String, List<String>> tvsDeepCopy) {
        if (!tvsDeepCopy.isEmpty()) {
            TreeSet<String> tvsWithSingleValue = new TreeSet<String>();
            for (Map.Entry<String, List<String>> e : tvsDeepCopy.entrySet()) {
                if (e.getValue().size() != 1) continue;
                tvsWithSingleValue.add(e.getKey());
            }
            if (!tvsWithSingleValue.isEmpty()) {
                this.simpleTags = new String[2][tvsWithSingleValue.size()];
                int i = 0;
                Iterator iterator = tvsWithSingleValue.iterator();
                while (iterator.hasNext()) {
                    String tv;
                    this.simpleTags[0][i] = tv = (String)iterator.next();
                    this.simpleTags[1][i] = (String)((List)tvsDeepCopy.get(tv)).get(0);
                    ++i;
                }
                for (String tv : tvsWithSingleValue) {
                    tvsDeepCopy.remove(tv);
                }
            }
            if (!tvsDeepCopy.isEmpty()) {
                this.complexTags = tvsDeepCopy;
            }
        }
    }

    @Override
    public boolean containsKey(String tag) {
        if (this.complexTags != null && this.complexTags.containsKey(tag)) {
            return true;
        }
        if (this.simpleTags != null) {
            for (String tvName : this.simpleTags[0]) {
                if (!tvName.equals(tag)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] get(String tag) {
        if (this.complexTags != null && this.complexTags.containsKey(tag)) {
            List list = (List)this.complexTags.get(tag);
            return list.toArray(new String[list.size()]);
        }
        if (this.simpleTags != null) {
            int i = 0;
            for (String tvName : this.simpleTags[0]) {
                if (tvName.equals(tag)) {
                    return new String[]{this.simpleTags[1][i]};
                }
                ++i;
            }
        }
        return new String[0];
    }

    @Override
    public SortedSet<String> keySet() {
        TreeSet<String> result = new TreeSet<String>();
        if (!this.isEmpty()) {
            if (this.complexTags != null) {
                result.addAll(this.complexTags.keySet());
            }
            if (this.simpleTags != null) {
                for (int i = 0; i < this.simpleTags[0].length; ++i) {
                    result.add(this.simpleTags[0][i]);
                }
            }
        }
        return result;
    }

    @Override
    public void put(String tag, String[] values) {
        if (tag != null) {
            ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(values));
            this.put(tag, tmp);
        }
    }

    @Override
    public void put(String tag, List<String> values) {
        if (tag != null) {
            if (values.size() == 1) {
                this.put(tag, values.get(0));
            } else {
                this.remove(tag);
                if (this.complexTags == null) {
                    this.complexTags = new TreeMap<String, List<String>>();
                }
                ArrayList<String> tmp = new ArrayList<String>(values.size());
                for (String value : values) {
                    String val = value == null ? "" : value;
                    tmp.add(this.options.internalize(val));
                }
                this.complexTags.put(this.options.internalize(tag), tmp);
            }
        }
    }

    @Override
    public void add(String tag, String valueIn) {
        if (tag != null) {
            String value;
            String string = value = valueIn == null ? "" : valueIn;
            if (this.complexTags != null && this.complexTags.containsKey(tag)) {
                ((List)this.complexTags.get(tag)).add(this.options.internalize(value));
            } else if (this.simpleTags != null) {
                ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.simpleTags[0]));
                ArrayList<String> vals = new ArrayList<String>(Arrays.asList(this.simpleTags[1]));
                int i = keys.indexOf(tag);
                if (i > -1) {
                    ArrayList<String> multiValue = new ArrayList<String>();
                    multiValue.add(this.options.internalize((String)vals.get(i)));
                    multiValue.add(this.options.internalize(value));
                    if (this.complexTags == null) {
                        this.complexTags = new TreeMap<String, List<String>>();
                    }
                    this.complexTags.put(this.options.internalize(tag), multiValue);
                    keys.remove(i);
                    vals.remove(i);
                    if (keys.isEmpty()) {
                        this.simpleTags = null;
                    } else {
                        this.simpleTags[0] = keys.toArray(new String[keys.size()]);
                        this.simpleTags[1] = vals.toArray(new String[vals.size()]);
                    }
                } else {
                    keys.add(this.options.internalize(tag));
                    vals.add(this.options.internalize(value));
                    this.simpleTags[0] = keys.toArray(new String[keys.size()]);
                    this.simpleTags[1] = vals.toArray(new String[vals.size()]);
                }
            } else {
                this.simpleTags = new String[2][1];
                this.simpleTags[0][0] = this.options.internalize(tag);
                this.simpleTags[1][0] = this.options.internalize(value);
            }
        }
    }

    @Override
    public SortedMap<String, String> getFirstValues() {
        TreeMap<String, String> res = new TreeMap<String, String>();
        if (this.complexTags != null) {
            for (Map.Entry<String, List<String>> e : this.complexTags.entrySet()) {
                res.put(e.getKey(), e.getValue().get(0));
            }
        }
        if (this.simpleTags != null) {
            for (int i = 0; i < this.simpleTags[0].length; ++i) {
                res.put(this.simpleTags[0][i], this.simpleTags[1][i]);
            }
        }
        return res;
    }

    @Override
    public SortedMap<String, String> getFirstValues(String tagList) {
        TreeMap<String, String> res = new TreeMap<String, String>();
        if (tagList != null && !tagList.trim().isEmpty()) {
            String[] tags = tagList.split(",");
            TreeSet<String> tagsAsSet = new TreeSet<String>();
            for (String tag : tags) {
                if (tag.trim().length() == 0) continue;
                tagsAsSet.add(tag.trim());
            }
            if (this.complexTags != null) {
                for (Map.Entry entry : this.complexTags.entrySet()) {
                    if (!tagsAsSet.contains(entry.getKey())) continue;
                    res.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                }
            }
            if (this.simpleTags != null) {
                for (int i = 0; i < this.simpleTags[0].length; ++i) {
                    if (!tagsAsSet.contains(this.simpleTags[0][i])) continue;
                    res.put(this.simpleTags[0][i], this.simpleTags[1][i]);
                }
            }
        }
        return res;
    }

    @Override
    public String getFirstValue(String tag) {
        if (tag == null) {
            return null;
        }
        if (this.complexTags != null && this.complexTags.containsKey(tag)) {
            return (String)((List)this.complexTags.get(tag)).get(0);
        }
        if (this.simpleTags != null) {
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.simpleTags[0]));
            int i = keys.indexOf(tag);
            if (i > -1) {
                return this.simpleTags[1][i];
            }
            return null;
        }
        return null;
    }

    @Override
    public int size() {
        int countComplexTags = this.complexTags == null ? 0 : this.complexTags.size();
        int countSimpleTags = this.simpleTags == null ? 0 : this.simpleTags[0].length;
        return countComplexTags + countSimpleTags;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public SortedMap<String, List<String>> asMap() {
        if (this.isEmpty()) {
            return new TreeMap<String, List<String>>();
        }
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        if (this.complexTags != null) {
            for (Map.Entry<String, List<String>> e : this.complexTags.entrySet()) {
                ArrayList<String> values = new ArrayList<String>(e.getValue().size());
                for (String v : e.getValue()) {
                    values.add(this.options.internalize(v));
                }
                result.put(this.options.internalize(e.getKey()), values);
            }
        }
        if (this.simpleTags != null) {
            for (int i = 0; i < this.simpleTags[0].length; ++i) {
                ArrayList<String> values = new ArrayList<String>(1);
                values.add(this.options.internalize(this.simpleTags[1][i]));
                result.put(this.options.internalize(this.simpleTags[0][i]), values);
            }
        }
        return result;
    }

    @Override
    public void put(String tag, String valueIn) {
        if (tag != null) {
            String value;
            String string = value = valueIn == null ? "" : valueIn;
            if (this.complexTags != null && this.complexTags.containsKey(tag)) {
                this.complexTags.remove(tag);
                if (this.complexTags.isEmpty()) {
                    this.complexTags = null;
                }
                this.add(tag, value);
            } else if (this.simpleTags != null) {
                int i = Arrays.asList(this.simpleTags[0]).indexOf(tag);
                if (i > -1) {
                    this.simpleTags[1][i] = this.options.internalize(value);
                } else {
                    this.add(tag, value);
                }
            } else {
                this.add(tag, value);
            }
        }
    }

    @Override
    public void remove(String tvName) {
        if (tvName != null) {
            if (this.complexTags != null && this.complexTags.containsKey(tvName)) {
                this.complexTags.remove(tvName);
                if (this.complexTags.isEmpty()) {
                    this.complexTags = null;
                }
            } else if (this.simpleTags != null) {
                ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.simpleTags[0]));
                ArrayList<String> vals = new ArrayList<String>(Arrays.asList(this.simpleTags[1]));
                int i = keys.indexOf(tvName);
                if (i > -1) {
                    keys.remove(i);
                    vals.remove(i);
                    if (keys.isEmpty()) {
                        this.simpleTags = null;
                    } else {
                        this.simpleTags[0] = keys.toArray(new String[keys.size()]);
                        this.simpleTags[1] = vals.toArray(new String[vals.size()]);
                    }
                }
            }
        }
    }

    @Override
    public void remove(Set<String> tvNames) {
        if (tvNames != null && !tvNames.isEmpty()) {
            if (this.complexTags != null) {
                for (String tvName : tvNames) {
                    if (!this.complexTags.containsKey(tvName)) continue;
                    this.complexTags.remove(tvName);
                }
                if (this.complexTags.isEmpty()) {
                    this.complexTags = null;
                }
            }
            if (this.simpleTags != null) {
                ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.simpleTags[0]));
                ArrayList<String> vals = new ArrayList<String>(Arrays.asList(this.simpleTags[1]));
                boolean tvRemoved = false;
                for (String tvName : tvNames) {
                    int i = keys.indexOf(tvName);
                    if (i <= -1) continue;
                    keys.remove(i);
                    vals.remove(i);
                    tvRemoved = true;
                }
                if (tvRemoved) {
                    if (keys.isEmpty()) {
                        this.simpleTags = null;
                    } else {
                        this.simpleTags[0] = keys.toArray(new String[keys.size()]);
                        this.simpleTags[1] = vals.toArray(new String[vals.size()]);
                    }
                }
            }
        }
    }
}

