/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Options;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaggedValueNormalizer {
    protected static final Set<String> iso19109Tags = Stream.of("language", "definition", "description").collect(Collectors.toSet());
    protected static final Set<String> gmlTags = Stream.of("targetNamespace", "xmlns", "version", "xsdDocument", "gmlProfileSchema", "sequenceNumber", "noPropertyType", "byValuePropertyType", "isCollection", "asDictionary", "inlineOrByReference", "isMetadata", "defaultCodeSpace", "xmlSchemaType", "documentation", "resourceURI", "codeList").collect(Collectors.toSet());
    protected static final Set<String> jsonTags = Stream.of("jsonFormat", "jsonDocument", "jsonBaseURI", "jsonBaseUri", "jsonLayerTableURI", "jsonDirectory", "defaultGeometry", "jsonPattern").collect(Collectors.toSet());
    protected static final Set<String> arcgisTags = Stream.of("HasZ", "HasM", "fieldType").collect(Collectors.toSet());
    protected static final Set<String> owlTags = Stream.of("owlSubPropertyOf", "owlEquivalentProperties", "owlDisjointProperties", "owlInverseProperties", "owlLogicalCharacteristics").collect(Collectors.toSet());
    protected static final Set<String> gpkgTags = Stream.of("gpkgZ", "gpkgM").collect(Collectors.toSet());
    protected static final Set<String> sqlTags = Stream.of("sqlEncodingRule", "sqlUnique", "sqlOnUpdate", "sqlOnDelete", "sqlSchema").collect(Collectors.toSet());
    protected static final Set<String> ldp2Tags = Stream.of("ldp2EncodingRule", "ldpCodeTargetValue", "ldpFallbackValue", "ldpFeatureTitleTemplate", "defaultInstant", "defaultIntervalStart", "defaultIntervalEnd", "ldpRemove").collect(Collectors.toSet());
    protected static final Set<String> shapeChangeTags = Stream.of("xsdEncodingRule", "xsdAsAttribute", "gmlAsGroup", "length", "maxLength", "base", "rangeMinimum", "rangeMaximum", "nilReasonAllowed", "gmlImplementedByNilReason", "implementedByNilReason", "primaryCode", "oclExpressions", "alias", "gmlAsCharacterString", "gmlMixin", "nillable", "suppress", "codeListValuePattern", "codeListRepresentation", "uomResourceURI", "uomResourceValuePattern", "uomResourceRepresentation", "physicalQuantity", "recommendedMeasure", "noncomparableMeasure", "asXMLAttribute", "soft-typed", "parent", "AAA:Kennung", "AAA:Datum", "AAA:Organisation", "AAA:Modellart", "AAA:Profile", "AAA:Grunddatenbestand", "AAA:Nutzungsart", "AAA:Nutzungsartkennung", "AAA:objektbildend", "AAA:Themen", "AAA:Revisionsnummer", "AAA:Version", "AAA:AAAVersion", "reverseRoleNAS", "allowedTypesNAS", "gmlArrayProperty", "gmlListProperty", "example", "dataCaptureStatement", "legalBasis", "profiles", "name", "infoURL", "broaderListedValue", "skosConceptSchemeSubclassName", "size", "omitWhenFlattened", "maxOccurs", "isFlatTarget", "Title", "formrows", "formcols", "validate", "Reiter", "generationDateTime", "ontologyName", "alwaysVoid", "neverVoid", "appliesTo", "vocabulary", "associativeTable", "jsonEncodingRule", "status", "geometry", "oneToManyReferenceColumnName", "dissolveAssociation", "precision", "scale", "numericType", "toFeatureType", "toCodelist", "codelistType", "shortName", "codeListSource", "codeListSourceCharset", "codeListSourceRepresentation", "codeListRestriction", "arcgisDefaultSubtype", "arcgisSubtypeCode", "arcgisUsedBySubtypes", "arcgisSubtypeInitialValues", "reportable", "dissolveAssociationAttributeType", "dissolveAssociationInlineOrByReference", "extensibility", "obligation", "metadataType", "voidReasonType", "valueTypeOptions", "xsdForcedImports", "pattern", "literalEncodingType", "timeIntervalBoundaryType").collect(Collectors.toSet());
    protected HashSet<String> allowedTags = null;
    protected Options options = null;

    public TaggedValueNormalizer(Options options) {
        this.options = options;
        this.allowedTags = new HashSet(100);
        this.allowedTags.addAll(iso19109Tags);
        this.allowedTags.addAll(gmlTags);
        this.allowedTags.addAll(jsonTags);
        this.allowedTags.addAll(arcgisTags);
        this.allowedTags.addAll(owlTags);
        this.allowedTags.addAll(gpkgTags);
        this.allowedTags.addAll(sqlTags);
        this.allowedTags.addAll(ldp2Tags);
        this.allowedTags.addAll(shapeChangeTags);
        for (String s : options.parameter("representTaggedValues").split("\\,")) {
            this.allowedTags.add(s.trim());
        }
        for (String s : options.parameter("addTaggedValues").split("\\,")) {
            this.allowedTags.add(s.trim());
        }
    }

    public String normalizeTaggedValue(String tag) {
        if (tag.startsWith("RationalRose$UGAS:")) {
            tag = tag.substring(18);
        } else if (tag.startsWith("RationalRose$ShapeChange:")) {
            tag = tag.substring(25);
        } else if (tag.startsWith("RationalRose$")) {
            tag = tag.substring(13);
        } else if (tag.contains("::")) {
            tag = tag.substring(tag.lastIndexOf("::") + 2);
        }
        tag = this.options.normalizeTag(tag);
        if (tag.equals("xmlNamespace")) {
            return "targetNamespace";
        }
        if (tag.equals("xmlNamespaceAbbreviation")) {
            return "xmlns";
        }
        if (tag.equals("xsdName")) {
            return "xsdDocument";
        }
        if (tag.equals("asGroup")) {
            return "gmlAsGroup";
        }
        if (tag.equals("implementedByNilReason")) {
            return "gmlImplementedByNilReason";
        }
        if (this.options.allowAllTags() || this.allowedTags.contains(tag)) {
            return tag;
        }
        return null;
    }
}

