/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.StereotypesImpl;
import de.interactive_instruments.ShapeChange.Options;
import java.util.SortedSet;
import java.util.TreeSet;

public class StereotypesCacheSet
extends StereotypesImpl {
    private String st = null;
    private SortedSet<String> stSet = null;

    public StereotypesCacheSet(Options options) {
        this.options = options;
    }

    public StereotypesCacheSet(Stereotypes stereotypes, Options options) {
        this.options = options;
        if (stereotypes != null && !stereotypes.isEmpty()) {
            for (String s : stereotypes.asArray()) {
                this.add(s);
            }
        }
    }

    @Override
    public int size() {
        if (this.st == null && this.stSet == null) {
            return 0;
        }
        if (this.st != null) {
            return 1;
        }
        return this.stSet.size();
    }

    @Override
    public boolean contains(String stereotype) {
        if (this.st != null) {
            return this.st.equals(stereotype);
        }
        if (this.stSet != null) {
            return this.stSet.contains(stereotype);
        }
        return false;
    }

    @Override
    public String[] asArray() {
        String[] result;
        if (this.st != null) {
            result = new String[]{this.st};
        } else if (this.stSet != null) {
            result = this.stSet.toArray(new String[this.stSet.size()]);
        } else {
            return new String[0];
        }
        return result;
    }

    @Override
    public SortedSet<String> asSet() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.st != null) {
            result.add(this.st);
        } else if (this.stSet != null) {
            result.addAll(this.stSet);
        }
        return result;
    }

    @Override
    public void add(String stereotype) {
        if (stereotype == null || stereotype.trim().length() == 0) {
            return;
        }
        if (this.st == null && this.stSet == null) {
            this.st = this.options.internalize(stereotype);
        } else {
            if (this.st != null) {
                this.stSet = new TreeSet<String>();
                this.stSet.add(this.options.internalize(this.st));
                this.st = null;
            }
            this.stSet.add(this.options.internalize(stereotype));
        }
    }

    @Override
    public void remove(String stereotype) {
        if (stereotype != null && stereotype.trim().length() != 0 && (this.st != null || this.stSet != null)) {
            if (this.st != null) {
                if (this.st.equals(stereotype)) {
                    this.st = null;
                }
            } else if (this.stSet.remove(stereotype) && this.stSet.size() == 1) {
                this.st = this.stSet.first();
                this.stSet = null;
            }
        }
    }

    @Override
    public String getOne() {
        if (this.st != null) {
            return this.st;
        }
        if (this.stSet != null && !this.stSet.isEmpty()) {
            return (String)this.stSet.iterator().next();
        }
        return "";
    }
}

