/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;
import java.util.Set;

public class StereotypeNormalizer {
    public static Stereotypes normalizeAndMapToWellKnownStereotype(String[] stereotypes, Info infoObject) {
        Options options = infoObject.options();
        ShapeChangeResult result = infoObject.result();
        result.addDebug(null, 50, infoObject.name(), String.join((CharSequence)", ", stereotypes));
        Stereotypes resultingStereotypes = options.stereotypesFactory();
        for (String stereotype : stereotypes) {
            String normalizedStereotype = options.normalizeStereotype(stereotype.trim());
            result.addDebug(null, 51, infoObject.name(), stereotype, normalizedStereotype);
            Set<String> wellKnownStereotypes = infoObject instanceof PropertyInfo ? Options.propertyStereotypes : (infoObject instanceof ClassInfo ? Options.classStereotypes : (infoObject instanceof PackageInfo ? Options.packageStereotypes : (infoObject instanceof AssociationInfo ? Options.assocStereotypes : new HashSet<String>())));
            String s = normalizedStereotype.toLowerCase();
            if (wellKnownStereotypes.contains(s)) {
                resultingStereotypes.add(s);
                result.addDebug(null, 52, infoObject.name(), s);
                continue;
            }
            if (options.allowAllStereotypes()) {
                resultingStereotypes.add(normalizedStereotype);
                result.addDebug(null, 56, infoObject.name(), normalizedStereotype);
                continue;
            }
            if (options.addedStereotypes().contains(normalizedStereotype)) {
                resultingStereotypes.add(normalizedStereotype);
                result.addDebug(null, 57, infoObject.name(), normalizedStereotype);
                continue;
            }
            result.addDebug(null, 53, infoObject.name(), normalizedStereotype);
        }
        result.addDebug(null, 54, infoObject.name(), Integer.toString(resultingStereotypes.size()), resultingStereotypes.toString());
        return resultingStereotypes;
    }
}

