/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.utils.XMLChar;

public abstract class PropertyInfoImpl
extends InfoImpl
implements PropertyInfo {
    protected Vector<Qualifier> qualifiers = null;
    protected boolean restriction = false;
    protected Boolean implementedByNilReason = null;
    protected Profiles profiles = null;
    private static int globalSequenceNumberForAttributes = -1073741824;
    private static int globalSequenceNumberForAssociationRoles = -536870912;
    protected boolean nilReasonAllowed = false;

    @Override
    public int getNextNumberForAttributeWithoutExplicitSequenceNumber() {
        return globalSequenceNumberForAttributes++;
    }

    @Override
    public int getNextNumberForAssociationRoleWithoutExplicitSequenceNumber() {
        return globalSequenceNumberForAssociationRoles++;
    }

    @Override
    public boolean isRestriction() {
        return this.restriction;
    }

    @Override
    public String language() {
        String lang = this.taggedValue("language");
        if (StringUtils.isBlank((CharSequence)lang)) {
            ClassInfo ci = this.inClass();
            if (ci != null) {
                return ci.language();
            }
        } else {
            return lang;
        }
        return null;
    }

    @Override
    public String encodingRule(String platform) {
        String s = this.taggedValue(platform + "EncodingRule");
        s = s == null || s.isEmpty() || this.options().ignoreEncodingRuleTaggedValues() ? this.inClass().encodingRule(platform) : s.toLowerCase();
        return s;
    }

    @Override
    public boolean isMetadata() {
        String s = this.taggedValue("isMetadata");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public String defaultCodeSpace() {
        String s = this.taggedValue("defaultCodeSpace");
        return s != null ? s : "";
    }

    @Override
    public String qname() {
        String s = this.inClass().pkg().xmlns();
        return s + ":" + this.name();
    }

    @Override
    public boolean implementedByNilReason() {
        if (this.implementedByNilReason == null) {
            String s = this.taggedValue("gmlImplementedByNilReason");
            this.implementedByNilReason = s != null && s.toLowerCase().equals("true") ? Boolean.valueOf(true) : (this.inClass().category() == 8 && this.inClass().properties().size() == 2 && this.name().equalsIgnoreCase("reason") && this.inClass().name().endsWith("Reason") ? Boolean.valueOf(true) : (this.options().isAIXM() && (this.inClass().category() == 1 || this.inClass().category() == 6 || this.inClass().category() == 16) ? Boolean.valueOf(true) : Boolean.valueOf(false)));
        }
        return this.implementedByNilReason;
    }

    @Override
    public boolean nilReasonAllowed() {
        String s = this.taggedValue("nilReasonAllowed");
        if (s != null && s.toLowerCase().equals("true")) {
            return true;
        }
        return this.nilReasonAllowed;
    }

    @Override
    public void nilReasonAllowed(boolean b) {
        this.nilReasonAllowed = b;
    }

    @Override
    public String fullName() {
        ClassInfo ci = this.inClass();
        if (ci == null) {
            return "<unknown>::" + this.name();
        }
        return ci.fullName() + "::" + this.name();
    }

    @Override
    public String fullNameInSchema() {
        ClassInfo ci = this.inClass();
        if (ci == null) {
            return "<unknown>::" + this.name();
        }
        return ci.fullNameInSchema() + "::" + this.name();
    }

    @Override
    public int categoryOfValue() {
        ClassInfo ci = this.model().classById(this.typeInfo().id);
        if (ci != null) {
            return ci.category();
        }
        return -1;
    }

    @Override
    public void postprocessAfterLoadingAndValidate() {
        if (this.postprocessed) {
            return;
        }
        super.postprocessAfterLoadingAndValidate();
        if (this.inClass().category() != 7 && this.inClass().category() != 3 && this.inClass().category() != 2) {
            ShapeChangeResult.MessageContext mc;
            ShapeChangeResult.MessageContext messageContext;
            MapEntry me;
            ShapeChangeResult.MessageContext mc3;
            String s;
            if (this.matches("req-xsd-prop-ncname") && !XMLChar.isValidNCName((String)(s = this.name())) && (mc3 = this.result().addError(null, 149, "property", s)) != null) {
                mc3.addDetail(null, 400, "Property", this.fullName());
            }
            if (this.matches("req-all-all-documentation")) {
                ShapeChangeResult.MessageContext mc2;
                s = this.documentation();
                if (!s.contains(this.options().nameSeparator()) && (mc2 = this.result().addError(null, 153, this.name(), this.options().nameSeparator())) != null) {
                    mc2.addDetail(null, 400, "Property", this.fullName());
                }
                if (!s.contains(this.options().definitionSeparator()) && (mc2 = this.result().addError(null, 153, this.name(), this.options().definitionSeparator())) != null) {
                    mc2.addDetail(null, 400, "Property", this.fullName());
                }
            }
            ClassInfo ci = this.model().classById(this.typeInfo().id);
            String pn = this.name();
            int basecat = this.inClass().category();
            if (this.matches("req-all-prop-sequenceNumber") && basecat != 3 && basecat != 2) {
                for (PackageInfo packageInfo : this.model().selectedSchemas()) {
                    ShapeChangeResult.MessageContext mc4;
                    if (!this.inClass().inSchema(packageInfo)) continue;
                    String sn = this.taggedValue("sequenceNumber");
                    if (sn != null && sn.length() != 0 || (mc4 = this.result().addError(null, 168, this.name(), this.inClass().name())) == null) break;
                    mc4.addDetail(null, 400, "Property", this.fullName());
                    break;
                }
            }
            if (this.matches("req-xsd-prop-value-type-exists") && ci == null && basecat != 3 && basecat != 2 && (me = this.options().typeMapEntry(this.typeInfo().name, this.encodingRule("xsd"))) == null && (messageContext = this.result().addWarning(null, 131, this.inClass().name() + "." + pn, this.typeInfo().name)) != null) {
                messageContext.addDetail(null, 400, "Property", this.fullName());
            }
            if (this.matches("req-xsd-prop-codelist-obligation") && ci != null && ci.category() == 2) {
                s = ci.taggedValue("vocabulary");
                String s2 = this.taggedValue("obligation");
                if (StringUtils.isNotBlank((CharSequence)s2) && !s2.equalsIgnoreCase("implementingRule") && !s2.equalsIgnoreCase("technicalGuidance")) {
                    mc = this.result().addError(null, 203, "obligation", this.inClass().name() + "." + pn, s2);
                    if (mc != null) {
                        mc.addDetail(null, 400, "Property", this.fullName());
                    }
                } else if (StringUtils.isNotBlank((CharSequence)s2) && StringUtils.isBlank((CharSequence)s) && (mc = this.result().addError(null, 203, "obligation", this.inClass().name() + "." + pn, s2)) != null) {
                    mc.addDetail(null, 400, "Property", this.fullName());
                }
                s = this.taggedValue("extendableMyMS");
                if (StringUtils.isNotBlank((CharSequence)s) && (mc = this.result().addError(null, 204, "extendableMyMS", this.inClass().name() + "." + pn)) != null) {
                    mc.addDetail(null, 400, "Property", this.fullName());
                }
            }
            if (this.matches("req-xsd-prop-data-type") && ci != null && (ci.category() == 5 || ci.category() == 8) && !this.isComposition() && !this.isAttribute() && this.isNavigable() && (mc = this.result().addError(null, 148, this.inClass().name(), this.name(), ci.name())) != null) {
                mc.addDetail(null, 400, "Property", this.fullName());
            }
        }
        this.postprocessed = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.initialValue() != null && !this.initialValue().isEmpty() && (this.initialValue().indexOf("{frozen}") > 0 || this.initialValue().indexOf("{readOnly}") > 0);
    }

    @Override
    public Qualifier qualifier(String name) {
        if (this.qualifiers == null) {
            return null;
        }
        for (Qualifier q : this.qualifiers) {
            if (!q.name.equals(name)) continue;
            return q;
        }
        return null;
    }

    public Vector<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    public String inlineOrByReferenceFromEncodingRule() {
        String s = "";
        if (this.options().isAIXM()) {
            if (this.categoryOfValue() == 1) {
                s = "byreference";
            } else if (this.categoryOfValue() == 6) {
                s = "inline";
            }
        }
        return s;
    }

    @Override
    public boolean voidable() {
        String s;
        this.validateStereotypesCache();
        boolean res = this.stereotypesCache.contains("voidable");
        if (!res && (s = this.taggedValue("nillable")) != null) {
            res = s.equalsIgnoreCase("true");
        }
        return res;
    }

    @Override
    public boolean propertyMetadata() {
        this.validateStereotypesCache();
        return this.stereotypesCache.contains("propertymetadata");
    }

    @Override
    public ClassInfo propertyMetadataType() {
        ClassInfo result = null;
        String mt = this.taggedValue("metadataType");
        if (StringUtils.isNotBlank((CharSequence)mt)) {
            String className = mt.trim();
            if (className.contains(":")) {
                result = this.model().classByFullNameInSchema(className);
            } else {
                PackageInfo schemaPkg = this.model().schemaPackage(this.inClass());
                if (schemaPkg != null) {
                    result = this.model().classes(schemaPkg).stream().filter(ci -> ci.name().equals(className)).findFirst().orElse(null);
                }
            }
        }
        return result;
    }

    @Override
    public PropertyInfo reverseProperty() {
        if (this.isAttribute() || this.association() == null) {
            return null;
        }
        AssociationInfo assoc = this.association();
        if (assoc.end1() == this) {
            return assoc.end2();
        }
        return assoc.end1();
    }

    @Override
    public Profiles profiles() {
        if (this.profiles == null) {
            String profilesTV = this.taggedValue("profiles");
            if (StringUtils.isBlank((CharSequence)profilesTV)) {
                this.profiles = new Profiles();
            } else {
                try {
                    Profiles tmp;
                    this.profiles = tmp = Profiles.parse(profilesTV, false);
                }
                catch (MalformedProfileIdentifierException e) {
                    ShapeChangeResult.MessageContext mc = this.result().addWarning(null, 20201);
                    if (mc != null) {
                        mc.addDetail(null, 20216, this.fullNameInSchema());
                        mc.addDetail(null, 20217, e.getMessage());
                        mc.addDetail(null, 20218, profilesTV);
                    }
                    this.profiles = new Profiles();
                }
            }
        }
        return this.profiles;
    }

    @Override
    public ClassInfo typeClass() {
        return this.model().classByIdOrName(this.typeInfo());
    }
}

