/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.junit.platform.commons.util.StringUtils;

public abstract class PackageInfoImpl
extends InfoImpl
implements PackageInfo {
    protected List<ImageMetadata> diagrams = null;

    @Override
    public String language() {
        String lang = this.taggedValue("language");
        if (StringUtils.isBlank((String)lang)) {
            if (this.isSchema()) {
                return null;
            }
            PackageInfo pi = this.owner();
            if (pi != null) {
                return pi.language();
            }
        } else {
            return lang;
        }
        return null;
    }

    @Override
    public String encodingRule(String platform) {
        String s;
        if (this.options().ignoreEncodingRuleTaggedValues()) {
            s = super.encodingRule(platform);
        } else {
            s = this.taggedValue(platform + "EncodingRule");
            if (s == null || s.isEmpty()) {
                PackageInfo o = this.owner();
                if (o != null) {
                    s = o.encodingRule(platform);
                }
                if (s == null) {
                    s = super.encodingRule(platform);
                }
            }
        }
        if (s != null) {
            s = s.toLowerCase();
        }
        return s;
    }

    @Override
    public String targetNamespace() {
        PackageInfo o;
        String s = this.options().nsOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.targetNamespace();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String xmlns() {
        PackageInfo o;
        String s = this.options().nsabrOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("xmlns");
        if (s == null) {
            s = this.taggedValue("xmlNamespaceAbbreviation");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.xmlns();
        }
        if (s != null) {
            s = s.trim();
            s = s.replace(":", "").replace("/", "");
        }
        return s;
    }

    @Override
    public String xsdDocument() {
        Object s = this.options().xsdOfPackage(this.name());
        if (s != null) {
            s = ((String)s).trim();
            return s;
        }
        s = this.taggedValue("xsdDocument");
        if (s == null) {
            s = this.taggedValue("xsdName");
        }
        if (s == null && this.isAppSchema()) {
            String name = this.name();
            StringBuffer str = new StringBuffer();
            int len = name != null ? name.length() : 0;
            block3: for (int i = 0; i < len; ++i) {
                char ch = name.charAt(i);
                switch (ch) {
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        str.append(ch);
                    }
                }
            }
            s = str.toString() + ".xsd";
            this.result().addWarning(null, 101, this.name(), this.id(), (String)s);
        }
        if (s != null) {
            s = ((String)s).trim();
        }
        return s;
    }

    @Override
    public SortedSet<PackageInfo> containedPackagesInSameTargetNamespace() {
        TreeSet<PackageInfo> result = new TreeSet<PackageInfo>();
        if (this.containedPackages() != null) {
            for (PackageInfo childPkg : this.containedPackages()) {
                if ((this.targetNamespace() != null || childPkg.targetNamespace() != null) && !this.targetNamespace().equals(childPkg.targetNamespace())) continue;
                result.add(childPkg);
                result.addAll(childPkg.containedPackagesInSameTargetNamespace());
            }
        }
        return result;
    }

    @Override
    public String gmlProfileSchema() {
        return this.taggedValue("gmlProfileSchema");
    }

    @Override
    public String version() {
        String s = this.options().versionOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("version");
        PackageInfo o = this.owner();
        if (s == null && o != null) {
            s = o.version();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public boolean isAppSchema() {
        return this.stereotype("application schema") || this.stereotype("schema");
    }

    @Override
    public boolean isSchema() {
        String s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s != null) {
            return true;
        }
        return this.options().nsOfPackage(this.name()) != null;
    }

    @Override
    public String schemaId() {
        if (this.isSchema()) {
            return this.id();
        }
        PackageInfo o = this.owner();
        if (o != null) {
            return o.schemaId();
        }
        return "(null)";
    }

    @Override
    public String fullName() {
        Object qualname = null;
        for (PackageInfo pi = this; pi != null; pi = pi.owner()) {
            qualname = qualname == null ? pi.name() : pi.name() + "::" + (String)qualname;
        }
        return qualname;
    }

    @Override
    public String fullNameInSchema() {
        if (this.targetNamespace() == null) {
            return this.fullName();
        }
        Object qualname = this.name();
        for (PackageInfo pi = this.owner(); pi != null && pi.targetNamespace() != null && pi.targetNamespace().equals(this.targetNamespace()); pi = pi.owner()) {
            qualname = pi.name() + "::" + (String)qualname;
        }
        return qualname;
    }

    @Override
    public void postprocessAfterLoadingAndValidate() {
        Object mc;
        String s;
        if (this.postprocessed) {
            return;
        }
        super.postprocessAfterLoadingAndValidate();
        if (this.matches("req-xsd-pkg-targetNamespace")) {
            s = this.taggedValue("targetNamespace");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "targetNamespace")) != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme")) {
                mc = this.result().addError(null, 150, this.name(), "targetNamespace", s);
                if (mc != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (this.matches("req-xsd-pkg-namespace-schema-only") && !this.isAppSchema() && (mc = this.result().addError(null, 147, this.name(), "targetNamespace")) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-xmlns") && this.isAppSchema()) {
            s = this.taggedValue("xmlns");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "xmlns")) != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme")) {
                mc = this.result().addError(null, 150, this.name(), "xmlns", s);
                if (mc != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (this.matches("req-xsd-pkg-namespace-schema-only") && !this.isAppSchema() && (mc = this.result().addError(null, 147, this.name(), "xmlns")) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-xsdDocument") && this.isAppSchema()) {
            s = this.taggedValue("xsdDocument");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "xsdDocument")) != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme") && (mc = this.result().addError(null, 150, this.name(), "xsdDocument", s)) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("rec-xsd-pkg-version")) {
            s = this.taggedValue("version");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addWarning(null, 146, this.name(), "version")) != null) {
                    ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme") && (mc = this.result().addWarning(null, 150, this.name(), "version", s)) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-all-all-documentation")) {
            s = this.documentation();
            if (!s.contains(this.options().nameSeparator()) && (mc = this.result().addError(null, 151, this.name(), this.options().nameSeparator())) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
            if (!s.contains(this.options().definitionSeparator()) && (mc = this.result().addError(null, 151, this.name(), this.options().definitionSeparator())) != null) {
                ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-dependencies")) {
            mc = this.supplierIds().iterator();
            while (mc.hasNext()) {
                ShapeChangeResult.MessageContext mc2;
                PackageInfo pi;
                ShapeChangeResult.MessageContext mc3;
                String pid = (String)mc.next();
                if (!this.isSchema() && (mc3 = this.result().addError(null, 159, this.name())) != null) {
                    mc3.addDetail(null, 400, "Package", this.fullName());
                }
                if ((pi = this.model().packageById(pid)) == null) {
                    mc2 = this.result().addError(null, 161, "Package", pid);
                    if (mc2 == null) continue;
                    mc2.addDetail(null, 400, "Package", this.fullName());
                    continue;
                }
                if (pi.isSchema() || (mc2 = this.result().addError(null, 160, pi.name(), this.name())) == null) continue;
                mc2.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if ((s = this.xsdDocument()) != null && !s.isEmpty() && !s.endsWith(".xsd") && (mc = this.result().addWarning(null, 167, this.xsdDocument())) != null) {
            ((ShapeChangeResult.MessageContext)mc).addDetail(null, 400, "Package", this.fullName());
        }
        this.postprocessed = true;
    }

    @Override
    public List<ImageMetadata> getDiagrams() {
        return this.diagrams;
    }

    @Override
    public void setDiagrams(List<ImageMetadata> diagrams) {
        this.diagrams = diagrams;
    }

    @Override
    public SortedSet<ClassInfo> containedClasses() {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        SortedSet<ClassInfo> classes = this.model().classes(this);
        for (ClassInfo ci : classes) {
            if (ci.pkg() != this) continue;
            result.add(ci);
        }
        return result;
    }

    @Override
    public PackageInfo rootPackage() {
        PackageInfo pi;
        for (pi = this; pi != null && !pi.isSchema(); pi = pi.owner()) {
        }
        return pi;
    }
}

