/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.SBVR.Sbvr2FolParser;
import de.interactive_instruments.ShapeChange.SBVR.SbvrRuleLoader;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ModelImpl
implements Model {
    protected boolean postprocessed = false;
    HashSet<String> xsdDocNames;
    HashSet<String> classNames;

    @Override
    public void postprocessAfterLoadingAndValidate() {
        if (this.postprocessed) {
            return;
        }
        if (this.options().constraintLoadingEnabled()) {
            this.postprocessFolConstraints();
        }
        this.xsdDocNames = new HashSet();
        this.classNames = new HashSet();
        Options options = this.options();
        for (PackageInfo pi : this.schemas("")) {
            if (options.skipSchema(pi)) continue;
            this.classNames.clear();
            this.postprocessPackage(pi, true);
        }
        this.postprocessed = true;
    }

    private void postprocessFolConstraints() {
        Sbvr2FolParser sbvrParser = new Sbvr2FolParser(this);
        for (PackageInfo pi : this.schemas("")) {
            if (this.options().skipSchema(pi)) continue;
            for (ClassInfo ci : this.classes(pi)) {
                List<Constraint> cons = ci.directConstraints();
                Collections.sort(cons, new Comparator<Constraint>(){

                    @Override
                    public int compare(Constraint o1, Constraint o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                for (Constraint con : cons) {
                    if (!(con instanceof FolConstraint)) continue;
                    FolConstraint folCon = (FolConstraint)con;
                    if (folCon.sourceType().equals("SBVR")) {
                        folCon.mergeComments(new String[]{folCon.text()});
                        FolExpression folExpr = sbvrParser.parse(folCon);
                        if (folExpr == null) continue;
                        folCon.setFolExpression(folExpr);
                        continue;
                    }
                    ShapeChangeResult.MessageContext ctx = this.result().addError(null, 38, folCon.sourceType());
                    ctx.addDetail(null, 39, folCon.name(), folCon.contextModelElmt().fullNameInSchema());
                }
            }
        }
    }

    @Override
    public SortedSet<AssociationInfo> associations() {
        TreeSet<AssociationInfo> result = new TreeSet<AssociationInfo>();
        for (ClassInfo cls : this.classes()) {
            for (PropertyInfo pi : cls.properties().values()) {
                if (pi.association() == null) continue;
                result.add(pi.association());
            }
        }
        return result;
    }

    @Override
    public void loadInformationFromExternalSources(boolean isLoadingInputModel) {
        String sbvrFileLocation;
        if (this.postprocessed) {
            return;
        }
        Options options = this.options();
        ShapeChangeResult result = this.result();
        if (isLoadingInputModel && (sbvrFileLocation = this.options().parameter("constraintExcelFile")) != null) {
            SbvrRuleLoader sbvrLoader = new SbvrRuleLoader(sbvrFileLocation, options, result, this);
            for (PackageInfo pi : this.selectedSchemas()) {
                sbvrLoader.loadSBVRRulesAsConstraints(pi);
            }
        }
    }

    public SortedSet<PackageInfo> selectedSchemas() {
        TreeSet<PackageInfo> res = new TreeSet<PackageInfo>();
        Options options = this.options();
        for (PackageInfo pi : this.schemas("")) {
            if (options.skipSchema(pi)) continue;
            res.add(pi);
        }
        return res;
    }

    @Override
    public SortedSet<? extends ClassInfo> selectedSchemaClasses() {
        TreeSet<ClassInfo> res = new TreeSet<ClassInfo>();
        for (PackageInfo selectedSchema : this.selectedSchemas()) {
            SortedSet<ClassInfo> cisOfSelectedSchema = this.classes(selectedSchema);
            for (ClassInfo ci : cisOfSelectedSchema) {
                res.add(ci);
            }
        }
        return res;
    }

    @Override
    public SortedSet<? extends PropertyInfo> selectedSchemaProperties() {
        SortedSet<? extends ClassInfo> selCis = this.selectedSchemaClasses();
        TreeSet<PropertyInfo> res = new TreeSet<PropertyInfo>();
        for (ClassInfo classInfo : selCis) {
            for (PropertyInfo pi : classInfo.properties().values()) {
                res.add(pi);
            }
        }
        return res;
    }

    @Override
    public SortedSet<ClassInfo> classes() {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        SortedSet<PackageInfo> packages = this.packages();
        for (PackageInfo pkg : packages) {
            result.addAll(pkg.containedClasses());
        }
        return result;
    }

    @Override
    public SortedSet<PropertyInfo> properties() {
        TreeSet<PropertyInfo> result = new TreeSet<PropertyInfo>();
        SortedSet<ClassInfo> classes = this.classes();
        for (ClassInfo cls : classes) {
            result.addAll(cls.properties().values());
        }
        return result;
    }

    @Override
    public PropertyInfo propertyByFullNameInSchema(String fullNameInSchema) {
        for (PropertyInfo pi : this.properties()) {
            if (!pi.fullNameInSchema().equals(fullNameInSchema)) continue;
            return pi;
        }
        return null;
    }

    @Override
    public ClassInfo classByFullNameInSchema(String fullNameInSchema) {
        for (ClassInfo ci : this.classes()) {
            if (!ci.fullNameInSchema().equals(fullNameInSchema)) continue;
            return ci;
        }
        return null;
    }

    @Override
    public SortedSet<PackageInfo> allPackagesFromSelectedSchemas() {
        TreeSet<PackageInfo> result = new TreeSet<PackageInfo>();
        for (PackageInfo selSchema : this.selectedSchemas()) {
            result.add(selSchema);
            result.addAll(selSchema.containedPackagesInSameTargetNamespace());
        }
        return result;
    }

    private void postprocessPackage(PackageInfo pi, boolean processClasses) {
        String xsdDocName;
        if (pi == null) {
            return;
        }
        pi.postprocessAfterLoadingAndValidate();
        if (pi.matches("req-xsd-pkg-xsdDocument-unique") && (xsdDocName = pi.xsdDocument()) != null && !xsdDocName.trim().isEmpty()) {
            if (this.xsdDocNames.contains(xsdDocName)) {
                ShapeChangeResult.MessageContext mc = this.result().addError(null, 162, xsdDocName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", pi.fullName());
                }
            } else {
                this.xsdDocNames.add(xsdDocName);
            }
        }
        if (processClasses) {
            for (ClassInfo ci : this.classes(pi)) {
                this.postprocessClass(ci);
            }
        }
        for (PackageInfo pi2 : pi.containedPackages()) {
            if (pi2.isSchema()) continue;
            this.postprocessPackage(pi2, false);
        }
    }

    private void postprocessClass(ClassInfo ci) {
        if (ci == null) {
            return;
        }
        ci.postprocessAfterLoadingAndValidate();
        if (ci.matches("req-xsd-cls-name-unique")) {
            String className = ci.name();
            if (this.classNames.contains(className)) {
                ShapeChangeResult.MessageContext mc = this.result().addError(null, 163, className, ci.pkg().targetNamespace());
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", ci.fullName());
                }
            } else {
                this.classNames.add(className);
            }
        }
        for (PropertyInfo propi : ci.properties().values()) {
            this.postprocessProperty(propi);
        }
    }

    private void postprocessProperty(PropertyInfo propi) {
        if (propi == null) {
            return;
        }
        propi.postprocessAfterLoadingAndValidate();
        if (!propi.isAttribute()) {
            this.postprocessAssociation(propi.association());
        }
    }

    private void postprocessAssociation(AssociationInfo ai) {
        if (ai == null) {
            return;
        }
        ai.postprocessAfterLoadingAndValidate();
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileNameOrConnectionString, String user, String pwd) throws ShapeChangeAbortException {
        throw new ShapeChangeAbortException("Initialization of repository with username and password not supported for this type of input model.");
    }

    @Override
    public boolean isInSelectedSchemas(ClassInfo ci) {
        SortedSet<PackageInfo> selectedSchemas = this.selectedSchemas();
        if (selectedSchemas == null || selectedSchemas.isEmpty()) {
            return false;
        }
        for (PackageInfo selectedSchema : selectedSchemas) {
            if (!ci.inSchema(selectedSchema)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PackageInfo schemaPackage(ClassInfo ci) {
        PackageInfo p = ci.pkg();
        do {
            if (!p.isSchema() && !p.isAppSchema()) continue;
            return p;
        } while ((p = p.owner()) != null);
        return null;
    }

    @Override
    public SortedSet<PackageInfo> packages(PackageInfo pkg) {
        TreeSet<PackageInfo> result = new TreeSet<PackageInfo>();
        if (pkg.targetNamespace() != null) {
            SortedSet<PackageInfo> allPackages = this.packages();
            for (PackageInfo pi : allPackages) {
                if (pi.targetNamespace() == null || !pi.targetNamespace().equals(pkg.targetNamespace())) continue;
                result.add(pi);
            }
        }
        return result;
    }

    @Override
    public SortedSet<PackageInfo> schemas(String name) {
        TreeSet<PackageInfo> res = new TreeSet<PackageInfo>();
        for (PackageInfo pi : this.packages()) {
            if (!pi.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (!pi.name().equals(name)) continue;
                res.add(pi);
                continue;
            }
            res.add(pi);
        }
        return res;
    }

    @Override
    public ClassInfo classByIdOrName(Type typeInfo) {
        if (typeInfo == null) {
            return null;
        }
        ClassInfo result = this.classById(typeInfo.id);
        if (result == null) {
            result = this.classByName(typeInfo.name);
        }
        return result;
    }

    @Override
    public Type typeByName(String typeName) {
        ClassInfo ci = this.classByName(typeName);
        Type typeInfo = new Type();
        typeInfo.name = typeName;
        typeInfo.id = ci != null ? ci.id() : "UNKNOWN";
        return typeInfo;
    }

    @Override
    public String descriptorSource(Descriptor descriptor) {
        Object source = this.options().descriptorSource(descriptor.getName());
        if (source == null) {
            source = "tag#" + descriptor;
        }
        return source;
    }

    @Override
    public PropertyInfo lookupNonNavigableAssociationRole(SortedSet<ClassInfo> classes, String roleName) {
        for (AssociationInfo ai : this.associations()) {
            for (ClassInfo classAtOneEnd : classes) {
                if (roleName.equals(ai.end1().name()) && classAtOneEnd == ai.end1().inClass()) {
                    return ai.end1();
                }
                if (!roleName.equals(ai.end2().name()) || classAtOneEnd != ai.end2().inClass()) continue;
                return ai.end2();
            }
        }
        return null;
    }
}

