/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangString
implements Comparable<LangString> {
    private static final Pattern langPattern = Pattern.compile("^\"(.*)\"@([a-zA-Z0-9\\-]{2,})$");
    private String value = null;
    private String lang = null;

    public static LangString parse(String string) {
        Matcher m = langPattern.matcher(string);
        if (m.matches()) {
            String text = m.group(1);
            String lang = m.group(2);
            return new LangString(text, lang);
        }
        return new LangString(string);
    }

    public static List<LangString> parse(String[] strings) {
        ArrayList<LangString> result = new ArrayList<LangString>();
        if (strings != null && strings.length != 0) {
            for (String s : strings) {
                if (s == null) continue;
                result.add(LangString.parse(s));
            }
        }
        return result;
    }

    public LangString(String value, String lang) {
        if (value != null) {
            this.value = value.intern();
        }
        if (lang != null) {
            this.lang = lang.intern();
        }
    }

    public LangString(String value) {
        if (value != null) {
            this.value = value.intern();
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value != null ? value.intern() : value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang != null ? lang.intern() : lang;
    }

    public boolean hasLang() {
        return this.lang != null && this.lang.length() > 0;
    }

    public boolean hasValue() {
        return this.getValue() != null && this.getValue().length() > 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.hasLang()) {
            result.append("\"");
        }
        result.append(this.value);
        if (this.hasLang()) {
            result.append("\"@");
            result.append(this.lang);
        }
        return result.toString();
    }

    public void appendSuffix(String s) {
        this.value = this.value + s;
    }

    @Override
    public int compareTo(LangString other) {
        if (!this.hasLang() && other.hasLang()) {
            return -1;
        }
        if (this.hasLang() && !other.hasLang()) {
            return 1;
        }
        if (this.hasLang() && other.hasLang() && this.getLang().compareTo(other.getLang()) != 0) {
            return this.getLang().compareTo(other.getLang());
        }
        if (!this.hasValue() && !other.hasValue()) {
            return 0;
        }
        if (!this.hasValue() && other.hasValue()) {
            return -1;
        }
        if (this.hasValue() && !other.hasValue()) {
            return 1;
        }
        return this.getValue().compareTo(other.getValue());
    }
}

