/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TargetRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class InfoImpl
implements Info {
    boolean postprocessed = false;
    private String lf = System.getProperty("line.separator");
    protected Descriptors descriptors = null;
    protected TaggedValues taggedValuesCache = null;
    protected Stereotypes stereotypesCache = null;
    private static final Pattern langPattern = Pattern.compile("^\"(.*)\"@([a-zA-Z0-9\\-]{2,})$");

    @Override
    public int compareTo(Info i) {
        String my = this.id();
        String other = i.id();
        return my.compareTo(other);
    }

    @Override
    public Stereotypes stereotypes() {
        this.validateStereotypesCache();
        return this.options().stereotypesFactory(this.stereotypesCache);
    }

    @Override
    public boolean stereotype(String stereotype) {
        Stereotypes stereotypes = this.stereotypes();
        String st = stereotype != null ? this.model().options().normalizeStereotype(stereotype) : "";
        for (String s : stereotypes.asArray()) {
            String sn = this.model().options().normalizeStereotype(s);
            if (!sn.equalsIgnoreCase(st)) continue;
            return true;
        }
        return st.isEmpty() && stereotypes.isEmpty();
    }

    @Override
    public TaggedValues taggedValuesForTagList(String tagList) {
        this.validateTaggedValuesCache();
        TaggedValues copy = this.options().taggedValueFactory(this.taggedValuesCache, tagList);
        return copy;
    }

    @Override
    public TaggedValues taggedValuesAll() {
        this.validateTaggedValuesCache();
        TaggedValues copy = this.options().taggedValueFactory(this.taggedValuesCache);
        return copy;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        String[] values = this.taggedValuesCache.get(tag);
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            for (int i = 1; i < values.length; ++i) {
                ShapeChangeResult.MessageContext mc = this.result().addWarning(null, 701, tag, values[0], values[i]);
                this.addContextDetails(mc);
            }
        }
        return this.options().internalize(values[0]);
    }

    private void addContextDetails(ShapeChangeResult.MessageContext mc) {
        if (mc != null) {
            if (this instanceof PropertyInfo) {
                mc.addDetail(null, 791, this.fullName());
            } else {
                mc.addDetail(null, 790, this.fullName());
            }
        }
    }

    @Override
    public String[] taggedValuesForTag(String tag) {
        this.validateTaggedValuesCache();
        Object[] result = this.taggedValuesCache.get(tag);
        if (result.length != 0) {
            Arrays.sort(result);
        }
        return result;
    }

    @Override
    public String taggedValueInLanguage(String tag, String language) {
        List<LangString> values = this.taggedValuesForTagAsLangStrings(tag);
        if (values.isEmpty()) {
            return null;
        }
        String result = null;
        for (LangString ls : values) {
            if (!ls.hasLang() || !ls.getLang().equalsIgnoreCase(language)) continue;
            if (result == null) {
                result = this.options().internalize(ls.getValue());
                continue;
            }
            ShapeChangeResult.MessageContext mc = this.model().result().addWarning(null, 702, tag, language, result, ls.toString());
            this.addContextDetails(mc);
        }
        return result;
    }

    @Override
    public String[] taggedValuesInLanguage(String tag, String language) {
        this.validateTaggedValuesCache();
        List<LangString> values = this.taggedValuesForTagAsLangStrings(tag);
        if (values.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LangString ls : values) {
            if (ls.hasLang() && ls.getLang().equalsIgnoreCase(language)) {
                result.add(this.options().internalize(ls.getValue()));
                continue;
            }
            result.add(this.options().internalize(ls.getValue()));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public List<LangString> taggedValuesForTagAsLangStrings(String tag) {
        String[] values = this.taggedValuesForTag(tag);
        ArrayList<LangString> result = new ArrayList<LangString>();
        for (String value : values) {
            if (value == null || value.length() == 0) continue;
            Matcher m = langPattern.matcher(value);
            if (m.matches()) {
                String text = m.group(1);
                String lang = m.group(2);
                result.add(new LangString(this.options().internalize(text), this.options().internalize(lang)));
                continue;
            }
            result.add(new LangString(this.options().internalize(value)));
        }
        return result;
    }

    @Override
    public Descriptors descriptors() {
        this.validateDescriptorsCache();
        return this.descriptors;
    }

    public void setDescriptors(Descriptors descriptors) {
        this.descriptors = descriptors;
    }

    protected List<LangString> descriptorValues(Descriptor descriptor) {
        ArrayList<LangString> result;
        block7: {
            String source;
            block8: {
                String[] tags;
                this.validateDescriptorsCache();
                if (this.descriptors.has(descriptor)) {
                    return this.descriptors.values(descriptor);
                }
                result = new ArrayList<LangString>();
                this.descriptors.put(descriptor, result);
                source = this.model().descriptorSource(descriptor);
                if (!source.startsWith("tag#")) break block8;
                for (String tag : tags = source.replace("tag#", "").split(";")) {
                    result.addAll(this.taggedValuesForTagAsLangStrings(tag));
                    if (result.isEmpty()) {
                        continue;
                    }
                    break block7;
                }
                break block7;
            }
            if (!source.startsWith("sc:extract#")) break block7;
            String token = source.replace("sc:extract#", "");
            String doc = this.documentation();
            if (doc != null && doc.trim().length() != 0) {
                String[] ss = doc.split(this.options().extractSeparator());
                boolean found = false;
                if (token.equals("PROLOG")) {
                    found = true;
                }
                for (String s : ss) {
                    if (found) {
                        if (s.trim().length() == 0) break;
                        result.add(new LangString(this.options().internalize(s.trim())));
                        break;
                    }
                    if (!s.trim().equalsIgnoreCase(token)) continue;
                    found = true;
                }
            }
        }
        return result;
    }

    private void validateDescriptorsCache() {
        if (this.descriptors == null) {
            this.descriptors = new Descriptors();
            for (Descriptor descriptor : Descriptor.values()) {
                List<LangString> list = this.descriptorValues(descriptor);
                this.descriptors.putCopy(descriptor, list);
            }
        }
    }

    @Override
    public String primaryCode() {
        String[] values = this.filterDescriptorValues(Descriptor.PRIMARYCODE);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String globalIdentifier() {
        String[] values = this.filterDescriptorValues(Descriptor.GLOBALIDENTIFIER);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String derivedDocumentation(String template, String novalue) {
        String tmp = template == null ? "[[definition]]" : template;
        String nov = novalue == null ? "" : novalue;
        String doc = tmp;
        Pattern pattern = Pattern.compile("\\[\\[(.+?)\\]\\]");
        Matcher matcher = pattern.matcher(tmp);
        HashMap<String, String> replacements = new HashMap<String, String>();
        Object s = this.definition();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("definition", ((String)s).trim());
        s = this.description();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("description", ((String)s).trim());
        s = this.documentation();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("documentation", ((String)s).trim());
        s = this.aliasName();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("alias", ((String)s).trim());
        s = this.primaryCode();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("primaryCode", ((String)s).trim());
        s = this.globalIdentifier();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("globalIdentifier", ((String)s).trim());
        s = this.legalBasis();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("legalBasis", ((String)s).trim());
        s = this.language();
        if (s == null || ((String)s).trim().isEmpty()) {
            s = nov;
        }
        replacements.put("language", ((String)s).trim());
        String[] sa = this.examples();
        if (sa != null && sa.length > 0) {
            s = "";
            for (String e : sa) {
                s = (String)s + e.trim() + this.lf + this.lf;
            }
            if (((String)s).trim().isEmpty()) {
                s = nov;
            }
        } else {
            s = nov;
        }
        replacements.put("example", ((String)s).trim());
        sa = this.dataCaptureStatements();
        if (sa != null && sa.length > 0) {
            s = "";
            for (String e : sa) {
                s = (String)s + e.trim() + this.lf + this.lf;
            }
            if (((String)s).trim().isEmpty()) {
                s = nov;
            }
        } else {
            s = nov;
        }
        replacements.put("dataCaptureStatement", ((String)s).trim());
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = (String)replacements.get(matcher.group(1));
            builder.append(doc.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(doc.substring(i, doc.length()));
        return builder.toString();
    }

    @Override
    public String documentation() {
        String[] values = this.filterDescriptorValues(Descriptor.DOCUMENTATION);
        if (values.length == 0) {
            return "";
        }
        return values[0];
    }

    @Override
    public String definition() {
        String[] values = this.filterDescriptorValues(Descriptor.DEFINITION);
        if (values.length == 0) {
            return "";
        }
        return values[0];
    }

    @Override
    public String description() {
        String[] values = this.filterDescriptorValues(Descriptor.DESCRIPTION);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String legalBasis() {
        String[] values = this.filterDescriptorValues(Descriptor.LEGALBASIS);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String language() {
        String[] values = this.filterDescriptorValues(Descriptor.LANGUAGE);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String[] dataCaptureStatements() {
        String[] values = this.filterDescriptorValues(Descriptor.DATACAPTURESTATEMENT);
        return values;
    }

    @Override
    public String[] examples() {
        String[] values = this.filterDescriptorValues(Descriptor.EXAMPLE);
        return values;
    }

    @Override
    public String aliasName() {
        String[] values = this.filterDescriptorValues(Descriptor.ALIAS);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    private String[] filterDescriptorValues(Descriptor descriptor) {
        ShapeChangeResult.MessageContext mc;
        List<LangString> lsList = this.descriptorValues(descriptor);
        ArrayList<String> result = new ArrayList<String>();
        for (LangString ls : lsList) {
            if (!ls.hasLang() || !ls.getLang().equalsIgnoreCase(this.options().language())) continue;
            if (descriptor.isSingleValued() && result.size() != 0) {
                mc = this.model().result().addWarning(null, 704, descriptor.getName(), ((String)result.get(0)).toString(), ls.toString());
                this.addContextDetails(mc);
                continue;
            }
            result.add(ls.getValue());
        }
        if (result.isEmpty()) {
            for (LangString ls : lsList) {
                if (ls.hasLang()) continue;
                if (descriptor.isSingleValued() && result.size() != 0) {
                    mc = this.model().result().addWarning(null, 704, descriptor.getName(), ((String)result.get(0)).toString(), ls.toString());
                    this.addContextDetails(mc);
                    continue;
                }
                result.add(ls.getValue());
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String encodingRule(String platform) {
        TargetRegistry tgtreg;
        String tgtClassName;
        String s = this.taggedValue(platform + "EncodingRule");
        if ((s == null || s.isEmpty() || this.options().ignoreEncodingRuleTaggedValues()) && (tgtClassName = (tgtreg = this.options().getTargetRegistry()).targetClassName(platform)) != null && (s = this.options().parameter(tgtClassName, "defaultEncodingRule")) == null) {
            s = tgtreg.targetDefaultEncodingRule(platform);
        }
        if (s != null) {
            s = s.toLowerCase();
        }
        if (!this.options().getRuleRegistry().encRuleExists(s)) {
            this.result().addError(null, 181, s, platform);
        }
        return s;
    }

    @Override
    public boolean matches(String rule) {
        String param;
        String[] ra = rule.toLowerCase().split("-", 4);
        if (ra.length != 4) {
            this.result().addError(null, 21, rule);
            return false;
        }
        if (!this.options().getRuleRegistry().hasRule(rule)) {
            this.result().addError(null, 164, rule);
            return false;
        }
        if (ra[0].equals("rule") && !ra[1].equals("all") && !this.options().targetMode(this.options().targetClassName(rule)).equals((Object)ProcessMode.enabled)) {
            return false;
        }
        if (ra[0].matches("re[cq]") && !ra[1].equals("all") && this.options().targetMode(this.options().targetClassName(rule)).equals((Object)ProcessMode.disabled)) {
            return false;
        }
        if (!ra[2].equals("all")) {
            if (ra[2].equals("pkg")) {
                if (!(this instanceof PackageInfo)) {
                    return false;
                }
            } else if (ra[2].equals("cls")) {
                if (!(this instanceof ClassInfo)) {
                    return false;
                }
            } else if (ra[2].equals("prop")) {
                if (!(this instanceof PropertyInfo)) {
                    return false;
                }
            } else if (ra[2].equals("rel")) {
                if (!(this instanceof AssociationInfo)) {
                    return false;
                }
            } else if (ra[2].equals("op")) {
                if (!(this instanceof OperationInfo)) {
                    return false;
                }
            } else {
                this.result().addError(null, 21, rule);
                return false;
            }
        }
        if (rule.equals("rule-xsd-cls-local-enumeration") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "enumStyle")) != null && param.equalsIgnoreCase("local")) {
            return true;
        }
        if (rule.equals("rule-xsd-cls-local-basictype") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "basicTypeStyle")) != null && param.equalsIgnoreCase("local")) {
            return true;
        }
        if (rule.equals("rule-xsd-pkg-schematron") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "schematron")) != null && param.equalsIgnoreCase("true")) {
            return true;
        }
        if (rule.equals("rule-xsd-prop-exclude-derived") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDerivedProperties")) != null && param.equalsIgnoreCase("false")) {
            return true;
        }
        if (ra[1].equals("all")) {
            TargetRegistry tgtreg = this.options().getTargetRegistry();
            for (String targetIdentifier : tgtreg.getTargetIdentifiers()) {
                String encRule = this.encodingRule(targetIdentifier);
                if (encRule == null || !this.options().getRuleRegistry().hasRule(rule, encRule)) continue;
                return true;
            }
            return false;
        }
        String encRule = this.encodingRule(ra[1]).toLowerCase();
        if (encRule != null) {
            boolean encRuleHasRule = this.options().getRuleRegistry().hasRule(rule, encRule);
            if (encRuleHasRule) {
                if (rule.equals("rule-xsd-all-no-documentation")) {
                    param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation");
                    return param == null || !param.equalsIgnoreCase("true");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void postprocessAfterLoadingAndValidate() {
    }

    @Override
    @Deprecated
    public Map<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.getFirstValues(tagList);
    }

    @Override
    public void removeTaggedValue(String tag) {
        this.validateTaggedValuesCache();
        this.taggedValuesCache.remove(tag);
    }

    @Override
    @Deprecated
    public Map<String, String> taggedValues() {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.getFirstValues();
    }
}

