/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.ConstraintContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DescriptorsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelReaderConstants;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.ProfilesContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.QualifiersContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.StringListContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.TaggedValuesContentHandler;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericPropertyContentHandler
extends AbstractGenericInfoContentHandler {
    private static final Set<String> SIMPLE_PROPERTY_FIELDS = new HashSet<String>(Arrays.asList("cardinality", "isDerived", "isReadOnly", "isAttribute", "isNavigable", "isOrdered", "isUnique", "isComposition", "isAggregation", "initialValue", "inlineOrByReference", "sequenceNumber", "associationId", "typeId", "typeName", "inClassId", "isOwned"));
    private static final Set<String> DEPRECATED_FIELDS = new HashSet<String>(Arrays.asList("reversePropertyId"));
    private GenericPropertyInfo genPi = new GenericPropertyInfo();
    private String associationId = null;
    private String inClassId = null;
    private String typeId = "0";
    private String typeName = null;
    private List<ConstraintContentHandler> constraintContentHandlers = new ArrayList<ConstraintContentHandler>();
    private ProfilesContentHandler profilesContentHandler = null;

    public GenericPropertyContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractContentHandler parent) {
        super(result, options, reader, parent);
        this.genPi.setResult(result);
        this.genPi.setOptions(options);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (GenericModelReaderConstants.SIMPLE_INFO_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("descriptors")) {
                DescriptorsContentHandler handler;
                this.descriptorsHandler = handler = new DescriptorsContentHandler(this.result, this.options, this.reader, this);
                this.reader.setContentHandler(handler);
            } else if (localName.equals("taggedValues")) {
                this.reader.setContentHandler(new TaggedValuesContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("stereotypes")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("profiles")) {
                this.profilesContentHandler = new ProfilesContentHandler(this.result, this.options, this.reader, this);
                this.reader.setContentHandler(this.profilesContentHandler);
            } else if (SIMPLE_PROPERTY_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("qualifiers")) {
                this.reader.setContentHandler(new QualifiersContentHandler(this.result, this.options, this.reader, this));
            } else if (!localName.equals("constraints")) {
                if (localName.equals("FolConstraint") || localName.equals("OclConstraint") || localName.equals("TextConstraint")) {
                    ConstraintContentHandler handler = new ConstraintContentHandler(this.result, this.options, this.reader, this);
                    this.constraintContentHandlers.add(handler);
                    this.reader.setContentHandler(handler);
                } else {
                    this.result.addDebug(null, 30800, "GenericPropertyContentHandler", localName);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (localName.equals("id")) {
                this.genPi.setId(this.sb.toString());
            } else if (localName.equals("name")) {
                this.genPi.setName(this.sb.toString());
            } else if (localName.equals("stereotypes")) {
                Stereotypes stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(this.stringList.toArray(new String[this.stringList.size()]), this.genPi);
                this.genPi.setStereotypes(stereotypesCache);
            } else if (!localName.equals("descriptors") && !localName.equals("taggedValues")) {
                if (localName.equals("profiles")) {
                    this.genPi.setProfiles(this.profilesContentHandler.getProfiles());
                } else if (localName.equals("cardinality")) {
                    String value = this.sb.toString();
                    Multiplicity m = new Multiplicity(value);
                    this.genPi.setCardinality(m);
                } else if (localName.equals("isDerived")) {
                    this.genPi.setDerived(this.toBooleanValue(this.sb));
                } else if (localName.equals("isReadOnly")) {
                    this.genPi.setReadOnly(this.toBooleanValue(this.sb));
                } else if (localName.equals("isAttribute")) {
                    this.genPi.setAttribute(this.toBooleanValue(this.sb));
                } else if (localName.equals("isNavigable")) {
                    this.genPi.setNavigable(this.toBooleanValue(this.sb));
                } else if (localName.equals("isOrdered")) {
                    this.genPi.setOrdered(this.toBooleanValue(this.sb));
                } else if (localName.equals("isUnique")) {
                    this.genPi.setUnique(this.toBooleanValue(this.sb));
                } else if (localName.equals("isOwned")) {
                    this.genPi.setOwned(this.toBooleanValue(this.sb));
                } else if (localName.equals("isComposition")) {
                    this.genPi.setComposition(this.toBooleanValue(this.sb));
                } else if (localName.equals("isAggregation")) {
                    this.genPi.setAggregation(this.toBooleanValue(this.sb));
                } else if (localName.equals("initialValue")) {
                    this.genPi.setInitialValue(this.sb.toString());
                } else if (localName.equals("inlineOrByReference")) {
                    this.genPi.setInlineOrByReference(this.sb.toString());
                } else if (localName.equals("sequenceNumber")) {
                    StructuredNumber sn = new StructuredNumber(this.sb.toString());
                    this.genPi.setSequenceNumber(sn, false);
                } else if (localName.equals("inClassId")) {
                    this.inClassId = this.sb.toString();
                } else if (localName.equals("associationId")) {
                    this.associationId = this.sb.toString();
                } else if (localName.equals("typeId")) {
                    this.typeId = this.sb.toString();
                } else if (localName.equals("typeName")) {
                    this.typeName = this.sb.toString();
                } else if (!(localName.equals("qualifiers") || localName.equals("constraints") || localName.equals("FolConstraint") || localName.equals("OclConstraint") || localName.equals("TextConstraint"))) {
                    if (localName.equals("Property")) {
                        Descriptors desc = this.options.parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false) ? null : (this.descriptorsHandler == null ? new Descriptors() : this.descriptorsHandler.getDescriptors());
                        this.genPi.setDescriptors(desc);
                        Type type = new Type();
                        type.id = this.options.internalize(this.typeId);
                        type.name = this.options.internalize(this.typeName);
                        this.genPi.setTypeInfo(type);
                        Vector<Constraint> cons = new Vector<Constraint>();
                        if (!this.options.constraintLoadingEnabled() || !this.options.isConstraintCreationForProperties()) {
                            this.constraintContentHandlers = new ArrayList<ConstraintContentHandler>();
                        } else {
                            for (ConstraintContentHandler cch : this.constraintContentHandlers) {
                                cons.add(cch.getConstraint());
                            }
                        }
                        this.genPi.setConstraints(cons);
                        if (this.genPi.cardinality() == null) {
                            this.genPi.setCardinality(new Multiplicity());
                        }
                        this.parent.endElement(uri, localName, qName);
                        this.reader.setContentHandler(this.parent);
                    } else {
                        this.result.addDebug(null, 30801, "GenericPropertyContentHandler", localName);
                    }
                }
            }
        }
    }

    public GenericPropertyInfo getGenericProperty() {
        return this.genPi;
    }

    @Override
    public void setTaggedValues(TaggedValues taggedValues) {
        this.genPi.setTaggedValues(taggedValues, false);
    }

    @Override
    public void setDiagrams(List<ImageMetadata> diagrams) {
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public String getInClassId() {
        return this.inClassId;
    }

    public List<ConstraintContentHandler> getConstraintContentHandlers() {
        return this.constraintContentHandlers;
    }

    public void setQualifiers(Vector<Qualifier> qualifiers) {
        this.genPi.setQualifiers(qualifiers);
    }
}

