/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DescriptorsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DiagramsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericClassContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelReaderConstants;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.StringListContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.TaggedValuesContentHandler;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.junit.platform.commons.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericPackageContentHandler
extends AbstractGenericInfoContentHandler {
    private static final Set<String> SIMPLE_PACKAGE_FIELDS = new HashSet<String>(Arrays.asList(new String[0]));
    private static final Set<String> DEPRECATED_FIELDS = new HashSet<String>(Arrays.asList("isAppSchema", "isSchema", "targetNamespace", "xmlns", "xsdDocument", "version"));
    private boolean isInPackages = false;
    private GenericPackageInfo genPi;
    private List<GenericPackageContentHandler> childPackageContentHandlers = new ArrayList<GenericPackageContentHandler>();
    private List<GenericClassContentHandler> classContentHandlers = new ArrayList<GenericClassContentHandler>();

    public GenericPackageContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractContentHandler parent) {
        super(result, options, reader, parent);
        this.genPi = new GenericPackageInfo();
        this.genPi.setResult(result);
        this.genPi.setOptions(options);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (GenericModelReaderConstants.SIMPLE_INFO_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("descriptors")) {
                DescriptorsContentHandler handler;
                this.descriptorsHandler = handler = new DescriptorsContentHandler(this.result, this.options, this.reader, this);
                this.reader.setContentHandler(handler);
            } else if (localName.equals("taggedValues")) {
                this.reader.setContentHandler(new TaggedValuesContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("stereotypes")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("diagrams")) {
                this.reader.setContentHandler(new DiagramsContentHandler(this.result, this.options, this.reader, this));
            } else if (SIMPLE_PACKAGE_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("supplierIds")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("packages")) {
                this.isInPackages = true;
            } else if (localName.equals("Package")) {
                if (this.isInPackages) {
                    GenericPackageContentHandler handler = new GenericPackageContentHandler(this.result, this.options, this.reader, this);
                    this.childPackageContentHandlers.add(handler);
                    this.reader.setContentHandler(handler);
                }
            } else if (!localName.equals("classes")) {
                if (localName.equals("Class")) {
                    GenericClassContentHandler handler = new GenericClassContentHandler(this.result, this.options, this.reader, this);
                    this.classContentHandlers.add(handler);
                    this.reader.setContentHandler(handler);
                } else {
                    this.result.addDebug(null, 30800, "GenericPackageContentHandler", localName);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (localName.equals("id")) {
                this.genPi.setId(this.sb.toString());
            } else if (localName.equals("name")) {
                this.genPi.setName(this.sb.toString());
            } else if (localName.equals("stereotypes")) {
                Stereotypes stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(this.stringList.toArray(new String[this.stringList.size()]), this.genPi);
                this.genPi.setStereotypes(stereotypesCache);
            } else if (!(localName.equals("descriptors") || localName.equals("taggedValues") || localName.equals("diagrams"))) {
                if (localName.equals("supplierIds")) {
                    this.genPi.setSupplierIds(new TreeSet<String>(this.stringList));
                } else if (localName.equals("packages")) {
                    this.isInPackages = false;
                } else if (!localName.equals("classes") && !localName.equals("Class")) {
                    if (localName.equals("Package")) {
                        if (!this.isInPackages) {
                            Descriptors desc = this.options.parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false) ? null : (this.descriptorsHandler == null ? new Descriptors() : this.descriptorsHandler.getDescriptors());
                            this.genPi.setDescriptors(desc);
                            TreeSet<GenericPackageInfo> children = new TreeSet<GenericPackageInfo>();
                            for (GenericPackageContentHandler gpch : this.childPackageContentHandlers) {
                                children.add(gpch.getGenericPackage());
                            }
                            this.genPi.setContainedPackages(children);
                            TreeSet<GenericClassInfo> classes = new TreeSet<GenericClassInfo>();
                            ArrayList<GenericClassContentHandler> classHandlersToRemove = new ArrayList<GenericClassContentHandler>();
                            for (GenericClassContentHandler gcch : this.classContentHandlers) {
                                GenericClassInfo genCi = gcch.getGenericClass();
                                String statusTaggedValue = genCi.taggedValue("status");
                                if (StringUtils.isNotBlank((String)statusTaggedValue) && this.options.prohibitedStatusValuesWhenLoadingClasses().contains(statusTaggedValue)) {
                                    classHandlersToRemove.add(gcch);
                                    continue;
                                }
                                classes.add(gcch.getGenericClass());
                            }
                            this.classContentHandlers.removeAll(classHandlersToRemove);
                            this.genPi.setClasses(classes);
                            this.parent.endElement(uri, localName, qName);
                            this.reader.setContentHandler(this.parent);
                        }
                    } else {
                        this.result.addDebug(null, 30801, "GenericPackageContentHandler", localName);
                    }
                }
            }
        }
    }

    public GenericPackageInfo getGenericPackage() {
        return this.genPi;
    }

    @Override
    public void setTaggedValues(TaggedValues taggedValues) {
        this.genPi.setTaggedValues(taggedValues, false);
    }

    @Override
    public void setDiagrams(List<ImageMetadata> diagrams) {
        this.genPi.setDiagrams(diagrams);
    }

    public List<GenericPackageContentHandler> getChildPackageContentHandlers() {
        return this.childPackageContentHandlers;
    }

    public List<GenericClassContentHandler> getClassContentHandlers() {
        return this.classContentHandlers;
    }

    public void visitPackageContentHandlers(Map<String, GenericPackageContentHandler> resultMap) {
        resultMap.put(this.genPi.id(), this);
        for (GenericPackageContentHandler gpch : this.childPackageContentHandlers) {
            gpch.visitPackageContentHandlers(resultMap);
        }
    }
}

