/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GenericModelErrorHandler
implements ErrorHandler {
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public List<String> errors() {
        return this.errors;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        this.warnings.add(this.getParseExceptionInfo(spe));
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        this.errors.add(this.getParseExceptionInfo(spe));
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
        throw new SAXException(message);
    }

    private String getParseExceptionInfo(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = systemId + " (" + spe.getLineNumber() + ":" + spe.getColumnNumber() + ") " + spe.getMessage();
        return info;
    }
}

