/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericAssociationContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelReaderConfigurationException;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericPackageContentHandler;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericModelContentHandler
extends AbstractContentHandler {
    private static final Set<String> ELEMENTS_TO_IGNORE = new HashSet<String>(Arrays.asList("globalProfileInfos", "Profile", "name", "description"));
    private List<GenericPackageContentHandler> packageContentHandlers = new ArrayList<GenericPackageContentHandler>();
    private List<GenericAssociationContentHandler> associationContentHandlers = new ArrayList<GenericAssociationContentHandler>();
    private String encoding = null;

    public GenericModelContentHandler(ShapeChangeResult result, Options options, XMLReader reader) {
        super(result, options, reader, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.length() == 0) {
            throw new GenericModelReaderConfigurationException("localName is empty. No Namespace support in the SAXParser?");
        }
        if (!ELEMENTS_TO_IGNORE.contains(localName)) {
            if (localName.equals("Model")) {
                if (atts != null) {
                    String scxmlProducerVersion;
                    String scxmlProducer;
                    String encoding_ = atts.getValue("encoding");
                    if (encoding_ != null) {
                        this.encoding = encoding_;
                    }
                    if (StringUtils.isBlank((CharSequence)(scxmlProducer = atts.getValue("scxmlProducer")))) {
                        scxmlProducer = "<not set>";
                    }
                    if (StringUtils.isBlank((CharSequence)(scxmlProducerVersion = atts.getValue("scxmlProducerVersion")))) {
                        scxmlProducerVersion = "<not set>";
                    }
                    this.result.addDebug(null, 30804, scxmlProducer, scxmlProducerVersion);
                }
            } else if (!localName.equals("packages")) {
                if (localName.equals("Package")) {
                    GenericPackageContentHandler handler = new GenericPackageContentHandler(this.result, this.options, this.reader, this);
                    this.packageContentHandlers.add(handler);
                    this.reader.setContentHandler(handler);
                } else if (!localName.equals("associations")) {
                    if (localName.equals("Association")) {
                        GenericAssociationContentHandler handler = new GenericAssociationContentHandler(this.result, this.options, this.reader, this);
                        this.associationContentHandlers.add(handler);
                        this.reader.setContentHandler(handler);
                    } else {
                        this.result.addDebug(null, 30800, "GenericModelContentHandler", localName);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public List<GenericPackageContentHandler> getPackageContentHandlers() {
        return this.packageContentHandlers;
    }

    public List<GenericAssociationContentHandler> getAssociationContentHandlers() {
        return this.associationContentHandlers;
    }

    public Map<String, GenericPackageContentHandler> getAllPackageContentHandlers() {
        HashMap<String, GenericPackageContentHandler> result = new HashMap<String, GenericPackageContentHandler>();
        for (GenericPackageContentHandler gpch : this.packageContentHandlers) {
            gpch.visitPackageContentHandlers(result);
        }
        return result;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

