/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.ConstraintContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DescriptorsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DiagramsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelReaderConstants;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericPropertyContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.ProfilesContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.StringListContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.TaggedValuesContentHandler;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericClassContentHandler
extends AbstractGenericInfoContentHandler {
    private static final Set<String> SIMPLE_CLASS_FIELDS = new HashSet<String>(Arrays.asList("isAbstract", "isLeaf", "associationId", "baseClassId", "linkedDocument"));
    private static final Set<String> DEPRECATED_FIELDS = new HashSet<String>(Arrays.asList("baseClassId"));
    private GenericClassInfo genCi = new GenericClassInfo();
    private String associationId = null;
    private String linkedDocument = null;
    private List<GenericPropertyContentHandler> propertyContentHandlers = new ArrayList<GenericPropertyContentHandler>();
    private List<ConstraintContentHandler> constraintContentHandlers = new ArrayList<ConstraintContentHandler>();
    private ProfilesContentHandler profilesContentHandler = null;

    public GenericClassContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractContentHandler parent) {
        super(result, options, reader, parent);
        this.genCi.setResult(result);
        this.genCi.setOptions(options);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (GenericModelReaderConstants.SIMPLE_INFO_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("descriptors")) {
                DescriptorsContentHandler handler;
                this.descriptorsHandler = handler = new DescriptorsContentHandler(this.result, this.options, this.reader, this);
                this.reader.setContentHandler(handler);
            } else if (localName.equals("taggedValues")) {
                this.reader.setContentHandler(new TaggedValuesContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("stereotypes")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("profiles")) {
                this.profilesContentHandler = new ProfilesContentHandler(this.result, this.options, this.reader, this);
                this.reader.setContentHandler(this.profilesContentHandler);
            } else if (localName.equals("diagrams")) {
                this.reader.setContentHandler(new DiagramsContentHandler(this.result, this.options, this.reader, this));
            } else if (SIMPLE_CLASS_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else if (localName.equals("supertypes")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (localName.equals("subtypes")) {
                this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
            } else if (!localName.equals("properties")) {
                if (localName.equals("Property")) {
                    GenericPropertyContentHandler handler = new GenericPropertyContentHandler(this.result, this.options, this.reader, this);
                    this.propertyContentHandlers.add(handler);
                    this.reader.setContentHandler(handler);
                } else if (!localName.equals("constraints")) {
                    if (localName.equals("FolConstraint") || localName.equals("OclConstraint") || localName.equals("TextConstraint")) {
                        ConstraintContentHandler handler = new ConstraintContentHandler(this.result, this.options, this.reader, this);
                        this.constraintContentHandlers.add(handler);
                        this.reader.setContentHandler(handler);
                    } else {
                        this.result.addDebug(null, 30800, "GenericClassContentHandler", localName);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("id")) {
            this.genCi.setId(this.sb.toString());
        } else if (localName.equals("name")) {
            this.genCi.setName(this.sb.toString());
        } else if (localName.equals("stereotypes")) {
            Stereotypes stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(this.stringList.toArray(new String[this.stringList.size()]), this.genCi);
            this.genCi.setStereotypes(stereotypesCache);
        } else if (!localName.equals("descriptors") && !localName.equals("taggedValues")) {
            if (localName.equals("profiles")) {
                this.genCi.setProfiles(this.profilesContentHandler.getProfiles());
            } else if (!localName.equals("diagrams")) {
                if (localName.equals("isAbstract")) {
                    this.genCi.setIsAbstract(this.toBooleanValue(this.sb));
                } else if (localName.equals("isLeaf")) {
                    this.genCi.setIsLeaf(this.toBooleanValue(this.sb));
                } else if (localName.equals("associationId")) {
                    this.associationId = this.sb.toString();
                } else if (!DEPRECATED_FIELDS.contains(localName)) {
                    if (localName.equals("linkedDocument")) {
                        this.linkedDocument = this.sb.toString();
                    } else if (localName.equals("supertypes")) {
                        this.genCi.setSupertypes(new TreeSet<String>(this.stringList));
                    } else if (localName.equals("subtypes")) {
                        this.genCi.setSubtypes(new TreeSet<String>(this.stringList));
                    } else if (!(localName.equals("properties") || localName.equals("Property") || localName.equals("constraints") || localName.equals("FolConstraint") || localName.equals("OclConstraint") || localName.equals("TextConstraint"))) {
                        if (localName.equals("Class")) {
                            Descriptors desc = this.options.parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false) ? null : (this.descriptorsHandler == null ? new Descriptors() : this.descriptorsHandler.getDescriptors());
                            this.genCi.setDescriptors(desc);
                            TreeMap<StructuredNumber, PropertyInfo> properties = new TreeMap<StructuredNumber, PropertyInfo>();
                            ArrayList<GenericPropertyContentHandler> handlersOfNonNavigableProperties = new ArrayList<GenericPropertyContentHandler>();
                            for (GenericPropertyContentHandler gpch : this.propertyContentHandlers) {
                                GenericPropertyInfo genPi = gpch.getGenericProperty();
                                if (genPi.isNavigable()) {
                                    properties.put(gpch.getGenericProperty().sequenceNumber(), genPi);
                                    continue;
                                }
                                handlersOfNonNavigableProperties.add(gpch);
                            }
                            this.genCi.setProperties(properties);
                            this.propertyContentHandlers.removeAll(handlersOfNonNavigableProperties);
                            Vector<Constraint> cons = new Vector<Constraint>();
                            if (!this.options.constraintLoadingEnabled()) {
                                this.constraintContentHandlers = new ArrayList<ConstraintContentHandler>();
                            } else {
                                for (ConstraintContentHandler cch : this.constraintContentHandlers) {
                                    cons.add(cch.getConstraint());
                                }
                            }
                            this.genCi.setDirectConstraints(cons);
                            this.parent.endElement(uri, localName, qName);
                            this.reader.setContentHandler(this.parent);
                        } else {
                            this.result.addDebug(null, 30801, "GenericClassContentHandler", localName);
                        }
                    }
                }
            }
        }
    }

    public GenericClassInfo getGenericClass() {
        return this.genCi;
    }

    @Override
    public void setTaggedValues(TaggedValues taggedValues) {
        this.genCi.setTaggedValues(taggedValues, false);
    }

    @Override
    public void setDiagrams(List<ImageMetadata> diagrams) {
        this.genCi.setDiagrams(diagrams);
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public String getLinkedDocument() {
        return this.linkedDocument;
    }

    public List<GenericPropertyContentHandler> getPropertyContentHandlers() {
        return this.propertyContentHandlers;
    }

    public List<ConstraintContentHandler> getConstraintContentHandlers() {
        return this.constraintContentHandlers;
    }
}

