/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DescriptorsContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelReaderConstants;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericPropertyContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.StringListContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.TaggedValuesContentHandler;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericAssociationContentHandler
extends AbstractGenericInfoContentHandler {
    private GenericAssociationInfo genAi = new GenericAssociationInfo();
    private boolean isInEnd1 = false;
    private boolean isInEnd2 = false;
    private String assocClassId = null;
    private String end1Id = null;
    private String end2Id = null;
    private GenericPropertyContentHandler end1PropertyContentHandler = null;
    private GenericPropertyContentHandler end2PropertyContentHandler = null;

    public GenericAssociationContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractContentHandler parent) {
        super(result, options, reader, parent);
        this.genAi.setResult(result);
        this.genAi.setOptions(options);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (GenericModelReaderConstants.SIMPLE_INFO_FIELDS.contains(localName)) {
            this.sb = new StringBuffer();
        } else if (localName.equals("descriptors")) {
            DescriptorsContentHandler handler;
            this.descriptorsHandler = handler = new DescriptorsContentHandler(this.result, this.options, this.reader, this);
            this.reader.setContentHandler(handler);
        } else if (localName.equals("taggedValues")) {
            this.reader.setContentHandler(new TaggedValuesContentHandler(this.result, this.options, this.reader, this));
        } else if (localName.equals("stereotypes")) {
            this.reader.setContentHandler(new StringListContentHandler(this.result, this.options, this.reader, this));
        } else if (localName.equals("assocClassId")) {
            this.sb = new StringBuffer();
        } else if (localName.equals("end1")) {
            this.isInEnd1 = true;
            this.end1Id = atts.getValue("", "ref");
        } else if (localName.equals("end2")) {
            this.isInEnd2 = true;
            this.end2Id = atts.getValue("", "ref");
        } else if (localName.equals("Property")) {
            GenericPropertyContentHandler handler = new GenericPropertyContentHandler(this.result, this.options, this.reader, this);
            if (this.isInEnd1) {
                this.end1PropertyContentHandler = handler;
            } else if (this.isInEnd2) {
                this.end2PropertyContentHandler = handler;
            }
            this.reader.setContentHandler(handler);
        } else {
            this.result.addDebug(null, 30800, "GenericAssociationContentHandler", localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("name")) {
            this.genAi.setName(this.sb.toString());
        } else if (localName.equals("id")) {
            this.genAi.setId(this.sb.toString());
        } else if (localName.equals("stereotypes")) {
            Stereotypes stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(this.stringList.toArray(new String[this.stringList.size()]), this.genAi);
            this.genAi.setStereotypes(stereotypesCache);
        } else if (!localName.equals("descriptors") && !localName.equals("taggedValues")) {
            if (localName.equals("assocClassId")) {
                this.assocClassId = this.sb.toString();
            } else if (localName.equals("end1")) {
                this.isInEnd1 = false;
            } else if (localName.equals("end2")) {
                this.isInEnd2 = false;
            } else if (!localName.equals("Property")) {
                if (localName.equals("Association")) {
                    Descriptors desc = this.options.parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false) ? null : (this.descriptorsHandler == null ? new Descriptors() : this.descriptorsHandler.getDescriptors());
                    this.genAi.setDescriptors(desc);
                    this.parent.endElement(uri, localName, qName);
                    this.reader.setContentHandler(this.parent);
                } else {
                    this.result.addDebug(null, 30801, "GenericAssociationContentHandler", localName);
                }
            }
        }
    }

    @Override
    public void setTaggedValues(TaggedValues taggedValues) {
        this.genAi.setTaggedValues(taggedValues, false);
    }

    @Override
    public void setDiagrams(List<ImageMetadata> diagrams) {
    }

    public GenericAssociationInfo getGenericAssociationInfo() {
        return this.genAi;
    }

    public String getAssocClassId() {
        return this.assocClassId;
    }

    public String getEnd1Id() {
        return this.end1Id;
    }

    public String getEnd2Id() {
        return this.end2Id;
    }

    public GenericPropertyContentHandler getEnd1PropertyContentHandler() {
        return this.end1PropertyContentHandler;
    }

    public GenericPropertyContentHandler getEnd2PropertyContentHandler() {
        return this.end2PropertyContentHandler;
    }
}

