/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DiagramsContentHandler
extends AbstractContentHandler
implements MessageSource {
    private static final Set<String> IMAGE_METADATA_FIELDS = new HashSet<String>(Arrays.asList("id", "name", "relPathToFile", "width", "height"));
    private static final Set<String> DEPRECATED_FIELDS = new HashSet<String>(Arrays.asList("file"));
    private AbstractGenericInfoContentHandler parent;
    private List<ImageMetadata> diagrams = new ArrayList<ImageMetadata>();
    private String id = null;
    private String name = null;
    private String relPathToFile = null;
    private String width = null;
    private String height = null;

    public DiagramsContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractGenericInfoContentHandler parent) {
        super(result, options, reader, parent);
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (localName.equals("ImageMetadata")) {
                this.id = null;
                this.name = null;
                this.relPathToFile = null;
                this.width = null;
                this.height = null;
            } else if (IMAGE_METADATA_FIELDS.contains(localName)) {
                this.sb = new StringBuffer();
            } else {
                this.result.addDebug(null, 30800, "DiagramsContentHandler", localName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("id")) {
            this.id = this.sb.toString();
        } else if (localName.equals("name")) {
            this.name = this.sb.toString();
        } else if (!DEPRECATED_FIELDS.contains(localName)) {
            if (localName.equals("relPathToFile")) {
                this.relPathToFile = this.sb.toString();
            } else if (localName.equals("width")) {
                this.width = this.sb.toString();
            } else if (localName.equals("height")) {
                this.height = this.sb.toString();
            } else if (localName.equals("ImageMetadata")) {
                try {
                    File f = new File(this.options.imageTmpDir(), this.relPathToFile);
                    int w = Integer.parseInt(this.width);
                    int h = Integer.parseInt(this.height);
                    ImageMetadata im = new ImageMetadata(this.id, this.name, f, this.relPathToFile, w, h);
                    this.diagrams.add(im);
                }
                catch (NumberFormatException e) {
                    this.result.addError(this, 30802, this.id, this.name, e.getMessage());
                }
            } else if (localName.equals("diagrams")) {
                if ("true".equalsIgnoreCase(this.options.parameter("loadDiagrams"))) {
                    boolean sortDiagramsByName = this.options.parameterAsBoolean(null, "sortDiagramsByName", true);
                    if (sortDiagramsByName) {
                        Collections.sort(this.diagrams, new Comparator<ImageMetadata>(){

                            @Override
                            public int compare(ImageMetadata o1, ImageMetadata o2) {
                                return o1.getName().compareTo(o2.getName());
                            }
                        });
                    }
                    this.parent.setDiagrams(this.diagrams);
                }
                this.parent.endElement(uri, localName, qName);
                this.reader.setContentHandler(this.parent);
            } else {
                this.result.addDebug(null, 30801, "DiagramsContentHandler", localName);
            }
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 30802: {
                return "(Generic model element reader) NumberFormatException while parsing content of ImageMetadata element with id '$1$' and name '$2$'. Message is: $3$.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

