/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.DescriptorValuesContentHandler;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DescriptorsContentHandler
extends AbstractContentHandler {
    public static final Set<String> DESCRIPTOR_FIELDS = new HashSet<String>(Arrays.asList("alias", "primaryCode", "globalIdentifier", "documentation", "definition", "description", "legalBasis", "language", "example", "dataCaptureStatement"));
    private Descriptors descriptors = new Descriptors();
    private DescriptorValuesContentHandler descriptorValuesHandler = null;

    public DescriptorsContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractGenericInfoContentHandler parent) {
        super(result, options, reader, parent);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (DESCRIPTOR_FIELDS.contains(localName)) {
            DescriptorValuesContentHandler handler;
            this.descriptorValuesHandler = handler = new DescriptorValuesContentHandler(this.result, this.options, this.reader, this);
            this.reader.setContentHandler(handler);
        } else if (!localName.equals("descriptors")) {
            this.result.addDebug(null, 30800, "DescriptorsContentHandler", localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("alias")) {
            this.descriptors.put(Descriptor.ALIAS, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("documentation")) {
            this.descriptors.put(Descriptor.DOCUMENTATION, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("definition")) {
            this.descriptors.put(Descriptor.DEFINITION, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("description")) {
            this.descriptors.put(Descriptor.DESCRIPTION, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("legalBasis")) {
            this.descriptors.put(Descriptor.LEGALBASIS, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("primaryCode")) {
            this.descriptors.put(Descriptor.PRIMARYCODE, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("globalIdentifier")) {
            this.descriptors.put(Descriptor.GLOBALIDENTIFIER, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("language")) {
            this.descriptors.put(Descriptor.LANGUAGE, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("example")) {
            this.descriptors.put(Descriptor.EXAMPLE, this.descriptorValuesHandler.getDescriptorValues());
        } else if (localName.equals("dataCaptureStatement")) {
            this.descriptors.put(Descriptor.DATACAPTURESTATEMENT, this.descriptorValuesHandler.getDescriptorValues());
        } else if (!localName.equals("descriptorValues")) {
            if (localName.equals("descriptors")) {
                for (Descriptor descriptor : Descriptor.values()) {
                    if (this.descriptors.has(descriptor)) continue;
                    ArrayList<LangString> list = new ArrayList<LangString>();
                    this.descriptors.put(descriptor, list);
                }
                this.parent.endElement(uri, localName, qName);
                this.reader.setContentHandler(this.parent);
            } else {
                this.result.addDebug(null, 30801, "DescriptorsContentHandler", localName);
            }
        }
    }

    public Descriptors getDescriptors() {
        return this.descriptors;
    }
}

