/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic.reader;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericFolConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericOclConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericTextConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.AbstractGenericInfoContentHandler;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConstraintContentHandler
extends AbstractContentHandler {
    private static final Set<String> CONSTRAINT_FIELDS = new HashSet<String>(Arrays.asList("name", "status", "text", "type", "sourceType", "description"));
    private static final Set<String> DEPRECATED_FIELDS = new HashSet<String>(Arrays.asList("contextModelElementId", "contextModelElementType"));
    private String name = null;
    private String status = null;
    private String text = null;
    private List<String> descriptions = new ArrayList<String>();
    private String type = null;
    private String sourceType = null;
    private Constraint constraint = null;

    public ConstraintContentHandler(ShapeChangeResult result, Options options, XMLReader reader, AbstractGenericInfoContentHandler parent) {
        super(result, options, reader, parent);
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (CONSTRAINT_FIELDS.contains(localName)) {
            this.sb = new StringBuffer();
        } else if (!DEPRECATED_FIELDS.contains(localName)) {
            this.result.addDebug(null, 30800, "ConstraintContentHandler", localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!DEPRECATED_FIELDS.contains(localName)) {
            if (localName.equals("name")) {
                this.name = this.sb.toString();
            } else if (localName.equals("status")) {
                this.status = this.sb.toString();
            } else if (localName.equals("text")) {
                this.text = this.sb.toString();
            } else if (localName.equals("description")) {
                this.descriptions.add(this.sb.toString());
            } else if (localName.equals("type")) {
                this.type = this.sb.toString();
            } else if (localName.equals("sourceType")) {
                this.sourceType = this.sb.toString();
            } else if (localName.equals("FolConstraint")) {
                GenericFolConstraint con = new GenericFolConstraint();
                this.constraint = con;
                con.setName(this.name);
                con.setStatus(this.status);
                if (!this.descriptions.isEmpty()) {
                    con.setComments(this.descriptions.toArray(new String[0]));
                }
                con.setText(this.text);
                con.setSourceType(this.sourceType);
                this.returnToParent(uri, localName, qName);
            } else if (localName.equals("OclConstraint")) {
                GenericOclConstraint con = new GenericOclConstraint();
                this.constraint = con;
                con.setName(this.name);
                con.setStatus(this.status);
                if (!this.descriptions.isEmpty()) {
                    con.setComments(this.descriptions.toArray(new String[0]));
                }
                con.setText(this.text);
                this.returnToParent(uri, localName, qName);
            } else if (localName.equals("TextConstraint")) {
                GenericTextConstraint con = new GenericTextConstraint();
                this.constraint = con;
                con.setName(this.name);
                con.setStatus(this.status);
                con.setText(this.text);
                con.setType(this.type);
                this.returnToParent(uri, localName, qName);
            } else {
                this.result.addDebug(null, 30801, "ConstraintContentHandler", localName);
            }
        }
    }

    private void returnToParent(String uri, String localName, String qName) throws SAXException {
        this.parent.endElement(uri, localName, qName);
        this.reader.setContentHandler(this.parent);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }
}

