/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.Model.TextConstraintImpl;
import org.apache.commons.lang3.StringUtils;

public class GenericTextConstraint
extends TextConstraintImpl {
    public GenericTextConstraint() {
    }

    public GenericTextConstraint(TextConstraint constraint) {
        this.contextModelElmt = constraint.contextModelElmt();
        this.contextModelElmtType = constraint.contextModelElmtType();
        this.constraintName = constraint.name();
        this.constraintStatus = constraint.status();
        this.constraintText = constraint.text();
        this.constraintType = constraint.type();
    }

    public GenericTextConstraint(GenericClassInfo genCi, Constraint origCon) {
        this.contextModelElmt = genCi;
        this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        this.constraintName = origCon.name();
        this.constraintStatus = origCon.status();
        this.constraintText = origCon.text();
        this.constraintType = this.determineConstraintType(origCon);
    }

    public GenericTextConstraint(GenericPropertyInfo genPi, Constraint origCon) {
        this.contextModelElmt = genPi;
        this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        this.constraintName = origCon.name();
        this.constraintStatus = origCon.status();
        this.constraintText = origCon.text();
        this.constraintType = this.determineConstraintType(origCon);
    }

    private String determineConstraintType(Constraint constr) {
        String type = "OCL";
        if (constr instanceof TextConstraint && StringUtils.isBlank((CharSequence)(type = ((TextConstraint)constr).type()))) {
            type = "Text";
        }
        return type;
    }

    public void setContextModelElmt(Info contextModelElmt) {
        this.contextModelElmt = contextModelElmt;
    }

    public void setContextModelElmtType(Constraint.ModelElmtContextType contextModelElmtType) {
        this.contextModelElmtType = contextModelElmtType;
    }

    public void setName(String name) {
        this.constraintName = name;
    }

    public void setStatus(String status) {
        this.constraintStatus = status;
    }

    public void setText(String text) {
        this.constraintText = text;
    }

    public void setType(String type) {
        this.constraintType = type;
    }
}

