/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GenericPropertyInfo
extends PropertyInfoImpl
implements MessageSource {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected Multiplicity cardinality = null;
    protected boolean isNavigable = true;
    protected StructuredNumber sequenceNumber = null;
    protected Type typeInfo = null;
    protected boolean isDerived = false;
    protected boolean isReadOnly = false;
    protected boolean isAttribute = true;
    protected boolean isOrdered = false;
    protected boolean isUnique = true;
    protected boolean isComposition = false;
    protected boolean isAggregation = false;
    protected boolean isOwned = false;
    protected String initialValue = null;
    protected String inlineOrByReference = null;
    protected AssociationInfo association = null;
    protected List<Constraint> constraints = null;
    protected ClassInfo inClass = null;

    public GenericPropertyInfo() {
    }

    public GenericPropertyInfo(GenericModel model, String id, String name) {
        this.model = model;
        this.options = model.options();
        this.result = model.result();
        this.setId(id);
        this.setName(name);
        this.cardinality = new Multiplicity("1");
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public void setInClass(ClassInfo inClass) {
        this.inClass = inClass;
    }

    public void setAssociation(AssociationInfo association) {
        this.association = association;
    }

    @Override
    public boolean isDerived() {
        return this.isDerived;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public boolean isNavigable() {
        return this.isNavigable;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isOwned() {
        return this.isOwned;
    }

    public boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    @Override
    public boolean isComposition() {
        return this.isComposition;
    }

    @Override
    public boolean isAggregation() {
        return this.isAggregation;
    }

    @Override
    public Multiplicity cardinality() {
        return this.cardinality;
    }

    @Override
    public String initialValue() {
        return this.initialValue;
    }

    @Override
    public String inlineOrByReference() {
        if (this.inlineOrByReference == null) {
            return "inlineOrByReference";
        }
        return this.inlineOrByReference;
    }

    @Override
    public ClassInfo inClass() {
        return this.inClass;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.inClass = (GenericClassInfo)ci;
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public List<Constraint> constraints() {
        if (this.constraints != null) {
            return this.constraints;
        }
        return new ArrayList<Constraint>(1);
    }

    @Override
    public AssociationInfo association() {
        return this.association;
    }

    public void setCardinality(Multiplicity cardinality) {
        this.cardinality = cardinality;
    }

    public void setConstraints(List<Constraint> list) {
        this.constraints = list != null && !list.isEmpty() ? list : null;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue != null ? this.options.internalize(initialValue) : null;
    }

    public void setInlineOrByReference(String inlineOrByReference) {
        this.inlineOrByReference = inlineOrByReference != null && !inlineOrByReference.equalsIgnoreCase("inlineOrByReference") ? this.options.internalize(inlineOrByReference) : null;
    }

    public void setAggregation(boolean isAggregation) {
        this.isAggregation = isAggregation;
    }

    public void setComposition(boolean isComposition) {
        this.isComposition = isComposition;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    public void setNavigable(boolean isNavigable) {
        this.isNavigable = isNavigable;
    }

    public void setOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public void setQualifiers(Vector<Qualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public void setOwned(boolean isOwned) {
        this.isOwned = isOwned;
    }

    public void setSequenceNumber(StructuredNumber sequenceNumber, boolean updateTaggedValue) {
        this.sequenceNumber = sequenceNumber;
        if (updateTaggedValue) {
            this.setTaggedValue("sequenceNumber", this.sequenceNumber.getString(), false);
        }
    }

    public void setTypeInfo(Type typeInfo) {
        this.typeInfo = typeInfo;
    }

    public void copyTypeInfo(Type typeInfo) {
        if (this.typeInfo == null) {
            this.typeInfo = new Type();
        }
        this.typeInfo.id = typeInfo.id;
        this.typeInfo.name = typeInfo.name;
    }

    public void setNilReasonAllowed(boolean nilReasonAllowed) {
        this.nilReasonAllowed = nilReasonAllowed;
    }

    public void setRestriction(boolean isRestriction) {
        this.restriction = isRestriction;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GenericModel model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    public void setId(String id) {
        this.id = this.options.internalize(id);
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = this.options.internalize(name);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    public void setStereotypes(Stereotypes stereotypeSet) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotypeSet != null && !stereotypeSet.isEmpty()) {
            for (String st : stereotypeSet.asArray()) {
                this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(st)));
            }
        }
    }

    public void setStereotype(String stereotype) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotype != null) {
            this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(stereotype)));
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory();
        }
    }

    public void setTaggedValues(TaggedValues taggedValues, boolean updateFields) {
        this.taggedValuesCache = this.options().taggedValueFactory(taggedValues);
        if (updateFields && !this.taggedValuesCache.isEmpty()) {
            for (String key : taggedValues.keySet()) {
                this.updateFieldsForTaggedValue(key, this.taggedValuesCache.getFirstValue(key));
            }
        }
    }

    public GenericPropertyInfo createCopy(String copyId) {
        GenericPropertyInfo copy = new GenericPropertyInfo(this.model, copyId, this.name);
        copy.setDescriptors(this.descriptors().createCopy());
        copy.setProfiles(this.profiles().createCopy());
        this.validateTaggedValuesCache();
        if (this.taggedValuesCache != null && !this.taggedValuesCache.isEmpty()) {
            copy.setTaggedValues(this.taggedValuesCache, false);
        }
        copy.setStereotypes(this.stereotypesCache);
        copy.setDerived(this.isDerived);
        copy.setReadOnly(this.isReadOnly);
        copy.setAttribute(this.isAttribute);
        copy.copyTypeInfo(this.typeInfo);
        copy.setNavigable(this.isNavigable);
        copy.setOrdered(this.isOrdered);
        copy.setUnique(this.isUnique);
        copy.setOwned(this.isOwned);
        copy.setComposition(this.isComposition);
        copy.setAggregation(this.isAggregation);
        copy.setCardinality(new Multiplicity(this.cardinality.toString()));
        copy.setInitialValue(this.initialValue);
        copy.setInlineOrByReference(this.inlineOrByReference);
        copy.setInClass(this.inClass);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.sequenceNumber.components.length - 1; ++i) {
            sb.append(this.sequenceNumber.components[i] + ".");
        }
        sb.append(this.sequenceNumber.components[this.sequenceNumber.components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        copy.setSequenceNumber(res, false);
        copy.setConstraints(this.constraints);
        copy.setAssociation(this.association);
        copy.setRestriction(this.restriction);
        copy.setNilReasonAllowed(this.nilReasonAllowed);
        return copy;
    }

    public String printAsString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        sb.append(indent + indent + "tagged values: ");
        this.validateTaggedValuesCache();
        if (this.taggedValuesCache == null || this.taggedValuesCache.isEmpty()) {
            sb.append("none");
        } else {
            sb.append(this.taggedValuesCache.toString());
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setTaggedValue(String tvName, String tvValue, boolean updateFields) {
        this.validateTaggedValuesCache();
        this.taggedValuesCache.put(tvName, tvValue);
        if (updateFields) {
            this.updateFieldsForTaggedValue(tvName, tvValue);
        }
    }

    protected void updateFieldsForTaggedValue(String tvName, String tvValue) {
        if (tvName.equalsIgnoreCase("nilReasonAllowed")) {
            if (tvValue.equalsIgnoreCase("true")) {
                this.setNilReasonAllowed(true);
            } else if (tvValue.equalsIgnoreCase("false")) {
                this.setNilReasonAllowed(false);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 1, tvName, tvValue);
                if (mc != null) {
                    mc.addDetail(this, 0, this.fullName());
                }
            }
        } else if (tvName.equalsIgnoreCase("inlineOrByReference")) {
            if (tvValue.equalsIgnoreCase("inline")) {
                this.setInlineOrByReference("inline");
            } else if (tvValue.equalsIgnoreCase("byReference")) {
                this.setInlineOrByReference("byreference");
            } else if (tvValue.equalsIgnoreCase("inlineOrByReference")) {
                this.setInlineOrByReference("inlineOrByReference");
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 2, tvName, tvValue);
                if (mc != null) {
                    mc.addDetail(this, 0, this.fullName());
                }
            }
        } else if (tvName.equalsIgnoreCase("sequenceNumber")) {
            this.setSequenceNumber(new StructuredNumber(tvValue), false);
        } else if (tvName.equalsIgnoreCase("profiles")) {
            this.profiles = null;
            super.profiles();
        }
    }

    public void addPrefixToModelElementIDs(String prefix) {
        this.id = prefix + this.id;
        if (this.typeInfo.id != null) {
            this.typeInfo.id = prefix + this.typeInfo.id;
        }
    }

    public void setProfiles(Profiles profiles) {
        this.profiles = profiles == null ? new Profiles() : profiles;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "(GenericPropertyInfo) When setting tagged value '$1$', a boolean value (either 'false' or 'true') was expected. Found '$2$' - cannot set field(s) for this tagged value.";
            }
            case 2: {
                return "(GenericPropertyInfo) When setting tagged value '$1$', one of the values 'inline', 'byReference', or 'inlineOrByReference' was expected. Found '$2$' - cannot set field for this tagged value.";
            }
        }
        return "(" + GenericPropertyInfo.class.getName() + ") Unknown message with number: " + mnr;
    }
}

