/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GenericPackageInfo
extends PackageInfoImpl
implements MessageSource {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected GenericPackageInfo owner = null;
    protected SortedSet<GenericPackageInfo> childPi = null;
    protected SortedSet<String> supplierIds = null;
    protected SortedSet<GenericClassInfo> classes = new TreeSet<GenericClassInfo>();

    @Override
    public SortedSet<PackageInfo> containedPackages() {
        TreeSet<GenericPackageInfo> children = null;
        if (this.childPi != null) {
            children = new TreeSet<GenericPackageInfo>((Collection<GenericPackageInfo>)this.childPi);
        }
        return children;
    }

    public Set<GenericPackageInfo> getAllPackages(Set<GenericPackageInfo> set) {
        if (set == null) {
            return null;
        }
        if (!this.childPi.isEmpty()) {
            for (PackageInfo packageInfo : this.childPi) {
                if (!(packageInfo instanceof GenericPackageInfo)) continue;
                ((GenericPackageInfo)packageInfo).getAllPackages(set);
            }
        }
        set.add(this);
        return set;
    }

    public SortedSet<GenericClassInfo> getClasses() {
        return this.classes;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Model model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public PackageInfo owner() {
        return this.owner;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    public void setClasses(SortedSet<GenericClassInfo> genericClassInfos) {
        this.classes = genericClassInfos;
    }

    public void setContainedPackages(SortedSet<GenericPackageInfo> childPi) {
        this.childPi = childPi;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setOwner(GenericPackageInfo owner) {
        this.owner = owner;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    public void setStereotypes(Stereotypes stereotypeSet) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotypeSet != null && !stereotypeSet.isEmpty()) {
            for (String st : stereotypeSet.asArray()) {
                this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(st)));
            }
        }
    }

    public void setStereotype(String stereotype) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotype != null) {
            this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(stereotype)));
        }
    }

    public void setSupplierIds(SortedSet<String> supplierIds) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            this.supplierIds = null;
        } else {
            this.supplierIds = new TreeSet<String>();
            for (String supplierId : supplierIds) {
                this.supplierIds.add(this.options.internalize(supplierId));
            }
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory();
        }
    }

    public void setTaggedValues(TaggedValues taggedValues, boolean updateFields) {
        this.taggedValuesCache = this.options().taggedValueFactory(taggedValues);
        if (!updateFields || !this.taggedValuesCache.isEmpty()) {
            // empty if block
        }
    }

    public void setTargetNamespace(String targetNamespace) {
        TaggedValues tmp = this.taggedValuesAll();
        tmp.put("targetNamespace", targetNamespace);
        this.setTaggedValues(tmp, false);
    }

    public void setVersion(String version) {
        TaggedValues tmp = this.taggedValuesAll();
        tmp.put("version", version);
        this.setTaggedValues(tmp, false);
    }

    public void setXmlns(String xmlns) {
        TaggedValues tmp = this.taggedValuesAll();
        tmp.put("xmlns", xmlns);
        this.setTaggedValues(tmp, false);
    }

    public void setXsdDocument(String xsdDocument) {
        TaggedValues tmp = this.taggedValuesAll();
        tmp.put("xsdDocument", xsdDocument);
        this.setTaggedValues(tmp, false);
    }

    @Override
    public SortedSet<String> supplierIds() {
        if (this.supplierIds == null) {
            return new TreeSet<String>();
        }
        return this.supplierIds;
    }

    public void getEmptyPackages(Set<PackageInfo> containerForEmptyPackages) {
        if (this.childPi == null || this.childPi.isEmpty()) {
            if (this.classes == null || this.classes.isEmpty()) {
                containerForEmptyPackages.add(this);
            }
        } else {
            for (PackageInfo packageInfo : this.childPi) {
                if (!(packageInfo instanceof GenericPackageInfo)) continue;
                ((GenericPackageInfo)packageInfo).getEmptyPackages(containerForEmptyPackages);
            }
            if (containerForEmptyPackages.containsAll(this.childPi) && (this.classes == null || this.classes.isEmpty())) {
                containerForEmptyPackages.add(this);
            }
        }
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        if (this.classes != null && this.classes.size() != 0) {
            sb.append(indent + "classes:\n");
            for (ClassInfo classInfo : this.classes) {
                sb.append(indent + indent + classInfo.name() + "\n");
            }
        } else {
            sb.append(indent + "<no classes>\n");
        }
        if (this.childPi != null && this.childPi.size() > 0) {
            sb.append(indent + "packages:\n");
            for (PackageInfo packageInfo : this.childPi) {
                if (packageInfo instanceof GenericPackageInfo) {
                    sb.append(((GenericPackageInfo)packageInfo).toString(indent + indent));
                    continue;
                }
                sb.append(indent + indent + packageInfo.name() + "(not a GenericPackageInfo\n");
            }
        } else {
            sb.append(indent + "<no child packages>\n");
        }
        return sb.toString();
    }

    public void addClass(GenericClassInfo ci) {
        if (ci != null) {
            this.classes.add(ci);
        }
    }

    void remove(ClassInfo ciToRemove) {
        if (ciToRemove != null) {
            this.classes.remove(ciToRemove);
        }
    }

    void removeChild(GenericPackageInfo piToRemove) {
        if (piToRemove != null) {
            this.childPi.remove(piToRemove);
        }
    }

    public void addPrefixToModelElementIDs(String prefix) {
        this.id = prefix + this.id;
        if (this.supplierIds != null) {
            TreeSet<String> tmp_supplierIds = new TreeSet<String>();
            for (String id : this.supplierIds) {
                tmp_supplierIds.add(prefix + id);
            }
            this.supplierIds = tmp_supplierIds;
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 30500: {
                return "(GenericPackageInfo.java) Child package '$1$' of package '$2$' is not an application schema but also not an instance of GenericPackageInfo. Cannot set the target namespace on '$3$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

