/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraintImpl;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.OclParser;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.StringReader;

public class GenericOclConstraint
extends OclConstraintImpl {
    public GenericOclConstraint() {
    }

    public GenericOclConstraint(GenericClassInfo ci, OclConstraint constr) {
        this.contextClass = ci;
        this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        this.contextModelElmt = ci;
        this.comments = constr.comments();
        this.initializeNonContextFields(constr.name(), constr.status(), constr.text(), this.contextModelElmt);
    }

    public GenericOclConstraint(GenericClassInfo ci, String constrName, String constrStatus, String constrText) {
        this.contextClass = ci;
        this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        this.contextModelElmt = ci;
        this.initializeNonContextFields(constrName, constrStatus, constrText, this.contextModelElmt);
    }

    private void initializeNonContextFields(String constrName, String constrStatus, String constrText, Info contextModelElement) {
        this.constraintName = constrName;
        this.constraintStatus = constrStatus;
        this.constraintText = constrText;
        this.syntaxTree = null;
        StringReader instream = new StringReader(this.constraintText);
        OclParser parse = new OclParser();
        this.syntaxTree = parse.parseOcl(instream, this.contextModelElmt);
        if (this.syntaxTree != null) {
            this.conditionType = this.syntaxTree.expressionType;
        }
        this.mergeComments(parse.getComments());
        if (parse.getNumberOfMessages() > 0) {
            String ctxType;
            Object ctx;
            if (this.contextModelElmtType == Constraint.ModelElmtContextType.CLASS) {
                ctx = contextModelElement.name();
                ctxType = "class";
            } else {
                ctx = this.contextClass.name() + "." + contextModelElement.name();
                ctxType = "property";
            }
            ShapeChangeResult.MessageContext messctx = contextModelElement.result().addInfo(null, 133, (String)ctx, this.constraintName, ctxType);
            if (messctx != null) {
                MessageCollection.Message[] msg;
                MessageCollection messages = parse.getMessageCollection();
                for (MessageCollection.Message m : msg = messages.getMessages()) {
                    String[] del = new String[]{"/", "-", ","};
                    String sr = m.getFormattedSourceReferences(1, 1, del);
                    String ms = m.getMessageText();
                    messctx.addDetail(null, 134, sr, ms);
                }
                String includeConstraintInMessages = contextModelElement.options().parameter("includeConstraintInMessages");
                if (includeConstraintInMessages != null && includeConstraintInMessages.equals("true")) {
                    messctx.addDetail("Constraint: " + this.constraintText);
                }
            }
        }
    }

    public GenericOclConstraint(GenericPropertyInfo pi, OclConstraint constr) {
        this.contextClass = pi.inClass();
        this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        this.contextModelElmt = pi;
        this.comments = constr.comments();
        this.initializeNonContextFields(constr.name(), constr.status(), constr.text(), this.contextModelElmt);
    }

    public GenericOclConstraint(PropertyInfo pi, String constrName, String constrStatus, String constrText) {
        this.contextClass = pi.inClass();
        this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        this.contextModelElmt = pi;
        this.initializeNonContextFields(constrName, constrStatus, constrText, this.contextModelElmt);
    }

    GenericOclConstraint(OclConstraint constr) {
        this.contextClass = constr.contextClass();
        this.contextModelElmt = constr.contextModelElmt();
        this.contextModelElmtType = constr.contextModelElmtType();
        this.constraintName = constr.name();
        this.constraintStatus = constr.status();
        this.constraintText = constr.text();
        this.syntaxTree = null;
        this.conditionType = null;
        this.comments = constr.comments();
    }

    public void setContext(ClassInfo contextClass, Info contextModelElement) {
        this.contextModelElmt = contextModelElement;
        this.contextClass = contextClass;
        if (contextModelElement instanceof PropertyInfo) {
            this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        } else if (contextModelElement instanceof ClassInfo) {
            this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        }
    }

    public void setContextModelElmt(Info contextModelElmt) {
        this.contextModelElmt = contextModelElmt;
    }

    public void setContextModelElmtType(Constraint.ModelElmtContextType contextModelElmtType) {
        this.contextModelElmtType = contextModelElmtType;
    }

    public void setName(String name) {
        this.constraintName = name;
    }

    public void setStatus(String status) {
        this.constraintStatus = status;
    }

    public void setText(String text) {
        this.constraintText = text;
    }
}

