/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.FolConstraintImpl;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericFolConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericOclConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericTextConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.ConstraintContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericAssociationContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericClassContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericModelErrorHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericPackageContentHandler;
import de.interactive_instruments.ShapeChange.Model.Generic.reader.GenericPropertyContentHandler;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraintImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.Model.TextConstraintImpl;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.SBVR.Sbvr2FolParser;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenericModel
extends ModelImpl
implements MessageSource {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected String characterEncoding = null;
    protected boolean loadingFromScxml = false;
    protected Map<String, GenericPropertyInfo> genPropertiesById = new HashMap<String, GenericPropertyInfo>();
    protected Map<String, GenericAssociationInfo> genAssociationInfosById = new HashMap<String, GenericAssociationInfo>();
    protected Map<String, GenericClassInfo> genClassInfosById = new HashMap<String, GenericClassInfo>();
    protected Map<String, GenericClassInfo> genClassInfosByName = new HashMap<String, GenericClassInfo>();
    protected Map<String, GenericPackageInfo> genPackageInfosById = new HashMap<String, GenericPackageInfo>();

    public GenericModel() {
    }

    public GenericModel(Model model) {
        this.options = model.options();
        this.result = model.result();
        this.characterEncoding = model.characterEncoding();
        for (PackageInfo piToCreate : model.packages()) {
            this.createGenericPackageInfo(piToCreate, this);
        }
        for (PackageInfo pi : model.packages()) {
            GenericPackageInfo genericPackageInfo = this.genPackageInfosById.get(pi.id());
            if (genericPackageInfo == null || pi.owner() == null) continue;
            GenericPackageInfo owner = this.genPackageInfosById.get(pi.owner().id());
            genericPackageInfo.setOwner(owner);
        }
        for (ClassInfo ci : model.classes()) {
            PackageInfo packageInfo = ci.pkg();
            Object genPi = null;
            if (packageInfo != null) {
                genPi = this.genPackageInfosById.get(packageInfo.id());
            }
            GenericClassInfo genCi = new GenericClassInfo(this, ci.id(), ci.name(), ci.category());
            genCi.setTaggedValues(ci.taggedValuesAll(), false);
            genCi.setStereotypes(ci.stereotypes());
            genCi.setDescriptors(ci.descriptors().createCopy());
            genCi.setProfiles(ci.profiles().createCopy());
            genCi.setPkg(ci.pkg());
            genCi.setIsAbstract(ci.isAbstract());
            genCi.setIsLeaf(ci.isLeaf());
            genCi.setAssocInfo(ci.isAssocClass());
            genCi.setSupertypes(this.copy(ci.supertypes()));
            genCi.setSubtypes(this.copy(ci.subtypes()));
            genCi.setProperties(ci.properties());
            genCi.setDirectConstraints(this.copy(ci.directConstraints()));
            genCi.setDiagrams(ci.getDiagrams());
            genCi.setLinkedDocument(ci.getLinkedDocument());
            this.register(genCi);
            if (genPi == null) continue;
            ((GenericPackageInfo)genPi).addClass(genCi);
        }
        for (GenericClassInfo genCi : this.genClassInfosById.values()) {
            SortedMap<StructuredNumber, PropertyInfo> sortedMap = genCi.properties();
            if (sortedMap == null) continue;
            for (PropertyInfo pi : sortedMap.values()) {
                if (this.genPropertiesById.containsKey(pi.id())) {
                    GenericPropertyInfo genericPropertyInfo = this.genPropertiesById.get(pi.id());
                    this.result.addWarning(this, 30318, pi.id(), pi.name(), genCi.name(), genericPropertyInfo.name() + " / " + genericPropertyInfo.inClass().name());
                    continue;
                }
                GenericPropertyInfo genericPropertyInfo = new GenericPropertyInfo(this, pi.id(), pi.name());
                genericPropertyInfo.setTaggedValues(pi.taggedValuesAll(), false);
                genericPropertyInfo.setStereotypes(pi.stereotypes());
                genericPropertyInfo.setDescriptors(pi.descriptors().createCopy());
                genericPropertyInfo.setProfiles(pi.profiles().createCopy());
                genericPropertyInfo.setDerived(pi.isDerived());
                genericPropertyInfo.setReadOnly(pi.isReadOnly());
                genericPropertyInfo.setAttribute(pi.isAttribute());
                genericPropertyInfo.copyTypeInfo(pi.typeInfo());
                genericPropertyInfo.setNavigable(pi.isNavigable());
                genericPropertyInfo.setOrdered(pi.isOrdered());
                genericPropertyInfo.setUnique(pi.isUnique());
                genericPropertyInfo.setOwned(pi.isOwned());
                genericPropertyInfo.setComposition(pi.isComposition());
                genericPropertyInfo.setAggregation(pi.isAggregation());
                Multiplicity mult = pi.cardinality();
                Multiplicity multC = new Multiplicity();
                multC.maxOccurs = mult.maxOccurs;
                multC.minOccurs = mult.minOccurs;
                genericPropertyInfo.setCardinality(multC);
                genericPropertyInfo.setInitialValue(pi.initialValue());
                genericPropertyInfo.setInlineOrByReference(pi.inlineOrByReference());
                genericPropertyInfo.setInClass(pi.inClass());
                StructuredNumber strucNum = pi.sequenceNumber();
                genericPropertyInfo.setSequenceNumber(this.copy(strucNum), true);
                genericPropertyInfo.setConstraints(this.copy(pi.constraints()));
                genericPropertyInfo.setAssociation(pi.association());
                genericPropertyInfo.setRestriction(pi.isRestriction());
                genericPropertyInfo.setNilReasonAllowed(pi.nilReasonAllowed());
                this.genPropertiesById.put(genericPropertyInfo.id, genericPropertyInfo);
            }
        }
        HashMap<String, GenericPropertyInfo> additionalPropsFromAssociationEnds = new HashMap<String, GenericPropertyInfo>();
        for (GenericPropertyInfo genericPropertyInfo : this.genPropertiesById.values()) {
            AssociationInfo ai = genericPropertyInfo.association();
            if (ai == null || this.genAssociationInfosById.containsKey(ai.id())) continue;
            GenericAssociationInfo genAi = this.createCopy(ai, ai.id());
            if (!this.genPropertiesById.containsKey(ai.end1().id()) && !additionalPropsFromAssociationEnds.containsKey(ai.end1().id())) {
                GenericPropertyInfo genericPropertyInfo2 = this.createAssociationEndCopy(ai.end1());
                additionalPropsFromAssociationEnds.put(genericPropertyInfo2.id(), genericPropertyInfo2);
            }
            if (!this.genPropertiesById.containsKey(ai.end2().id()) && !additionalPropsFromAssociationEnds.containsKey(ai.end2().id())) {
                GenericPropertyInfo genericPropertyInfo3 = this.createAssociationEndCopy(ai.end2());
                additionalPropsFromAssociationEnds.put(genericPropertyInfo3.id(), genericPropertyInfo3);
            }
            this.genAssociationInfosById.put(genAi.id(), genAi);
        }
        for (GenericPropertyInfo genericPropertyInfo : additionalPropsFromAssociationEnds.values()) {
            this.genPropertiesById.put(genericPropertyInfo.id(), genericPropertyInfo);
        }
        for (GenericPackageInfo genericPackageInfo : this.genPackageInfosById.values()) {
            TreeSet<GenericPackageInfo> childPi_update = new TreeSet<GenericPackageInfo>();
            for (PackageInfo packageInfo : genericPackageInfo.containedPackages()) {
                childPi_update.add(this.updatePackageInfo(packageInfo));
            }
            genericPackageInfo.setContainedPackages(childPi_update);
            TreeSet<GenericClassInfo> classes_update = new TreeSet<GenericClassInfo>();
            for (GenericClassInfo cI : genericPackageInfo.getClasses()) {
                classes_update.add(this.updateClassInfo(cI));
            }
            genericPackageInfo.setClasses(classes_update);
        }
        for (GenericClassInfo genericClassInfo : this.genClassInfosById.values()) {
            PackageInfo pkg = genericClassInfo.pkg();
            genericClassInfo.setPkg(this.updatePackageInfo(pkg));
            AssociationInfo assoClass = genericClassInfo.isAssocClass();
            genericClassInfo.setAssocInfo(this.updateAssociationInfo(assoClass));
            SortedMap<StructuredNumber, PropertyInfo> sortedMap = genericClassInfo.properties();
            TreeMap<StructuredNumber, PropertyInfo> propertiesC = new TreeMap<StructuredNumber, PropertyInfo>();
            for (PropertyInfo origPi : sortedMap.values()) {
                PropertyInfo pValue = this.updatePropertyInfo(origPi);
                if (pValue == null) {
                    this.result.addError(this, 30321, origPi.name(), genericClassInfo.name());
                    continue;
                }
                if (pValue instanceof GenericPropertyInfo && !pValue.inClass().id().equals(genericClassInfo.id())) {
                    if (this.options().isAIXM()) {
                        propertiesC.put(pValue.sequenceNumber(), pValue);
                        continue;
                    }
                    this.result.addError(this, 30319, origPi.name(), origPi.inClass().name(), pValue.inClass().name());
                    continue;
                }
                propertiesC.put(pValue.sequenceNumber(), pValue);
            }
            genericClassInfo.setProperties(propertiesC);
            List<Constraint> constraints = genericClassInfo.directConstraints();
            genericClassInfo.setDirectConstraints(this.updateContext(constraints, genericClassInfo));
        }
        for (GenericPropertyInfo genericPropertyInfo : this.genPropertiesById.values()) {
            ClassInfo inClass = genericPropertyInfo.inClass();
            genericPropertyInfo.setInClass(this.updateClassInfo(inClass));
            List<Constraint> constraints = genericPropertyInfo.constraints();
            genericPropertyInfo.setConstraints(this.updateContext(constraints, genericPropertyInfo));
            AssociationInfo associationInfo = genericPropertyInfo.association();
            genericPropertyInfo.setAssociation(this.updateAssociationInfo(associationInfo));
        }
        for (GenericAssociationInfo genericAssociationInfo : this.genAssociationInfosById.values()) {
            this.updateAssociationInfoContent(genericAssociationInfo);
        }
    }

    private GenericPropertyInfo createAssociationEndCopy(PropertyInfo assocEnd) {
        GenericPropertyInfo copy = this.createCopy(assocEnd, assocEnd.id());
        return copy;
    }

    public void register(GenericClassInfo genCi) {
        this.genClassInfosById.put(genCi.id, genCi);
        this.genClassInfosByName.put(genCi.name, genCi);
    }

    private Vector<Constraint> updateContext(List<Constraint> constraints, Info owner) {
        Vector<Constraint> results = new Vector<Constraint>();
        if (constraints != null) {
            for (Constraint con : constraints) {
                GenericClassInfo genCi;
                GenericPropertyInfo genPi;
                Constraint genCon;
                if (!(con instanceof GenericFolConstraint || con instanceof GenericTextConstraint || con instanceof GenericOclConstraint)) {
                    this.result.addError(this, 30300, con.name(), con.contextModelElmt().name());
                    continue;
                }
                Info contextModelElement = con.contextModelElmt();
                if (contextModelElement == null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("(GenericModel) contextModelElement for constraint named '" + con.name() + "' [" + con.text() + "] is null.");
                    if (owner instanceof PropertyInfo) {
                        PropertyInfo pi = (PropertyInfo)owner;
                        sb.append(" Omitting constraint in property '" + pi.name() + "' of class '" + pi.inClass().name() + "'.");
                    } else if (owner instanceof ClassInfo) {
                        ClassInfo ci = (ClassInfo)owner;
                        sb.append(" Omitting constraint in class '" + ci.name() + "'.");
                    } else {
                        sb.append(" Omitting constraint in Info class '" + owner.name() + "'.");
                    }
                    this.result.addError(this, 30301, sb.toString());
                    continue;
                }
                if (con instanceof FolConstraint) {
                    genCon = (GenericFolConstraint)con;
                    if (((FolConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.ATTRIBUTE)) {
                        genPi = this.genPropertiesById.get(contextModelElement.id());
                        if (genPi == null) {
                            this.result.addError(this, 30325, con.name(), contextModelElement.name());
                            continue;
                        }
                        ((FolConstraintImpl)genCon).setContextModelElmt(genPi);
                        results.add(genCon);
                        continue;
                    }
                    if (((FolConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.CLASS)) {
                        genCi = this.genClassInfosById.get(contextModelElement.id());
                        if (genCi == null) {
                            this.result.addError(this, 30326, con.name(), contextModelElement.name());
                            continue;
                        }
                        ((FolConstraintImpl)genCon).setContextModelElmt(genCi);
                        results.add(genCon);
                        continue;
                    }
                    this.result.addWarning(this, 30304, ((FolConstraintImpl)genCon).contextModelElmtType().name());
                    continue;
                }
                if (con instanceof TextConstraint) {
                    genCon = (GenericTextConstraint)con;
                    if (((TextConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.ATTRIBUTE)) {
                        genPi = this.genPropertiesById.get(contextModelElement.id());
                        if (genPi == null) {
                            this.result.addError(this, 30302, con.name(), contextModelElement.name());
                            continue;
                        }
                        ((GenericTextConstraint)genCon).setContextModelElmt(genPi);
                        results.add(genCon);
                        continue;
                    }
                    if (((TextConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.CLASS)) {
                        genCi = this.genClassInfosById.get(contextModelElement.id());
                        if (genCi == null) {
                            this.result.addError(this, 30303, con.name(), contextModelElement.name());
                            continue;
                        }
                        ((GenericTextConstraint)genCon).setContextModelElmt(genCi);
                        results.add(genCon);
                        continue;
                    }
                    this.result.addWarning(this, 30304, ((TextConstraintImpl)genCon).contextModelElmtType().name());
                    continue;
                }
                if (con instanceof OclConstraint) {
                    InfoImpl context;
                    genCon = (GenericOclConstraint)con;
                    if (((OclConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.ATTRIBUTE)) {
                        context = this.genPropertiesById.get(contextModelElement.id());
                        if (context == null) {
                            if (((OclConstraintImpl)genCon).contextClass() == null) {
                                this.result.addError(this, 30305, con.name(), contextModelElement.name());
                                continue;
                            }
                            this.result.addError(this, 30306, con.name(), contextModelElement.name(), ((OclConstraintImpl)genCon).contextClass().name());
                            continue;
                        }
                        ClassInfo inClass = context.inClass();
                        ((GenericOclConstraint)genCon).setContext(this.updateClassInfo(inClass), context);
                        results.add(genCon);
                        continue;
                    }
                    if (((OclConstraintImpl)genCon).contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.CLASS)) {
                        context = this.genClassInfosById.get(contextModelElement.id());
                        if (context == null) {
                            if (((OclConstraintImpl)genCon).contextClass() == null) {
                                this.result.addError(this, 30307, con.name(), contextModelElement.name());
                                continue;
                            }
                            this.result.addError(this, 30308, con.name(), contextModelElement.name(), ((OclConstraintImpl)genCon).contextClass().name());
                            continue;
                        }
                        ((GenericOclConstraint)genCon).setContext((ClassInfo)((Object)context), context);
                        results.add(genCon);
                        continue;
                    }
                    this.result.addWarning(this, 30304, ((OclConstraintImpl)genCon).contextModelElmtType().name());
                    continue;
                }
                this.result.addWarning(this, 30309, con.getClass().getName());
            }
        }
        return results;
    }

    public Vector<Constraint> copy(List<Constraint> constraints) {
        Vector<GenericFolConstraint> conCopies = null;
        if (constraints != null) {
            conCopies = new Vector<GenericFolConstraint>();
            for (Constraint con : constraints) {
                Constraint genCon;
                if (con instanceof FolConstraint) {
                    genCon = new GenericFolConstraint((FolConstraint)con);
                    conCopies.add((GenericFolConstraint)genCon);
                    continue;
                }
                if (con instanceof TextConstraint) {
                    genCon = new GenericTextConstraint((TextConstraint)con);
                    conCopies.add((GenericFolConstraint)genCon);
                    continue;
                }
                if (con instanceof OclConstraint) {
                    genCon = new GenericOclConstraint((OclConstraint)con);
                    conCopies.add((GenericFolConstraint)genCon);
                    continue;
                }
                this.result.addWarning(this, 30309, con.getClass().getName());
            }
        }
        return conCopies;
    }

    private void updateAssociationInfoContent(GenericAssociationInfo gai) {
        PropertyInfo end1 = gai.end1();
        gai.setEnd1(this.updatePropertyInfo(end1));
        PropertyInfo end2 = gai.end2();
        gai.setEnd2(this.updatePropertyInfo(end2));
        ClassInfo assocClass = gai.assocClass();
        gai.setAssocClass(this.updateClassInfo(assocClass));
    }

    private StructuredNumber copy(StructuredNumber strucNum) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strucNum.components.length - 1; ++i) {
            sb.append(strucNum.components[i] + ".");
        }
        sb.append(strucNum.components[strucNum.components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        return res;
    }

    private GenericPackageInfo updatePackageInfo(PackageInfo pIn) {
        if (pIn == null) {
            return null;
        }
        return this.genPackageInfosById.get(pIn.id());
    }

    private GenericClassInfo updateClassInfo(ClassInfo cIn) {
        if (cIn == null) {
            return null;
        }
        return this.genClassInfosById.get(cIn.id());
    }

    private PropertyInfo updatePropertyInfo(PropertyInfo pIn) {
        if (pIn == null) {
            return null;
        }
        if (this.genPropertiesById.containsKey(pIn.id())) {
            return this.genPropertiesById.get(pIn.id());
        }
        return pIn;
    }

    public void addClass(GenericClassInfo genCi) {
        this.genClassInfosById.put(genCi.id(), genCi);
        this.genClassInfosByName.put(genCi.name(), genCi);
        if (!(genCi.pkg() instanceof GenericPackageInfo)) {
            this.result.addError(this, 30310, genCi.pkg().name(), genCi.name());
            return;
        }
        this.genPackageInfosById.put(genCi.pkg().id(), (GenericPackageInfo)genCi.pkg());
        ((GenericPackageInfo)genCi.pkg()).addClass(genCi);
        if (genCi.isAssocClass() != null) {
            this.genAssociationInfosById.put(genCi.isAssocClass().id(), (GenericAssociationInfo)genCi.isAssocClass());
        }
        if (genCi.properties() != null && genCi.properties().size() > 0) {
            for (PropertyInfo pi : genCi.properties().values()) {
                this.genPropertiesById.put(pi.id(), (GenericPropertyInfo)pi);
            }
        }
    }

    private AssociationInfo updateAssociationInfo(AssociationInfo aIn) {
        if (aIn == null) {
            return null;
        }
        if (this.genAssociationInfosById.containsKey(aIn.id())) {
            return this.genAssociationInfosById.get(aIn.id());
        }
        return aIn;
    }

    private GenericPackageInfo createGenericPackageInfo(PackageInfo pi, GenericModel model) {
        if (this.genPackageInfosById.containsKey(pi.id())) {
            return this.genPackageInfosById.get(pi.id());
        }
        GenericPackageInfo genPi = new GenericPackageInfo();
        genPi.setOptions(pi.options());
        genPi.setResult(pi.result());
        genPi.setModel(model);
        genPi.setTaggedValues(pi.taggedValuesAll(), false);
        genPi.setStereotypes(pi.stereotypes());
        genPi.setId(pi.id());
        genPi.setName(pi.name());
        genPi.setDescriptors(pi.descriptors().createCopy());
        genPi.setDiagrams(pi.getDiagrams());
        TreeSet<GenericPackageInfo> genChildPi = new TreeSet<GenericPackageInfo>();
        for (PackageInfo childPi : pi.containedPackages()) {
            genChildPi.add(this.createGenericPackageInfo(childPi, this));
        }
        genPi.setContainedPackages(genChildPi);
        TreeSet<String> genSupIds = new TreeSet<String>();
        for (String supId : pi.supplierIds()) {
            genSupIds.add(supId);
        }
        genPi.setSupplierIds(genSupIds);
        this.genPackageInfosById.put(genPi.id(), genPi);
        return genPi;
    }

    public boolean isInAppSchema(PackageInfo pi) {
        if (this.selectedSchemas().contains(pi)) {
            return true;
        }
        if (pi.owner() != null) {
            return this.isInAppSchema(pi.owner());
        }
        return false;
    }

    public boolean isInAppSchema(ClassInfo ci) {
        return this.isInAppSchema(ci.pkg());
    }

    public boolean isKindOf(ClassInfo childCi, ClassInfo parentCi) {
        if (childCi.id().equals(parentCi.id())) {
            return true;
        }
        if (parentCi.subtypes() == null || parentCi.subtypes().isEmpty()) {
            return false;
        }
        SortedSet<String> parentCiSubtypeIds = parentCi.subtypes();
        for (String parentCiSubtypeId : parentCiSubtypeIds) {
            ClassInfo parentCiSubtype = this.classById(parentCiSubtypeId);
            if (!this.isKindOf(childCi, parentCiSubtype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.result = r;
        this.options = o;
        File modelfile = new File((String)repositoryFileName);
        boolean ex = true;
        if (!modelfile.exists()) {
            ex = false;
            if (!((String)repositoryFileName).toLowerCase().endsWith(".xml") && !((String)repositoryFileName).toLowerCase().endsWith(".zip")) {
                repositoryFileName = (String)repositoryFileName + ".xml";
                modelfile = new File((String)repositoryFileName);
                ex = modelfile.exists();
            }
        }
        if (!ex) {
            r.addFatalError(this, 25, (String)repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        boolean isZip = ((String)repositoryFileName).toLowerCase().endsWith(".zip");
        ZipFile zip = null;
        try {
            InputStream inputStream;
            ZipEntry zentry;
            Enumeration<? extends ZipEntry> entries;
            String scxmlXsdLocation = this.options.parameterAsString(null, "scxmlXsdLocation", null, false, true);
            if (scxmlXsdLocation != null) {
                InputStream inputStreamForValidation;
                if (isZip) {
                    zip = new ZipFile(modelfile);
                    entries = zip.entries();
                    if (entries.hasMoreElements()) {
                        zentry = entries.nextElement();
                        inputStreamForValidation = zip.getInputStream(zentry);
                        if (entries.hasMoreElements()) {
                            this.result.addWarning(this, 30327, (String)repositoryFileName, zentry.getName());
                        }
                    } else {
                        inputStreamForValidation = null;
                        this.result.addError(this, 30328, (String)repositoryFileName);
                    }
                } else {
                    inputStreamForValidation = new FileInputStream(modelfile);
                }
                if (inputStreamForValidation != null) {
                    StreamSource instanceDocument = new StreamSource(inputStreamForValidation);
                    System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/XML/XMLSchema/v1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory");
                    SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/XML/XMLSchema/v1.1");
                    Schema s = null;
                    try {
                        if (scxmlXsdLocation.startsWith("http")) {
                            s = sf.newSchema(new URL(scxmlXsdLocation));
                        } else {
                            File schemaFile = new File(scxmlXsdLocation);
                            s = sf.newSchema(schemaFile);
                        }
                    }
                    catch (SAXException e) {
                        this.result.addError(this, 30507, scxmlXsdLocation, e.getMessage());
                    }
                    catch (MalformedURLException e) {
                        this.result.addError(this, 30506, scxmlXsdLocation, e.getMessage());
                    }
                    if (s != null) {
                        Validator v = s.newValidator();
                        v.setFeature("http://apache.org/xml/features/validation/schema", true);
                        v.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                        GenericModelErrorHandler errorHandler = new GenericModelErrorHandler();
                        v.setErrorHandler(errorHandler);
                        v.validate(instanceDocument);
                        if (errorHandler.hasWarnings() || errorHandler.hasErrors()) {
                            this.result.addInfo(this, 30500);
                            if (errorHandler.hasWarnings()) {
                                List<String> warnings = errorHandler.warnings();
                                for (String w : warnings) {
                                    this.result.addInfo(this, 30502, w);
                                }
                            }
                            if (errorHandler.hasErrors()) {
                                List<String> errors = errorHandler.errors();
                                for (String e : errors) {
                                    this.result.addInfo(this, 30503, e);
                                }
                            }
                            this.result.addInfo(this, 30501);
                            if (errorHandler.hasErrors()) {
                                this.result.addFatalError(this, 30504);
                                throw new ShapeChangeAbortException();
                            }
                        } else {
                            this.result.addInfo(this, 30505);
                        }
                    }
                }
            }
            if (isZip) {
                zip = new ZipFile(modelfile);
                entries = zip.entries();
                if (entries.hasMoreElements()) {
                    zentry = entries.nextElement();
                    inputStream = zip.getInputStream(zentry);
                    if (entries.hasMoreElements()) {
                        this.result.addWarning(this, 30327, (String)repositoryFileName, zentry.getName());
                    }
                } else {
                    inputStream = null;
                    this.result.addError(this, 30328, (String)repositoryFileName);
                }
            } else {
                inputStream = new FileInputStream(modelfile);
            }
            if (inputStream != null) {
                GenericAssociationInfo genAi;
                GenericClassInfo genCi;
                GenericPackageInfo genPkg;
                InputSource is = new InputSource(inputStream);
                System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                GenericModelContentHandler modelHandler = new GenericModelContentHandler(this.result, this.options, xmlReader);
                xmlReader.setContentHandler(modelHandler);
                xmlReader.parse(is);
                this.characterEncoding = modelHandler.getEncoding();
                this.loadingFromScxml = true;
                if (this.options.parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false)) {
                    this.result.addDebug(this, 30401);
                }
                Map<String, GenericPackageContentHandler> packageHandlers = modelHandler.getAllPackageContentHandlers();
                HashMap<String, GenericClassContentHandler> classHandlers = new HashMap<String, GenericClassContentHandler>();
                HashMap<String, GenericAssociationContentHandler> associationHandlers = new HashMap<String, GenericAssociationContentHandler>();
                HashMap<String, Object> propertyHandlers = new HashMap<String, Object>();
                for (GenericPackageContentHandler pkgHandler : packageHandlers.values()) {
                    genPkg = pkgHandler.getGenericPackage();
                    genPkg.setModel(this);
                    genPkg.descriptors();
                    this.genPackageInfosById.put(genPkg.id(), pkgHandler.getGenericPackage());
                    for (GenericClassContentHandler clsHandler : pkgHandler.getClassContentHandlers()) {
                        genCi = clsHandler.getGenericClass();
                        genCi.setModel(this);
                        genCi.descriptors();
                        classHandlers.put(genCi.id(), clsHandler);
                        this.genClassInfosById.put(genCi.id(), genCi);
                        this.genClassInfosByName.put(genCi.name(), genCi);
                        for (GenericPropertyContentHandler propHandler : clsHandler.getPropertyContentHandlers()) {
                            GenericPropertyInfo genProp = propHandler.getGenericProperty();
                            genProp.setModel(this);
                            genProp.descriptors();
                            propertyHandlers.put(genProp.id(), propHandler);
                            this.genPropertiesById.put(genProp.id(), genProp);
                        }
                    }
                }
                for (GenericAssociationContentHandler assocHandler : modelHandler.getAssociationContentHandlers()) {
                    genAi = assocHandler.getGenericAssociationInfo();
                    genAi.setModel(this);
                    genAi.descriptors();
                    associationHandlers.put(genAi.id(), assocHandler);
                    this.genAssociationInfosById.put(genAi.id(), genAi);
                    GenericPropertyContentHandler end1Handler = assocHandler.getEnd1PropertyContentHandler();
                    GenericPropertyContentHandler end2Handler = assocHandler.getEnd2PropertyContentHandler();
                    if (end1Handler != null) {
                        GenericPropertyInfo genPropEnd1 = end1Handler.getGenericProperty();
                        genPropEnd1.setModel(this);
                        genPropEnd1.descriptors();
                        propertyHandlers.put(genPropEnd1.id(), end1Handler);
                        this.genPropertiesById.put(genPropEnd1.id(), genPropEnd1);
                    }
                    if (end2Handler == null) continue;
                    GenericPropertyInfo genPropEnd2 = end2Handler.getGenericProperty();
                    genPropEnd2.setModel(this);
                    genPropEnd2.descriptors();
                    propertyHandlers.put(genPropEnd2.id(), end2Handler);
                    this.genPropertiesById.put(genPropEnd2.id(), genPropEnd2);
                }
                for (GenericPackageContentHandler pkgHandler : packageHandlers.values()) {
                    genPkg = pkgHandler.getGenericPackage();
                    for (GenericPackageContentHandler childPkgHandler : pkgHandler.getChildPackageContentHandlers()) {
                        GenericPackageInfo childPkg = childPkgHandler.getGenericPackage();
                        childPkg.setOwner(genPkg);
                    }
                    for (GenericClassContentHandler clsHandler : pkgHandler.getClassContentHandlers()) {
                        genCi = clsHandler.getGenericClass();
                        genCi.setPkg(genPkg);
                    }
                }
                for (GenericClassContentHandler clsHandler : classHandlers.values()) {
                    GenericClassInfo genCi2 = clsHandler.getGenericClass();
                    if (clsHandler.getAssociationId() != null) {
                        genCi2.setAssocInfo(this.genAssociationInfosById.get(clsHandler.getAssociationId()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)clsHandler.getLinkedDocument())) {
                        File ldFile = new File(this.options.linkedDocumentsTmpDir(), clsHandler.getLinkedDocument());
                        if (!ldFile.exists()) {
                            this.result.addWarning(this, 30400, genCi2.id(), StringUtils.stripToEmpty((String)genCi2.name()), clsHandler.getLinkedDocument());
                        } else {
                            genCi2.setLinkedDocument(ldFile);
                        }
                    }
                    for (GenericPropertyContentHandler propHandler : clsHandler.getPropertyContentHandlers()) {
                        GenericPropertyInfo genPi = propHandler.getGenericProperty();
                        genPi.setInClass(genCi2);
                    }
                    for (ConstraintContentHandler conHandler : clsHandler.getConstraintContentHandlers()) {
                        this.updateConstraintContext(conHandler, genCi2);
                    }
                }
                for (GenericAssociationContentHandler assocHandler : associationHandlers.values()) {
                    genAi = assocHandler.getGenericAssociationInfo();
                    if (assocHandler.getAssocClassId() != null) {
                        genAi.setAssocClass(this.genClassInfosById.get(assocHandler.getAssocClassId()));
                    }
                    GenericPropertyInfo end1 = assocHandler.getEnd1Id() != null ? this.genPropertiesById.get(assocHandler.getEnd1Id()) : assocHandler.getEnd1PropertyContentHandler().getGenericProperty();
                    GenericPropertyInfo end2 = assocHandler.getEnd2Id() != null ? this.genPropertiesById.get(assocHandler.getEnd2Id()) : assocHandler.getEnd2PropertyContentHandler().getGenericProperty();
                    genAi.setEnd1(end1);
                    genAi.setEnd2(end2);
                }
                for (GenericPropertyContentHandler propHandler : propertyHandlers.values()) {
                    GenericPropertyInfo genPi = propHandler.getGenericProperty();
                    if (propHandler.getAssociationId() != null) {
                        genPi.setAssociation(this.genAssociationInfosById.get(propHandler.getAssociationId()));
                    }
                    if (propHandler.getInClassId() != null) {
                        genPi.setInClass(this.genClassInfosById.get(propHandler.getInClassId()));
                    }
                    for (ConstraintContentHandler conHandler : propHandler.getConstraintContentHandlers()) {
                        this.updateConstraintContext(conHandler, genPi);
                    }
                }
                for (GenericClassInfo genCi3 : this.genClassInfosById.values()) {
                    genCi3.establishCategory();
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.result.addFatalError(this, 30803, e.getMessage());
            throw new ShapeChangeAbortException();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    this.result.addFatalError(this, 30803, e.getMessage());
                    throw new ShapeChangeAbortException();
                }
            }
            this.loadingFromScxml = false;
        }
    }

    private void updateConstraintContext(ConstraintContentHandler conHandler, Info contextModelElement) {
        Constraint con = conHandler.getConstraint();
        Constraint.ModelElmtContextType contextModelElementType = Constraint.ModelElmtContextType.CLASS;
        if (contextModelElement instanceof PropertyInfo) {
            contextModelElementType = Constraint.ModelElmtContextType.ATTRIBUTE;
        }
        if (con instanceof GenericFolConstraint) {
            GenericFolConstraint genCon = (GenericFolConstraint)con;
            genCon.setContextModelElmt(contextModelElement);
            genCon.setContextModelElmtType(contextModelElementType);
        } else if (con instanceof GenericOclConstraint) {
            GenericOclConstraint genCon = (GenericOclConstraint)con;
            genCon.setContextModelElmt(contextModelElement);
            genCon.setContextModelElmtType(contextModelElementType);
        } else {
            GenericTextConstraint genCon = (GenericTextConstraint)con;
            genCon.setContextModelElmt(contextModelElement);
            genCon.setContextModelElmtType(contextModelElementType);
        }
    }

    @Override
    public SortedSet<ClassInfo> classes() {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        result.addAll(this.genClassInfosById.values());
        return result;
    }

    @Override
    public SortedSet<ClassInfo> classes(PackageInfo pi) {
        TreeSet<ClassInfo> res = new TreeSet<ClassInfo>();
        String tns = pi.targetNamespace();
        return this.addClasses(this.genPackageInfosById.get(pi.id()), tns, res);
    }

    private SortedSet<ClassInfo> addClasses(PackageInfo pi, String tns, SortedSet<ClassInfo> res) {
        String ctns = pi.targetNamespace();
        if (!(ctns == null || tns != null && tns.equals(ctns))) {
            return res;
        }
        if (pi instanceof GenericPackageInfo) {
            res.addAll(((GenericPackageInfo)pi).getClasses());
            for (PackageInfo cpi : pi.containedPackages()) {
                res = this.addClasses(cpi, tns, res);
            }
        }
        return res;
    }

    @Override
    public void postprocessAfterLoadingAndValidate() {
        if (this.options.isLoadConstraintsForSelectedSchemasOnly()) {
            for (GenericClassInfo genCi : this.genClassInfosById.values()) {
                if (this.isInSelectedSchemas(genCi)) continue;
                this.removeConstraintsOfClassAndItsProperties(genCi);
            }
        }
        HashSet<PackageInfo> genPkgsToRemove = new HashSet<PackageInfo>();
        Set<String> excludedPkgNames = this.options.getExcludedPackages();
        for (GenericPackageInfo genericPackageInfo : this.getGenPackages().values()) {
            if (!excludedPkgNames.contains(genericPackageInfo.name())) continue;
            genPkgsToRemove.add(genericPackageInfo);
        }
        this.exclude(genPkgsToRemove);
        super.postprocessAfterLoadingAndValidate();
        for (GenericClassInfo genericClassInfo : this.genClassInfosById.values()) {
            if (this.options.isClassTypeToCreateConstraintsFor(genericClassInfo.category())) continue;
            this.removeConstraintsOfClassAndItsProperties(genericClassInfo);
        }
        this.removeDuplicateConstraintsInSubtypes();
        this.validateConstraints();
        for (GenericPropertyInfo genericPropertyInfo : this.getGenProperties().values()) {
            ShapeChangeResult.MessageContext mc;
            if (genericPropertyInfo.inClass().category() != 3 && genericPropertyInfo.inClass().category() != 2) continue;
            if (genericPropertyInfo.isOrdered()) {
                genericPropertyInfo.setOrdered(false);
                mc = this.result.addDebug(this, 30330, "isOrdered", genericPropertyInfo.name(), "true");
                if (mc != null) {
                    mc.addDetail(this, 1, genericPropertyInfo.fullNameInSchema());
                }
            }
            if (!genericPropertyInfo.isUnique()) {
                genericPropertyInfo.setUnique(true);
                mc = this.result.addDebug(this, 30330, "isUnique", genericPropertyInfo.name(), "false");
                if (mc != null) {
                    mc.addDetail(this, 1, genericPropertyInfo.fullNameInSchema());
                }
            }
            if (genericPropertyInfo.isOwned()) {
                genericPropertyInfo.setOwned(false);
                mc = this.result.addDebug(this, 30330, "isOwned", genericPropertyInfo.name(), "true");
                if (mc != null) {
                    mc.addDetail(this, 1, genericPropertyInfo.fullNameInSchema());
                }
            }
            if (genericPropertyInfo.isComposition()) {
                genericPropertyInfo.setComposition(false);
                mc = this.result.addDebug(this, 30330, "isComposition", genericPropertyInfo.name(), "true");
                if (mc != null) {
                    mc.addDetail(this, 1, genericPropertyInfo.fullNameInSchema());
                }
            }
            if (!genericPropertyInfo.isAggregation()) continue;
            genericPropertyInfo.setAggregation(false);
            mc = this.result.addDebug(this, 30330, "isAggregation", genericPropertyInfo.name(), "true");
            if (mc == null) continue;
            mc.addDetail(this, 1, genericPropertyInfo.fullNameInSchema());
        }
    }

    private void removeDuplicateConstraintsInSubtypes() {
        for (ClassInfo classInfo : this.selectedSchemaClasses()) {
            GenericClassInfo genCi = (GenericClassInfo)classInfo;
            if (((TreeSet)genCi.supertypes()).isEmpty()) continue;
            SortedSet<ClassInfo> sts = genCi.supertypeClasses();
            List<Constraint> ciDirectCons = genCi.directConstraints();
            Vector<Constraint> newClassConstraints = new Vector<Constraint>();
            for (Constraint con : ciDirectCons) {
                boolean foundInSupertype = false;
                block2: for (ClassInfo st : sts) {
                    for (Constraint stCon : st.constraints()) {
                        if (!((String)StringUtils.defaultIfBlank((CharSequence)stCon.name(), (CharSequence)"")).trim().equals(((String)StringUtils.defaultIfBlank((CharSequence)con.name(), (CharSequence)"")).trim()) || !((String)StringUtils.defaultIfBlank((CharSequence)stCon.text(), (CharSequence)"")).trim().equals(((String)StringUtils.defaultIfBlank((CharSequence)con.text(), (CharSequence)"")).trim())) continue;
                        foundInSupertype = true;
                        break block2;
                    }
                }
                if (foundInSupertype) continue;
                newClassConstraints.add(con);
            }
            genCi.setDirectConstraints(newClassConstraints);
        }
    }

    private void removeConstraintsOfClassAndItsProperties(GenericClassInfo genCi) {
        if (genCi.hasDirectConstraints()) {
            genCi.setDirectConstraints(null);
        }
        for (PropertyInfo pi : genCi.properties().values()) {
            GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
            if (!genPi.hasConstraints()) continue;
            genPi.setConstraints(null);
        }
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.genPackageInfosById.get(id);
    }

    @Override
    public ClassInfo classById(String id) {
        return this.genClassInfosById.get(id);
    }

    @Override
    public ClassInfo classByName(String name) {
        return this.genClassInfosByName.get(name);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String characterEncoding() {
        return this.characterEncoding;
    }

    public TreeSet<String> copy(SortedSet<String> hs) {
        if (hs == null) {
            return null;
        }
        TreeSet<String> res = new TreeSet<String>();
        for (String s : hs) {
            res.add(s);
        }
        return res;
    }

    public String printToString(String indent) {
        StringBuffer sb = new StringBuffer();
        for (PackageInfo selectedSchema : this.selectedSchemas()) {
            sb.append("Selected schema: " + selectedSchema.name() + "\r\n");
        }
        if (this.genAssociationInfosById != null) {
            for (String assocInfoId : this.genAssociationInfosById.keySet()) {
                sb.append("Association Id: " + assocInfoId + "\r\n");
            }
        }
        if (this.genPackageInfosById != null) {
            for (String packageInfoId : this.genPackageInfosById.keySet()) {
                sb.append("Package full name: " + this.genPackageInfosById.get(packageInfoId).fullName() + "\r\n");
            }
        }
        if (this.genClassInfosById != null) {
            for (String classInfoId : this.genClassInfosById.keySet()) {
                sb.append("Class full name: " + this.genClassInfosById.get(classInfoId).fullName() + "\r\n");
            }
        }
        return sb.toString();
    }

    public void add(GenericPropertyInfo newProperty, ClassInfo classToAddProperty) {
        this.add(newProperty, classToAddProperty, PropertyCopyDuplicatBehaviorIndicator.ADD);
    }

    public void add(GenericPropertyInfo newProperty, ClassInfo classToAddProperty, PropertyCopyDuplicatBehaviorIndicator behavior) {
        ((GenericClassInfo)classToAddProperty).addProperty(newProperty, behavior);
    }

    public void add(List<GenericPropertyInfo> newProperties, PropertyCopyDuplicatBehaviorIndicator behavior) {
        if (newProperties == null || newProperties.isEmpty()) {
            return;
        }
        HashMap newPropsByInClass = new HashMap();
        for (GenericPropertyInfo newProp : newProperties) {
            List<GenericPropertyInfo> propsForInClass;
            GenericClassInfo inClass = (GenericClassInfo)newProp.inClass();
            if (newPropsByInClass.containsKey(inClass)) {
                propsForInClass = (List)newPropsByInClass.get(inClass);
            } else {
                propsForInClass = new ArrayList();
                newPropsByInClass.put(inClass, propsForInClass);
            }
            propsForInClass.add(newProp);
        }
        for (GenericClassInfo inClass : newPropsByInClass.keySet()) {
            inClass.addPropertiesInSequence((List)newPropsByInClass.get(inClass), behavior);
        }
    }

    public void add(GenericPropertyInfo newProperty, GenericClassInfo classToAddProperty, PropertyCopyPositionIndicator copyPositionIndicator, PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        ArrayList<GenericPropertyInfo> l = new ArrayList<GenericPropertyInfo>();
        l.add(newProperty);
        switch (copyPositionIndicator) {
            case PROPERTY_COPY_TOP: {
                classToAddProperty.addPropertiesAtTop(l, duplicateHandling);
                break;
            }
            case PROPERTY_COPY_INSEQUENCE: {
                classToAddProperty.addPropertiesInSequence(l, duplicateHandling);
                break;
            }
            case PROPERTY_COPY_BOTTOM: {
                classToAddProperty.addPropertiesAtBottom(l, duplicateHandling);
            }
        }
    }

    public void remove(GenericClassInfo ciToRemove) {
        this.remove(ciToRemove, false, false);
    }

    private void remove(GenericClassInfo ciToRemove, boolean keepAssociationProperties, boolean keepPropertiesWithTheTypeAsValueType) {
        SortedSet sortedSet;
        if (ciToRemove == null || !this.isInAppSchema(ciToRemove) || !this.genClassInfosById.containsKey(ciToRemove.id())) {
            return;
        }
        HashSet<PropertyInfo> propsToRemove = new HashSet<PropertyInfo>();
        HashSet<AssociationInfo> associationsToRemove = new HashSet<AssociationInfo>();
        for (PropertyInfo propertyInfo : ciToRemove.properties().values()) {
            propsToRemove.add(propertyInfo);
            AssociationInfo associationInfo = propertyInfo.association();
            if (associationInfo == null) continue;
            if (associationInfo.end1() != null) {
                propsToRemove.add(associationInfo.end1());
            }
            if (associationInfo.end2() != null) {
                propsToRemove.add(associationInfo.end2());
            }
            associationsToRemove.add(associationInfo);
        }
        for (PropertyInfo propertyInfo : this.genPropertiesById.values()) {
            AssociationInfo associationInfo;
            if (!propertyInfo.typeInfo().id.equals(ciToRemove.id())) continue;
            if (keepPropertiesWithTheTypeAsValueType) {
                propertyInfo.typeInfo().id = "REMOVED";
            } else {
                propsToRemove.add(propertyInfo);
            }
            if ((associationInfo = propertyInfo.association()) == null) continue;
            if (associationInfo.end1() != null) {
                if (keepPropertiesWithTheTypeAsValueType && associationInfo.end1().isNavigable() && associationInfo.end1().typeInfo().id.equals(ciToRemove.id())) {
                    associationInfo.end1().typeInfo().id = "REMOVED";
                    GenericPropertyInfo genEnd1 = (GenericPropertyInfo)associationInfo.end1();
                    genEnd1.setAssociation(null);
                    genEnd1.setComposition(true);
                    genEnd1.setAggregation(false);
                    genEnd1.setAttribute(true);
                } else {
                    propsToRemove.add(associationInfo.end1());
                }
            }
            if (associationInfo.end2() != null) {
                if (keepPropertiesWithTheTypeAsValueType && associationInfo.end2().isNavigable() && associationInfo.end2().typeInfo().id.equals(ciToRemove.id())) {
                    associationInfo.end2().typeInfo().id = "REMOVED";
                    GenericPropertyInfo genEnd2 = (GenericPropertyInfo)associationInfo.end2();
                    genEnd2.setAssociation(null);
                    genEnd2.setComposition(true);
                    genEnd2.setAggregation(false);
                    genEnd2.setAttribute(true);
                } else {
                    propsToRemove.add(associationInfo.end2());
                }
            }
            associationsToRemove.add(associationInfo);
        }
        AssociationInfo association2 = ciToRemove.isAssocClass();
        if (association2 != null) {
            if (!(association2.end1() == null || keepAssociationProperties && association2.end1().isNavigable())) {
                propsToRemove.add(association2.end1());
            }
            if (!(association2.end2() == null || keepAssociationProperties && association2.end2().isNavigable())) {
                propsToRemove.add(association2.end2());
            }
            associationsToRemove.add(association2);
        }
        for (PropertyInfo propertyInfo : propsToRemove) {
            if (propertyInfo instanceof GenericPropertyInfo) {
                GenericPropertyInfo propToRemove = (GenericPropertyInfo)propertyInfo;
                this.genPropertiesById.remove(propToRemove.id());
                if (propToRemove.inClass() instanceof GenericClassInfo) {
                    ((GenericClassInfo)propToRemove.inClass()).removePropertyById(propToRemove.id());
                    continue;
                }
                this.result.addError(this, 30313, propToRemove.inClass().name(), propToRemove.name);
                continue;
            }
            this.result.addWarning(this, 30312, propertyInfo.inClass().name(), propertyInfo.name());
        }
        for (AssociationInfo associationInfo : associationsToRemove) {
            this.genAssociationInfosById.remove(((GenericAssociationInfo)associationInfo).id());
            ClassInfo assocClass = associationInfo.assocClass();
            if (assocClass == null || assocClass == ciToRemove) continue;
            if (assocClass instanceof GenericClassInfo) {
                this.remove((GenericClassInfo)associationInfo.assocClass());
                continue;
            }
            this.result.addError(this, 30322, assocClass.name(), assocClass.id());
        }
        SortedSet sortedSet2 = ciToRemove.subtypes();
        if (sortedSet2 != null && sortedSet2.size() > 0) {
            for (String ciToRemoveSubtypeId : sortedSet2) {
                ClassInfo ciToRemoveSubtype = this.classById(ciToRemoveSubtypeId);
                if (ciToRemoveSubtype == null) {
                    this.result.addDebug(this, 30324, ciToRemove.name(), ciToRemoveSubtypeId);
                    continue;
                }
                if (!(ciToRemoveSubtype instanceof GenericClassInfo)) {
                    this.result.addWarning(this, 30323, ciToRemove.name(), ciToRemoveSubtype.name());
                    continue;
                }
                GenericClassInfo genCiToRemoveSubtype = (GenericClassInfo)ciToRemoveSubtype;
                genCiToRemoveSubtype.removeSupertype(ciToRemove.id());
            }
        }
        if ((sortedSet = ciToRemove.supertypes()) != null && sortedSet.size() > 0) {
            for (String ciToRemoveSupertypeId : sortedSet) {
                GenericClassInfo ciBase = this.genClassInfosById.get(ciToRemoveSupertypeId);
                if (ciBase != null) {
                    ciBase.removeSubtype(ciToRemove.id());
                    continue;
                }
                this.result.addError(this, 30314, ciToRemoveSupertypeId, ciToRemove.name);
            }
        }
        ((GenericPackageInfo)ciToRemove.pkg()).remove(ciToRemove);
        this.genClassInfosById.remove(ciToRemove.id());
        this.genClassInfosByName.remove(ciToRemove.name());
    }

    private void exclude(GenericClassInfo ci) {
        SortedSet sortedSet;
        if (ci == null || !this.genClassInfosById.containsKey(ci.id())) {
            return;
        }
        HashSet<PropertyInfo> propsToExclude = new HashSet<PropertyInfo>();
        HashSet<AssociationInfo> associationsToExclude = new HashSet<AssociationInfo>();
        for (PropertyInfo propertyInfo : ci.properties().values()) {
            propsToExclude.add(propertyInfo);
        }
        for (PropertyInfo propertyInfo : this.genPropertiesById.values()) {
            if (!propertyInfo.typeInfo().id.equals(ci.id())) continue;
            AssociationInfo associationInfo = propertyInfo.association();
            if (associationInfo != null) {
                if (associationInfo.end1() != null) {
                    if (associationInfo.end1().isNavigable() && associationInfo.end1().typeInfo().id.equals(ci.id())) {
                        associationInfo.end1().typeInfo().id = "unknown";
                        GenericPropertyInfo genEnd1 = (GenericPropertyInfo)associationInfo.end1();
                        genEnd1.setAssociation(null);
                        genEnd1.setComposition(true);
                        genEnd1.setAggregation(false);
                        genEnd1.setAttribute(true);
                    } else {
                        propsToExclude.add(associationInfo.end1());
                    }
                }
                if (associationInfo.end2() != null) {
                    if (associationInfo.end2().isNavigable() && associationInfo.end2().typeInfo().id.equals(ci.id())) {
                        associationInfo.end2().typeInfo().id = "unknown";
                        GenericPropertyInfo genEnd2 = (GenericPropertyInfo)associationInfo.end2();
                        genEnd2.setAssociation(null);
                        genEnd2.setComposition(true);
                        genEnd2.setAggregation(false);
                        genEnd2.setAttribute(true);
                    } else {
                        propsToExclude.add(associationInfo.end2());
                    }
                }
                associationsToExclude.add(associationInfo);
                continue;
            }
            propertyInfo.typeInfo().id = "unknown";
        }
        AssociationInfo association = ci.isAssocClass();
        if (association != null) {
            GenericAssociationInfo genericAssociationInfo = (GenericAssociationInfo)association;
            genericAssociationInfo.setAssocClass(null);
            ci.setAssocInfo(null);
        }
        for (PropertyInfo propertyInfo : propsToExclude) {
            GenericPropertyInfo propToRemove = (GenericPropertyInfo)propertyInfo;
            this.genPropertiesById.remove(propToRemove.id());
            if (propToRemove.inClass() == null) continue;
            ((GenericClassInfo)propToRemove.inClass()).removePropertyById(propToRemove.id());
        }
        for (AssociationInfo associationInfo : associationsToExclude) {
            GenericAssociationInfo genAi = (GenericAssociationInfo)associationInfo;
            this.genAssociationInfosById.remove(genAi.id());
            GenericClassInfo assocClass = (GenericClassInfo)genAi.assocClass();
            if (assocClass == null) continue;
            genAi.setAssocClass(null);
            assocClass.setAssocInfo(null);
        }
        SortedSet sortedSet2 = ci.subtypes();
        if (sortedSet2.size() > 0) {
            for (String ciSubtypeId : sortedSet2) {
                ClassInfo ciSubtype = this.classById(ciSubtypeId);
                if (ciSubtype == null) continue;
                GenericClassInfo genCiSubtype = (GenericClassInfo)ciSubtype;
                genCiSubtype.removeSupertype(ci.id());
            }
        }
        if ((sortedSet = ci.supertypes()).size() > 0) {
            for (String ciSupertypeId : sortedSet) {
                GenericClassInfo ciBase = this.genClassInfosById.get(ciSupertypeId);
                if (ciBase == null) continue;
                ciBase.removeSubtype(ci.id());
            }
        }
        ((GenericPackageInfo)ci.pkg()).remove(ci);
        this.genClassInfosById.remove(ci.id());
        this.genClassInfosByName.remove(ci.name());
    }

    public void remove(Collection<GenericClassInfo> cisToRemove) {
        if (cisToRemove == null || cisToRemove.size() == 0) {
            return;
        }
        for (GenericClassInfo ciToRemove : cisToRemove) {
            this.remove(ciToRemove);
        }
    }

    public Map<String, GenericAssociationInfo> getGenAssociations() {
        return this.genAssociationInfosById;
    }

    @Override
    public SortedSet<AssociationInfo> associations() {
        return this.genAssociationInfosById.isEmpty() ? new TreeSet<AssociationInfo>() : new TreeSet<GenericAssociationInfo>(this.genAssociationInfosById.values());
    }

    public Map<String, GenericPropertyInfo> getGenProperties() {
        return this.genPropertiesById;
    }

    public Map<String, GenericPackageInfo> getGenPackages() {
        return this.genPackageInfosById;
    }

    public Map<String, GenericClassInfo> getGenClasses() {
        return this.genClassInfosById;
    }

    public void remove(GenericPropertyInfo genPi, boolean tryKeepAssociation) {
        if (genPi != null) {
            AssociationInfo association = genPi.association();
            if (association == null) {
                if (genPi.inClass() instanceof GenericClassInfo) {
                    ((GenericClassInfo)genPi.inClass()).removePropertyById(genPi.id());
                    this.genPropertiesById.remove(genPi.id());
                } else {
                    this.result.addError(this, 30313, genPi.inClass().name(), genPi.name);
                }
            } else {
                PropertyInfo end1 = association.end1();
                PropertyInfo end2 = association.end2();
                PropertyInfo other = null;
                other = end1.id().equals(genPi.id()) ? end2 : end1;
                boolean removeAssociation = false;
                if (tryKeepAssociation) {
                    if (!other.isNavigable()) {
                        removeAssociation = true;
                    } else {
                        genPi.setNavigable(false);
                        if (genPi.inClass() instanceof GenericClassInfo) {
                            ((GenericClassInfo)genPi.inClass()).removePropertyById(genPi.id());
                        } else {
                            this.result.addError(this, 30313, genPi.inClass().name(), genPi.name);
                        }
                    }
                } else {
                    removeAssociation = true;
                }
                if (removeAssociation) {
                    this.remove(association);
                }
            }
        }
    }

    public void remove(AssociationInfo ai) {
        GenericClassInfo associationClass = null;
        ClassInfo assocClass = ai.assocClass();
        if (assocClass != null) {
            associationClass = (GenericClassInfo)ai.assocClass();
        }
        if (associationClass != null) {
            this.remove(associationClass);
        } else {
            PropertyInfo end1 = ai.end1();
            PropertyInfo end2 = ai.end2();
            ((GenericClassInfo)end1.inClass()).removePropertyById(end1.id());
            this.genPropertiesById.remove(end1.id());
            ((GenericClassInfo)end2.inClass()).removePropertyById(end2.id());
            this.genPropertiesById.remove(end2.id());
            this.genAssociationInfosById.remove(ai.id());
        }
    }

    public void removeByClassCategory(int classCategory) {
        for (GenericClassInfo genCi : this.genClassInfosById.values().toArray(new GenericClassInfo[this.genClassInfosById.values().size()])) {
            if (genCi.category() != classCategory) continue;
            this.remove(genCi);
        }
    }

    public void copyClassContent(GenericClassInfo fromClass, GenericClassInfo toClass, PropertyCopyPositionIndicator copyPositionIndicator, PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        SortedMap<StructuredNumber, PropertyInfo> properties = fromClass.properties();
        if (properties != null && !properties.isEmpty()) {
            ArrayList<GenericPropertyInfo> copiedProps = new ArrayList<GenericPropertyInfo>();
            HashMap propsToSkipById = new HashMap();
            for (PropertyInfo propI : properties.values()) {
                if (propsToSkipById.containsKey(propI.id()) || !propI.isAttribute()) continue;
                GenericPropertyInfo genProp = (GenericPropertyInfo)propI;
                String copyId = genProp.id() + "_copyFrom" + fromClass.name() + "To" + toClass.name();
                GenericPropertyInfo copy = genProp.createCopy(copyId);
                copy.setInClass(toClass);
                copiedProps.add(copy);
            }
            switch (copyPositionIndicator) {
                case PROPERTY_COPY_TOP: {
                    toClass.addPropertiesAtTop(copiedProps, duplicateHandling);
                    break;
                }
                case PROPERTY_COPY_INSEQUENCE: {
                    toClass.addPropertiesInSequence(copiedProps, duplicateHandling);
                    break;
                }
                case PROPERTY_COPY_BOTTOM: {
                    toClass.addPropertiesAtBottom(copiedProps, duplicateHandling);
                }
            }
        }
    }

    public GenericAssociationInfo createCopy(AssociationInfo ai, String copyId) {
        GenericAssociationInfo genAi = new GenericAssociationInfo();
        genAi.setOptions(ai.options());
        genAi.setResult(ai.result());
        genAi.setModel(this);
        genAi.setId(copyId);
        genAi.setName(ai.name());
        genAi.setDescriptors(ai.descriptors().createCopy());
        genAi.setStereotypes(ai.stereotypes());
        genAi.setTaggedValues(ai.taggedValuesAll(), false);
        genAi.setEnd1(ai.end1());
        genAi.setEnd2(ai.end2());
        genAi.setAssocClass(ai.assocClass());
        return genAi;
    }

    public GenericClassInfo createCopy(ClassInfo ci, String copyId) {
        GenericClassInfo genCi = new GenericClassInfo(this, copyId, ci.name(), ci.category());
        genCi.setTaggedValues(ci.taggedValuesAll(), false);
        genCi.setStereotypes(ci.stereotypes());
        genCi.setDescriptors(ci.descriptors().createCopy());
        genCi.setProfiles(ci.profiles().createCopy());
        genCi.setPkg(ci.pkg());
        genCi.setIsAbstract(ci.isAbstract());
        genCi.setIsLeaf(ci.isLeaf());
        genCi.setAssocInfo(ci.isAssocClass());
        genCi.setSupertypes(this.copy(ci.supertypes()));
        genCi.setSubtypes(this.copy(ci.subtypes()));
        genCi.setProperties(ci.properties());
        genCi.setDirectConstraints(this.copy(ci.directConstraints()));
        genCi.setDiagrams(ci.getDiagrams());
        genCi.setLinkedDocument(ci.getLinkedDocument());
        return genCi;
    }

    public GenericPropertyInfo createCopy(PropertyInfo pi, String copyId) {
        GenericPropertyInfo copy = new GenericPropertyInfo(this, copyId, pi.name());
        copy.setDescriptors(pi.descriptors().createCopy());
        copy.setProfiles(pi.profiles().createCopy());
        copy.setStereotypes(pi.stereotypes());
        copy.setTaggedValues(pi.taggedValuesAll(), false);
        copy.setDerived(pi.isDerived());
        copy.setReadOnly(pi.isReadOnly());
        copy.setAttribute(pi.isAttribute());
        copy.copyTypeInfo(pi.typeInfo());
        copy.setNavigable(pi.isNavigable());
        copy.setOrdered(pi.isOrdered());
        copy.setUnique(pi.isUnique());
        copy.setOwned(pi.isOwned());
        copy.setComposition(pi.isComposition());
        copy.setAggregation(pi.isAggregation());
        copy.setCardinality(new Multiplicity(pi.cardinality().toString()));
        copy.setInitialValue(pi.initialValue());
        copy.setInlineOrByReference(pi.inlineOrByReference());
        copy.setInClass(pi.inClass());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pi.sequenceNumber().components.length - 1; ++i) {
            sb.append(pi.sequenceNumber().components[i] + ".");
        }
        sb.append(pi.sequenceNumber().components[pi.sequenceNumber().components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        copy.setSequenceNumber(res, false);
        copy.setConstraints(pi.constraints());
        copy.setAssociation(pi.association());
        copy.setRestriction(pi.isRestriction());
        copy.setNilReasonAllowed(pi.nilReasonAllowed());
        return copy;
    }

    private void exclude(Set<PackageInfo> packagesToExclude) {
        for (PackageInfo pi : packagesToExclude) {
            PackageInfo owner;
            SortedSet<PackageInfo> genPiChildren;
            if (!this.genPackageInfosById.containsKey(pi.id())) continue;
            GenericPackageInfo genPi = this.genPackageInfosById.get(pi.id());
            Object[] genPiClasses = genPi.getClasses().stream().toArray();
            if (genPiClasses != null && genPiClasses.length > 0) {
                for (Object ci : genPiClasses) {
                    this.exclude((GenericClassInfo)ci);
                }
            }
            if ((genPiChildren = genPi.containedPackages()) != null && !genPiChildren.isEmpty()) {
                this.exclude(genPiChildren);
            }
            if ((owner = genPi.owner()) != null) {
                ((GenericPackageInfo)owner).removeChild(genPi);
            }
            this.genPackageInfosById.remove(pi.id());
        }
    }

    public void remove(Set<PackageInfo> packagesToRemove) {
        for (PackageInfo pi : packagesToRemove) {
            PackageInfo owner;
            SortedSet<PackageInfo> genPiChildren;
            if (!this.genPackageInfosById.containsKey(pi.id())) continue;
            GenericPackageInfo genPi = this.genPackageInfosById.get(pi.id());
            Object[] genPiClasses = genPi.getClasses().stream().toArray();
            if (genPiClasses != null && genPiClasses.length > 0) {
                for (Object ci : genPiClasses) {
                    this.remove((GenericClassInfo)ci, false, true);
                }
            }
            if ((genPiChildren = genPi.containedPackages()) != null && !genPiChildren.isEmpty()) {
                this.remove((Set<PackageInfo>)genPiChildren);
            }
            if ((owner = genPi.owner()) != null) {
                ((GenericPackageInfo)owner).removeChild(genPi);
            }
            this.genPackageInfosById.remove(pi.id());
        }
    }

    public void dissolveAssociation(GenericAssociationInfo genAI) {
        ArrayList<GenericPropertyInfo> associationends = new ArrayList<GenericPropertyInfo>();
        associationends.add((GenericPropertyInfo)genAI.end1());
        associationends.add((GenericPropertyInfo)genAI.end2());
        for (int i = 0; i < associationends.size(); ++i) {
            GenericPropertyInfo genPi = (GenericPropertyInfo)associationends.get(i);
            if (!genPi.isNavigable()) {
                this.genPropertiesById.remove(genPi.id());
                ((GenericClassInfo)genPi.inClass()).removePropertyById(genPi.id());
                continue;
            }
            genPi.setAssociation(null);
            genPi.setAttribute(true);
            genPi.setAggregation(false);
            genPi.setComposition(true);
        }
        if (genAI.assocClass() != null) {
            if (genAI.assocClass() instanceof GenericClassInfo) {
                this.remove((GenericClassInfo)genAI.assocClass(), true, false);
            } else {
                this.result.addError(this, 30315, genAI.assocClass().name());
            }
        }
        this.genAssociationInfosById.remove(genAI.id());
    }

    public void updateClassName(GenericClassInfo genCi, String newName) {
        String oldName = genCi.name();
        if (this.genClassInfosByName.keySet().contains(oldName)) {
            GenericClassInfo tmp = this.genClassInfosByName.get(oldName);
            this.genClassInfosByName.remove(oldName);
            this.genClassInfosByName.put(newName, tmp);
        }
        for (GenericPropertyInfo genPi : this.getGenProperties().values()) {
            if (!genPi.typeInfo().id.equals(genCi.id())) continue;
            genPi.typeInfo().name = newName;
        }
        genCi.setName(newName);
    }

    @Override
    public SortedSet<PackageInfo> packages() {
        TreeSet<PackageInfo> allPackages = new TreeSet<PackageInfo>();
        for (PackageInfo packageInfo : this.genPackageInfosById.values()) {
            allPackages.add(packageInfo);
        }
        return allPackages;
    }

    public void removeByClassId(String id) {
        if (this.genClassInfosById.containsKey(id)) {
            GenericClassInfo genCi = this.genClassInfosById.get(id);
            this.remove(genCi);
        }
    }

    public void addAssociation(GenericAssociationInfo ai) {
        this.genAssociationInfosById.put(ai.id(), ai);
    }

    public SortedSet<GenericClassInfo> selectedSchemaClasses() {
        TreeSet<GenericClassInfo> res = new TreeSet<GenericClassInfo>();
        for (PackageInfo selectedSchema : this.selectedSchemas()) {
            SortedSet<ClassInfo> cisOfSelectedSchema = this.classes(selectedSchema);
            for (ClassInfo ci : cisOfSelectedSchema) {
                res.add((GenericClassInfo)ci);
            }
        }
        return res;
    }

    public SortedSet<GenericPropertyInfo> selectedSchemaProperties() {
        SortedSet<GenericClassInfo> selCis = this.selectedSchemaClasses();
        TreeSet<GenericPropertyInfo> res = new TreeSet<GenericPropertyInfo>();
        for (GenericClassInfo selCi : selCis) {
            for (PropertyInfo pi : selCi.properties.values()) {
                if (!pi.isNavigable()) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                res.add(genPi);
            }
        }
        return res;
    }

    public SortedSet<GenericAssociationInfo> selectedSchemaAssociations() {
        SortedSet<GenericPropertyInfo> selGenPis = this.selectedSchemaProperties();
        TreeSet<GenericAssociationInfo> res = new TreeSet<GenericAssociationInfo>();
        for (GenericPropertyInfo genPi : selGenPis) {
            if (genPi.isAttribute) continue;
            res.add((GenericAssociationInfo)genPi.association());
        }
        return res;
    }

    public Map<String, GenericPackageInfo> getGenPackageInfosById() {
        return this.genPackageInfosById;
    }

    public void setGenPackageInfosById(Map<String, GenericPackageInfo> genPackageInfosById) {
        this.genPackageInfosById = genPackageInfosById;
    }

    public void setGenClassInfosById(Map<String, GenericClassInfo> genClassInfosById) {
        this.genClassInfosById = genClassInfosById;
    }

    public void setGenClassInfosByName(Map<String, GenericClassInfo> genClassInfosByName) {
        this.genClassInfosByName = genClassInfosByName;
    }

    public void setGenAssociationInfosById(Map<String, GenericAssociationInfo> genAssociationInfosById) {
        this.genAssociationInfosById = genAssociationInfosById;
    }

    public void setGenPropertiesById(Map<String, GenericPropertyInfo> genPropertiesById) {
        this.genPropertiesById = genPropertiesById;
    }

    public void register(GenericPropertyInfo genPi) {
        if (genPi != null) {
            this.genPropertiesById.put(genPi.id(), genPi);
        }
    }

    public void addPrefixToModelElementIDs(String prefix) {
        if (prefix == null) {
            return;
        }
        HashMap<String, GenericPropertyInfo> tmp_genPropertiesById = new HashMap<String, GenericPropertyInfo>();
        for (Map.Entry<String, GenericPropertyInfo> entry : this.genPropertiesById.entrySet()) {
            String string = prefix + entry.getKey();
            entry.getValue().addPrefixToModelElementIDs(prefix);
            tmp_genPropertiesById.put(string, entry.getValue());
        }
        this.genPropertiesById = tmp_genPropertiesById;
        HashMap<String, GenericAssociationInfo> tmp_genAssociationInfosById = new HashMap<String, GenericAssociationInfo>();
        for (Map.Entry<String, GenericAssociationInfo> entry : this.genAssociationInfosById.entrySet()) {
            String string = prefix + entry.getKey();
            entry.getValue().addPrefixToModelElementIDs(prefix);
            tmp_genAssociationInfosById.put(string, entry.getValue());
        }
        this.genAssociationInfosById = tmp_genAssociationInfosById;
        HashMap<String, GenericClassInfo> hashMap = new HashMap<String, GenericClassInfo>();
        for (Map.Entry<String, GenericClassInfo> entry : this.genClassInfosById.entrySet()) {
            String newId = prefix + entry.getKey();
            entry.getValue().addPrefixToModelElementIDs(prefix);
            hashMap.put(newId, entry.getValue());
        }
        this.genClassInfosById = hashMap;
        HashMap<String, GenericPackageInfo> hashMap2 = new HashMap<String, GenericPackageInfo>();
        for (Map.Entry<String, GenericPackageInfo> e : this.genPackageInfosById.entrySet()) {
            String newId = prefix + e.getKey();
            e.getValue().addPrefixToModelElementIDs(prefix);
            hashMap2.put(newId, e.getValue());
        }
        this.genPackageInfosById = hashMap2;
    }

    public void validateConstraints() {
        boolean invalidConstraintsEncountered = false;
        Sbvr2FolParser sbvrParser = new Sbvr2FolParser(this, true);
        for (PackageInfo pkg : this.selectedSchemas()) {
            for (ClassInfo tmp : this.classes(pkg)) {
                GenericClassInfo genCi = (GenericClassInfo)tmp;
                if (genCi.category() == 16) continue;
                List<Constraint> ciCons = genCi.directConstraints();
                Collections.sort(ciCons, ConstraintComparators.NAME);
                Vector<Constraint> newClassConstraints = new Vector<Constraint>();
                for (Constraint con : ciCons) {
                    Constraint parsedConstraint;
                    if (con instanceof OclConstraint) {
                        OclConstraint oclCon = (OclConstraint)con;
                        parsedConstraint = this.parse(oclCon, genCi);
                        if (parsedConstraint instanceof TextConstraint) {
                            invalidConstraintsEncountered = true;
                        }
                        newClassConstraints.add(parsedConstraint);
                        continue;
                    }
                    if (con instanceof FolConstraint) {
                        FolConstraint folCon = (FolConstraint)con;
                        parsedConstraint = this.parse(folCon, sbvrParser, genCi);
                        if (parsedConstraint instanceof TextConstraint) {
                            invalidConstraintsEncountered = true;
                        }
                        newClassConstraints.add(parsedConstraint);
                        continue;
                    }
                    if (con instanceof TextConstraint) {
                        newClassConstraints.add(con);
                        continue;
                    }
                    this.result.addInfo(this, 20111, con.name(), genCi.fullNameInSchema());
                    newClassConstraints.add(con);
                }
                genCi.setDirectConstraints(newClassConstraints);
                for (PropertyInfo pi : genCi.properties().values()) {
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    List<Constraint> piCons = genPi.constraints();
                    if (piCons == null) continue;
                    Collections.sort(piCons, ConstraintComparators.NAME);
                    Vector<Constraint> newPropertyConstraints = new Vector<Constraint>();
                    for (Constraint con : piCons) {
                        if (con instanceof OclConstraint) {
                            OclConstraint oclCon = (OclConstraint)con;
                            Constraint parsedConstraint = this.parse(oclCon, genPi);
                            if (parsedConstraint instanceof TextConstraint) {
                                invalidConstraintsEncountered = true;
                            }
                            newPropertyConstraints.add(parsedConstraint);
                            continue;
                        }
                        if (con instanceof TextConstraint) {
                            newPropertyConstraints.add(con);
                            continue;
                        }
                        this.result.addInfo(this, 20111, con.name(), genPi.fullNameInSchema());
                        newPropertyConstraints.add(con);
                    }
                    genPi.setConstraints(newPropertyConstraints);
                }
            }
        }
        if (invalidConstraintsEncountered) {
            this.result.addWarning(this, 30329);
        }
    }

    protected Constraint parse(FolConstraint con, Sbvr2FolParser parser, GenericClassInfo genCi) {
        if (con.sourceType().equals("SBVR")) {
            con.mergeComments(new String[]{con.text()});
            FolExpression folExpr = parser.parse(con);
            if (folExpr != null) {
                con.setFolExpression(folExpr);
                return con;
            }
            this.result.addInfo(this, 20110, con.name(), genCi.fullNameInSchema());
            return new GenericTextConstraint(genCi, (Constraint)con);
        }
        ShapeChangeResult.MessageContext ctx = this.result.addError(null, 38, con.sourceType());
        ctx.addDetail(null, 39, con.name(), con.contextModelElmt().fullNameInSchema());
        return new GenericTextConstraint(genCi, (Constraint)con);
    }

    protected Constraint parse(OclConstraint con, GenericClassInfo genCi) {
        GenericOclConstraint validated = new GenericOclConstraint(genCi, con);
        if (validated.syntaxTree() != null) {
            return validated;
        }
        this.result.addInfo(this, 20110, con.name(), genCi.fullNameInSchema());
        GenericTextConstraint fallback = new GenericTextConstraint(genCi, (Constraint)con);
        return fallback;
    }

    protected Constraint parse(OclConstraint con, GenericPropertyInfo genPi) {
        GenericOclConstraint validated = new GenericOclConstraint(genPi, con);
        if (validated.syntaxTree() != null) {
            return validated;
        }
        this.result.addInfo(this, 20110, con.name(), genPi.fullNameInSchema());
        GenericTextConstraint fallback = new GenericTextConstraint(genPi, (Constraint)con);
        return fallback;
    }

    @Override
    public String descriptorSource(Descriptor descriptor) {
        Object source = null;
        if (this.options().parameterAsBoolean(null, "applyDescriptorSourcesWhenLoadingScxml", false) && this.loadingFromScxml) {
            source = this.options().descriptorSource(descriptor.getName());
            if (source == null) {
                source = "tag#" + descriptor;
            }
        } else {
            source = "sc:internal";
        }
        return source;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: property '$1$'";
            }
            case 2: {
                return "Context: class '$1$'";
            }
            case 25: {
                return "Model repository file named '$1$' not found";
            }
            case 20110: {
                return "The constraint '$1$' on '$2$' will be converted into a simple TextConstraint.";
            }
            case 20111: {
                return "The constraint '$1$' on '$2$' was not recognized as a constraint to be validated.";
            }
            case 30300: {
                return "(GenericModel.java) Constraint '$1$' in Class '$2$' not of type 'GenericText/OclConstraint'.";
            }
            case 30301: {
                return "(GenericModel.java) $1$";
            }
            case 30302: {
                return "(GenericModel.java) Could not find GenericPropertyInfo to update context info with for GenericTextConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30303: {
                return "(GenericModel.java) Could not find GenericClassInfo to update context info with for GenericTextConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30304: {
                return "(GenericModel.java) Unrecognized constraint context model element type: '$1$'";
            }
            case 30305: {
                return "(GenericModel.java) Could not find GenericPropertyInfo to update context info with for GenericOclConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30306: {
                return "(GenericModel.java) Could not find GenericPropertyInfo to update context info with for GenericOclConstraint named '$1$'. - Context model element name is '$2$'. - Context class name is '$3$'.";
            }
            case 30307: {
                return "(GenericModel.java) Could not find GenericClassInfo to update context info with for GenericOclConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30308: {
                return "(GenericModel.java) Could not find GenericClassInfo to update context info with for GenericOclConstraint named '$1$'. - Context model element name is '$2$'. - Context class name is '$3$'.";
            }
            case 30309: {
                return "(GenericModel.java) Unrecognized constraint type: '$1$'.";
            }
            case 30310: {
                return "(GenericModel.java) Package '$1$' is not of type 'GenericPackageInfo'. Cannot add class '$2$'";
            }
            case 30311: {
                return "(GenericModel.java) Class '$1$' is not of type 'GenericClassInfo' (was trying to add new property '$2$').";
            }
            case 30312: {
                return "(GenericModel.java) Property $1$.$2$ is not of type 'GenericPropertyInfo' (most likely because the property belongs to a class that is not part of the selected schema). Cannot remove the property.";
            }
            case 30313: {
                return "(GenericModel.java) Class '$1$' is not of type 'GenericClassInfo' (was trying to remove property '$2$')";
            }
            case 30314: {
                return "(GenericModel.java) Class with id '$1$' not found. Cannot remove subtype '$2$'";
            }
            case 30315: {
                return "(GenericModel.java) Association class '$1$' not of type GenericClassInfo. Cannot remove it.";
            }
            case 30316: {
                return "(GenericModel.java) Class with name '$1$' and id '$2$' is not of type 'GenericClassInfo'.";
            }
            case 30317: {
                return "(GenericModel.java) Property with name '$1$' and id '$2$' is not of type 'GenericPropertyInfo'.";
            }
            case 30318: {
                return "(GenericModel.java) Property with id '$1$' (name: '$2$', in class: '$3$') already exists in the generic model (details about that property [property name / in class name]: $4$). The property will be ignored (not added to its class).";
            }
            case 30319: {
                return "(GenericModel.java) GenericPropertyInfo that should be used to represent the property '$1$' is not in the same class (property in class is '$2$', generic property in class is '$3$'). The property will not be added to class '$2$'.";
            }
            case 30320: {
                return "(GenericModel.java) PropertyInfo with sequenceNumber '$1$' in class '$2$' is null. The property will be ignored.";
            }
            case 30321: {
                return "(GenericModel.java) No GenericPropertyInfo found that represents property '$1$' in class '$2$'. The property will be ignored.";
            }
            case 30322: {
                return "(GenericModel.java) Class with name '$1$' and id '$2$' is not of type 'GenericClassInfo'. Cannot remove it from the model.";
            }
            case 30323: {
                return "(GenericModel.java) Subtype of '$1$' with name '$2$' found in the model but it is not a GenericClassInfo (likely because it does not belong to a schema selected for processing). Cannot remove the supertype relationship to '$1$' in the subtype '$2$'.";
            }
            case 30324: {
                return "(GenericModel.java) Subtype of '$1$' with id '$2$' not found in the model. Cannot remove the supertype relationship to '$1$' in the subtype.";
            }
            case 30325: {
                return "(GenericModel.java) Could not find GenericPropertyInfo to update context info with for GenericFolConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30326: {
                return "(GenericModel.java) Could not find GenericClassInfo to update context info with for GenericFolConstraint named '$1$'. - Context model element name is '$2$'.";
            }
            case 30327: {
                return "(Generic model) The zip file at '$1$' contains more than one entry. Only the entry '$2$' will be loaded. Other entries will be ignored.";
            }
            case 30328: {
                return "(Generic model) The zip file at '$1$' does not contain any entry. The model will be empty.";
            }
            case 30329: {
                return "One or more OclConstraints or FolConstraints were invalid and have been transformed into TextConstraints. For further details, consult the validation messages that were logged on INFO level before this message. This is not an issue if these constraints are not processed by subsequent transformations or targets.";
            }
            case 30330: {
                return "Field '$1$' of code/enum '$2$' is $3$, which is not the applicable default. Using default for this property.";
            }
            case 30400: {
                return "While parsing content of Class element with id '$1$' and name '$2$', linked document does not exist at '$3$'.";
            }
            case 30401: {
                return "Input parameter 'applyDescriptorSourcesWhenLoadingScxml' is set to 'true'. Descriptors elements in SCXML will be ignored. Descriptors of model elements loaded from SCXML will be determined based upon configured descriptor sources.";
            }
            case 30500: {
                return "--- SCXML VALIDATION RESULTS - START ---";
            }
            case 30501: {
                return "--- SCXML VALIDATION RESULTS - END ---";
            }
            case 30502: {
                return "Warning: $1$";
            }
            case 30503: {
                return "Error: $1$";
            }
            case 30504: {
                return "SCXML is invalid. Execution will stop now.";
            }
            case 30505: {
                return "--- SCXML IS VALID ---";
            }
            case 30506: {
                return "SCXML XSD location URL '$1$' (defined via input parameter 'scxmlXsdLocation') is malformed. Validation of SCXML will be skipped. Message from Java MalformedURLException is: $2$.";
            }
            case 30507: {
                return "Schema could not be created from SCXML XSD location '$1$' (defined via input parameter 'scxmlXsdLocation'). Validation of SCXML will be skipped. Message from Java SAXException is: $2$.";
            }
            case 30803: {
                return "Exception occurred while reading the model XML. Message is: $1$.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }

    public static enum PropertyCopyDuplicatBehaviorIndicator {
        IGNORE,
        IGNORE_UNRESTRICT,
        ADD,
        OVERWRITE;

    }

    public static enum PropertyCopyPositionIndicator {
        PROPERTY_COPY_TOP,
        PROPERTY_COPY_INSEQUENCE,
        PROPERTY_COPY_BOTTOM;

    }

    protected static class ConstraintComparators {
        public static Comparator<Constraint> NAME = new Comparator<Constraint>(){

            @Override
            public int compare(Constraint o1, Constraint o2) {
                return o1.name().compareTo(o2.name());
            }
        };

        protected ConstraintComparators() {
        }
    }
}

