/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class GenericClassInfo
extends ClassInfoImpl
implements MessageSource {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected PackageInfo pkg = null;
    protected AssociationInfo assocClass = null;
    protected TreeSet<String> supertypes = new TreeSet();
    protected TreeSet<String> subtypes = new TreeSet();
    protected SortedMap<StructuredNumber, PropertyInfo> properties = new TreeMap<StructuredNumber, PropertyInfo>();
    protected Vector<Constraint> constraints = null;

    public GenericClassInfo() {
    }

    public GenericClassInfo(GenericModel model, String id, String name, int category) {
        this.model = model;
        this.options = model.options();
        this.result = model.result();
        this.id = id;
        this.name = name;
        this.category = category;
    }

    public void setPkg(PackageInfo pkg) {
        this.pkg = pkg;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setAssocInfo(AssociationInfo assocClass) {
        this.assocClass = assocClass;
    }

    public void setSupertypes(TreeSet<String> supertypes) {
        this.supertypes = supertypes == null || supertypes.isEmpty() ? null : supertypes;
    }

    public void setSubtypes(TreeSet<String> subtypes) {
        this.subtypes = subtypes;
    }

    public void setProperties(SortedMap<StructuredNumber, PropertyInfo> properties) {
        this.properties = properties;
    }

    public void setDirectConstraints(Vector<Constraint> list) {
        this.constraints = list;
    }

    @Override
    public String fullName() {
        if (this.pkg != null && this.name != null) {
            return this.pkg.fullName() + "::" + this.name;
        }
        return null;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GenericModel model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            this.stereotypesCache = this.options().stereotypesFactory();
        }
    }

    public void setStereotypes(Stereotypes stereotypeSet) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotypeSet != null && !stereotypeSet.isEmpty()) {
            for (String st : stereotypeSet.asArray()) {
                this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(st)));
            }
        }
    }

    public void setStereotype(String stereotype) {
        this.stereotypesCache = this.options().stereotypesFactory();
        if (stereotype != null) {
            this.stereotypesCache.add(this.options.internalize(this.options.normalizeStereotype(stereotype)));
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            this.taggedValuesCache = this.options().taggedValueFactory();
        }
    }

    public void setTaggedValues(TaggedValues taggedValues, boolean updateFields) {
        this.taggedValuesCache = this.options().taggedValueFactory(taggedValues);
        if (updateFields && !this.taggedValuesCache.isEmpty()) {
            for (String key : taggedValues.keySet()) {
                this.updateFieldsForTaggedValue(key, this.taggedValuesCache.getFirstValue(key));
            }
        }
    }

    private void updateFieldsForTaggedValue(String tvName, String tvValue) {
        if (tvName.equalsIgnoreCase("profiles")) {
            this.profiles = null;
            super.profiles();
        }
    }

    @Override
    public PackageInfo pkg() {
        return this.pkg;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public AssociationInfo isAssocClass() {
        return this.assocClass;
    }

    public TreeSet<String> supertypes() {
        if (this.supertypes == null) {
            return new TreeSet<String>();
        }
        return this.supertypes;
    }

    public TreeSet<String> subtypes() {
        if (this.subtypes == null) {
            return new TreeSet<String>();
        }
        return this.subtypes;
    }

    public boolean hasSupertypes() {
        return this.supertypes != null && this.supertypes.size() > 0;
    }

    public boolean hasSubtypes() {
        return this.subtypes != null && this.subtypes.size() > 0;
    }

    public boolean hasDirectConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    @Override
    public SortedMap<StructuredNumber, PropertyInfo> properties() {
        if (this.properties == null) {
            return new TreeMap<StructuredNumber, PropertyInfo>();
        }
        return this.properties;
    }

    @Override
    public List<Constraint> directConstraints() {
        if (this.constraints == null) {
            return new Vector<Constraint>(1);
        }
        return this.constraints;
    }

    @Override
    public PropertyInfo property(String name) {
        for (PropertyInfo pi : this.properties.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        HashMap<String, ClassInfo> baseClassesById = new HashMap<String, ClassInfo>();
        if (this.supertypes != null && !this.supertypes.isEmpty()) {
            for (String supertypeId : this.supertypes) {
                baseClassesById.put(supertypeId, this.model.classById(supertypeId));
            }
        }
        for (ClassInfo baseCi : baseClassesById.values()) {
            PropertyInfo pi = baseCi.property(name);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    @Override
    public OperationInfo operation(String name, String[] types) {
        return null;
    }

    public String printAsString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        sb.append(indent + indent + "properties:\n");
        for (PropertyInfo property : this.properties.values()) {
            sb.append(((GenericPropertyInfo)property).printAsString(indent + indent));
        }
        return sb.toString();
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void removeSubtype(String subtypeId) {
        if (this.subtypes != null) {
            this.subtypes.remove(subtypeId);
        }
    }

    public boolean addSubtype(String subtypeId) {
        if (this.subtypes == null) {
            this.subtypes = new TreeSet();
        }
        return this.subtypes.add(subtypeId);
    }

    public void removeSupertype(String supertypeId) {
        if (this.supertypes == null || this.supertypes.size() == 0 || supertypeId == null) {
            return;
        }
        this.supertypes.remove(supertypeId);
    }

    public boolean addSupertype(String supertypeId) {
        if (this.supertypes == null) {
            this.supertypes = new TreeSet();
        }
        return ((TreeSet)this.supertypes()).add(supertypeId);
    }

    public void addProperty(GenericPropertyInfo newProperty, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        GenericPropertyInfo existingPropWithSameName;
        if (this.properties == null) {
            this.properties = new TreeMap<StructuredNumber, PropertyInfo>();
        }
        if ((existingPropWithSameName = (GenericPropertyInfo)this.ownedProperty(newProperty.name())) == null) {
            this.properties.put(newProperty.sequenceNumber(), newProperty);
            this.model.genPropertiesById.put(newProperty.id(), newProperty);
        } else if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD) {
            this.result.addWarning(this, 30200, newProperty.name(), this.name());
            this.properties.put(newProperty.sequenceNumber(), newProperty);
            this.model.genPropertiesById.put(newProperty.id(), newProperty);
        } else if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE) {
            this.result.addWarning(this, 30201, newProperty.name(), this.name());
        } else if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE_UNRESTRICT) {
            this.result.addWarning(this, 30202, newProperty.name(), this.name());
            existingPropWithSameName.setRestriction(false);
        } else if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE) {
            this.result.addWarning(this, 30203, newProperty.name(), this.name());
            this.properties.remove(existingPropWithSameName.sequenceNumber());
            this.model.genPropertiesById.remove(existingPropWithSameName.id());
            this.properties.put(newProperty.sequenceNumber(), newProperty);
            this.model.genPropertiesById.put(newProperty.id(), newProperty);
        }
    }

    public StructuredNumber getNextSequenceNumber() {
        int maxSequenceNumber = Integer.MIN_VALUE;
        if (this.properties == null || this.properties.isEmpty()) {
            maxSequenceNumber = 0;
        } else {
            Set<StructuredNumber> enumSeqNumbers = this.properties.keySet();
            for (StructuredNumber strucNum : enumSeqNumbers) {
                if (strucNum.components[0] <= maxSequenceNumber) continue;
                maxSequenceNumber = strucNum.components[0];
            }
        }
        int result = maxSequenceNumber + 1;
        return new StructuredNumber(result);
    }

    public void addConstraints(List<Constraint> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Vector();
        }
        for (Constraint con : list) {
            if (this.constraints.contains(con)) continue;
            this.constraints.addElement(con);
        }
    }

    public void removePropertyById(String id) {
        StructuredNumber keyFound = null;
        for (Map.Entry<StructuredNumber, PropertyInfo> entry : this.properties.entrySet()) {
            PropertyInfo pi = entry.getValue();
            if (!pi.id().equals(id)) continue;
            keyFound = entry.getKey();
        }
        if (keyFound != null) {
            this.properties.remove(keyFound);
        }
    }

    public void updateSubtypeId(String currentId, String newId) {
        if (this.subtypes != null && this.subtypes.contains(currentId)) {
            this.subtypes.remove(currentId);
            this.subtypes.add(newId);
        }
    }

    public void updateSupertypeId(String currentId, String newId) {
        if (this.supertypes != null && this.supertypes.contains(currentId)) {
            this.supertypes.remove(currentId);
            this.supertypes.add(newId);
        }
    }

    public GenericClassInfo createCopy(String copyId, String copyName, int copyCategory) {
        GenericClassInfo copy = new GenericClassInfo(this.model, copyId, copyName, copyCategory);
        copy.setDescriptors(this.descriptors().createCopy());
        copy.setProfiles(this.profiles().createCopy());
        copy.setStereotypes(this.stereotypesCache);
        copy.setTaggedValues(this.taggedValuesCache, false);
        copy.setPkg(this.pkg);
        copy.setIsAbstract(this.isAbstract);
        copy.setIsLeaf(this.isLeaf);
        copy.setAssocInfo(this.assocClass);
        copy.setSupertypes(this.supertypes == null ? null : (TreeSet)this.supertypes.clone());
        copy.setSubtypes(this.subtypes == null ? null : (TreeSet)this.subtypes.clone());
        copy.setDiagrams(this.diagrams);
        copy.setLinkedDocument(this.linkedDocument);
        TreeMap<StructuredNumber, PropertyInfo> copyProperties = new TreeMap<StructuredNumber, PropertyInfo>();
        for (PropertyInfo propI : this.properties.values()) {
            if (!propI.isAttribute()) continue;
            GenericPropertyInfo genProp = (GenericPropertyInfo)propI;
            String newId = genProp.name() + "_propertyCopyFor_" + copyId;
            GenericPropertyInfo propCopy = genProp.createCopy(newId);
            propCopy.setSequenceNumber(propI.sequenceNumber().createCopy(), false);
            propCopy.setInClass(copy);
            copyProperties.put(propCopy.sequenceNumber(), propCopy);
        }
        copy.setProperties(copyProperties);
        if (this.constraints == null) {
            copy.setDirectConstraints(null);
        } else {
            copy.setDirectConstraints((Vector)this.constraints.clone());
        }
        return copy;
    }

    public void removeByStructuredNumber(StructuredNumber sn) {
        StructuredNumber keyFound = null;
        for (StructuredNumber key : this.properties.keySet()) {
            if (!key.equals(sn)) continue;
            keyFound = key;
        }
        if (keyFound != null) {
            this.properties.remove(keyFound);
        }
    }

    public void addPropertiesAtTop(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.size() == 0) {
            return;
        }
        if (this.properties == null || this.properties.size() == 0) {
            this.properties = new TreeMap<StructuredNumber, PropertyInfo>();
            for (GenericPropertyInfo newProp : newProps) {
                this.addProperty(newProp, duplicateHandling);
            }
        } else {
            int minMajorComponentExistingProps = Integer.MAX_VALUE;
            int maxMajorComponentNewProps = Integer.MIN_VALUE;
            for (GenericPropertyInfo genericPropertyInfo : newProps) {
                StructuredNumber snNewProp = genericPropertyInfo.sequenceNumber();
                if (snNewProp.components[0] <= maxMajorComponentNewProps) continue;
                maxMajorComponentNewProps = snNewProp.components[0];
            }
            for (StructuredNumber structuredNumber : this.properties.keySet()) {
                if (structuredNumber.components[0] >= minMajorComponentExistingProps) continue;
                minMajorComponentExistingProps = structuredNumber.components[0];
            }
            if (maxMajorComponentNewProps >= minMajorComponentExistingProps) {
                int shift = maxMajorComponentNewProps - minMajorComponentExistingProps + 1;
                for (StructuredNumber snOfExistingProp : this.properties.keySet()) {
                    snOfExistingProp.components[0] = snOfExistingProp.components[0] + shift;
                }
            }
            for (GenericPropertyInfo genericPropertyInfo : newProps) {
                this.addProperty(genericPropertyInfo, duplicateHandling);
            }
        }
    }

    public GenericPropertyInfo propertyBySequenceNumber(StructuredNumber sn) {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        for (PropertyInfo pi : this.properties.values()) {
            if (!pi.sequenceNumber().equals(sn)) continue;
            return (GenericPropertyInfo)pi;
        }
        return null;
    }

    public void addPropertiesInSequence(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.isEmpty()) {
            return;
        }
        if (this.properties == null) {
            this.properties = new TreeMap<StructuredNumber, PropertyInfo>();
        }
        if (this.properties.isEmpty()) {
            for (GenericPropertyInfo newProperty : newProps) {
                this.properties.put(newProperty.sequenceNumber(), newProperty);
                this.model.genPropertiesById.put(newProperty.id(), newProperty);
            }
        } else {
            HashMap<String, GenericPropertyInfo> existingPropsByName = new HashMap<String, GenericPropertyInfo>();
            for (PropertyInfo existingProp : this.properties.values()) {
                existingPropsByName.put(existingProp.name(), (GenericPropertyInfo)existingProp);
            }
            for (GenericPropertyInfo newProperty : newProps) {
                GenericPropertyInfo existingPropWithSameName;
                StructuredNumber newpropsn = newProperty.sequenceNumber();
                if (this.properties.containsKey(newpropsn)) {
                    newProperty.setSequenceNumber(newpropsn.createCopyWithSuffix(1), true);
                }
                if ((existingPropWithSameName = (GenericPropertyInfo)existingPropsByName.get(newProperty.name())) == null) {
                    this.properties.put(newProperty.sequenceNumber(), newProperty);
                    existingPropsByName.put(newProperty.name(), newProperty);
                    this.model.genPropertiesById.put(newProperty.id(), newProperty);
                    continue;
                }
                if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD) {
                    this.result.addWarning(this, 30200, newProperty.name(), this.name());
                    this.properties.put(newProperty.sequenceNumber(), newProperty);
                    existingPropsByName.put(newProperty.name(), newProperty);
                    this.model.genPropertiesById.put(newProperty.id(), newProperty);
                    continue;
                }
                if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE) {
                    this.result.addWarning(this, 30201, newProperty.name(), this.name());
                    continue;
                }
                if (duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE_UNRESTRICT) {
                    this.result.addWarning(this, 30202, newProperty.name(), this.name());
                    existingPropWithSameName.setRestriction(false);
                    continue;
                }
                if (duplicateHandling != GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE) continue;
                this.result.addWarning(this, 30203, newProperty.name(), this.name());
                this.properties.remove(existingPropWithSameName.sequenceNumber());
                this.model.genPropertiesById.remove(existingPropWithSameName.id());
                this.properties.put(newProperty.sequenceNumber(), newProperty);
                existingPropsByName.put(newProperty.name(), newProperty);
                this.model.genPropertiesById.put(newProperty.id(), newProperty);
            }
        }
    }

    public void addPropertyAtBottom(GenericPropertyInfo newProp, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        ArrayList<GenericPropertyInfo> newProps = new ArrayList<GenericPropertyInfo>();
        newProps.add(newProp);
        this.addPropertiesAtBottom(newProps, duplicateHandling);
    }

    public void addPropertiesAtBottom(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.size() == 0) {
            return;
        }
        if (this.properties == null) {
            this.properties = new TreeMap<StructuredNumber, PropertyInfo>();
        }
        Collections.sort(newProps, new Comparator<GenericPropertyInfo>(){

            @Override
            public int compare(GenericPropertyInfo o1, GenericPropertyInfo o2) {
                return o1.sequenceNumber().compareTo(o2.sequenceNumber());
            }
        });
        for (GenericPropertyInfo newProp : newProps) {
            int minMajorComponentNewProp = newProp.sequenceNumber().components[0];
            int maxMajorComponentExistingProps = Integer.MIN_VALUE;
            for (StructuredNumber snExistingProp : this.properties.keySet()) {
                if (snExistingProp.components[0] <= maxMajorComponentExistingProps) continue;
                maxMajorComponentExistingProps = snExistingProp.components[0];
            }
            if (minMajorComponentNewProp <= maxMajorComponentExistingProps) {
                StructuredNumber snNewProp = newProp.sequenceNumber();
                snNewProp.components[0] = maxMajorComponentExistingProps + 1;
            }
            this.addProperty(newProp, duplicateHandling);
        }
    }

    public void setTaggedValue(String tvName, String tvValue, boolean updateFields) {
        this.validateTaggedValuesCache();
        this.taggedValuesCache.put(tvName, tvValue);
        if (updateFields) {
            this.updateFieldsForTaggedValue(tvName, tvValue);
        }
    }

    public void addPrefixToModelElementIDs(String prefix) {
        this.id = prefix + this.id;
        if (this.subtypes != null) {
            TreeSet<CallSite> tmp_subtypes = new TreeSet<CallSite>();
            for (String id : this.subtypes) {
                tmp_subtypes.add((CallSite)((Object)(prefix + id)));
            }
            this.subtypes = tmp_subtypes;
        }
        if (this.supertypes != null) {
            TreeSet<CallSite> tmp_supertypes = new TreeSet<CallSite>();
            for (String id : this.supertypes) {
                tmp_supertypes.add((CallSite)((Object)(prefix + id)));
            }
            this.supertypes = tmp_supertypes;
        }
    }

    public void setProfiles(Profiles profiles) {
        this.profiles = profiles == null ? new Profiles() : profiles;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "(GenericClassInfo) When setting tagged value '$1$', a boolean value (either 'false' or 'true') was expected. Found '$2$' - cannot set class field(s) for this tagged value.";
            }
            case 30200: {
                return "(GenericModel.java) Duplicate property encountered. Property with name '$1$' already exists in class '$2$'. Because the duplicate property behavior is set to 'ADD' the duplicate will nevertheless be added, resulting in two properties with the same name in the class.";
            }
            case 30201: {
                return "(GenericModel.java) Duplicate property encountered. Property with name '$1$' already exists in class '$2$'. Because the duplicate property behavior is set to 'IGNORE' the duplicate will be ignored and the existing property kept. The isRestriction setting of the existing property will not be changed.";
            }
            case 30202: {
                return "(GenericModel.java) Duplicate property encountered. Property with name '$1$' already exists in class '$2$'. Because the duplicate property behavior is set to 'IGNORE_UNRESTRICT' the duplicate will be ignored and the existing property kept. In case that the existing property is a restriction, it is set to not being a restriction.";
            }
            case 30203: {
                return "(GenericModel.java) Duplicate property encountered. Property with name '$1$' already exists in class '$2$'. Because the duplicate property behavior is set to 'OVERWRITE' the duplicate/new property will overwrite the existing one.";
            }
        }
        return "(" + GenericClassInfo.class.getName() + ") Unknown message with number: " + mnr;
    }
}

