/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.FolConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.AttributeConstraint;
import org.sparx.AttributeTag;
import org.sparx.Collection;
import org.sparx.ConnectorEnd;
import org.sparx.RoleTag;

public class PropertyInfoEA
extends PropertyInfoImpl
implements PropertyInfo {
    protected boolean aliasAccessed = false;
    protected boolean documentationAccessed = false;
    protected boolean globalIdentifierAccessed = false;
    protected EADocument document = null;
    protected ClassInfoEA classInfo = null;
    protected String eaPropertyId = null;
    protected String eaName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoEA typeClassInfo = null;
    protected Attribute eaAttribute = null;
    protected boolean isAttribute = true;
    protected int eaAttributeId = -1;
    AssociationInfoEA associationInfo = null;
    boolean reversedAssoc = false;
    ConnectorEnd eaConnectorEnd = null;
    protected StructuredNumber sequenceNumber = new StructuredNumber(Integer.MIN_VALUE);
    protected Multiplicity multiplicity = new Multiplicity();
    protected String initialValueCache = null;
    protected Boolean isReadOnlyCache = null;
    protected Boolean isDerivedCache = null;
    protected Boolean isNavigableCache = null;
    protected String aggregationTypeCache = null;
    protected Boolean isOrderedCache = null;
    protected Boolean isUniqueCache = null;
    protected Boolean isOwnedCache = null;
    protected Vector<Constraint> constraintsCache = null;

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, Attribute attr) {
        this.document = doc;
        this.classInfo = ci;
        this.eaAttribute = attr;
        this.eaAttributeId = this.eaAttribute.GetAttributeID();
        this.eaPropertyId = ci.id();
        this.eaPropertyId = this.eaPropertyId + "_";
        this.eaPropertyId = this.eaPropertyId + Integer.valueOf(this.eaAttributeId).toString();
        this.eaName = this.eaAttribute.GetName();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
        String s = this.taggedValue("sequenceNumber");
        this.sequenceNumber = this.createStructuredNumberForAttribute(s);
        int typeid = this.eaAttribute.GetClassifierID();
        this.typeInfo.id = String.valueOf(typeid);
        this.typeInfo.name = this.eaAttribute.GetType().trim();
        this.typeClassInfo = (ClassInfoEA)this.document.fClassById.get(this.typeInfo.id);
        if (this.typeClassInfo == null) {
            this.typeClassInfo = (ClassInfoEA)this.document.fClassByName.get(this.typeInfo.name);
        }
        if (this.typeClassInfo != null) {
            this.typeInfo.name = this.typeClassInfo.name();
            this.typeInfo.id = this.typeClassInfo.id();
        } else {
            this.typeInfo.id = "unknown";
        }
        String[] bounds = new String[]{this.eaAttribute.GetLowerBound().trim(), this.eaAttribute.GetUpperBound().trim()};
        int[] mult = new int[]{0, 0};
        for (int i = 0; i < 2; ++i) {
            if (bounds[i].length() == 0) {
                mult[i] = 1;
                continue;
            }
            if (bounds[i].equals("*")) {
                mult[i] = i == 0 ? 0 : Integer.MAX_VALUE;
                continue;
            }
            try {
                mult[i] = Integer.parseInt(bounds[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, bounds[i]);
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.inClass().fullName());
                }
                mult[i] = 1;
            }
        }
        this.multiplicity.minOccurs = mult[0];
        this.multiplicity.maxOccurs = mult[1];
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    PropertyInfoEA(EADocument doc, ClassInfoEA ci, ConnectorEnd ce, String connectorId, String typeName) {
        this.document = doc;
        this.classInfo = ci;
        this.eaConnectorEnd = ce;
        this.eaPropertyId = ci.id();
        this.eaPropertyId = this.eaPropertyId + "_";
        this.eaPropertyId = this.eaPropertyId + "A" + connectorId;
        this.eaName = ce.GetRole();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
        String s = this.taggedValue("sequenceNumber");
        this.sequenceNumber = this.createStructuredNumberForAssociationRole(s);
        this.typeInfo.id = "unknown";
        this.typeInfo.name = typeName;
        this.setMultiplicity(this.eaConnectorEnd);
        this.setQualifiers(this.eaConnectorEnd);
        this.document.result.addDebug(null, 10013, "property (navigable role to excluded class as attribute)", this.id(), this.name());
    }

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, AssociationInfoEA ai, boolean reversed, ConnectorEnd eaCE, ClassInfoEA tci) {
        this.document = doc;
        this.classInfo = ci;
        this.associationInfo = ai;
        this.reversedAssoc = reversed;
        this.eaConnectorEnd = eaCE;
        this.isAttribute = false;
        this.eaPropertyId = (reversed ? "S" : "T") + ai.id();
        this.eaName = EAConnectorEndUtil.getRoleName(this.eaConnectorEnd, this.eaPropertyId);
        this.typeClassInfo = tci;
        this.typeInfo.id = tci.id();
        this.typeInfo.name = tci.name();
        String s = this.taggedValue("sequenceNumber");
        this.sequenceNumber = this.createStructuredNumberForAssociationRole(s);
        this.setMultiplicity(this.eaConnectorEnd);
        this.setQualifiers(this.eaConnectorEnd);
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    private void setQualifiers(ConnectorEnd ce) {
        String qualifierString = ce.GetQualifier();
        if (qualifierString != null && !qualifierString.isEmpty()) {
            this.qualifiers = new Vector();
            for (String st : qualifierString.split(";")) {
                st = st.trim();
                int idx = st.indexOf(":");
                Qualifier q = new Qualifier();
                this.qualifiers.addElement(q);
                if (idx > 0) {
                    q.name = st.substring(0, idx).trim();
                    q.type = st.substring(idx + 1).trim();
                    continue;
                }
                q.name = st.trim();
            }
        }
    }

    private void setMultiplicity(ConnectorEnd ce) {
        String card = ce.GetCardinality();
        String[] ranges = card.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < ranges.length; ++i) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, minmax[1]);
                        if (mc != null) {
                            mc.addDetail(null, 400, "Class", this.inClass().fullName());
                        }
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0) {
                lower = 1;
                upper = 1;
            } else if (ranges[i].equals("*")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, ranges[i]);
                    if (mc != null) {
                        mc.addDetail(null, 400, "Class", this.inClass().fullName());
                    }
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper <= maxv) continue;
            maxv = upper;
        }
        this.multiplicity.minOccurs = minv;
        this.multiplicity.maxOccurs = maxv;
    }

    private StructuredNumber createStructuredNumberForAttribute(String s) {
        if (s != null && s.length() > 0 && s.matches("[0-9\\.]*")) {
            return new StructuredNumber(s);
        }
        return new StructuredNumber(this.getNextNumberForAttributeWithoutExplicitSequenceNumber());
    }

    private StructuredNumber createStructuredNumberForAssociationRole(String s) {
        if (s != null && s.length() > 0) {
            return new StructuredNumber(s);
        }
        return new StructuredNumber(this.getNextNumberForAssociationRoleWithoutExplicitSequenceNumber());
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public Multiplicity cardinality() {
        return this.multiplicity;
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = (ClassInfoEA)ci;
    }

    @Override
    public String initialValue() {
        if (this.initialValueCache == null && this.eaAttribute != null) {
            this.initialValueCache = this.eaAttribute.GetDefault();
            if (this.initialValueCache.equals("")) {
                this.initialValueCache = null;
            }
            if (this.initialValueCache != null) {
                this.initialValueCache = this.initialValueCache.trim();
                this.initialValueCache = StringUtils.removeStart((String)this.initialValueCache, (String)"\"");
                this.initialValueCache = StringUtils.removeEnd((String)this.initialValueCache, (String)"\"");
                String iv = this.initialValueCache.toLowerCase();
                if (iv.equals("true")) {
                    this.initialValueCache = "true";
                }
                if (iv.equals("false")) {
                    this.initialValueCache = "false";
                }
            }
        }
        return this.initialValueCache;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isReadOnlyCache == null) {
            this.isReadOnlyCache = this.eaAttribute != null ? Boolean.valueOf(this.eaAttribute.GetIsConst()) : Boolean.valueOf(false);
        }
        return this.isReadOnlyCache;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.taggedValue("inlineOrByReference");
        if (s == null) {
            s = "";
        }
        if (s.length() == 0) {
            s = super.inlineOrByReferenceFromEncodingRule();
        }
        if (s.length() == 0) {
            String cont = null;
            cont = this.eaAttribute != null ? this.eaAttribute.GetContainment() : this.eaConnectorEnd.GetContainment();
            if (cont != null) {
                if (cont.equals("By Reference")) {
                    s = "byreference";
                } else if (cont.equals("By Value")) {
                    s = "inline";
                }
            }
        }
        return s.toLowerCase();
    }

    private void validateAggregationType() {
        if (this.aggregationTypeCache == null) {
            if (this.isAttribute()) {
                this.aggregationTypeCache = "composite";
            } else {
                ConnectorEnd otherEnd = ((PropertyInfoEA)this.reverseProperty()).eaConnectorEnd;
                int agt = otherEnd.GetAggregation();
                if (agt == 1) {
                    this.aggregationTypeCache = "shared";
                } else if (agt == 2) {
                    this.aggregationTypeCache = "composite";
                }
            }
            if (this.aggregationTypeCache == null) {
                this.aggregationTypeCache = "none";
            }
        }
    }

    @Override
    public boolean isAggregation() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("shared") && this.inClass().category() != 3 && this.inClass().category() != 2;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    public int getEAAttributeId() {
        return this.eaAttributeId;
    }

    @Override
    public boolean isComposition() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("composite") && this.inClass().category() != 3 && this.inClass().category() != 2;
    }

    @Override
    public boolean isDerived() {
        if (this.isDerivedCache == null) {
            this.isDerivedCache = this.eaAttribute != null ? this.eaAttribute.GetIsDerived() : this.eaConnectorEnd.GetDerived();
        }
        return this.isDerivedCache;
    }

    @Override
    public boolean isNavigable() {
        if (this.isNavigableCache == null) {
            this.isNavigableCache = true;
            if (!this.isAttribute()) {
                this.isNavigableCache = EAConnectorEndUtil.isNavigable(this.eaConnectorEnd, this.associationInfo.eaConnector);
            }
        }
        return this.isNavigableCache;
    }

    @Override
    public boolean isOrdered() {
        if (this.isOrderedCache == null) {
            this.isOrderedCache = Boolean.FALSE;
            if (this.inClass().category() != 3 && this.inClass().category() != 2) {
                if (this.eaAttribute != null) {
                    this.isOrderedCache = this.eaAttribute.GetIsOrdered();
                } else {
                    int ordering = this.eaConnectorEnd.GetOrdering();
                    if (ordering != 0) {
                        this.isOrderedCache = true;
                    }
                }
            }
        }
        return this.isOrderedCache;
    }

    @Override
    public boolean isUnique() {
        if (this.isUniqueCache == null) {
            this.isUniqueCache = Boolean.TRUE;
            if (this.inClass().category() != 3 && this.inClass().category() != 2) {
                if (this.eaAttribute != null) {
                    this.isUniqueCache = !this.eaAttribute.GetAllowDuplicates();
                } else {
                    boolean uniqueness;
                    boolean bl = uniqueness = !this.eaConnectorEnd.GetAllowDuplicates();
                    if (!uniqueness) {
                        this.isUniqueCache = false;
                    }
                }
            }
        }
        return this.isUniqueCache;
    }

    @Override
    public boolean isOwned() {
        if (this.isOwnedCache == null) {
            this.isOwnedCache = Boolean.FALSE;
            if (this.inClass().category() != 3 && this.inClass().category() != 2 && !this.isAttribute()) {
                this.isOwnedCache = this.eaConnectorEnd.GetOwnedByClassifier();
            }
        }
        return this.isOwnedCache;
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaAttribute != null ? this.eaAttribute.GetStereotypeEx() : this.eaConnectorEnd.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(stereotypes, this);
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        block9: {
            block10: {
                if (this.taggedValuesCache != null) break block9;
                this.taggedValuesCache = this.options().taggedValueFactory(0);
                if (this.eaAttribute == null) break block10;
                Collection tvs = this.eaAttribute.GetTaggedValues();
                if (tvs == null) break block9;
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
                for (AttributeTag tv : tvs) {
                    String t = tv.GetName();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.add(t, v);
                }
                break block9;
            }
            Collection tvs = this.eaConnectorEnd.GetTaggedValues();
            if (tvs != null) {
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
                for (RoleTag tv : tvs) {
                    String t = tv.GetTag();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.startsWith("<memo>$ea_notes=")) {
                        v = v.substring(16);
                    } else if (v.startsWith("<memo>")) {
                        v = "";
                    } else if (v.contains("$ea_notes=")) {
                        v = v.substring(0, v.indexOf("$ea_notes="));
                    }
                    this.taggedValuesCache.add(t, v);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void taggedValue(String tag, String value) {
        if (this.eaAttribute != null) {
            boolean upd = false;
            for (AttributeTag tv : this.eaAttribute.GetTaggedValues()) {
                if (!tv.GetName().equals(tag)) continue;
                if (value == null) {
                    value = "";
                }
                if (tv.GetValue().equals(value)) {
                    return;
                }
                tv.SetValue(value);
                tv.Update();
                return;
            }
            if (upd) return;
            if (value == null) return;
            AttributeTag tv = (AttributeTag)this.eaAttribute.GetTaggedValues().AddNew(tag, value);
            tv.Update();
        } else {
            boolean upd = false;
            for (RoleTag tv : this.eaConnectorEnd.GetTaggedValues()) {
                if (!tv.GetTag().equals(tag)) continue;
                if (value == null) {
                    value = "";
                }
                if (tv.GetValue().equals(value)) {
                    return;
                }
                tv.SetValue(value);
                tv.Update();
                return;
            }
            if (upd) return;
            if (value == null) return;
            Iterator tv = (RoleTag)this.eaConnectorEnd.GetTaggedValues().AddNew(tag, value);
            tv.Update();
        }
        this.taggedValuesCache = null;
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public String id() {
        return this.eaPropertyId;
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            if (this.classInfo == null || this.classInfo.category() != 2 && this.classInfo.category() != 3) {
                this.eaName = this.id();
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "property", this.eaName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.classInfo.fullName());
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 136, this.id(), this.classInfo.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.classInfo.fullName());
                }
            }
        }
        return this.eaName;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            Collection constrs;
            this.constraintsCache = new Vector();
            if (!this.document.options.constraintLoadingEnabled()) {
                return;
            }
            if (!this.document.options.isConstraintCreationForProperties()) {
                return;
            }
            if (this.document.options.isLoadConstraintsForSelectedSchemasOnly() && !this.document.isInSelectedSchemas(this.inClass())) {
                return;
            }
            if (this.eaAttribute != null && (constrs = this.eaAttribute.GetConstraints()) != null) {
                String types = this.document.options.parameter("oclConstraintTypeRegex");
                for (AttributeConstraint constr : constrs) {
                    OclConstraintEA ocl;
                    String type = constr.GetType();
                    Constraint oc = types.length() > 0 && type.matches(types) ? ((ocl = new OclConstraintEA(this.document, this, constr)).syntaxTree() == null ? new TextConstraintEA(this.document, this, constr) : ocl) : (type.equalsIgnoreCase("SBVR") ? new FolConstraintEA(this.document, this, constr) : new TextConstraintEA(this.document, this, constr));
                    this.constraintsCache.add(oc);
                }
            }
        }
    }

    public Vector<Constraint> constraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }

    @Override
    public AssociationInfo association() {
        return this.associationInfo;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty()) {
            if (!this.documentationAccessed && descriptor == Descriptor.DOCUMENTATION) {
                this.documentationAccessed = true;
                String s = null;
                if (this.model().descriptorSource(Descriptor.DOCUMENTATION).equals("ea:notes") && (s = this.eaAttribute != null ? this.eaAttribute.GetNotes() : this.eaConnectorEnd.GetRoleNote()) != null) {
                    s = this.document.applyEAFormatting(s);
                }
                if (s == null || s.isEmpty()) {
                    String thisNameLowerCase = this.name().trim().toLowerCase(Locale.ENGLISH);
                    String thisNameLowerCaseForValueConcept = "_" + thisNameLowerCase;
                    for (String cid : this.classInfo.supplierIds()) {
                        ClassInfoEA cix = (ClassInfoEA)this.document.fClassById.get(cid);
                        if (cix == null) continue;
                        String cixNameLowerCase = cix.name().trim().toLowerCase(Locale.ENGLISH);
                        if (this.classInfo.category() == 3 && cix.stereotype("valueconcept") && (cixNameLowerCase.equals(thisNameLowerCase) || cixNameLowerCase.endsWith(thisNameLowerCaseForValueConcept))) {
                            s = cix.documentation();
                            break;
                        }
                        if (this.classInfo.category() == 3 || !cix.stereotype("attributeconcept") && !cix.stereotype("roleconcept") || !cixNameLowerCase.equals(thisNameLowerCase)) continue;
                        s = cix.documentation();
                        break;
                    }
                }
                if (s != null) {
                    ls.add(new LangString(this.options().internalize(s)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.globalIdentifierAccessed && descriptor == Descriptor.GLOBALIDENTIFIER) {
                this.globalIdentifierAccessed = true;
                if (this.model().descriptorSource(Descriptor.GLOBALIDENTIFIER).equals("ea:guidtoxml")) {
                    Object gi;
                    if (this.eaAttribute != null) {
                        gi = this.document.repository.GetProjectInterface().GUIDtoXML(this.eaAttribute.GetAttributeGUID());
                    } else {
                        String connectorGUID = this.associationInfo.eaConnector.GetConnectorGUID();
                        String xmlGuid = this.document.repository.GetProjectInterface().GUIDtoXML(connectorGUID);
                        String assocRoleGUID = "EAID_" + (this.reversedAssoc ? "src" : "dst") + xmlGuid.substring(7);
                        gi = assocRoleGUID;
                    }
                    if (gi != null && !((String)gi).isEmpty()) {
                        ls.add(new LangString(this.options().internalize((String)gi)));
                        this.descriptors().put(descriptor, ls);
                    }
                }
            } else if (!this.aliasAccessed && descriptor == Descriptor.ALIAS) {
                String a;
                this.aliasAccessed = true;
                if (this.model().descriptorSource(Descriptor.ALIAS).equals("ea:alias") && (a = this.eaAttribute != null ? this.eaAttribute.GetStyle() : this.eaConnectorEnd.GetAlias()) != null && !a.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(a)));
                    this.descriptors().put(descriptor, ls);
                }
            }
        }
        return ls;
    }
}

