/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.TaggedValue;

public class PackageInfoEA
extends PackageInfoImpl
implements PackageInfo {
    protected boolean aliasAccessed = false;
    protected boolean connectorsAccessed = false;
    protected boolean documentationAccessed = false;
    protected boolean globalIdentifierAccessed = false;
    protected Collection<Connector> conns = null;
    protected EADocument document = null;
    protected PackageInfoEA parentPI = null;
    protected TreeSet<PackageInfoEA> childPI = new TreeSet();
    protected TreeSet<ClassInfoEA> childCI = new TreeSet();
    protected Package eaPackage = null;
    protected int eaPackageId = 0;
    protected String packageId = null;
    protected Element eaPackageElmt = null;
    protected int eaPackageElmtId = 0;
    protected String eaName = null;
    protected TreeSet<String> supplierIds = null;

    public Package getEaPackageObj() {
        return this.eaPackage;
    }

    public int getEaPackageId() {
        return this.eaPackageId;
    }

    public PackageInfoEA(EADocument doc, PackageInfoEA ppi, Package pack, Element packelmt) {
        this.document = doc;
        this.eaPackage = pack;
        this.eaPackageId = this.eaPackage.GetPackageID();
        this.packageId = "P" + Integer.valueOf(this.eaPackageId).toString();
        this.eaName = this.eaPackage.GetName().trim();
        this.eaPackageElmt = packelmt;
        if (this.eaPackageElmt != null) {
            this.eaPackageElmtId = this.eaPackageElmt.GetElementID();
        }
        this.parentPI = ppi;
        if (ppi != null) {
            ppi.childPI.add(this);
        }
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public SortedSet<PackageInfo> containedPackages() {
        return (TreeSet)this.childPI.clone();
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaPackage.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(stereotypes, this);
        }
    }

    @Override
    public PackageInfo owner() {
        return this.parentPI;
    }

    @Override
    public SortedSet<String> supplierIds() {
        if (this.supplierIds == null) {
            this.supplierIds = new TreeSet();
            if (!this.connectorsAccessed) {
                this.conns = this.eaPackage.GetConnectors();
                this.connectorsAccessed = true;
            }
            if (this.conns != null) {
                for (Connector conn : this.conns) {
                    String suppPackId;
                    PackageInfoEA suppPack;
                    String type = conn.GetType();
                    if (!type.equals("Dependency") && !type.equals("Package")) continue;
                    int suppId = conn.GetSupplierID();
                    String suppIdS = Integer.toString(suppId);
                    if (suppId == this.eaPackageElmtId || (suppPack = (PackageInfoEA)this.document.fPackageByElmtId.get(suppIdS)) == null || (suppPackId = suppPack.id()) == null) continue;
                    this.supplierIds.add(suppPackId);
                }
            }
        }
        return this.supplierIds;
    }

    @Override
    public String id() {
        return this.packageId;
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            this.eaName = this.id();
            ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "package", this.eaName);
            if (mc != null) {
                mc.addDetail(null, 400, "Package", this.owner().fullName());
            }
        }
        return this.eaName;
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = null;
            int ntvs = 0;
            if (this.eaPackageElmt != null && (tvs = this.eaPackageElmt.GetTaggedValues()) != null) {
                ntvs = tvs.GetCount();
            }
            this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
            if (tvs != null) {
                for (TaggedValue tv : tvs) {
                    String t = tv.GetName();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.add(t, v);
                }
            }
        }
    }

    public void taggedValue(String tag, String value) {
        Collection cTV = this.eaPackageElmt.GetTaggedValues();
        TaggedValue tv = (TaggedValue)cTV.GetByName(tag);
        if (tv == null && value != null) {
            tv = (TaggedValue)cTV.AddNew(tag, value);
            tv.Update();
        } else if (tv != null) {
            if (value == null) {
                value = "";
            }
            if (!tv.GetValue().equals(value)) {
                tv.SetValue(value);
                tv.Update();
            }
        }
        this.taggedValuesCache = null;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty()) {
            if (!this.documentationAccessed && descriptor == Descriptor.DOCUMENTATION) {
                this.documentationAccessed = true;
                String s = this.eaPackage.GetNotes();
                if (s != null) {
                    s = this.document.applyEAFormatting(s);
                }
                if (s != null) {
                    ls.add(new LangString(this.options().internalize(s)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.globalIdentifierAccessed && descriptor == Descriptor.GLOBALIDENTIFIER) {
                String gi;
                this.globalIdentifierAccessed = true;
                if (this.model().descriptorSource(Descriptor.GLOBALIDENTIFIER).equals("ea:guidtoxml") && (gi = this.document.repository.GetProjectInterface().GUIDtoXML(this.eaPackage.GetPackageGUID())) != null && !gi.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(gi)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.aliasAccessed && descriptor == Descriptor.ALIAS) {
                String a;
                this.aliasAccessed = true;
                if (this.model().descriptorSource(Descriptor.ALIAS).equals("ea:alias") && (a = this.eaPackage.GetAlias()) != null && !a.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(a)));
                    this.descriptors().put(descriptor, ls);
                }
            }
        }
        return ls;
    }
}

