/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.OperationInfoImpl;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Type;
import java.util.List;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.Method;
import org.sparx.MethodTag;
import org.sparx.Parameter;

public class OperationInfoEA
extends OperationInfoImpl
implements OperationInfo {
    protected boolean aliasAccessed = false;
    protected boolean globalIdentifierAccessed = false;
    protected EADocument document = null;
    protected ClassInfoEA classInfo = null;
    protected String eaOperationId = null;
    protected String eaName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoEA typeClassInfo = null;
    protected Method eaMethod = null;
    protected Collection<Parameter> eaParametersCache = null;

    public OperationInfoEA(EADocument doc, ClassInfoEA ci, Method meth) {
        this.document = doc;
        this.classInfo = ci;
        this.eaMethod = meth;
        this.eaOperationId = ci.id();
        this.eaOperationId = this.eaOperationId + "_M";
        this.eaOperationId = this.eaOperationId + String.valueOf(this.eaMethod.GetMethodID());
        this.eaName = this.eaMethod.GetName();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
    }

    private void validateParametersCache() {
        if (this.eaParametersCache == null) {
            this.eaParametersCache = this.eaMethod.GetParameters();
        }
    }

    @Override
    public int parameterCount() {
        this.validateParametersCache();
        if (this.eaParametersCache == null) {
            return 0;
        }
        return this.eaParametersCache.GetCount() + 1;
    }

    public TreeMap<Integer, String> parameterNames() {
        this.validateParametersCache();
        int count = 0;
        TreeMap<Integer, String> parms = new TreeMap<Integer, String>();
        if (this.eaParametersCache != null) {
            for (Parameter p : this.eaParametersCache) {
                String name = p.GetName();
                parms.put(++count, name);
            }
            parms.put(++count, "__RETURN__");
        }
        return parms;
    }

    public TreeMap<Integer, String> parameterTypes() {
        this.validateParametersCache();
        int count = 0;
        TreeMap<Integer, String> parms = new TreeMap<Integer, String>();
        if (this.eaParametersCache != null) {
            for (Parameter p : this.eaParametersCache) {
                String type = p.GetType();
                parms.put(++count, type);
            }
            String ret = this.eaMethod.GetReturnType();
            parms.put(++count, ret);
        }
        return parms;
    }

    @Override
    public String id() {
        return this.eaOperationId;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        return this.eaName;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaMethod.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(stereotypes, this);
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaMethod.GetTaggedValues();
            if (tvs != null) {
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
                for (MethodTag tv : tvs) {
                    String t = tv.GetName();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.add(t, v);
                }
            } else {
                this.taggedValuesCache = this.options().taggedValueFactory(0);
            }
        }
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty()) {
            if (!this.globalIdentifierAccessed && descriptor == Descriptor.GLOBALIDENTIFIER) {
                String gi;
                this.globalIdentifierAccessed = true;
                if (this.model().descriptorSource(Descriptor.GLOBALIDENTIFIER).equals("ea:guidtoxml") && (gi = this.document.repository.GetProjectInterface().GUIDtoXML(this.eaMethod.GetMethodGUID())) != null && !gi.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(gi)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.aliasAccessed && descriptor == Descriptor.ALIAS) {
                String a;
                this.aliasAccessed = true;
                if (this.model().descriptorSource(Descriptor.ALIAS).equals("ea:alias") && (a = this.eaMethod.GetStyle()) != null && !a.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(a)));
                    this.descriptors().put(descriptor, ls);
                }
            }
        }
        return ls;
    }
}

