/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraintImpl;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.OclParser;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.StringReader;
import org.sparx.AttributeConstraint;
import org.sparx.Constraint;

public class OclConstraintEA
extends OclConstraintImpl
implements OclConstraint {
    protected EADocument document = null;
    protected Constraint eaConstraintClass;
    protected AttributeConstraint eaConstraintAttribute;

    public OclConstraintEA(EADocument doc, ClassInfoEA ci, Constraint constr) {
        ShapeChangeResult.MessageContext messctx;
        this.document = doc;
        this.contextClass = ci;
        this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        this.contextModelElmt = ci;
        this.eaConstraintClass = constr;
        this.constraintName = constr.GetName();
        this.constraintStatus = constr.GetStatus();
        this.constraintText = constr.GetNotes();
        if (this.constraintText != null) {
            this.constraintText = doc.applyEAFormatting(this.constraintText);
        }
        this.syntaxTree = null;
        StringReader instream = new StringReader(this.constraintText);
        OclParser parse = new OclParser();
        this.document.result.addDebug(null, 10006, ci.name(), this.constraintName);
        this.syntaxTree = parse.parseOcl(instream, this.contextModelElmt);
        if (this.syntaxTree != null) {
            this.conditionType = this.syntaxTree.expressionType;
        }
        this.comments = parse.getComments();
        if (this.document.options.parameter("reportLevel").equals("DEBUG")) {
            String[] comments;
            this.document.result.addDebug(null, 10024, parse.debugTempNodes());
            if (this.syntaxTree != null) {
                this.document.result.addDebug(null, 10024, parse.debugOclNodes());
            }
            for (String c : comments = parse.getComments()) {
                this.document.result.addDebug(null, 10025, c);
            }
        }
        if (parse.getNumberOfMessages() > 0 && (messctx = this.document.result.addError(null, 133, ci.name(), this.constraintName, "class")) != null) {
            MessageCollection.Message[] msg;
            MessageCollection messages = parse.getMessageCollection();
            for (MessageCollection.Message m : msg = messages.getMessages()) {
                String[] del = new String[]{"/", "-", ","};
                String sr = m.getFormattedSourceReferences(1, 1, del);
                String ms = m.getMessageText();
                messctx.addDetail(null, 134, sr, ms);
            }
            String includeConstraintInMessages = this.document.options.parameter("includeConstraintInMessages");
            if (includeConstraintInMessages != null && includeConstraintInMessages.equals("true")) {
                messctx.addDetail("Constraint: " + this.constraintText);
            }
        }
    }

    public OclConstraintEA(EADocument doc, PropertyInfoEA pi, AttributeConstraint constr) {
        ShapeChangeResult.MessageContext messctx;
        this.document = doc;
        this.contextClass = pi.inClass();
        this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        this.contextModelElmt = pi;
        this.eaConstraintAttribute = constr;
        this.constraintName = constr.GetName().trim();
        int ib = this.constraintName.indexOf("[");
        int ie = this.constraintName.indexOf("]", ib);
        this.constraintStatus = "";
        if (ib != -1 && ie != -1) {
            this.constraintStatus = this.constraintName.substring(ib + 1, ie).trim();
            this.constraintName = this.constraintName.substring(0, ib);
        }
        this.constraintText = constr.GetNotes();
        if (this.constraintText != null) {
            this.constraintText = doc.applyEAFormatting(this.constraintText);
        }
        this.syntaxTree = null;
        StringReader instream = new StringReader(this.constraintText);
        OclParser parse = new OclParser();
        this.document.result.addDebug(null, 10006, this.contextClass.name() + "." + pi.name(), this.constraintName);
        this.syntaxTree = parse.parseOcl(instream, this.contextModelElmt);
        if (this.syntaxTree != null) {
            this.conditionType = this.syntaxTree.expressionType;
        }
        this.comments = parse.getComments();
        if (this.document.options.parameter("reportLevel").equals("DEBUG")) {
            String[] comments;
            this.document.result.addDebug(null, 10024, parse.debugTempNodes());
            if (this.syntaxTree != null) {
                this.document.result.addDebug(null, 10024, parse.debugOclNodes());
            }
            for (String c : comments = parse.getComments()) {
                this.document.result.addDebug(null, 10025, c);
            }
        }
        if (parse.getNumberOfMessages() > 0 && (messctx = this.document.result.addError(null, 133, this.contextClass.name() + "." + pi.name(), this.constraintName, "property")) != null) {
            MessageCollection.Message[] msg;
            MessageCollection messages = parse.getMessageCollection();
            for (MessageCollection.Message m : msg = messages.getMessages()) {
                String[] del = new String[]{"/", "-", ","};
                String sr = m.getFormattedSourceReferences(1, 1, del);
                String ms = m.getMessageText();
                messctx.addDetail(null, 134, sr, ms);
            }
            String includeConstraintInMessages = this.document.options.parameter("includeConstraintInMessages");
            if (includeConstraintInMessages != null && includeConstraintInMessages.equals("true")) {
                messctx.addDetail("Constraint: " + this.constraintText);
            }
        }
    }
}

