/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Collection;
import org.sparx.Diagram;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Project;
import org.sparx.Repository;

public class EADocument
extends ModelImpl
implements Model,
MessageSource {
    public static final int STATUS_EADOCUMENT_INITSTART = 101;
    public static final int STATUS_EADOCUMENT_READMODEL = 102;
    public static final int STATUS_EADOCUMENT_ESTABLISHCLASSES = 103;
    public static final int STATUS_EADOCUMENT_READCONSTARINTS = 104;
    public Options options = null;
    public ShapeChangeResult result = null;
    protected Repository repository = null;
    protected final String characterEncoding = "Windows-1252";
    SortedMap<String, ClassInfoEA> fClassById = new TreeMap<String, ClassInfoEA>();
    SortedMap<String, ClassInfoEA> fClassByName = new TreeMap<String, ClassInfoEA>();
    SortedMap<String, PackageInfoEA> fPackageById = new TreeMap<String, PackageInfoEA>();
    SortedMap<String, PackageInfoEA> fPackageByElmtId = new TreeMap<String, PackageInfoEA>();
    SortedMap<String, AssociationInfoEA> fAssociationById = new TreeMap<String, AssociationInfoEA>();
    protected Set<String> excludedPackageNames = null;

    public EADocument() {
    }

    public EADocument(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.initialise(r, o, repositoryFileName);
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileNameOrConnectionString, String username, String password) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        StatusBoard.getStatusBoard().statusChanged(101);
        String connectionString = this.determineConnectionString(repositoryFileNameOrConnectionString);
        this.repository = new Repository();
        r.addInfo(this, 43, connectionString);
        if (!this.repository.OpenFile2(connectionString, username, password)) {
            String errormsg = this.repository.GetLastError();
            r.addFatalError(this, 35, errormsg, repositoryFileNameOrConnectionString, username, password);
            throw new ShapeChangeAbortException();
        }
        r.addInfo(this, 44, connectionString);
        this.executeCommonInitializationProcedure(r);
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileNameOrConnectionString) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        StatusBoard.getStatusBoard().statusChanged(101);
        String connectionString = this.determineConnectionString(repositoryFileNameOrConnectionString);
        this.repository = new Repository();
        r.addInfo(this, 43, connectionString);
        if (!this.repository.OpenFile(connectionString)) {
            String errormsg = this.repository.GetLastError();
            r.addFatalError(null, 30, errormsg, connectionString);
            throw new ShapeChangeAbortException();
        }
        r.addInfo(this, 44, connectionString);
        this.executeCommonInitializationProcedure(r);
    }

    private String determineConnectionString(String repositoryFileNameOrConnectionString) throws ShapeChangeAbortException {
        if (((String)repositoryFileNameOrConnectionString).contains("DBType=") || ((String)repositoryFileNameOrConnectionString).contains("Connect=Cloud")) {
            return repositoryFileNameOrConnectionString;
        }
        File repfile = new File((String)repositoryFileNameOrConnectionString);
        boolean ex = true;
        if (!repfile.exists()) {
            ex = false;
            if (!((String)repositoryFileNameOrConnectionString).toLowerCase().endsWith(".eap")) {
                repositoryFileNameOrConnectionString = (String)repositoryFileNameOrConnectionString + ".eap";
                repfile = new File((String)repositoryFileNameOrConnectionString);
                ex = repfile.exists();
            }
        }
        if (!ex) {
            this.result.addFatalError(null, 31, (String)repositoryFileNameOrConnectionString);
            throw new ShapeChangeAbortException();
        }
        return repfile.getAbsolutePath();
    }

    private void executeCommonInitializationProcedure(ShapeChangeResult r) throws ShapeChangeAbortException {
        boolean loadLinkedDocuments;
        r.addInfo(this, 45, this.repository.GetConnectionString());
        this.excludedPackageNames = this.options.getExcludedPackages();
        StatusBoard.getStatusBoard().statusChanged(102);
        class EvalTask {
            PackageInfoEA fatherPI;
            Package eaPackage;

            EvalTask(PackageInfoEA fpi, Package p) {
                this.fatherPI = fpi;
                this.eaPackage = p;
            }
        }
        LinkedList<EvalTask> evalp = new LinkedList<EvalTask>();
        Collection model = this.repository.GetModels();
        for (Package p : model) {
            String name = p.GetName();
            if (this.excludedPackageNames.contains(name)) continue;
            evalp.addLast(new EvalTask(null, p));
        }
        while (evalp.size() > 0) {
            Iterator<ClassInfoEA> et = (EvalTask)evalp.removeFirst();
            Package pack = ((EvalTask)((Object)et)).eaPackage;
            PackageInfoEA fpi = ((EvalTask)((Object)et)).fatherPI;
            String name = pack.GetName();
            if (this.excludedPackageNames.contains(name)) continue;
            Element packelmt = pack.GetElement();
            PackageInfoEA pi = new PackageInfoEA(this, fpi, pack, packelmt);
            this.fPackageById.put(pi.id(), pi);
            if (packelmt != null) {
                this.fPackageByElmtId.put(Integer.valueOf(packelmt.GetElementID()).toString(), pi);
            }
            for (Element elmt : pack.GetElements()) {
                String statusTaggedValue;
                String type = elmt.GetType();
                if (!type.equals("DataType") && !type.equals("Class") && !type.equals("Interface") && !type.equals("Enumeration") || (statusTaggedValue = EAElementUtil.taggedValue(elmt, "status")) != null && this.options.prohibitedStatusValuesWhenLoadingClasses().contains(statusTaggedValue)) continue;
                ClassInfoEA ci = new ClassInfoEA(this, pi, elmt);
                this.fClassById.put(ci.id(), ci);
                this.fClassByName.put(ci.name(), ci);
            }
            for (Package pnxt : pack.GetPackages()) {
                evalp.addLast(new EvalTask(pi, pnxt));
            }
        }
        StatusBoard.getStatusBoard().statusChanged(103);
        for (ClassInfoEA ci : this.fClassById.values()) {
            ci.establishClassDerivationHierarchy();
            ci.establishAssociations();
        }
        if (this.options.constraintLoadingEnabled()) {
            StatusBoard.getStatusBoard().statusChanged(104);
            for (ClassInfoEA ci : this.fClassById.values()) {
                ci.constraints();
                SortedMap<StructuredNumber, PropertyInfo> props = ci.properties();
                for (PropertyInfo pi : props.values()) {
                    pi.constraints();
                }
            }
        }
        SortedSet<PackageInfo> schemas = this.schemas("");
        for (PackageInfo pi : schemas) {
            this.options.addSchemaLocation(pi.targetNamespace(), pi.xsdDocument());
        }
        String loadDiagrams = this.options.parameter("loadDiagrams");
        if (loadDiagrams != null && loadDiagrams.equalsIgnoreCase("true")) {
            File tmpDir = this.options.imageTmpDir();
            if (tmpDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (IOException e) {
                    this.result.addWarning(this, 34, tmpDir.getAbsolutePath());
                }
                if (!tmpDir.exists()) {
                    try {
                        FileUtils.forceMkdir((File)tmpDir);
                    }
                    catch (IOException e) {
                        this.result.addWarning(null, 32, tmpDir.getAbsolutePath());
                    }
                }
            }
            AtomicInteger imgIdCounter = new AtomicInteger(0);
            SortedSet<PackageInfo> selectedSchema = this.selectedSchemas();
            for (PackageInfo pi : selectedSchema) {
                if (pi == null || this.options.skipSchema(pi)) continue;
                this.saveDiagrams(imgIdCounter, "img", tmpDir, this.escapeFileName(tmpDir.getName()), pi);
            }
        }
        if (loadLinkedDocuments = this.options.parameterAsBoolean(null, "loadLinkedDocuments", false)) {
            File tmpDir = this.options.linkedDocumentsTmpDir();
            if (tmpDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (IOException e) {
                    this.result.addWarning(this, 34, tmpDir.getAbsolutePath());
                }
                if (!tmpDir.exists()) {
                    try {
                        FileUtils.forceMkdir((File)tmpDir);
                    }
                    catch (IOException e) {
                        this.result.addWarning(null, 32, tmpDir.getAbsolutePath());
                    }
                }
            }
            this.saveLinkedDocuments(tmpDir);
        }
        r.addInfo(this, 46, this.repository.GetConnectionString());
    }

    private String escapeFileName(String filename) {
        if (filename == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char aChar = filename.charAt(i);
            if (aChar == ' ') {
                sb.append('_');
                continue;
            }
            if (!CharUtils.isAsciiPrintable((char)aChar)) continue;
            sb.append(aChar);
        }
        return sb.toString();
    }

    private void saveDiagrams(AtomicInteger imgIdCounter, String imgIdPrefix, File targetFolder, String relPathWithTargetFolder, PackageInfo pi) {
        String classDiagramRegex;
        File pi_folder;
        if (!targetFolder.exists()) {
            targetFolder.mkdir();
        }
        if (!(pi_folder = new File(targetFolder, this.escapeFileName(pi.name()))).mkdir()) {
            this.result.addWarning(null, 32, pi_folder.getAbsolutePath());
        }
        String newRelPathWithTargetFolder = relPathWithTargetFolder + "/" + this.escapeFileName(pi.name());
        Project projectInterface = this.repository.GetProjectInterface();
        PackageInfoEA piEa = (PackageInfoEA)this.fPackageById.get(pi.id());
        List<Diagram> diagramList = this.getDiagramsOfPackage(piEa);
        String packageDiagramRegex = this.options.parameter("packageDiagramRegex");
        if (packageDiagramRegex == null) {
            packageDiagramRegex = "NAME";
        }
        if ((classDiagramRegex = this.options.parameter("classDiagramRegex")) == null) {
            classDiagramRegex = "NAME";
        }
        String elementNameKeyForMatching = "NAME";
        for (Diagram d : diagramList) {
            SortedSet<ClassInfo> clTmp;
            String regexForModelElement;
            boolean relevantDiagram;
            String type;
            String relPathToFile;
            File img;
            String imgName;
            String imgId;
            block18: {
                block17: {
                    imgId = imgIdPrefix + imgIdCounter.incrementAndGet();
                    String imgFileName = this.escapeFileName(imgId + ".jpg");
                    imgName = d.GetName();
                    img = new File(pi_folder, imgFileName);
                    relPathToFile = newRelPathWithTargetFolder + "/" + imgFileName;
                    type = d.GetType();
                    relevantDiagram = false;
                    if (!type.equalsIgnoreCase("Package")) break block17;
                    regexForModelElement = packageDiagramRegex.replaceAll(elementNameKeyForMatching, pi.name());
                    if (!imgName.matches(regexForModelElement)) break block18;
                    relevantDiagram = true;
                    break block18;
                }
                if (type.equalsIgnoreCase("Logical") || type.equalsIgnoreCase("class")) {
                    SortedSet<ClassInfo> clTmp2;
                    regexForModelElement = packageDiagramRegex.replaceAll(elementNameKeyForMatching, pi.name());
                    if (imgName.matches(regexForModelElement)) {
                        relevantDiagram = true;
                    }
                    if ((clTmp2 = this.classes(pi)) != null && !clTmp2.isEmpty() && !relevantDiagram) {
                        for (ClassInfo ci : clTmp2) {
                            if (ci.pkg() != pi || !imgName.matches(regexForModelElement = classDiagramRegex.replaceAll(elementNameKeyForMatching, ci.name()))) continue;
                            relevantDiagram = true;
                            break;
                        }
                    }
                }
            }
            if (!relevantDiagram) continue;
            this.repository.OpenDiagram(d.GetDiagramID());
            projectInterface.SaveDiagramImageToFile(img.getAbsolutePath());
            String lastError = projectInterface.GetLastError();
            if (StringUtils.isNotBlank((CharSequence)lastError)) {
                this.result.addWarning("An error was reported by the EA ProjectInterface after saving image of diagram '" + imgName + "' to file '" + img.getAbsolutePath() + "': " + lastError);
            }
            this.repository.CloseDiagram(d.GetDiagramID());
            int width = 400;
            int height = 400;
            try {
                BufferedImage bimg = ImageIO.read(img);
                width = bimg.getWidth();
                height = bimg.getHeight();
            }
            catch (IOException e) {
                this.result.addError(this, 33, imgName, pi.name());
                e.printStackTrace(System.err);
                continue;
            }
            ImageMetadata imgMeta = new ImageMetadata(imgId, imgName, img, relPathToFile, width, height);
            if (type.equalsIgnoreCase("Package")) {
                this.addDiagramToPackage(pi, imgMeta);
                continue;
            }
            if (!type.equalsIgnoreCase("Logical") && !type.equalsIgnoreCase("class")) continue;
            regexForModelElement = packageDiagramRegex.replaceAll(elementNameKeyForMatching, pi.name());
            if (imgName.matches(regexForModelElement)) {
                this.addDiagramToPackage(pi, imgMeta);
            }
            if ((clTmp = this.classes(pi)) == null || clTmp.isEmpty()) continue;
            for (ClassInfo ci : clTmp) {
                if (ci.pkg() != pi || !imgName.matches(regexForModelElement = classDiagramRegex.replaceAll(elementNameKeyForMatching, ci.name()))) continue;
                this.addDiagramToClass(ci, imgMeta);
            }
        }
        SortedSet<PackageInfo> children = pi.containedPackages();
        if (children != null) {
            for (PackageInfo piChild : children) {
                if (!piChild.targetNamespace().equals(pi.targetNamespace())) continue;
                this.saveDiagrams(imgIdCounter, imgIdPrefix, pi_folder, newRelPathWithTargetFolder, piChild);
            }
        }
    }

    private void saveLinkedDocuments(File targetFolder) {
        if (!targetFolder.exists()) {
            targetFolder.mkdir();
        }
        SortedSet<? extends ClassInfo> selClasses = this.selectedSchemaClasses();
        for (ClassInfo classInfo : selClasses) {
            ClassInfoEA eaCi = (ClassInfoEA)classInfo;
            File ldFile = new File(targetFolder, "linkedDoc_" + eaCi.name() + ".docx");
            boolean fileSaved = eaCi.eaClassElement.SaveLinkedDocument(ldFile.getAbsolutePath());
            if (fileSaved) {
                eaCi.setLinkedDocument(ldFile);
                continue;
            }
            eaCi.setLinkedDocument(null);
        }
    }

    private List<Diagram> getDiagramsOfPackage(PackageInfoEA piEa) {
        Collection diagrams = piEa.eaPackage.GetDiagrams();
        ArrayList<Diagram> diagramList = new ArrayList<Diagram>();
        for (Diagram d : diagrams) {
            diagramList.add(d);
        }
        boolean sortDiagramsByName = this.options.parameterAsBoolean(null, "sortDiagramsByName", true);
        if (sortDiagramsByName) {
            Collections.sort(diagramList, new Comparator<Diagram>(){

                @Override
                public int compare(Diagram o1, Diagram o2) {
                    return o1.GetName().compareTo(o2.GetName());
                }
            });
        }
        return diagramList;
    }

    private void addDiagramToClass(ClassInfo ci, ImageMetadata imgMeta) {
        List<ImageMetadata> ciDiagrams = ci.getDiagrams();
        if (ciDiagrams == null) {
            ciDiagrams = new ArrayList<ImageMetadata>();
        }
        ciDiagrams.add(imgMeta);
        ci.setDiagrams(ciDiagrams);
    }

    private void addDiagramToPackage(PackageInfo pi, ImageMetadata imgMeta) {
        List<ImageMetadata> piDiagrams = pi.getDiagrams();
        if (piDiagrams == null) {
            piDiagrams = new ArrayList<ImageMetadata>();
        }
        piDiagrams.add(imgMeta);
        pi.setDiagrams(piDiagrams);
    }

    @Override
    public String characterEncoding() {
        return "Windows-1252";
    }

    @Override
    public ClassInfo classById(String id) {
        return (ClassInfo)this.fClassById.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return (ClassInfo)this.fClassByName.get(nam);
    }

    @Override
    public SortedSet<ClassInfo> classes() {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        result.addAll(this.fClassById.values());
        return result;
    }

    @Override
    public SortedSet<ClassInfo> classes(PackageInfo pi) {
        TreeSet<ClassInfo> res = new TreeSet<ClassInfo>();
        String tns = pi.targetNamespace();
        return this.addClasses((PackageInfoEA)pi, tns, res);
    }

    private SortedSet<ClassInfo> addClasses(PackageInfoEA pi, String tns, SortedSet<ClassInfo> res) {
        String ctns = pi.targetNamespace();
        if (!(ctns == null || tns != null && tns.equals(ctns))) {
            return res;
        }
        res.addAll(pi.childCI);
        for (PackageInfoEA cpi : pi.childPI) {
            res = this.addClasses(cpi, tns, res);
        }
        return res;
    }

    @Override
    public PackageInfo packageById(String id) {
        return (PackageInfo)this.fPackageById.get(id);
    }

    @Override
    public void shutdown() {
        if (this.repository != null) {
            this.repository.CloseFile();
            this.repository.Exit();
            this.repository = null;
        }
    }

    public Repository getEARepository() {
        return this.repository;
    }

    public String applyEAFormatting(String s) {
        return this.repository.GetFormatFromField("TXT", s);
    }

    public Repository repository() {
        return this.repository;
    }

    @Override
    public SortedSet<PackageInfo> packages() {
        TreeSet<PackageInfo> allPackages = new TreeSet<PackageInfo>();
        for (PackageInfo packageInfo : this.fPackageById.values()) {
            allPackages.add(packageInfo);
        }
        return allPackages;
    }

    @Override
    public String descriptorSource(Descriptor descriptor) {
        Object source = this.options().descriptorSource(descriptor.getName());
        if (source == null) {
            source = descriptor == Descriptor.DOCUMENTATION ? "ea:notes" : (descriptor == Descriptor.ALIAS ? "ea:alias" : (descriptor == Descriptor.GLOBALIDENTIFIER ? "none" : (descriptor == Descriptor.DEFINITION ? "sc:extract#PROLOG" : (descriptor == Descriptor.DESCRIPTION ? "none" : "tag#" + descriptor))));
        }
        return source;
    }

    @Override
    public SortedSet<AssociationInfo> associations() {
        return this.fAssociationById.isEmpty() ? new TreeSet<AssociationInfo>() : new TreeSet<AssociationInfoEA>(this.fAssociationById.values());
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Context: supertype '$1$'";
            }
            case 5: {
                return "Context: subtype '$1$'";
            }
            case 33: {
                return "Could not read diagram from temporary image directory (diagram name: $1$, in package: $2$); this diagram will be ignored.";
            }
            case 34: {
                return "Could not delete directory $1$";
            }
            case 35: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$2$', username is: '$3$', password is: '$4$', EA message is: '$1$'";
            }
            case 43: {
                return "Connecting to $1$";
            }
            case 44: {
                return "Connected to $1$";
            }
            case 45: {
                return "Starting reading $1$";
            }
            case 46: {
                return "Finished reading $1$";
            }
        }
        return "(" + EADocument.class.getName() + ") Unknown message with number: " + mnr;
    }
}

