/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.FolConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.OperationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.junit.platform.commons.util.StringUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.Element;
import org.sparx.Method;
import org.sparx.TaggedValue;

public class ClassInfoEA
extends ClassInfoImpl
implements ClassInfo,
MessageSource {
    protected boolean aliasAccessed = false;
    protected boolean connectorsAccessed = false;
    protected boolean documentationAccessed = false;
    protected boolean globalIdentifierAccessed = false;
    protected boolean isAssocClassAccessed = false;
    protected AssociationInfo assoc = null;
    protected Collection<Connector> conns = null;
    protected TreeSet<String> supplierIds = null;
    protected EADocument document;
    protected PackageInfoEA packageInfo;
    protected TreeSet<ClassInfoEA> baseclassInfoSet = null;
    protected TreeSet<ClassInfoEA> subclassInfoSet = new TreeSet();
    protected Element eaClassElement = null;
    protected int eaClassId = 0;
    protected String eaName = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected Vector<PropertyInfoEA> registeredRoles = new Vector();
    protected Vector<PropertyInfoEA> registeredRolesAsAttributes = new Vector();
    protected TreeMap<StructuredNumber, PropertyInfo> propertiesCache = null;
    protected TreeMap<Integer, OperationInfo> operationsCache = null;
    protected Vector<Constraint> constraintsCache = null;
    private Boolean realization = null;

    public ClassInfoEA(EADocument doc, PackageInfoEA pi, Element elmt) throws ShapeChangeAbortException {
        String realization;
        this.document = doc;
        this.packageInfo = pi;
        this.eaClassElement = elmt;
        this.eaClassId = this.eaClassElement.GetElementID();
        this.eaName = this.eaClassElement.GetName().trim();
        pi.childCI.add(this);
        this.isAbstract = this.eaClassElement.GetAbstract().equals("1");
        this.isLeaf = this.eaClassElement.GetIsLeaf();
        this.establishCategory();
        if (this.category == -1 && elmt.GetType().equalsIgnoreCase("enumeration")) {
            this.category = 3;
        }
        if ((realization = this.document.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "realisationLikeGeneralisation")) != null && realization.equalsIgnoreCase("false")) {
            this.realization = Boolean.FALSE;
        }
    }

    public void establishClassDerivationHierarchy() {
        if (!this.connectorsAccessed) {
            this.conns = this.eaClassElement.GetConnectors();
            this.connectorsAccessed = true;
        }
        if (this.conns != null) {
            for (Connector conn : this.conns) {
                int cat;
                int bclid;
                ClassInfoEA baseCI;
                int clientid;
                String conntype = conn.GetType();
                boolean gen = conntype.equals("Generalization");
                boolean rea = conntype.equals("Realisation");
                if (this.realization != null && !this.realization.booleanValue()) {
                    rea = false;
                }
                if (!gen && !rea || (clientid = conn.GetClientID()) != this.eaClassId || (baseCI = (ClassInfoEA)this.document.fClassById.get(String.valueOf(bclid = conn.GetSupplierID()))) == null || rea && (cat = baseCI.category()) != 4) continue;
                if (this.baseclassInfoSet == null) {
                    this.baseclassInfoSet = new TreeSet();
                }
                this.baseclassInfoSet.add(baseCI);
                baseCI.subclassInfoSet.add(this);
            }
        }
    }

    public void establishAssociations() {
        if (!this.connectorsAccessed) {
            this.conns = this.eaClassElement.GetConnectors();
            this.connectorsAccessed = true;
        }
        if (this.conns != null) {
            for (Connector conn : this.conns) {
                int id;
                String connid;
                boolean known;
                String type = conn.GetType();
                if (!type.equalsIgnoreCase("Association") && !type.equalsIgnoreCase("Aggregation") || (known = this.document.fAssociationById.containsKey(connid = this.createAssociationId(Integer.valueOf(id = conn.GetConnectorID()).toString())))) continue;
                Integer clientId = conn.GetClientID();
                Integer supplierId = conn.GetSupplierID();
                Integer otherEndId = clientId.toString().equals(this.id()) ? supplierId : clientId;
                Element otherEndClass = this.document.getEARepository().GetElementByID(otherEndId.intValue());
                boolean otherEndNotInExcludedPackages = this.document.fClassById.containsKey(otherEndId.toString());
                String statusTaggedValue = EAElementUtil.taggedValue(otherEndClass, "status");
                if (!StringUtils.isBlank((String)statusTaggedValue) && this.options().prohibitedStatusValuesWhenLoadingClasses().contains(statusTaggedValue)) continue;
                if (otherEndNotInExcludedPackages) {
                    AssociationInfoEA ai = new AssociationInfoEA(this.document, conn, connid);
                    if (!ai.relevant) continue;
                    this.document.fAssociationById.put(connid, ai);
                    continue;
                }
                ConnectorEnd otherEnd = clientId.toString().equals(this.id()) ? conn.GetSupplierEnd() : conn.GetClientEnd();
                if (!EAConnectorEndUtil.isNavigable(otherEnd, conn)) continue;
                PropertyInfoEA roleAsAttribute = new PropertyInfoEA(this.document, this, otherEnd, connid, otherEndClass.GetName());
                this.registeredRolesAsAttributes.add(roleAsAttribute);
            }
        }
    }

    private String createAssociationId(String baseId) {
        return "as" + baseId;
    }

    public void establishRoles(PropertyInfoEA pi) {
        this.registeredRoles.add(pi);
    }

    public Element getEaClassElement() {
        return this.eaClassElement;
    }

    public int getEaElementId() {
        return this.eaClassId;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public boolean checkSupertypes(int cat) {
        TreeSet<Object> bcis = new TreeSet();
        if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        boolean res = true;
        for (ClassInfoEA classInfoEA : bcis) {
            int bcicat = classInfoEA.category();
            if (bcicat == -1) {
                res = classInfoEA.checkSupertypes(cat);
            } else {
                if (bcicat == 4) continue;
                if (bcicat != cat) {
                    res = false;
                }
            }
            if (res) continue;
            break;
        }
        if (res) {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "TRUE");
        } else {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    @Override
    public PackageInfo pkg() {
        return this.packageInfo;
    }

    @Override
    public SortedMap<StructuredNumber, PropertyInfo> properties() {
        this.validatePropertiesCache();
        return (TreeMap)this.propertiesCache.clone();
    }

    @Override
    public PropertyInfo property(String name) {
        this.validatePropertiesCache();
        for (PropertyInfo pi : this.propertiesCache.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        TreeSet<Object> bcis = new TreeSet();
        if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoEA bci : bcis) {
            PropertyInfo pi = bci.property(name);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaClassElement.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(stereotypes, this);
            if (!this.stereotypesCache.contains("enumeration") && !this.stereotypesCache.contains("codelist") && this.eaClassElement.GetType().equalsIgnoreCase("enumeration")) {
                this.stereotypesCache.add("enumeration");
                this.document.result.addDebug(null, 52, this.name(), "enumeration");
            }
            if (!this.stereotypesCache.contains("datatype") && !this.stereotypesCache.contains("union") && this.eaClassElement.GetType().equalsIgnoreCase("datatype")) {
                this.stereotypesCache.add("datatype");
                this.document.result.addDebug(null, 52, this.name(), "datatype");
            }
            this.document.result.addDebug(this, 55, this.name(), Integer.toString(this.stereotypesCache.size()), this.stereotypesCache.toString());
        }
    }

    @Override
    public SortedSet<String> subtypes() {
        TreeSet<String> subids = new TreeSet<String>();
        for (ClassInfoEA sci : this.subclassInfoSet) {
            subids.add(sci.id());
        }
        return subids;
    }

    @Override
    public SortedSet<String> supertypes() {
        TreeSet<String> baseids = new TreeSet<String>();
        if (this.baseclassInfoSet != null) {
            for (ClassInfoEA bci : this.baseclassInfoSet) {
                baseids.add(bci.id());
            }
        }
        return baseids;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty()) {
            if (!this.documentationAccessed && descriptor == Descriptor.DOCUMENTATION) {
                HashSet<ClassInfoEA> sts;
                this.documentationAccessed = true;
                String s = null;
                if (this.model().descriptorSource(Descriptor.DOCUMENTATION).equals("ea:notes") && (s = this.eaClassElement.GetNotes()) != null) {
                    s = this.document.applyEAFormatting(s);
                }
                if (s == null || s.isEmpty()) {
                    for (String cid : this.supplierIds()) {
                        ClassInfoEA cix = (ClassInfoEA)this.document.fClassById.get(cid);
                        if (cix == null || !cix.name().equalsIgnoreCase(this.name()) || !cix.stereotype("featureconcept")) continue;
                        s = cix.documentation();
                        break;
                    }
                }
                if ((s == null || s.isEmpty()) && (sts = this.supertypesAsClassInfoEA()) != null) {
                    for (ClassInfoEA stci : sts) {
                        if (!stci.name().equals(this.name())) continue;
                        s = stci.documentation();
                        break;
                    }
                }
                if (s != null) {
                    ls.add(new LangString(this.options().internalize(s)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.globalIdentifierAccessed && descriptor == Descriptor.GLOBALIDENTIFIER) {
                String gi;
                this.globalIdentifierAccessed = true;
                if (this.model().descriptorSource(Descriptor.GLOBALIDENTIFIER).equals("ea:guidtoxml") && (gi = this.document.repository.GetProjectInterface().GUIDtoXML(this.eaClassElement.GetElementGUID())) != null && !gi.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(gi)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.aliasAccessed && descriptor == Descriptor.ALIAS) {
                String a;
                this.aliasAccessed = true;
                if (this.model().descriptorSource(Descriptor.ALIAS).equals("ea:alias") && (a = this.eaClassElement.GetAlias()) != null && !a.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(a)));
                    this.descriptors().put(descriptor, ls);
                }
            }
        }
        return ls;
    }

    @Override
    public String id() {
        return Integer.valueOf(this.eaClassId).toString();
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            this.eaName = this.id();
            ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "class", this.eaName);
            if (mc != null) {
                mc.addDetail(null, 400, "Package", this.pkg().fullName());
            }
        }
        return this.eaName;
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaClassElement.GetTaggedValues();
            if (tvs != null) {
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
                for (TaggedValue tv : tvs) {
                    String t = tv.GetName();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.add(t, v);
                }
            } else {
                this.taggedValuesCache = this.options().taggedValueFactory(0);
            }
        }
    }

    public void taggedValue(String tag, String value) {
        Collection cTV = this.eaClassElement.GetTaggedValues();
        TaggedValue tv = (TaggedValue)cTV.GetByName(tag);
        if (tv == null && value != null) {
            tv = (TaggedValue)cTV.AddNew(tag, value);
            tv.Update();
        } else if (tv != null) {
            if (value == null) {
                value = "";
            }
            if (!tv.GetValue().equals(value)) {
                tv.SetValue(value);
                tv.Update();
            }
        }
        this.taggedValuesCache = null;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            this.constraintsCache = new Vector();
            if (!this.document.options.constraintLoadingEnabled()) {
                return;
            }
            if (!this.document.options.isClassTypeToCreateConstraintsFor(this.category())) {
                return;
            }
            if (this.document.options.isLoadConstraintsForSelectedSchemasOnly() && !this.document.isInSelectedSchemas(this)) {
                return;
            }
            Collection constrs = this.eaClassElement.GetConstraints();
            String oclTypes = this.document.options.parameter("oclConstraintTypeRegex");
            String folTypes = this.document.options.parameter("folConstraintTypeRegex");
            if (constrs != null) {
                for (org.sparx.Constraint constr : constrs) {
                    OclConstraintEA ocl;
                    String type = constr.GetType();
                    Constraint oc = oclTypes.length() > 0 && type.matches(oclTypes) ? ((ocl = new OclConstraintEA(this.document, this, constr)).syntaxTree() == null ? new TextConstraintEA(this.document, this, constr) : ocl) : (folTypes != null && folTypes.length() > 0 && type.matches(folTypes) ? new FolConstraintEA(this.document, this, constr) : new TextConstraintEA(this.document, this, constr));
                    this.constraintsCache.add(oc);
                }
            }
        }
    }

    private HashSet<ClassInfoEA> supertypesAsClassInfoEA() {
        HashSet<ClassInfoEA> baseClasses = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfoSet != null) {
            for (ClassInfoEA bci : this.baseclassInfoSet) {
                baseClasses.add(bci);
            }
        }
        return baseClasses;
    }

    public Vector<Constraint> directConstraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }

    private void validatePropertiesCache() {
        if (this.propertiesCache == null) {
            ShapeChangeResult.MessageContext mc;
            PropertyInfo piTemp;
            this.propertiesCache = new TreeMap();
            Collection attrs = this.eaClassElement.GetAttributes();
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    ShapeChangeResult.MessageContext mc2;
                    int cat;
                    String vis;
                    if (this.document.options.parameter("publicOnly").equals("true") && !(vis = attr.GetVisibility()).equalsIgnoreCase("Public")) continue;
                    PropertyInfoEA pi = new PropertyInfoEA(this.document, this, attr);
                    PropertyInfo piTemp2 = this.propertiesCache.get(pi.sequenceNumber());
                    if (piTemp2 != null && (cat = this.category()) != 3 && cat != 2 && !pi.sequenceNumber.equals(new StructuredNumber(Integer.MIN_VALUE)) && (mc2 = this.document.result.addError(null, 107, pi.name(), this.name(), piTemp2.name())) != null) {
                        mc2.addDetail(null, 400, "Package", this.pkg().fullName());
                    }
                    this.propertiesCache.put(pi.sequenceNumber(), pi);
                }
            }
            for (PropertyInfoEA pi : this.registeredRoles) {
                piTemp = this.propertiesCache.get(pi.sequenceNumber());
                if (piTemp != null && (mc = this.document.result.addError(null, 107, pi.name(), this.name(), piTemp.name())) != null) {
                    mc.addDetail(null, 400, "Package", this.pkg().fullName());
                }
                this.propertiesCache.put(pi.sequenceNumber(), pi);
            }
            for (PropertyInfoEA pi : this.registeredRolesAsAttributes) {
                piTemp = this.propertiesCache.get(pi.sequenceNumber());
                if (piTemp != null && (mc = this.document.result.addError(null, 107, pi.name(), this.name(), piTemp.name())) != null) {
                    mc.addDetail(null, 400, "Package", this.pkg().fullName());
                }
                this.propertiesCache.put(pi.sequenceNumber(), pi);
            }
        }
    }

    private void validateOperationsCache() {
        if (this.operationsCache == null) {
            this.operationsCache = new TreeMap();
            Collection meths = this.eaClassElement.GetMethods();
            int i = 0;
            if (meths != null) {
                for (Method meth : meths) {
                    OperationInfoEA oi = new OperationInfoEA(this.document, this, meth);
                    this.operationsCache.put(++i, oi);
                }
            }
        }
    }

    @Override
    public OperationInfo operation(String name, String[] types) {
        this.validateOperationsCache();
        block0: for (OperationInfo oi : this.operationsCache.values()) {
            if (!oi.name().equals(name)) continue;
            if (types == null) {
                return oi;
            }
            if (types.length != oi.parameterCount()) continue;
            SortedMap<Integer, String> ptypes = oi.parameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals("*") && !((String)ptypes.get(i + 1)).equals(types[i])) continue block0;
            }
            return oi;
        }
        TreeSet<Object> bcis = new TreeSet();
        if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoEA bci : bcis) {
            OperationInfo oi = bci.operation(name, types);
            if (oi == null) continue;
            return oi;
        }
        return null;
    }

    @Override
    public AssociationInfo isAssocClass() {
        if (!this.isAssocClassAccessed) {
            this.isAssocClassAccessed = true;
            if (this.eaClassElement.GetSubtype() == 17 && !this.eaClassElement.MiscData(3).isEmpty()) {
                this.assoc = (AssociationInfo)this.document.fAssociationById.get(this.createAssociationId(this.eaClassElement.MiscData(3)));
            }
        }
        return this.assoc;
    }

    protected TreeSet<String> supplierIds() {
        if (this.supplierIds == null) {
            this.supplierIds = new TreeSet();
            if (!this.connectorsAccessed) {
                this.conns = this.eaClassElement.GetConnectors();
                this.connectorsAccessed = true;
            }
            if (this.conns != null) {
                for (Connector conn : this.conns) {
                    String suppPackId;
                    ClassInfoEA suppClass;
                    String type = conn.GetType();
                    if (!type.equals("Dependency")) continue;
                    int suppId = conn.GetSupplierID();
                    String suppIdS = Integer.toString(suppId);
                    if (suppId == this.eaClassId || (suppClass = (ClassInfoEA)this.document.fClassById.get(suppIdS)) == null || (suppPackId = suppClass.id()) == null) continue;
                    this.supplierIds.add(suppPackId);
                }
            }
        }
        return this.supplierIds;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 55: {
                return "After taking into account data types and enumerations modelled without the use of stereotypes is element '$1$' treated as having $2$ well-known stereotype(s): '$3$'";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

