/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.AssociationInfoImpl;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.StereotypeNormalizer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import java.util.List;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.ConnectorTag;

public class AssociationInfoEA
extends AssociationInfoImpl
implements AssociationInfo {
    EADocument document = null;
    Connector eaConnector = null;
    protected String connectorId = null;
    protected int navigability = 0;
    protected boolean relevant = false;
    protected PropertyInfoEA[] properties = new PropertyInfoEA[]{null, null};
    protected boolean aliasAccessed = false;
    protected boolean assocAccessed = false;
    protected ClassInfo assocClass = null;
    protected boolean documentationAccessed = false;
    protected boolean globalIdentifierAccessed = false;

    AssociationInfoEA(EADocument doc, Connector conn, String id) {
        this.document = doc;
        this.eaConnector = conn;
        this.connectorId = id;
        this.name = this.eaConnector.GetName();
        this.navigability = EAConnectorUtil.navigability(this.eaConnector);
        Role[] roles = new Role[2];
        ConnectorEnd ce = null;
        class Role {
            ConnectorEnd eaConnEnd = null;
            ClassInfoEA ci = null;

            Role() {
            }
        }
        roles[0] = new Role();
        ce = this.eaConnector.GetClientEnd();
        Integer cid = this.eaConnector.GetClientID();
        roles[0].ci = (ClassInfoEA)this.document.fClassById.get(cid.toString());
        roles[0].eaConnEnd = ce;
        roles[1] = new Role();
        ce = this.eaConnector.GetSupplierEnd();
        cid = this.eaConnector.GetSupplierID();
        roles[1].ci = (ClassInfoEA)this.document.fClassById.get(cid.toString());
        roles[1].eaConnEnd = ce;
        if (roles[0].ci != null && roles[1].ci != null) {
            this.relevant = true;
            for (int i = 0; i < 2; ++i) {
                PropertyInfoEA pi;
                this.properties[i] = pi = new PropertyInfoEA(this.document, roles[1 - i].ci, this, i == 0, roles[i].eaConnEnd, roles[i].ci);
                if (!pi.isNavigable()) continue;
                roles[1 - i].ci.establishRoles(pi);
            }
        }
        this.document.result.addDebug(null, 10013, "association", this.id(), this.name());
    }

    @Override
    public PropertyInfo end1() {
        return this.properties[0];
    }

    @Override
    public PropertyInfo end2() {
        return this.properties[1];
    }

    @Override
    public String id() {
        return this.connectorId;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaConnector.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = StereotypeNormalizer.normalizeAndMapToWellKnownStereotype(stereotypes, this);
        }
    }

    @Override
    public void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaConnector.GetTaggedValues();
            if (tvs != null) {
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = this.options().taggedValueFactory(ntvs);
                for (ConnectorTag tv : tvs) {
                    String t = tv.GetName();
                    t = this.options().taggedValueNormalizer().normalizeTaggedValue(t);
                    if (t == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.add(t, v);
                }
            } else {
                this.taggedValuesCache = this.options().taggedValueFactory(0);
            }
        }
    }

    @Override
    public ClassInfo assocClass() {
        if (!this.assocAccessed) {
            this.assocAccessed = true;
            if (EAConnectorUtil.isAssociationClassConnector(this.eaConnector)) {
                this.assocClass = (ClassInfo)this.document.fClassById.get(this.eaConnector.MiscData(0));
            }
        }
        return this.assocClass;
    }

    @Override
    protected List<LangString> descriptorValues(Descriptor descriptor) {
        List<LangString> ls = super.descriptorValues(descriptor);
        if (ls.isEmpty()) {
            if (!this.documentationAccessed && descriptor == Descriptor.DOCUMENTATION) {
                this.documentationAccessed = true;
                String s = this.eaConnector.GetNotes();
                if (s != null) {
                    s = this.document.applyEAFormatting(s);
                }
                if (s != null) {
                    ls.add(new LangString(this.options().internalize(s)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.globalIdentifierAccessed && descriptor == Descriptor.GLOBALIDENTIFIER) {
                String gi;
                this.globalIdentifierAccessed = true;
                if (this.model().descriptorSource(Descriptor.GLOBALIDENTIFIER).equals("ea:guidtoxml") && (gi = this.document.repository.GetProjectInterface().GUIDtoXML(this.eaConnector.GetConnectorGUID())) != null && !gi.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(gi)));
                    this.descriptors().put(descriptor, ls);
                }
            } else if (!this.aliasAccessed && descriptor == Descriptor.ALIAS) {
                String a;
                this.aliasAccessed = true;
                if (this.model().descriptorSource(Descriptor.ALIAS).equals("ea:alias") && (a = this.eaConnector.GetAlias()) != null && !a.isEmpty()) {
                    ls.add(new LangString(this.options().internalize(a)));
                    this.descriptors().put(descriptor, ls);
                }
            }
        }
        return ls;
    }
}

