/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.LangString;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Descriptors {
    private EnumMap<Descriptor, DescriptorValue> descriptorValues = new EnumMap(Descriptor.class);

    public boolean has(Descriptor descriptor) {
        return this.descriptorValues.containsKey((Object)descriptor);
    }

    public List<LangString> values(Descriptor descriptor) {
        ArrayList<LangString> result = new ArrayList<LangString>();
        DescriptorValue dv = this.descriptorValues.get((Object)descriptor);
        if (dv != null) {
            result.addAll(dv.getValues());
        }
        return result;
    }

    public boolean isEmpty() {
        if (this.descriptorValues == null || this.descriptorValues.isEmpty()) {
            return true;
        }
        boolean nonBlankValueFound = false;
        block0: for (DescriptorValue dv : this.descriptorValues.values()) {
            if (dv == null || dv.getValues().isEmpty()) continue;
            for (LangString value : dv.getValues()) {
                if (!StringUtils.isNotBlank((CharSequence)value.getValue())) continue;
                nonBlankValueFound = true;
                break block0;
            }
        }
        return !nonBlankValueFound;
    }

    public List<String> values(Descriptor descriptor, String lang) {
        ArrayList<String> result = new ArrayList<String>();
        DescriptorValue dv = this.descriptorValues.get((Object)descriptor);
        if (dv != null) {
            List<LangString> lvs = dv.getValues();
            for (LangString lv : lvs) {
                if ((lang != null || lv.hasLang()) && (lang == null || !lv.hasLang() || !lv.getLang().equalsIgnoreCase(lang))) continue;
                result.add(lv.getValue());
            }
        }
        return result;
    }

    public DescriptorValue get(Descriptor descriptor) {
        return this.descriptorValues.get((Object)descriptor);
    }

    public void put(Descriptor descriptor, List<LangString> descriptorValues) {
        if (descriptorValues.isEmpty()) {
            this.descriptorValues.put(descriptor, null);
        } else {
            DescriptorValue dv = new DescriptorValue(descriptorValues);
            this.descriptorValues.put(descriptor, dv);
        }
    }

    public void put(Descriptor descriptor, String stringValue) {
        if (stringValue == null) {
            this.descriptorValues.put(descriptor, null);
        } else {
            DescriptorValue dv = new DescriptorValue(new LangString(stringValue));
            this.descriptorValues.put(descriptor, dv);
        }
    }

    public void put(Descriptor descriptor, String[] stringValues) {
        if (stringValues == null || stringValues.length == 0) {
            this.descriptorValues.put(descriptor, null);
        } else {
            ArrayList<LangString> values = new ArrayList<LangString>();
            for (String s : stringValues) {
                values.add(new LangString(s));
            }
            this.put(descriptor, values);
        }
    }

    public void put(Descriptor descriptor, LangString ls) {
        if (ls == null) {
            this.descriptorValues.put(descriptor, null);
        } else {
            DescriptorValue dv = new DescriptorValue(ls);
            this.descriptorValues.put(descriptor, dv);
        }
    }

    public void putCopy(Descriptor descriptor, List<LangString> values) {
        if (values == null || values.isEmpty()) {
            this.descriptorValues.put(descriptor, null);
        } else {
            ArrayList<LangString> copy = new ArrayList<LangString>();
            for (LangString ls : values) {
                copy.add(new LangString(ls.getValue(), ls.getLang()));
            }
            DescriptorValue dv = new DescriptorValue(copy);
            this.descriptorValues.put(descriptor, dv);
        }
    }

    public void putCopy(Descriptor[] descriptorsToCopy, Descriptors originalDescriptors) {
        for (Descriptor descriptor : descriptorsToCopy) {
            this.putCopy(descriptor, originalDescriptors.values(descriptor));
        }
    }

    public void remove(Descriptor descriptor) {
        this.descriptorValues.remove((Object)descriptor);
    }

    public Descriptors createCopy() {
        Descriptors copy = new Descriptors();
        for (Map.Entry<Descriptor, DescriptorValue> entry : this.descriptorValues.entrySet()) {
            ArrayList<LangString> valueCopy = new ArrayList<LangString>();
            if (entry.getValue() != null) {
                for (LangString ls : entry.getValue().getValues()) {
                    valueCopy.add(new LangString(ls.getValue(), ls.getLang()));
                }
            }
            copy.put(entry.getKey(), valueCopy);
        }
        return copy;
    }

    public List<LangString> createValueCopy(Descriptor descriptor) {
        ArrayList<LangString> valueCopy = new ArrayList<LangString>();
        for (LangString ls : this.values(descriptor)) {
            valueCopy.add(new LangString(ls.getValue(), ls.getLang()));
        }
        return valueCopy;
    }

    public void appendSuffix(EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor, boolean addDescriptorIfMissing) {
        if (separatorAndSuffixByDescriptor != null) {
            for (Descriptor descriptor : separatorAndSuffixByDescriptor.keySet()) {
                DescriptorValue dv;
                Pair<String, String> separatorAndSuffix = separatorAndSuffixByDescriptor.get((Object)descriptor);
                if (addDescriptorIfMissing && (!this.descriptorValues.containsKey((Object)descriptor) || this.descriptorValues.get((Object)descriptor) == null)) {
                    this.put(descriptor, (String)separatorAndSuffix.getRight());
                    continue;
                }
                if (this.descriptorValues == null || !this.descriptorValues.containsKey((Object)descriptor) || (dv = this.descriptorValues.get((Object)descriptor)) == null) continue;
                dv.appendSuffix((String)separatorAndSuffix.getLeft() + (String)separatorAndSuffix.getRight());
            }
        }
    }

    public static List<LangString> merge(Descriptor descriptor, Info info1, Info info2, EnumMap<Descriptor, String> separatorByDescriptor, String defaultSeparator) {
        String separator = defaultSeparator;
        if (separatorByDescriptor.containsKey((Object)descriptor)) {
            separator = separatorByDescriptor.get((Object)descriptor);
        }
        return Descriptors.merge(descriptor, info1, info2, separator);
    }

    public static List<LangString> merge(Descriptor descriptor, Info info1, Info info2, String separator) {
        HashSet<LangString> result = new HashSet<LangString>();
        List<LangString> info1DVs = info1.descriptors().createValueCopy(descriptor);
        List<LangString> info2DVs = info2.descriptors().createValueCopy(descriptor);
        HashSet<LangString> unmatched_info2DVs = new HashSet<LangString>(info2DVs);
        if (descriptor.isSingleValued()) {
            for (LangString i1val : info1DVs) {
                String d1 = StringUtils.stripToNull((String)i1val.getValue());
                boolean matchFound = false;
                for (LangString i2val : info2DVs) {
                    String d2 = StringUtils.stripToNull((String)i2val.getValue());
                    if ((i1val.hasLang() || i2val.hasLang()) && (!i1val.hasLang() || !i2val.hasLang() || !i1val.getLang().equalsIgnoreCase(i2val.getLang()))) continue;
                    matchFound = true;
                    if (d1 == null && d2 == null) {
                        result.add(i1val);
                    } else if (d1 == null) {
                        result.add(i2val);
                    } else if (d2 == null) {
                        result.add(i1val);
                    } else {
                        LangString merge = new LangString(StringUtils.join((Object[])new String[]{d1, d2}, (String)separator));
                        result.add(merge);
                    }
                    unmatched_info2DVs.remove(i2val);
                }
                if (matchFound) continue;
                result.add(i1val);
            }
            for (LangString i2val : unmatched_info2DVs) {
                result.add(i2val);
            }
        } else {
            result.addAll(info1DVs);
            result.addAll(info2DVs);
        }
        return new ArrayList<LangString>(result);
    }

    private class DescriptorValue {
        private LangString singleValue = null;
        private ArrayList<LangString> multipleValues = null;

        DescriptorValue(LangString value) {
            if (value != null) {
                this.singleValue = value;
            }
        }

        DescriptorValue(List<LangString> values) {
            if (values != null && !values.isEmpty()) {
                if (values.size() == 1) {
                    this.singleValue = values.get(0);
                } else {
                    this.multipleValues = new ArrayList();
                    this.multipleValues.addAll(values);
                    this.multipleValues.trimToSize();
                }
            }
        }

        List<LangString> getValues() {
            ArrayList<LangString> result = new ArrayList<LangString>();
            if (this.singleValue != null) {
                result.add(this.singleValue);
            } else if (this.multipleValues != null) {
                result.addAll(this.multipleValues);
            }
            return result;
        }

        void appendSuffix(String s) {
            if (s != null) {
                if (this.singleValue != null) {
                    this.singleValue.appendSuffix(s);
                } else if (this.multipleValues != null) {
                    for (LangString val : this.multipleValues) {
                        val.appendSuffix(s);
                    }
                }
            }
        }
    }
}

