/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapEntryParamInfos
implements MessageSource {
    public static final String PARAM_VALIDATION_PATTERN = "((\\w+)(\\{(([^;=\\}]+)=?((?<==)[^;=\\}]+)?[\\s;]*)+\\})?[\\s,]*)+";
    public static final String PARAMETER_IDENTIFICATION_PATTERN = "(\\w+)\\{?((?<=\\{)[^\\}]+(?=\\}))?\\}?[\\s;]*";
    public static final String CHARACTERISTICS_IDENTIFICATION_PATTERN = "([^;=]+)=?((?<==)[^;=]+)?[\\s;]*";
    private Pattern validationPattern;
    private Pattern paramIdentPattern;
    private Pattern charactIdentPattern;
    private Map<String, Map<String, Map<String, String>>> paramCache;
    private Collection<ProcessMapEntry> mapEntries;
    private ShapeChangeResult result;
    private Options options;
    private boolean allParamsInMapEntriesAreValid = true;

    public MapEntryParamInfos(ShapeChangeResult result, Collection<ProcessMapEntry> pmes) {
        this.result = result;
        this.options = result.options();
        this.validationPattern = Pattern.compile(PARAM_VALIDATION_PATTERN);
        this.paramIdentPattern = Pattern.compile(PARAMETER_IDENTIFICATION_PATTERN);
        this.charactIdentPattern = Pattern.compile(CHARACTERISTICS_IDENTIFICATION_PATTERN);
        this.mapEntries = pmes;
        this.paramCache = new HashMap<String, Map<String, Map<String, String>>>();
        if (pmes != null) {
            for (ProcessMapEntry pme : pmes) {
                ShapeChangeResult.MessageContext mc;
                if (!pme.hasParam()) continue;
                String param = pme.getParam();
                String pmeKey = pme.getType() + "#" + pme.getRule().toLowerCase();
                Matcher vm = this.validationPattern.matcher(param);
                if (vm.matches()) {
                    if (this.paramCache.containsKey(pmeKey)) {
                        mc = result.addWarning(this, 4);
                        mc.addDetail(this, 1, pme.getType(), pme.getRule(), param);
                        continue;
                    }
                    HashMap charactByParameterName = new HashMap();
                    this.paramCache.put(pmeKey, charactByParameterName);
                    Matcher pim = this.paramIdentPattern.matcher(param);
                    while (pim.find()) {
                        String parameterName = pim.group(1);
                        if (charactByParameterName.containsKey(parameterName)) {
                            ShapeChangeResult.MessageContext mc2 = result.addWarning(this, 5, parameterName);
                            mc2.addDetail(this, 1, pme.getType(), pme.getRule(), param);
                            continue;
                        }
                        HashMap<String, String> characteristics = new HashMap<String, String>();
                        charactByParameterName.put(parameterName, characteristics);
                        String parameterValue = pim.group(2);
                        if (parameterValue == null) continue;
                        Matcher cim = this.charactIdentPattern.matcher(parameterValue);
                        while (cim.find()) {
                            String characteristicId = cim.group(1);
                            if (characteristics.containsKey(characteristicId)) {
                                ShapeChangeResult.MessageContext mc3 = result.addWarning(this, 6, characteristicId, parameterName);
                                mc3.addDetail(this, 1, pme.getType(), pme.getRule(), param);
                                continue;
                            }
                            String characteristicValue = cim.group(2);
                            characteristics.put(characteristicId, characteristicValue);
                        }
                    }
                    continue;
                }
                this.allParamsInMapEntriesAreValid = false;
                mc = result.addError(this, 3);
                mc.addDetail(this, 1, pme.getType(), pme.getRule(), param);
            }
        }
    }

    public boolean hasParameter(String typeName, String encodingRule, String parameterName) {
        ProcessMapEntry relevantMapEntry = this.options.targetMapEntry(typeName, encodingRule);
        return this.hasParameter(relevantMapEntry, parameterName);
    }

    public boolean hasParameter(ProcessMapEntry pme, String parameterName) {
        if (pme == null) {
            return false;
        }
        String pmeKey = pme.getType() + "#" + pme.getRule().toLowerCase();
        return this.paramCache.containsKey(pmeKey) && this.paramCache.get(pmeKey).containsKey(parameterName);
    }

    public boolean hasCharacteristic(String typeName, String encodingRule, String parameter, String characteristic) {
        Map<String, String> characteristics = this.getCharacteristics(typeName, encodingRule, parameter);
        if (characteristics == null) {
            return false;
        }
        return characteristics.containsKey(characteristic);
    }

    public Map<String, String> getCharacteristics(String typeName, String encodingRule, String parameter) {
        ProcessMapEntry relevantMapEntry = this.options.targetMapEntry(typeName, encodingRule);
        if (relevantMapEntry == null) {
            return null;
        }
        String pmeKey = typeName + "#" + relevantMapEntry.rule.toLowerCase();
        if (!this.paramCache.containsKey(pmeKey)) {
            return null;
        }
        return this.paramCache.get(pmeKey).get(parameter);
    }

    public ProcessMapEntry getMapEntry(String typeName, String encodingRule) {
        ProcessMapEntry relevantMapEntry = this.options.targetMapEntry(typeName, encodingRule);
        if (relevantMapEntry == null) {
            return null;
        }
        String pmeKey = typeName + "#" + relevantMapEntry.rule;
        for (ProcessMapEntry pme : this.mapEntries) {
            if (!pmeKey.equalsIgnoreCase(pme.getType() + "#" + pme.getRule())) continue;
            return pme;
        }
        return null;
    }

    public String getCharacteristic(String typeName, String encodingRule, String parameter, String characteristic) {
        Map<String, String> characteristics = this.getCharacteristics(typeName, encodingRule, parameter);
        if (characteristics == null) {
            return null;
        }
        return characteristics.get(characteristic);
    }

    public Map<String, Map<String, Map<String, String>>> getParameterCache() {
        return this.paramCache;
    }

    public boolean isValid() {
        return this.allParamsInMapEntriesAreValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: map entry with @type='$1$', @rule='$2$' and @param='$3$'.";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "Found invalid value for 'param' attribute in map entry. The entry will be ignored. Ensure that the value matches the regular expression ((\\w+)(\\{(([^;=\\}]+)=?((?<==)[^;=\\}]+)?[\\s;]*)+\\})?[\\s,]*)+.";
            }
            case 4: {
                return "Found another map entry with 'param' attribute for a type/rule mapping for which a 'param' attribute has already been parsed. The 'param' value of the additional map entry will be ignored.";
            }
            case 5: {
                return "Found duplicate parameter name '$1$' in map entry 'param'. Only the first occurrence of the parameter will be used. If you intended to define multiple characteristics for this parameter, note that multiple characteristics of a parameter are encoded as key-value pairs within a semicolon delimited list (example: theParameter{characteristicA=xyz;characteristicB=42;characteristicC}).";
            }
            case 6: {
                return "Found duplicate characteristic id '$1$' for parameter with name '$2$' in map entry 'param'. Only the first occurrence of the characteristic will be used. Note that it depends on the actual characteristic whether it is multi-valued or not. See the documentation of the according characteristic for further details.";
            }
        }
        return "(" + MapEntryParamInfos.class.getName() + ") Unknown message with number: " + mnr;
    }
}

