/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.DefaultDialog;
import de.interactive_instruments.ShapeChange.UI.Dialog;
import javax.swing.JOptionPane;

public class Main {
    public static void main(String[] argv) {
        try {
            Options options = new Options();
            ShapeChangeResult result = new ShapeChangeResult(options);
            Runtime.Version javaVersion = Runtime.version();
            if (javaVersion.feature() < 11) {
                result.addProcessFlowError(null, 18, javaVersion.toString());
                System.exit(1);
            }
            Converter converter = new Converter(options, result);
            boolean dialog = false;
            String arg = null;
            for (int i = 0; i < argv.length; ++i) {
                arg = argv[i];
                if (!arg.startsWith("-")) continue;
                String option = arg.substring(1);
                if (option.equals("h")) {
                    Main.printUsage();
                    System.exit(1);
                }
                if (option.equals("c")) {
                    if (++i == argv.length) {
                        result.addProcessFlowError(null, 111, "-c");
                        continue;
                    }
                    options.configFile = argv[i];
                    continue;
                }
                if (option.equals("x")) {
                    String x1 = null;
                    String x2 = null;
                    if (++i == argv.length) {
                        result.addProcessFlowError(null, 111, "-x");
                    } else {
                        x1 = argv[i];
                        if (++i == argv.length) {
                            result.addProcessFlowError(null, 111, "-x");
                        } else {
                            x2 = argv[i];
                        }
                    }
                    if (x2 == null) continue;
                    options.setReplaceValue(x1, x2);
                    continue;
                }
                if (!option.equals("d")) continue;
                dialog = true;
            }
            if (options.configFile == null) {
                dialog = true;
            }
            if (dialog) {
                Main.createAndShowGUI(converter, options, result);
            } else {
                options.loadConfiguration();
                converter.convert();
            }
        }
        catch (ShapeChangeAbortException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private static void createAndShowGUI(Converter c, Options o, ShapeChangeResult r) {
        String title;
        String msg;
        Dialog dialog = null;
        String modelFile = null;
        try {
            o.loadConfiguration();
        }
        catch (ShapeChangeAbortException e) {
            msg = "Error while loading the configuration." + System.getProperty("line.separator") + e.toString();
            title = "Error";
            JOptionPane.showMessageDialog(null, msg, title, 0);
            System.exit(1);
        }
        try {
            String classname = o.parameter("dialogClass");
            if (classname != null) {
                Class<?> theClass = Class.forName(classname);
                dialog = (Dialog)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                dialog.initialise(c, o, r, o.parameter("inputFile"));
            }
        }
        catch (Exception e) {
            msg = "Error while creating input dialog." + System.getProperty("line.separator") + e.toString();
            title = "Error";
            JOptionPane.showMessageDialog(null, msg, title, 0);
            System.exit(1);
        }
        if (dialog == null) {
            dialog = new DefaultDialog(c, o, r, modelFile);
        }
        dialog.setVisible(true);
    }

    protected static void printUsage() {
        System.err.println("ShapeChange command line interface");
        System.err.println();
        System.err.println("ShapeChange takes a ISO 19109 application schema");
        System.err.println("from a UML model and translates it into a GML application");
        System.err.println("schema or other implementation representations");
        System.err.println();
        System.err.println("usage: java -jar ShapeChange.jar (options) modelfile");
        System.err.println();
        System.err.println("options:");
        System.err.println(" -c cfgfile The location of the main configuration");
        System.err.println("            file. XInclude is supported and can be used");
        System.err.println("            to modularise the confguration. The default is");
        System.err.println("            http://shapechange.net/resources/config/minimal.xml.");
        System.err.println(" -x val rep If a configuration file contains a parameter");
        System.err.println("            with a value of 'val' then the value will be");
        System.err.println("            replaced by 'rep'. This option may occur multiple");
        System.err.println("            times.");
        System.err.println("            Example: -x '$dir$' './result/xsd' would replace.");
        System.err.println("            any parameter values '$dir$' in the configuration.");
        System.err.println("            file with './result/xsd'.");
        System.err.println(" -d         Invokes the user interface.");
        System.err.println(" -h         This help screen.");
        System.err.println();
    }
}

