/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.PackageInfoConfiguration;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class InputConfiguration {
    private String id;
    private Map<String, String> parametersByName;
    private Map<String, String> stereotypeAliasesByAlias;
    private Map<String, String> tagAliasesByAlias;
    private SortedMap<String, String> descriptorSources = new TreeMap<String, String>();
    private Map<String, PackageInfoConfiguration> packageInfosByName;

    public InputConfiguration(String id, Map<String, String> parametersByName, Map<String, String> stereotypeAliasesByAlias, Map<String, String> tagAliasesByAlias, Map<String, String> descriptorSources, Map<String, PackageInfoConfiguration> packageInfosByName) {
        this.id = id;
        this.parametersByName = parametersByName;
        this.stereotypeAliasesByAlias = stereotypeAliasesByAlias;
        this.tagAliasesByAlias = tagAliasesByAlias;
        if (descriptorSources != null) {
            this.descriptorSources.putAll(descriptorSources);
        }
        this.packageInfosByName = packageInfosByName;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getParameters() {
        return this.parametersByName;
    }

    public boolean hasParameter(String paramName) {
        return this.parametersByName != null && this.parametersByName.containsKey(paramName);
    }

    public Map<String, String> getStereotypeAliases() {
        return this.stereotypeAliasesByAlias;
    }

    public Map<String, String> getTagAliases() {
        return this.tagAliasesByAlias;
    }

    public SortedMap<String, String> getDescriptorSources() {
        return this.descriptorSources;
    }

    public Map<String, PackageInfoConfiguration> getPackageInfos() {
        return this.packageInfosByName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InputConfiguration:\r\n");
        sb.append("\tid: " + this.id + "\r\n");
        sb.append("\tpackage infos: ");
        if (this.packageInfosByName == null || this.packageInfosByName.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.packageInfosByName.keySet()) {
                PackageInfoConfiguration pi = this.packageInfosByName.get(key);
                sb.append("\t\tPackageInfo (" + key);
                if (pi.getNsabr() != null) {
                    sb.append(pi.getNsabr() + "|");
                } else {
                    sb.append("no nsabr|");
                }
                if (pi.getNs() != null) {
                    sb.append(pi.getNs() + "|");
                } else {
                    sb.append("no ns|");
                }
                if (pi.getXsdDocument() != null) {
                    sb.append(pi.getXsdDocument() + "|");
                } else {
                    sb.append("no xsdDocument|");
                }
                if (pi.getVersion() != null) {
                    sb.append(pi.getVersion());
                } else {
                    sb.append("no version");
                }
                sb.append(")\r\n");
            }
        }
        sb.append("\tparameters: ");
        if (this.parametersByName == null || this.parametersByName.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.parametersByName.keySet()) {
                sb.append("\t\t(" + key + " | " + this.parametersByName.get(key) + ")\r\n");
            }
        }
        sb.append("\tstereotypealiases: ");
        if (this.stereotypeAliasesByAlias == null || this.stereotypeAliasesByAlias.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.stereotypeAliasesByAlias.keySet()) {
                sb.append("\t\t(" + key + " | " + this.stereotypeAliasesByAlias.get(key) + ")\r\n");
            }
        }
        sb.append("\ttagaliases: ");
        if (this.tagAliasesByAlias == null || this.tagAliasesByAlias.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.tagAliasesByAlias.keySet()) {
                sb.append("\t\t(" + key + " | " + this.tagAliasesByAlias.get(key) + ")\r\n");
            }
        }
        sb.append("\tdescriptorsources: ");
        if (this.descriptorSources.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.descriptorSources.keySet()) {
                sb.append("\t\t(" + key + " | " + (String)this.descriptorSources.get(key) + ")\r\n");
            }
        }
        return sb.toString();
    }
}

