/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.InputAndLogParameterProvider;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.Util.ShapeChangeClassFinder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class InputAndLogParameterRegistry {
    protected SortedSet<String> allowedInputParametersWithStaticNames = new TreeSet<String>();
    protected List<Pattern> regexesForAllowedInputParametersWithDynamicNames = new ArrayList<Pattern>();
    protected SortedSet<String> allowedLogParametersWithStaticNames = new TreeSet<String>();
    protected List<Pattern> regexesForAllowedLogParametersWithDynamicNames = new ArrayList<Pattern>();

    public InputAndLogParameterRegistry() throws ShapeChangeAbortException {
        List<Class<?>> inputAndLogParameterProviders = ShapeChangeClassFinder.findClassesImplementing("de.interactive_instruments.ShapeChange.InputAndLogParameterProvider");
        for (Class<?> ppCls : inputAndLogParameterProviders) {
            try {
                List<Pattern> lpRegexes;
                SortedSet<String> lps;
                List<Pattern> ipRegexes;
                InputAndLogParameterProvider pp = (InputAndLogParameterProvider)ppCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                SortedSet<String> ips = pp.allowedInputParametersWithStaticNames();
                if (ips != null) {
                    this.allowedInputParametersWithStaticNames.addAll(ips);
                }
                if ((ipRegexes = pp.regexesForAllowedInputParametersWithDynamicNames()) != null) {
                    this.regexesForAllowedInputParametersWithDynamicNames.addAll(ipRegexes);
                }
                if ((lps = pp.allowedLogParametersWithStaticNames()) != null) {
                    this.allowedLogParametersWithStaticNames.addAll(lps);
                }
                if ((lpRegexes = pp.regexesForAllowedLogParametersWithDynamicNames()) == null) continue;
                this.regexesForAllowedLogParametersWithDynamicNames.addAll(lpRegexes);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("Exception occurred while loading InputAndLogParameterProvider class " + ppCls.getName() + " and attempting to gather information about (additional) allowed input and log parameters.");
                e.printStackTrace();
            }
        }
    }

    public SortedSet<String> getAllowedInputParametersWithStaticNames() {
        return this.allowedInputParametersWithStaticNames;
    }

    public List<Pattern> getRegexesForAllowedInputParametersWithDynamicNames() {
        return this.regexesForAllowedInputParametersWithDynamicNames;
    }

    public SortedSet<String> getAllowedLogParametersWithStaticNames() {
        return this.allowedLogParametersWithStaticNames;
    }

    public List<Pattern> getRegexesForAllowedLogParametersWithDynamicNames() {
        return this.regexesForAllowedLogParametersWithDynamicNames;
    }
}

